/*
 * Decompiled with CFR 0.152.
 */
package arch.RISCV;

import framework.DVAbi;
import framework.DVCode;
import framework.DVImmediateOperand;
import framework.DVOpCodeProcessor;
import framework.DVOpCodes;
import framework.DVStatements;
import framework.DVUtil;
import framework.Token;
import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;

public class DVArchOpCodes
extends DVOpCodes {
    private int xLen = 0;
    private int noRegs = 0;
    private int xLenNoBits = 0;
    private int regFileNoBits = 0;
    private int fLenNoBits = 0;
    private int fLen = 0;
    private int abiFLen = 0;
    private boolean mExt = false;
    private boolean aExt = false;
    private boolean cExt = false;
    private boolean dExt = false;
    private boolean fExt = false;
    private boolean nExt = false;
    private boolean qExt = false;
    private boolean zTsoExt = false;
    private boolean sExt = false;
    private boolean zicsrExt = false;
    private boolean zifenceiExt = false;
    private String extension = null;
    private DVAbi abi = null;
    private String os = null;
    private final HashMap<String, DVOpCodeProcessor> processOpCode = new HashMap();
    private boolean useCExtension;
    private boolean[] regUpdateFlags = new boolean[64];
    private HashMap<BigInteger, LinkedList<BranchStmt>> branchStmtList = new HashMap();
    private static final BigInteger[] destRegExclList = new BigInteger[]{BigInteger.ZERO};
    private static final EnumSet<DVUtil.ImmType> immInt = EnumSet.of(DVUtil.ImmType.INTEGER);
    private static final EnumSet<DVUtil.ImmType> immIntExt = EnumSet.of(DVUtil.ImmType.INTEGER, DVUtil.ImmType.EXTERNAL);
    private static final EnumSet<DVUtil.ImmType> immIntBaseDsp = EnumSet.of(DVUtil.ImmType.INTEGER, DVUtil.ImmType.BASEDSP);
    private static final EnumSet<DVUtil.ImmType> immIntPCRel = EnumSet.of(DVUtil.ImmType.INTEGER, DVUtil.ImmType.PCREL);
    private static final EnumSet<DVUtil.ImmType> immIntExtBaseDsp = EnumSet.of(DVUtil.ImmType.INTEGER, DVUtil.ImmType.EXTERNAL, DVUtil.ImmType.BASEDSP);
    private static final EnumSet<DVUtil.ImmType> immIntExtPCRel = EnumSet.of(DVUtil.ImmType.INTEGER, DVUtil.ImmType.EXTERNAL, DVUtil.ImmType.PCREL);
    private static final long noopCode = 28691L;
    private static final long noopCodeC = 1L;

    public DVArchOpCodes(DVStatements.Statement statement, String string, String string2, String string3) {
        String string4;
        string = string.toUpperCase();
        String string5 = "";
        int n = string.indexOf(58);
        if (n < 0) {
            string4 = string;
        } else {
            string4 = string.substring(0, n);
            string5 = string.substring(n + 1);
        }
        n = string5.indexOf(58);
        if (n >= 0) {
            this.extension = string5.substring(n + 1);
            string5 = string5.substring(0, n);
        }
        int n2 = 0;
        switch (string4) {
            case "RV32I": {
                this.xLen = 32;
                this.xLenNoBits = 5;
                this.noRegs = 32;
                this.regFileNoBits = 5;
                break;
            }
            case "RV32E": {
                this.xLen = 32;
                this.xLenNoBits = 5;
                this.noRegs = 16;
                this.regFileNoBits = 4;
                n2 = 8;
                break;
            }
            case "RV64I": {
                this.xLen = 64;
                this.xLenNoBits = 6;
                this.noRegs = 32;
                this.regFileNoBits = 5;
                break;
            }
            default: {
                statement.putError("Architecture specified [%s] is invalid", string4);
                return;
            }
        }
        Object object = "";
        int n3 = 0;
        boolean bl = false;
        block56: while (string5.length() > 0) {
            String string6;
            n = string5.indexOf(44);
            if (n == -1) {
                string6 = string5;
                string5 = "";
            } else {
                string6 = string5.substring(0, n);
                string5 = string5.substring(n + 1);
            }
            switch (string6) {
                case "A": {
                    if (this.aExt) {
                        object = (String)object + "," + string6;
                    }
                    this.aExt = true;
                    continue block56;
                }
                case "C": {
                    if (this.cExt) {
                        object = (String)object + "," + string6;
                    }
                    this.cExt = true;
                    n2 |= 1;
                    continue block56;
                }
                case "D": {
                    if (this.dExt) {
                        object = (String)object + "," + string6;
                    }
                    n3 = this.fLen != 0 ? 1 : 0;
                    this.fLen = 64;
                    this.fLenNoBits = 6;
                    this.dExt = true;
                    continue block56;
                }
                case "F": {
                    if (this.fExt) {
                        object = (String)object + "," + string6;
                    }
                    n3 = this.fLen != 0 ? 1 : 0;
                    this.fLen = 32;
                    this.fLenNoBits = 5;
                    this.fExt = true;
                    continue block56;
                }
                case "M": {
                    if (this.mExt) {
                        object = (String)object + "," + string6;
                    }
                    this.mExt = true;
                    continue block56;
                }
                case "N": {
                    if (this.nExt) {
                        object = (String)object + "," + string6;
                    }
                    this.nExt = true;
                    continue block56;
                }
                case "Q": {
                    if (this.qExt) {
                        object = (String)object + "," + string6;
                    }
                    n3 = this.fLen != 0 ? 1 : 0;
                    this.fLen = 128;
                    this.fLenNoBits = 7;
                    this.qExt = true;
                    continue block56;
                }
                case "S": {
                    if (this.sExt) {
                        object = (String)object + "," + string6;
                    }
                    this.sExt = true;
                    continue block56;
                }
                case "ZTSO": {
                    if (this.zTsoExt) {
                        object = (String)object + "," + string6;
                    }
                    this.zTsoExt = true;
                    n2 |= 0x10;
                    continue block56;
                }
                case "ZICSR": {
                    if (this.zicsrExt) {
                        object = (String)object + "," + string6;
                    }
                    this.zicsrExt = true;
                    continue block56;
                }
                case "ZIFENCEI": {
                    if (this.zifenceiExt) {
                        object = (String)object + "," + string6;
                    }
                    this.zifenceiExt = true;
                    continue block56;
                }
            }
            statement.putError("Architectural option [%s] is invalid", string6);
            bl = true;
        }
        if (this.qExt) {
            this.dExt = true;
        }
        if (this.dExt) {
            this.fExt = true;
        }
        if (this.fExt) {
            this.zicsrExt = true;
        }
        if (((String)object).length() > 0) {
            statement.putError("These options [%s] have been specified multiple times", ((String)object).substring(1));
            return;
        }
        if (bl) {
            return;
        }
        if (n3 != 0) {
            statement.putError("Multiple floatig point options specified");
            return;
        }
        this.useCExtension = this.cExt;
        switch (string2 = string2.toUpperCase()) {
            case "ILP32": {
                if (this.noRegs == 32 && this.xLen == 32) break;
                statement.putError("Harware configuration does not support abi [%s]", string2);
                break;
            }
            case "ILP32F": {
                n2 |= 2;
                this.abiFLen = 32;
                if (this.noRegs == 32 && this.xLen == 32 && this.fLen >= 32) break;
                statement.putError("Harware configuration does not support abi [%s]", string2);
                break;
            }
            case "ILP32D": {
                n2 |= 4;
                this.abiFLen = 64;
                if (this.noRegs == 32 && this.xLen == 32 && this.fLen >= 64) break;
                statement.putError("Harware configuration does not support abi [%s]", string2);
                break;
            }
            case "ILP32E": {
                if (this.noRegs == 16) break;
                statement.putError("Harware configuration does not match abi [%s]", string2);
                break;
            }
            case "LP64": {
                if (this.xLen == 64) break;
                statement.putError("Harware configuration does not support abi [%s]", string2);
                break;
            }
            case "LP64F": {
                n2 |= 2;
                this.abiFLen = 32;
                this.abiFLen = 32;
                if (this.xLen == 64 && this.fLen >= 32) break;
                statement.putError("Harware configuration does not support abi [%s]", string2);
                break;
            }
            case "LP64D": {
                n2 |= 4;
                this.abiFLen = 64;
                if (this.xLen == 64 && this.fLen >= 64) break;
                statement.putError("Harware configuration does not support abi [%s]", string2);
                break;
            }
            case "LP64Q": {
                n2 |= 6;
                this.abiFLen = 128;
                if (this.xLen == 64 && this.fLen >= 128) break;
                statement.putError("Harware configuration does not support abi [%s]", string2);
                break;
            }
            default: {
                statement.putError("Abi [%s] is invalid", string2);
                return;
            }
        }
        if ((this.abi = new Abi(statement, string2, n2)) == null) {
            return;
        }
        this.os = string3.toUpperCase();
        this.opCodeSetup(this.processOpCode);
    }

    @Override
    public boolean verifyArchitecture(DVStatements.Statement statement, String string) {
        if (string.equals("RISCV")) {
            return true;
        }
        return statement.putErrorFalse("Architecture mismatch due to configuration error\nArchitecture requested [%s] does not match [RISCV] loaded architecture Java Class", string);
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public boolean verifyExtension(DVStatements.Statement statement, String string) {
        return false;
    }

    @Override
    public DVAbi getAbi() {
        return this.abi;
    }

    @Override
    public String getHexCodeHeader() {
        return "--CODE-----------";
    }

    @Override
    public int getHexCodeLength() {
        return this.getHexCodeHeader().length();
    }

    @Override
    public void postProcess() {
        this.branchStmtList.forEach((bigInteger, linkedList) -> {
            for (BranchStmt branchStmt : linkedList) {
                LinkedList<BranchStmt> linkedList2 = this.branchStmtList.get(branchStmt.toOffset);
                if (linkedList2 == null) continue;
                for (BranchStmt branchStmt2 : linkedList2) {
                    if (branchStmt2.conditional || !branchStmt.toOffset.equals(branchStmt2.owner.getOffset()) || branchStmt.owner.getOwnerSection() != branchStmt2.owner.getOwnerSection()) continue;
                    branchStmt.owner.putWarning("Branch To Branch detected\nBranching to unconditional branch in statement [%s]", branchStmt2.owner.getFirstLineNumber());
                }
            }
        });
    }

    private void opCodeSetup(HashMap<String, DVOpCodeProcessor> hashMap) {
        this.processOpCode.put("C.SUSPEND", new SuspendCExtension());
        this.processOpCode.put("C.RESUME", new ResumeCExtension());
        this.processOpCode.put("CLRREGFLAGS", new ClearRegUpdateFlags("Clear update flags for all registers"));
        this.processOpCode.put("REGSAVE", new RegSaveArea("Conditional register save area"));
        this.processOpCode.put("FREGSAVE", new FloatRegSaveArea("Conditional register save area"));
        this.processOpCode.put("ALIGN", new OpCodeAlign("ALIGN: Align on specified boundary using NoOp codes"));
        this.processOpCode.put("ILLEGAL", new NPFormat(0L, "ILLEGAL: Illegal operation", 0L, "ILLEGAL -> C.ILLEGAL: Illegal operation"));
        this.processOpCode.put("LUI", new UFormat(55L, "LUI: Load in RegD the sign extended Immediate value shifted left by 12 bits"));
        this.processOpCode.put("AUIPC", new UFormat(23L, "AUIPC: Add the sign extended Immediate value shifted left by 12 bits to the Program Counter and store result in RegD"));
        this.processOpCode.put("JAL", new JFormat(111L, "JAL: Jump to PC relative sign extended Immediate shifted left by 1, and store link address in RegD"));
        this.processOpCode.put("JALR", new IFormat(103L, 0L, immIntExt, "JALR: Jump to ( Reg1 + immediate ) address, and store link address in RegD"));
        this.processOpCode.put("BEQ", new BFormat(99L, 0L, "BEQ: Branch to PC relative signed extended Immediate multiplied by 2 if signed Reg1 == Reg2 (signed)"));
        this.processOpCode.put("BNE", new BFormat(99L, 1L, "BNE: Branch to PC relative signed extended Immediate multiplied by 2 if Reg1 != Reg2 (signed)"));
        this.processOpCode.put("BLT", new BFormat(99L, 4L, "BLT: Branch to PC relative signed extended Immediate multiplied by 2 if Reg1 < Reg2 (signed)"));
        this.processOpCode.put("BGE", new BFormat(99L, 5L, "BGE: Branch to PC relative signed extended Immediate multiplied by 2 if Reg1 >= Reg2 (signed)"));
        this.processOpCode.put("BLTU", new BFormat(99L, 6L, "BLTU: Branch to PC relative signed extended Immediate multiplied by 2 if Reg1 < Reg2 (unsigned)"));
        this.processOpCode.put("BGEU", new BFormat(99L, 7L, "BGEU: Branch to PC relative signed extended Immediate multiplied by 2 if Reg1 >= Reg2 (unsigned)"));
        this.processOpCode.put("LB", new IFormat(3L, 0L, immIntExtBaseDsp, "LB: Load sign extended byte into RegD at Reg1 relative sign extended Immediate"));
        this.processOpCode.put("LH", new IFormat(3L, 1L, immIntExtBaseDsp, "LH: Load sign extended half word into RegD at Reg1 relative sign extended Immediate"));
        this.processOpCode.put("LW", new IFormat(3L, 2L, immIntExtBaseDsp, EnumSet.of(IFormatType.CONDITIONAL), "LW: Load sign extended (64 & 128 bits only) word into RegD at Reg1 relative sign extended Immediate"));
        this.processOpCode.put("LBU", new IFormat(3L, 4L, immIntExtBaseDsp, "LBU: Load zero extended byte into RegD at Reg1 relative sign extended Immediate"));
        this.processOpCode.put("LHU", new IFormat(3L, 5L, immIntExtBaseDsp, "LHU: Load zero extended half word into RegD at Reg1 relative sign extended Immediate"));
        this.processOpCode.put("SB", new SFormat(35L, 0L, immIntExtBaseDsp, "SB: Store Reg2 low byte into Reg1 relative sign extended Immediate memory address"));
        this.processOpCode.put("SH", new SFormat(35L, 1L, immIntExtBaseDsp, "SH: Store Reg2 low half word into Reg1 relative sign extended Immediate memory address"));
        this.processOpCode.put("SW", new SFormat(35L, 2L, immIntExtBaseDsp, EnumSet.of(SFormatType.CONDITIONAL), "SW: Store Reg2 word into Reg1 relative sign extended Immediate memory address"));
        this.processOpCode.put("ADDI", new IFormat(19L, 0L, immIntExtBaseDsp, "ADDI: Add sign extended Immediate to Reg1 and store result into RegD"));
        this.processOpCode.put("SLTI", new IFormat(19L, 2L, immInt, "SLTI: Set RegD to 1 if Reg1 < Immediate (signed), set to zero otherwise"));
        this.processOpCode.put("SLTIU", new IFormat(19L, 3L, immInt, "SLTIU: Set RegD to 1 if Reg1 < Immediate (unsigned), set to zero otherwise"));
        this.processOpCode.put("XORI", new IFormat(19L, 4L, immInt, "XORI: Exclusive OR sign extended Immediate to Reg1 and store result into RegD"));
        this.processOpCode.put("ORI", new IFormat(19L, 6L, immInt, "ORI: OR sign extended Immediate to Reg1 and store result into RegD"));
        this.processOpCode.put("ANDI", new IFormat(19L, 7L, immInt, "ANDI: AND sign extended Immediate to Reg1 and store result into RegD"));
        this.processOpCode.put("SLLI", new SHFormat(19L, 1L, this.xLenNoBits, "SLLI: Shift Logical Left Reg1 by the Shift Amount and store result in RegD"));
        this.processOpCode.put("SRLI", new SHFormat(19L, 5L, this.xLenNoBits, "SRLI: Shift Logical Right Reg1 by the Shift Amount and store result in RegD"));
        this.processOpCode.put("SRAI", new SHFormat(19L, 262149L, this.xLenNoBits, "SRAI: Shift Arithmetic Right Reg1 by the Shift Amount and store result in RegD"));
        this.processOpCode.put("ADD", new RFormat(51L, 0L, 0L, "ADD: Add Reg2 to Reg1 and store result in RegD"));
        this.processOpCode.put("SUB", new RFormat(51L, 0L, 32L, "SUB: Subtract Reg2 from Reg1 and store result in RegD"));
        this.processOpCode.put("SLL", new RFormat(51L, 1L, 0L, "SLL: Shift Logical Left Reg1 by the amount in Reg2 and store result in RegD"));
        this.processOpCode.put("SLT", new RFormat(51L, 2L, 0L, "SLT: Set RegD to 1 if Reg1 < Reg2 (signed), set to zero otherwise"));
        this.processOpCode.put("SLTU", new RFormat(51L, 3L, 0L, "SLT: Set RegD to 1 if Reg1 < Reg2 (unsigned), set to zero otherwise"));
        this.processOpCode.put("XOR", new RFormat(51L, 4L, 0L, "XOR: Exclusive OR SReg1 with SReg2 and store result in RegD"));
        this.processOpCode.put("SRL", new RFormat(51L, 5L, 0L, "SRL: Shift Logical Right SReg1 by the Shift Amount in SReg2 and store result in RegD"));
        this.processOpCode.put("SRA", new RFormat(51L, 5L, 32L, "SRA: Shift Arithmetic Right Reg1 by the Shift Amount in SReg2 and store result in RegD"));
        this.processOpCode.put("OR", new RFormat(51L, 6L, 0L, "OR: OR SReg1 with SReg2 and store result in RegD"));
        this.processOpCode.put("AND", new RFormat(51L, 7L, 0L, "AND: AND SReg1 with SReg2 and store result in RegD"));
        this.processOpCode.put("FENCE", new IFormat(15L, 0L, immInt, EnumSet.of(IFormatType.IMM_NOT_ZERO), "FENCE: Synchronize memory read and write of this hart with other harts according to Immediate bits setting"));
        this.processOpCode.put("ECALL", new NPFormat(115L, "ECALL: Invoke software interrup trap handler"));
        this.processOpCode.put("EBREAK", new NPFormat(1048691L, "EBREAK: Invoke software interrup trap handler", 36866L, "EBREAK -> C.EBREAK: Invoke debugger interrupt trap handler"));
        if (this.xLen >= 64) {
            this.processOpCode.put("LWU", new IFormat(3L, 6L, immIntExtBaseDsp, "LWU: Load zero extended word into RegD at Reg1 relative sign extended Immediate"));
            this.processOpCode.put("LD", new IFormat(3L, 3L, immIntExtBaseDsp, EnumSet.of(IFormatType.CONDITIONAL), "LD: Load sign extended word into RegD at Reg1 relative sign extended Immediate"));
            this.processOpCode.put("SD", new SFormat(35L, 3L, immIntExtBaseDsp, EnumSet.of(SFormatType.CONDITIONAL), "SD: Store Reg2 double word into Reg1 relative sign extended Immediate memory address"));
            this.processOpCode.put("ADDIW", new IFormat(27L, 0L, immIntExtBaseDsp, "ADDIW: Add sign extended Immediate to Reg1 low word and store sign extended result into RegD"));
            this.processOpCode.put("SLLIW", new SHFormat(27L, 1L, 32, "SLLIW: Shift Logical Left Reg1 low word by the Shift Amount and store the result in RegD"));
            this.processOpCode.put("SRLIW", new SHFormat(27L, 5L, 32, "SRLIW: Shift Logical Right Reg1 low word by the Shift Amount and store the result in RegD"));
            this.processOpCode.put("SRAIW", new SHFormat(27L, 262149L, 32, "SRAIW: Shift Arithmetic Right Reg1 low word by the Shift Amount and store the result in RegD"));
            this.processOpCode.put("ADDW", new RFormat(59L, 0L, 0L, "ADDW: Add Reg2 low word to Reg1 and store sign extended result in RegD"));
            this.processOpCode.put("SUBW", new RFormat(59L, 0L, 32L, "SUBW: Subtract Reg2 low word from Reg1 low word and store sign extended result in RegD"));
            this.processOpCode.put("SLLW", new RFormat(59L, 1L, 0L, "SLLW: Shift Logical Left Reg1 low word by the Shift Amount in Reg2 and store result in RegD"));
            this.processOpCode.put("SRLW", new RFormat(59L, 5L, 0L, "SRLW: Shift Logical Right Reg1 low word by the Shift Amount in Reg2 and store result in RegD"));
            this.processOpCode.put("SRAW", new RFormat(59L, 5L, 32L, "SRAW: Shift Arithmetic Right Reg1 low word by the Shift Amount in Reg2 and store result in RegD"));
        }
        if (this.aExt) {
            long l = 47L;
            long l2 = 2L;
            this.processOpCode.put("LR.W", new RFormat(l, l2, 0L, 8L, "LR.W: Load Reserved word at address pointed by Reg1 into RegD sign extended"));
            this.processOpCode.put("LR.W.AQ", new RFormat(l, l2, 0L, 10L, "LR.W.AQ: Load Reserved word at address pointed by Reg1 into RegD sign extended - Aquire"));
            this.processOpCode.put("LR.W.RL", new RFormat(l, l2, 0L, 9L, "LR.W.RL: Load Reserved word at address pointed by Reg1 into RegD sign extended - Release"));
            this.processOpCode.put("LR.W.AQ.RL", new RFormat(l, l2, 0L, 11L, "LR.W.AQ.RL: Load Reserved word at address pointed by Reg1 into RegD sign extended - Aquire/Relase"));
            this.processOpCode.put("SC.W", new RFormat(l, l2, 12L, "CS.W: Store Conditional low word in Reg2 at address pointed by Reg1 and load success (zero) or failure (one) into RegD"));
            this.processOpCode.put("SC.W.AQ", new RFormat(l, l2, 14L, "SC.W.AQ: Store Conditional low word in Reg2 at address pointed by Reg1 and load success (zero) or failure (one) into RegD - Aquire"));
            this.processOpCode.put("SC.W.RL", new RFormat(l, l2, 13L, "SC.W.RL: Store Conditional low word in Reg2 at address pointed by Reg1 and load success (zero) or failure (one) into RegD - Release"));
            this.processOpCode.put("SC.W.AQ.RL", new RFormat(l, l2, 15L, "SC.W.AQ.RL: Store Conditional low word in Reg2 at address pointed by Reg1 and load success (zero) or failure (one) into RegD - Aquire/Relase"));
            this.processOpCode.put("AMOSWAP.W", new RFormat(l, l2, 4L, RFormatType.ZERO_DESTREG_OK, "AMOSWAP.W: Atomic swap word in Reg2 with word at Reg1 address into RegD"));
            this.processOpCode.put("AMOSWAP.W.AQ", new RFormat(l, l2, 6L, RFormatType.ZERO_DESTREG_OK, "AMOSWAP.AQ.W: Atomic swap word in Reg2 with word at Reg1 address into RegD - Aquire"));
            this.processOpCode.put("AMOSWAP.W.RL", new RFormat(l, l2, 5L, RFormatType.ZERO_DESTREG_OK, "AMOSWAP.RL.W: Atomic swap word in Reg2 with word at Reg1 address into RegD - Relase"));
            this.processOpCode.put("AMOSWAP.W.AQ.RL", new RFormat(l, l2, 7L, RFormatType.ZERO_DESTREG_OK, "AMOSWAP.AQ.RL.W: Atomic load word at Reg1 address into RegD - Reg2 must be zero - Aquire/Release"));
            this.processOpCode.put("AMOADD.W", new RFormat(l, l2, 0L, RFormatType.ZERO_DESTREG_OK, "AMOADD.W: Atomic load/sign extend word at Reg1 address into RegD and store back Reg2+RegD"));
            this.processOpCode.put("AMOADD.W.AQ", new RFormat(l, l2, 2L, RFormatType.ZERO_DESTREG_OK, "AMOADD.AQ.W: Atomic load/sign extend word at Reg1 address into RegD and store back Reg2+RegD - Aquire"));
            this.processOpCode.put("AMOADD.W.RL", new RFormat(l, l2, 1L, RFormatType.ZERO_DESTREG_OK, "AMOADD.RL.W: Atomic load/sign extend word at Reg1 address into RegD and store back Reg2+RegD - Relase"));
            this.processOpCode.put("AMOADD.W.AQ.RL", new RFormat(l, l2, 3L, RFormatType.ZERO_DESTREG_OK, "AMOADD.AQ.RL.W: Atomic load/sign extend word at Reg1 address into RegD and store back Reg2+RegD - Aquire/Release"));
            this.processOpCode.put("AMOXOR.W", new RFormat(l, l2, 16L, RFormatType.ZERO_DESTREG_OK, "AMOXOR.W: Atomic load/sign extend word at Reg1 address into RegD and store back XOR(Reg2, RegD)"));
            this.processOpCode.put("AMOXOR.W.AQ", new RFormat(l, l2, 18L, RFormatType.ZERO_DESTREG_OK, "AMOXOR.AQ.W: Atomic load/sign extend word at Reg1 address into RegD and store back XOR(Reg2, RegD) - Aquire"));
            this.processOpCode.put("AMOXOR.W.RL", new RFormat(l, l2, 17L, RFormatType.ZERO_DESTREG_OK, "AMOXOR.RL.W: Atomic load/sign extend word at Reg1 address into RegD and store back XOR(Reg2, RegD) - Relase"));
            this.processOpCode.put("AMOXOR.W.AQ.RL", new RFormat(l, l2, 19L, RFormatType.ZERO_DESTREG_OK, "AMOXOR.AQ.RL.W: Atomic load/sign extend word at Reg1 address into RegD and store back XOR(Reg2, RegD) - Aquire/Release"));
            this.processOpCode.put("AMOAND.W", new RFormat(l, l2, 48L, RFormatType.ZERO_DESTREG_OK, "AMOAND.W: Atomic load/sign extend word at Reg1 address into RegD and store back AND(Reg2, RegD)"));
            this.processOpCode.put("AMOAND.W.AQ", new RFormat(l, l2, 50L, RFormatType.ZERO_DESTREG_OK, "AMOAND.AQ.W: Atomic load/sign extend word at Reg1 address into RegD and store back AND(Reg2, RegD) - Aquire"));
            this.processOpCode.put("AMOAND.W.RL", new RFormat(l, l2, 49L, RFormatType.ZERO_DESTREG_OK, "AMOAND.RL.W: Atomic load/sign extend word at Reg1 address into RegD and store back AND(Reg2, RegD) - Relase"));
            this.processOpCode.put("AMOAND.W.AQ.RL", new RFormat(l, l2, 51L, RFormatType.ZERO_DESTREG_OK, "AMOAND.AQ.RL.W: Atomic load/sign extend word at Reg1 address into RegD and store back AND(Reg2, RegD) - Aquire/Release"));
            this.processOpCode.put("AMOOR.W", new RFormat(l, l2, 32L, RFormatType.ZERO_DESTREG_OK, "AMOOR.W: Atomic load/sign extend word at Reg1 address into RegD and store back OR(Reg2, RegD)"));
            this.processOpCode.put("AMOOR.W.AQ", new RFormat(l, l2, 34L, RFormatType.ZERO_DESTREG_OK, "AMOOR.AQ.W: Atomic load/sign extend word at Reg1 address into RegD and store back OR(Reg2, RegD) - Aquire"));
            this.processOpCode.put("AMOOR.W.RL", new RFormat(l, l2, 33L, RFormatType.ZERO_DESTREG_OK, "AMOOR.RL.W: Atomic load/sign extend word at Reg1 address into RegD and store back OR(Reg2, RegD) - Relase"));
            this.processOpCode.put("AMOOR.W.AQ.RL", new RFormat(l, l2, 35L, RFormatType.ZERO_DESTREG_OK, "AMOOR.AQ.RL.W: Atomic load/sign extend word at Reg1 address into RegD and store back OR(Reg2, RegD) - Aquire/Release"));
            this.processOpCode.put("AMOMIN.W", new RFormat(l, l2, 64L, RFormatType.ZERO_DESTREG_OK, "AMOMIN.W: Atomic load/sign extend word at Reg1 address into RegD and store back signed MIN(Reg2, RegD)"));
            this.processOpCode.put("AMOMIN.W.AQ", new RFormat(l, l2, 66L, RFormatType.ZERO_DESTREG_OK, "AMOMIN.AQ.W: Atomic load/sign extend word at Reg1 address into RegD and store back signed MIN(Reg2, RegD) - Aquire"));
            this.processOpCode.put("AMOMIN.W.RL", new RFormat(l, l2, 65L, RFormatType.ZERO_DESTREG_OK, "AMOMIN.RL.W: Atomic load/sign extend word at Reg1 address into RegD and store back signed MIN(Reg2, RegD) - Relase"));
            this.processOpCode.put("AMOMIN.W.AQ.RL", new RFormat(l, l2, 67L, RFormatType.ZERO_DESTREG_OK, "AMOMIN.AQ.RL.W: Atomic load/sign extend word at Reg1 address into RegD and store back signed MIN(Reg2, RegD) - Aquire/Release"));
            this.processOpCode.put("AMOMAX.W", new RFormat(l, l2, 80L, RFormatType.ZERO_DESTREG_OK, "AMOMAX.W: Atomic load/sign extend word at Reg1 address into RegD and store back signed MAX(Reg2, RegD)"));
            this.processOpCode.put("AMOMAX.W.AQ", new RFormat(l, l2, 82L, RFormatType.ZERO_DESTREG_OK, "AMOMAX.AQ.W: Atomic load/sign extend word at Reg1 address into RegD and store back signed MAX(Reg2, RegD) - Aquire"));
            this.processOpCode.put("AMOMAX.W.RL", new RFormat(l, l2, 81L, RFormatType.ZERO_DESTREG_OK, "AMOMAX.RL.W: Atomic load/sign extend word at Reg1 address into RegD and store back signed MAX(Reg2, RegD) - Relase"));
            this.processOpCode.put("AMOMAX.W.AQ.RL", new RFormat(l, l2, 83L, RFormatType.ZERO_DESTREG_OK, "AMOMAX.AQ.RL.W: Atomic load/sign extend word at Reg1 address into RegD and store back signed MAX(Reg2, RegD) - Aquire/Release"));
            this.processOpCode.put("AMOMINU.W", new RFormat(l, l2, 64L, RFormatType.ZERO_DESTREG_OK, "AMOMINU.W: Atomic load/sign extend word at Reg1 address into RegD and store back unsigned MIN(Reg2, RegD)"));
            this.processOpCode.put("AMOMINU.W.AQ", new RFormat(l, l2, 66L, RFormatType.ZERO_DESTREG_OK, "AMOMINU.AQ.W: Atomic load/sign extend word at Reg1 address into RegD and store back unsigned MIN(Reg2, RegD) - Aquire"));
            this.processOpCode.put("AMOMINU.W.RL", new RFormat(l, l2, 65L, RFormatType.ZERO_DESTREG_OK, "AMOMINU.RL.W: Atomic load/sign extend word at Reg1 address into RegD and store back unsigned MIN(Reg2, RegD) - Relase"));
            this.processOpCode.put("AMOMINU.W.AQ.RL", new RFormat(l, l2, 67L, RFormatType.ZERO_DESTREG_OK, "AMOMINU.AQ.RL.W: Atomic load/sign extend word at Reg1 address into RegD and store back unsigned MIN(Reg2, RegD) - Aquire/Release"));
            this.processOpCode.put("AMOMAXU.W", new RFormat(l, l2, 80L, RFormatType.ZERO_DESTREG_OK, "AMOMAXU.W: Atomic load/sign extend word at Reg1 address into RegD and store back unsigned MAX(Reg2, RegD)"));
            this.processOpCode.put("AMOMAXU.W.AQ", new RFormat(l, l2, 82L, RFormatType.ZERO_DESTREG_OK, "AMOMAXU.AQ.W: Atomic load/sign extend word at Reg1 address into RegD and store back unsigned MAX(Reg2, RegD) - Aquire"));
            this.processOpCode.put("AMOMAXU.W.RL", new RFormat(l, l2, 81L, RFormatType.ZERO_DESTREG_OK, "AMOMAXU.RL.W: Atomic load/sign extend word at Reg1 address into RegD and store back unsigned MAX(Reg2, RegD) - Relase"));
            this.processOpCode.put("AMOMAXU.W.AQ.RL", new RFormat(l, l2, 83L, RFormatType.ZERO_DESTREG_OK, "AMOMAX.AQ.RL.W: Atomic load/sign extend word at Reg1 address into RegD and store back unsigned MAX(Reg2, RegD) - Aquire/Release"));
            if (this.xLen >= 64) {
                l2 = 3L;
                this.processOpCode.put("LR.D", new RFormat(l, l2, 8L, 0L, "LR.D: Load Reserved double word at address pointed by Reg1 into RegD sign extended"));
                this.processOpCode.put("LR.D.AQ", new RFormat(l, l2, 10L, 0L, "LR.D.AQ: Load Reserved double word at address pointed by Reg1 into RegD sign extended - Aquire"));
                this.processOpCode.put("LR.D.RL", new RFormat(l, l2, 9L, 0L, "LR.D.RL: Load Reserved double word at address pointed by Reg1 into RegD sign extended - Release"));
                this.processOpCode.put("LR.D.AQ.RL", new RFormat(l, l2, 11L, 0L, "LR.D.AQ.RL: Load Reserved double word at address pointed by Reg1 into RegD sign extended - Aquire/Relase"));
                this.processOpCode.put("SC.D", new RFormat(l, l2, 12L, "CS.D: Store Conditional double word in Reg2 at address pointed by Reg1 and load success (zero) or failure (one) into RegD"));
                this.processOpCode.put("SC.D.AQ", new RFormat(l, l2, 14L, "SC.D.AQ: Store Conditional double word in Reg2 at address pointed by Reg1 and load success (zero) or failure (one) into RegD - Aquire"));
                this.processOpCode.put("SC.D.RL", new RFormat(l, l2, 13L, "SC.D.RL: Store Conditional double word in Reg2 at address pointed by Reg1 and load success (zero) or failure (one) into RegD - Release"));
                this.processOpCode.put("SC.D.AQ.RL", new RFormat(l, l2, 15L, "SC.D.AQ.RL: Store Conditional double word in Reg2 at address pointed by Reg1 and load success (zero) or failure (one) into RegD - Aquire/Relase"));
                this.processOpCode.put("AMOSWAP.D", new RFormat(l, l2, 4L, RFormatType.ZERO_DESTREG_OK, "AMOSWAP.D: Atomic swap word in Reg2 with word at Reg1 address into RegD"));
                this.processOpCode.put("AMOSWAP.D.AQ", new RFormat(l, l2, 6L, RFormatType.ZERO_DESTREG_OK, "AMOSWAP.AQ.D: Atomic swap word in Reg2 with word at Reg1 address into RegD - Aquire"));
                this.processOpCode.put("AMOSWAP.D.RL", new RFormat(l, l2, 5L, RFormatType.ZERO_DESTREG_OK, "AMOSWAP.RL.D: Atomic swap word in Reg2 with word at Reg1 address into RegD - Relase"));
                this.processOpCode.put("AMOSWAP.D.AQ.RL", new RFormat(l, l2, 7L, RFormatType.ZERO_DESTREG_OK, "AMOSWAP.AQ.RL.D: Atomic swap word in Reg2 with word at Reg1 address into RegD - Aquire/Release"));
                this.processOpCode.put("AMOADD.D", new RFormat(l, l2, 0L, RFormatType.ZERO_DESTREG_OK, "AMOADD.D: Atomic load/sign extend double word at Reg1 address into RegD and store back Reg2+RegD"));
                this.processOpCode.put("AMOADD.D.AQ", new RFormat(l, l2, 2L, RFormatType.ZERO_DESTREG_OK, "AMOADD.AQ.D: Atomic load/sign extend double word at Reg1 address into RegD and store back Reg2+RegD - Aquire"));
                this.processOpCode.put("AMOADD.D.RL", new RFormat(l, l2, 1L, RFormatType.ZERO_DESTREG_OK, "AMOADD.RL.D: Atomic load/sign extend double word at Reg1 address into RegD and store back Reg2+RegD - Relase"));
                this.processOpCode.put("AMOADD.D.AQ.RL", new RFormat(l, l2, 3L, RFormatType.ZERO_DESTREG_OK, "AMOADD.AQ.RL.D: Atomic load/sign extend double word at Reg1 address into RegD and store back Reg2+RegD - Aquire/Release"));
                this.processOpCode.put("AMOXOR.D", new RFormat(l, l2, 16L, RFormatType.ZERO_DESTREG_OK, "AMOXOR.D: Atomic load/sign extend double word at Reg1 address into RegD and store back XOR(Reg2, RegD)"));
                this.processOpCode.put("AMOXOR.D.AQ", new RFormat(l, l2, 18L, RFormatType.ZERO_DESTREG_OK, "AMOXOR.AQ.D: Atomic load/sign extend double word at Reg1 address into RegD and store back XOR(Reg2, RegD) - Aquire"));
                this.processOpCode.put("AMOXOR.D.RL", new RFormat(l, l2, 17L, RFormatType.ZERO_DESTREG_OK, "AMOXOR.RL.D: Atomic load/sign extend double word at Reg1 address into RegD and store back XOR(Reg2, RegD) - Relase"));
                this.processOpCode.put("AMOXOR.D.AQ.RL", new RFormat(l, l2, 19L, RFormatType.ZERO_DESTREG_OK, "AMOXOR.AQ.RL.D: Atomic load/sign extend double word at Reg1 address into RegD and store back XOR(Reg2, RegD) - Aquire/Release"));
                this.processOpCode.put("AMOAND.D", new RFormat(l, l2, 48L, RFormatType.ZERO_DESTREG_OK, "AMOAND.D: Atomic load/sign extend double word at Reg1 address into RegD and store back AND(Reg2, RegD)"));
                this.processOpCode.put("AMOAND.D.AQ", new RFormat(l, l2, 50L, RFormatType.ZERO_DESTREG_OK, "AMOAND.AQ.D: Atomic load/sign extend double word at Reg1 address into RegD and store back AND(Reg2, RegD) - Aquire"));
                this.processOpCode.put("AMOAND.D.RL", new RFormat(l, l2, 49L, RFormatType.ZERO_DESTREG_OK, "AMOAND.RL.D: Atomic load/sign extend double word at Reg1 address into RegD and store back AND(Reg2, RegD) - Relase"));
                this.processOpCode.put("AMOAND.D.AQ.RL", new RFormat(l, l2, 51L, RFormatType.ZERO_DESTREG_OK, "AMOAND.AQ.RL.D: Atomic load/sign extend double word at Reg1 address into RegD and store back AND(Reg2, RegD) - Aquire/Release"));
                this.processOpCode.put("AMOOR.D", new RFormat(l, l2, 32L, RFormatType.ZERO_DESTREG_OK, "AMOOR.D: Atomic load/sign extend double word at Reg1 address into RegD and store back OR(Reg2, RegD)"));
                this.processOpCode.put("AMOOR.D.AQ", new RFormat(l, l2, 34L, RFormatType.ZERO_DESTREG_OK, "AMOOR.AQ.D: Atomic load/sign extend double word at Reg1 address into RegD and store back OR(Reg2, RegD) - Aquire"));
                this.processOpCode.put("AMOOR.D.RL", new RFormat(l, l2, 33L, RFormatType.ZERO_DESTREG_OK, "AMOOR.RL.D: Atomic load/sign extend double word at Reg1 address into RegD and store back OR(Reg2, RegD) - Relase"));
                this.processOpCode.put("AMOOR.D.AQ.RL", new RFormat(l, l2, 35L, RFormatType.ZERO_DESTREG_OK, "AMOOR.AQ.RL.D: Atomic load/sign extend double word at Reg1 address into RegD and store back OR(Reg2, RegD) - Aquire/Release"));
                this.processOpCode.put("AMOMIN.D", new RFormat(l, l2, 64L, RFormatType.ZERO_DESTREG_OK, "AMOMIN.D: Atomic load/sign extend double word at Reg1 address into RegD and store back signed MIN(Reg2, RegD)"));
                this.processOpCode.put("AMOMIN.D.AQ", new RFormat(l, l2, 66L, RFormatType.ZERO_DESTREG_OK, "AMOMIN.AQ.D: Atomic load/sign extend double word at Reg1 address into RegD and store back signed MIN(Reg2, RegD) - Aquire"));
                this.processOpCode.put("AMOMIN.D.RL", new RFormat(l, l2, 65L, RFormatType.ZERO_DESTREG_OK, "AMOMIN.RL.D: Atomic load/sign extend double word at Reg1 address into RegD and store back signed MIN(Reg2, RegD) - Relase"));
                this.processOpCode.put("AMOMIN.D.AQ.RL", new RFormat(l, l2, 67L, RFormatType.ZERO_DESTREG_OK, "AMOMIN.AQ.RL.D: Atomic load/sign extend double word at Reg1 address into RegD and store back signed MIN(Reg2, RegD) - Aquire/Release"));
                this.processOpCode.put("AMOMAX.D", new RFormat(l, l2, 80L, RFormatType.ZERO_DESTREG_OK, "AMOMAX.D: Atomic load/sign extend double word at Reg1 address into RegD and store back signed MAX(Reg2, RegD)"));
                this.processOpCode.put("AMOMAX.D.AQ", new RFormat(l, l2, 82L, RFormatType.ZERO_DESTREG_OK, "AMOMAX.AQ.D: Atomic load/sign extend double word at Reg1 address into RegD and store back signed MAX(Reg2, RegD) - Aquire"));
                this.processOpCode.put("AMOMAX.D.RL", new RFormat(l, l2, 81L, RFormatType.ZERO_DESTREG_OK, "AMOMAX.RL.D: Atomic load/sign extend double word at Reg1 address into RegD and store back signed MAX(Reg2, RegD) - Relase"));
                this.processOpCode.put("AMOMAX.D.AQ.RL", new RFormat(l, l2, 83L, RFormatType.ZERO_DESTREG_OK, "AMOMAX.AQ.RL.D: Atomic load/sign extend double word at Reg1 address into RegD and store back signed MAX(Reg2, RegD) - Aquire/Release"));
                this.processOpCode.put("AMOMINU.D", new RFormat(l, l2, 64L, RFormatType.ZERO_DESTREG_OK, "AMOMINU.D: Atomic load/sign extend double word at Reg1 address into RegD and store back unsigned MIN(Reg2, RegD)"));
                this.processOpCode.put("AMOMINU.D.AQ", new RFormat(l, l2, 66L, RFormatType.ZERO_DESTREG_OK, "AMOMINU.AQ.D: Atomic load/sign extend double word at Reg1 address into RegD and store back unsigned MIN(Reg2, RegD) - Aquire"));
                this.processOpCode.put("AMOMINU.D.RL", new RFormat(l, l2, 65L, RFormatType.ZERO_DESTREG_OK, "AMOMINU.RL.D: Atomic load/sign extend double word at Reg1 address into RegD and store back unsigned MIN(Reg2, RegD) - Relase"));
                this.processOpCode.put("AMOMINU.D.AQ.RL", new RFormat(l, l2, 67L, RFormatType.ZERO_DESTREG_OK, "AMOMINU.AQ.RL.D: Atomic load/sign extend double word at Reg1 address into RegD and store back unsigned MIN(Reg2, RegD) - Aquire/Release"));
                this.processOpCode.put("AMOMAXU.D", new RFormat(l, l2, 80L, RFormatType.ZERO_DESTREG_OK, "AMOMAXU.D: Atomic load/sign extend double word at Reg1 address into RegD and store back unsigned MAX(Reg2, RegD)"));
                this.processOpCode.put("AMOMAXU.D.AQ", new RFormat(l, l2, 82L, RFormatType.ZERO_DESTREG_OK, "AMOMAXU.AQ.D: Atomic load/sign extend double word at Reg1 address into RegD and store back unsigned MAX(Reg2, RegD) - Aquire"));
                this.processOpCode.put("AMOMAXU.D.RL", new RFormat(l, l2, 81L, RFormatType.ZERO_DESTREG_OK, "AMOMAXU.RL.D: Atomic load/sign extend double word at Reg1 address into RegD and store back unsigned MAX(Reg2, RegD) - Relase"));
                this.processOpCode.put("AMOMAXU.D.AQ.RL", new RFormat(l, l2, 83L, RFormatType.ZERO_DESTREG_OK, "AMOMAX.AQ.RL.D: Atomic load/sign extend double word at Reg1 address into RegD and store back unsigned MAX(Reg2, RegD) - Aquire/Release"));
            }
        }
        if (this.dExt) {
            this.processOpCode.put("FLD", new IFormat(7L, 3L, immIntExtBaseDsp, EnumSet.of(IFormatType.CONDITIONAL, IFormatType.FLOAT_REG), "FLD: Load 64 bit float into RegD from Reg1 relative sign extended Immediate memory location"));
            this.processOpCode.put("FSD", new SFormat(39L, 3L, immIntExtBaseDsp, EnumSet.of(SFormatType.CONDITIONAL, SFormatType.FLOAT_REG), "SLD Store 64 bit float in Reg2 at Reg1 relative sign extended Immediate memory location"));
            this.processOpCode.put("FMADD.D", new R4Format(33554499L, true, "FMADD.D Compute 64 bit float [ (Reg1 x Reg2) + Reg3 ] and store 64 bit result into float RegD"));
            this.processOpCode.put("FMSUB.D", new R4Format(33554503L, true, "FMSUB.D Compute 64 bit float [ (Reg1 x Reg2) - Reg3 ] and store 64 bit result into float RegD"));
            this.processOpCode.put("FNMSUB.D", new R4Format(33554507L, true, "FNMSUB.D Compute 64 bit float [ - (Reg1 x Reg2) + Reg3 ] and store 64 bit result into float RegD"));
            this.processOpCode.put("FNMADD.D", new R4Format(33554511L, true, "FNMADD.D Compute 64 bit float [ - (Reg1 x Reg2) - Reg3 ] and store 64 bit result into float RegD"));
            this.processOpCode.put("FADD.D", new RFormat(83L, 0L, true, "FADD.D Compute 64 bit float [ Reg1 + Reg2 ] and store 64 bit result into float RegD"));
            this.processOpCode.put("FSUB.D", new RFormat(83L, 4L, true, "FSUB.D Compute 64 bit float [ Reg1 - Reg2 ] and store 64 bit result into float RegD"));
            this.processOpCode.put("FMUL.D", new RFormat(83L, 4L, true, "FMUL.D Compute 64 bit float [ Reg1 * Reg2 ] and store 64 bit result into float RegD"));
            this.processOpCode.put("FDIV.D", new RFormat(83L, 4L, true, "FDIV.D Compute 64 bit float [ Reg1 / Reg2 ] and store 64 bit result into float RegD"));
            this.processOpCode.put("FSQRT.D", new RFormat(83L, 0L, 44L, true, RFormatType.CONST_SRC2REG_RM, "FSQRT.D Compute 64 bit float [ SQRT( Reg1 ) ] and store 64 bit result into float RegD"));
            this.processOpCode.put("FSGNJ.D", new RFormat(83L, 0L, 16L, true, "FSGNJ.D Inject 64 bit float Reg2 sign into 64 bit float Reg1 and store 64 bit result into float RegD"));
            this.processOpCode.put("FSGNJN.D", new RFormat(83L, 1L, 16L, true, "FSGNJN.D Inject 64 bit float Reg2 negated sign into 64 bit float Reg1 and store 64 bit result into float RegD"));
            this.processOpCode.put("FSGNJX.D", new RFormat(83L, 2L, 16L, true, "FSGNJX.D Inject 64 bit float Reg2 and Reg1 signs XORed together into 64 bit float Reg1 and store 64 bit result into float RegD"));
            this.processOpCode.put("FMIN.D", new RFormat(83L, 0L, 21L, true, "FMIN.D Compute 64 bit float [ MIN( Reg1 + Reg2 ) ] and store 64 bit result into float RegD"));
            this.processOpCode.put("FMAX.D", new RFormat(83L, 1L, 21L, true, "FMAX.D Compute 64 bit float [ MAX( Reg1 + Reg2 ) ] and store 64 bit result into float RegD"));
            this.processOpCode.put("FCVT.S.D", new RFormat(83L, 1L, 32L, true, RFormatType.CONST_SRC2REG_RM, "FCVT.S.D Convert 64 bit float Reg1 to 32 bit float and store result into 32 bit float RegD"));
            this.processOpCode.put("FCVT.D.S", new RFormat(83L, 0L, 33L, true, RFormatType.CONST_SRC2REG_RM, "FCVT.D.S Convert 32 bit float Reg1 to 64 bit float and store result into 64 bit float RegD"));
            this.processOpCode.put("FEQ.D", new RFormat(83L, 2L, 81L, "FEQ.D Compute 64 bit float [ ( Reg1 == Reg2 ) ] and store boolean 0 or 1 result in xLen integer RegD"));
            this.processOpCode.put("FLT.D", new RFormat(83L, 1L, 81L, "FLT.D Compute 64 bit float [ ( Reg1 < Reg2 ) ] and store boolean 0 or 1 result in xLen integer RegD"));
            this.processOpCode.put("FLE.D", new RFormat(83L, 0L, 81L, "FLE.D Compute 64 bit float [ ( Reg1 <= Reg2 ) ] and store boolean 0 or 1 result in xLen integer RegD"));
            this.processOpCode.put("FCLASS.D", new RFormat(83L, 1L, 0L, 113L, "FCLASS.D Compute 64 bit float Reg2 class and store it to low 10 bits of integer RegD zero extended"));
            this.processOpCode.put("FCVT.W.D", new RFormat(83L, 0L, 97L, RFormatType.CONST_SRC2REG_RM, "FCVT.W.D Convert 64 bit float Reg1 to 32 bit signed integer and store 32 bit result into RegD sign extended"));
            this.processOpCode.put("FCVT.WU.D", new RFormat(83L, 1L, 97L, RFormatType.CONST_SRC2REG_RM, "FCVT.WU.D Convert 64 bit float Reg1 to 32 bit unsigned integer and store 32 bit result into RegD zero extended"));
            this.processOpCode.put("FCVT.D.W", new RFormat(83L, 0L, 105L, true, RFormatType.CONST_SRC2REG_RM, "FCVT.D.W Convert 32 bit signed integer Reg1 to 64 bit float and store result into 64 bit float RegD"));
            this.processOpCode.put("FCVT.D.WU", new RFormat(83L, 1L, 105L, true, RFormatType.CONST_SRC2REG_RM, "FCVT.D.WU Convert 32 bit unsigned integer Reg1 to 64 bit float and store result into 64 bit float RegD"));
            if (this.xLen > 32) {
                this.processOpCode.put("FCVT.L.D", new RFormat(83L, 2L, 97L, RFormatType.CONST_SRC2REG_RM, "FCVT.L.D Convert 64 bit float Reg1 to 64 bit signed integer and store 64 bit result into integer RegD sign extended"));
                this.processOpCode.put("FCVT.LU.D", new RFormat(83L, 3L, 97L, RFormatType.CONST_SRC2REG_RM, "FCVT.LU.D Convert 64 bit float Reg1 to 64 bit unsigned integer and store 64 bit result into integer RegD zero extended"));
                this.processOpCode.put("FMV.X.D", new RFormat(83L, 0L, 0L, 113L, "FMV.X.D Copy 64 bit float Reg2 bit pattern to low 64 bits of integer RegD sign extended"));
                this.processOpCode.put("FCVT.D.L", new RFormat(83L, 2L, 105L, true, RFormatType.CONST_SRC2REG_RM, "FCVT.D.L Convert 64 bit signed integer Reg1 to 64 bit float and store result into 64 bit float RegD"));
                this.processOpCode.put("FCVT.D.LU", new RFormat(83L, 3L, 105L, true, RFormatType.CONST_SRC2REG_RM, "FCVT.D.LU Convert 64 bit unsigned integer Reg1 to 64 bit float and store result into 64 bit float RegD"));
                this.processOpCode.put("FMV.D.X", new RFormat(83L, 0L, 0L, 121L, true, "FMV.D.X Copy low 64 bit integer Reg2 bit pattern to 64 bit float RegD"));
            }
        }
        if (this.fExt) {
            this.processOpCode.put("FLW", new IFormat(7L, 2L, immIntExtBaseDsp, EnumSet.of(IFormatType.CONDITIONAL, IFormatType.FLOAT_REG), "FLW: Load 32 bit float into RegD from Reg1 relative sign extended Immediate memory location"));
            this.processOpCode.put("FSW", new SFormat(39L, 2L, immIntExtBaseDsp, EnumSet.of(SFormatType.CONDITIONAL, SFormatType.FLOAT_REG), "SLW Store 32 bit float in Reg2 at Reg1 relative sign extended Immediate memory location"));
            this.processOpCode.put("FMADD.S", new R4Format(67L, true, "FMADD.S Compute 32 bit float [ (Reg1 x Reg2) + Reg3 ] and store 32 bit result into float RegD"));
            this.processOpCode.put("FMSUB.S", new R4Format(71L, true, "FMSUB.S Compute 32 bit float [ (Reg1 x Reg2) - Reg3 ] and store 32 bit result into float RegD"));
            this.processOpCode.put("FNMSUB.S", new R4Format(75L, true, "FNMSUB.S Compute 32 bit float [ - (Reg1 x Reg2) + Reg3 ] and store 32 bit result into float RegD"));
            this.processOpCode.put("FNMADD.S", new R4Format(79L, true, "FNMADD.S Compute 32 bit float [ - (Reg1 x Reg2) - Reg3 ] and store 32 bit result into float RegD"));
            this.processOpCode.put("FADD.S", new RFormat(83L, 0L, true, "FADD.S Compute 32 bit float [ Reg1 + Reg2 ] and store 32 bit result into RegD"));
            this.processOpCode.put("FSUB.S", new RFormat(83L, 4L, true, "FSUB.S Compute 32 bit float [ Reg1 - Reg2 ] and store 32 bit result into RegD"));
            this.processOpCode.put("FMUL.S", new RFormat(83L, 8L, true, "FMUL.S Compute 32 bit float [ Reg1 * Reg2 ] and store 32 bit result into RegD"));
            this.processOpCode.put("FDIV.S", new RFormat(83L, 12L, true, "FDIV.S Compute 32 bit float [ Reg1 / Reg2 ] and store 32 bit result into RegD"));
            this.processOpCode.put("FSQRT.S", new RFormat(83L, 0L, 44L, true, RFormatType.CONST_SRC2REG_RM, "FSQRT.S Compute 32 bit float [ SQRT( Reg1 ) ] and store 32 bit result into float RegD"));
            this.processOpCode.put("FSGNJ.S", new RFormat(83L, 0L, 16L, true, "FSGNJ.S Inject 32 bit float Reg2 sign into 32 bit float Reg1 and store 32 bit result into float RegD"));
            this.processOpCode.put("FSGNJN.S", new RFormat(83L, 1L, 16L, true, "FSGNJN.S Inject 32 bit float Reg2 negated sign into 32 bit float Reg1 and store 32 bit result into float RegD"));
            this.processOpCode.put("FSGNJX.S", new RFormat(83L, 2L, 16L, true, "FSGNJX.S Inject 32 bit float Reg2 and Reg1 signs XORed together into 32 bit float Reg1 and store 32 bit result into RegD"));
            this.processOpCode.put("FMIN.S", new RFormat(83L, 0L, 20L, true, "FMIN.S Compute 32 bit float [ MIN( Reg1 , Reg2 ) ] and store 32 bit result into float RegD"));
            this.processOpCode.put("FMAX.S", new RFormat(83L, 2L, 20L, true, "FMAX.S Compute 32 bit float [ MAX( Reg1 , Reg2 ) ] and store 32 bit result into float RegD"));
            this.processOpCode.put("FCVT.W.S", new RFormat(83L, 0L, 96L, RFormatType.CONST_SRC2REG_RM, "FCVT.W.S Convert 32 bit float Reg1 to 32 bit signed integer and store 32 bit result into integer RegD sign extended"));
            this.processOpCode.put("FCVT.WU.S", new RFormat(83L, 1L, 96L, RFormatType.CONST_SRC2REG_RM, "FCVT.WU.S Convert 32 bit float Reg1 to 32 bit unsigned integer and store 32 bit result into integer RegD zero extended"));
            this.processOpCode.put("FMV.X.W", new RFormat(83L, 0L, 0L, 112L, "FMV.X.W Copy 32 bit float Reg2 bit pattern to low 32 bits of RegD sign extended"));
            this.processOpCode.put("FEQ.S", new RFormat(83L, 2L, 80L, "FEQ.S Compute 32 bit float [ ( Reg1 == Reg2 ) ] and store boolean 0 or 1 result in xLen integer RegD"));
            this.processOpCode.put("FLT.S", new RFormat(83L, 1L, 80L, "FLT.S Compute 32 bit float [ ( Reg1 < Reg2 ) ] and store boolean 0 or 1 result in xLen integer RegD"));
            this.processOpCode.put("FLE.S", new RFormat(83L, 0L, 80L, "FLE.S Compute 32 bit float [ ( Reg1 <= Reg2 ) ] and store boolean 0 or 1 result in xLen integer RegD"));
            this.processOpCode.put("FCLASS.S", new RFormat(83L, 1L, 0L, 112L, "FCLASS.S Compute 32 bit float Reg2 class and store it to low 10 bits of integer RegD zero extended"));
            this.processOpCode.put("FCVT.S.W", new RFormat(83L, 0L, 104L, true, RFormatType.CONST_SRC2REG_RM, "FCVT.S.W Convert 32 bit signed integer Reg1 to 32 bit float and store result into 32 bit float RegD"));
            this.processOpCode.put("FCVT.S.WU", new RFormat(83L, 1L, 104L, true, RFormatType.CONST_SRC2REG_RM, "FCVT.S.WU Convert 32 bit unsigned integer Reg1 to 32 bit float and store result into 32 bit float RegD"));
            this.processOpCode.put("FMV.W.X", new RFormat(83L, 0L, 0L, 120L, true, "FMV.W.X Copy low 32 bit integer Reg2 bit pattern to 32 bit float RegD"));
            if (this.xLen > 32) {
                this.processOpCode.put("FCVT.L.S", new RFormat(83L, 2L, 96L, RFormatType.CONST_SRC2REG_RM, "FCVT.L.S Convert 32 bit float Reg1 to 64 bit signed integer and store 32 bit result into integer RegD sign extended"));
                this.processOpCode.put("FCVT.LU.S", new RFormat(83L, 3L, 96L, RFormatType.CONST_SRC2REG_RM, "FCVT.LU.S Convert 32 bit float Reg1 to 64 bit unsigned integer and store 32 bit result into integer RegD zero extended"));
                this.processOpCode.put("FCVT.S.L", new RFormat(83L, 2L, 104L, true, RFormatType.CONST_SRC2REG_RM, "FCVT.S.L Convert 64 bit signed integer Reg1 to 32 bit float and store result into 32 bit float RegD"));
                this.processOpCode.put("FCVT.S.LU", new RFormat(83L, 3L, 104L, true, RFormatType.CONST_SRC2REG_RM, "FCVT.S.LU Convert 64 bit unsigned integer Reg1 to 32 bit float and store result into 32 bit float RegD"));
            }
        }
        if (this.mExt) {
            this.processOpCode.put("MUL", new RFormat(51L, 0L, 1L, "MUL Multiply xLen values in Reg1 and Reg2 and store low xLen result in RegD"));
            this.processOpCode.put("MULH", new RFormat(51L, 1L, 1L, "MULH Multiply signed xLen values in Reg1 and Reg2 and store high xLen result in RegD"));
            this.processOpCode.put("MULHSU", new RFormat(51L, 2L, 1L, "MULHSU Multiply signed xLen value in Reg1 and unsigned xLen value in Reg2and store high xLen result in RegD"));
            this.processOpCode.put("MULHU", new RFormat(51L, 3L, 1L, "MULHU Multiply unsigned xLen values in Reg1 and Reg2 and store high xLen result in RegD"));
            this.processOpCode.put("DIV", new RFormat(51L, 4L, 1L, "DIV Divide signed xLen value in Reg1 by signed xLen value in Reg2 and store result in RegD"));
            this.processOpCode.put("DIVU", new RFormat(51L, 5L, 1L, "DIVU Divide unsigned xLen value in Reg1 by unsigned xLen value in Reg2 and store result in RegD"));
            this.processOpCode.put("REM", new RFormat(51L, 6L, 1L, "REM Divide signed xLen value in Reg1 by signed xLen value in Reg2 and store reminder in RegD"));
            this.processOpCode.put("REMU", new RFormat(51L, 7L, 1L, "REMU Divide usigned xLen value in Reg1 by usigned xLen value in Reg2 and store reminder in RegD"));
            if (this.xLen >= 64) {
                this.processOpCode.put("MULW", new RFormat(59L, 0L, 1L, "MULW Multiply low 32 bit signed values in Reg1 and Reg2 and store low 32 bit signed result in RegD"));
                this.processOpCode.put("DIVW", new RFormat(59L, 4L, 1L, "DIVW Divide low 32 bit signed values in Reg1 and Reg2 and store 32 bit result signed extended to 64 bits in RegD"));
                this.processOpCode.put("DIVUW", new RFormat(59L, 5L, 1L, "DIVW Divide low 32 bits unsigned values in Reg1 and Reg2 and store 32 bit result signed extended to 64 bits in RegD"));
                this.processOpCode.put("REMW", new RFormat(59L, 6L, 1L, "REMW Divide low 32 bit signed values in Reg1 and Reg2 and store 32 bit reminder signed extended to 64 bits in RegD"));
                this.processOpCode.put("REMUW", new RFormat(59L, 7L, 1L, "REMUW Divide low 32 bit unsigned values in Reg1 and Reg2 and store 32 bit reminder signed extended to 64 bits in RegD"));
            }
        }
        if (this.nExt) {
            this.processOpCode.put("URET", new NPFormat(2097267L, "URET: Return from user level interrupt"));
        }
        if (this.qExt) {
            this.processOpCode.put("FLQ", new IFormat(7L, 4L, immIntExtBaseDsp, EnumSet.of(IFormatType.CONDITIONAL, IFormatType.FLOAT_REG), "FLQ: Load 128 bit float into RegD from Reg1 relative sign extended Immediate memory location"));
            this.processOpCode.put("FSQ", new SFormat(39L, 4L, immIntExtBaseDsp, EnumSet.of(SFormatType.CONDITIONAL, SFormatType.FLOAT_REG), "FSQ Store 128 bit float in Reg2 at Reg1 relative sign extended Immediate memory location"));
            this.processOpCode.put("FMADD.Q", new R4Format(100663363L, true, "FMADD.Q Compute 128 bit float [ (Reg1 x Reg2) + Reg3 ] and store 128 bit result into float RegD"));
            this.processOpCode.put("FMSUB.Q", new R4Format(100663367L, true, "FMSUB.Q Compute 128 bit float [ (Reg1 x Reg2) - Reg3 ] and store 128 bit result into float RegD"));
            this.processOpCode.put("FNMSUB.Q", new R4Format(100663371L, true, "FNMSUB.Q Compute 128 bit float [ - (Reg1 x Reg2) + Reg3 ] and store 128 bit result into float RegD"));
            this.processOpCode.put("FNMADD.Q", new R4Format(100663375L, true, "FNMADD.Q Compute 128 bit float [ - (Reg1 x Reg2) - Reg3 ] and store 128 bit result into float RegD"));
            this.processOpCode.put("FADD.Q", new RFormat(83L, 3L, true, "FADD.Q Compute 128 bit float [ Reg1 + Reg2 ] and store 128 bit result into float RegD"));
            this.processOpCode.put("FSUB.Q", new RFormat(83L, 7L, true, "FSUB.Q Compute 128 bit float [ Reg1 - Reg2 ] and store 128 bit result into float RegD"));
            this.processOpCode.put("FMUL.Q", new RFormat(83L, 11L, true, "FMUL.Q Compute 128 bit float [ Reg1 * Reg2 ] and store 128 bit result into float RegD"));
            this.processOpCode.put("FDIV.Q", new RFormat(83L, 15L, true, "FDIV.Q Compute 128 bit float [ Reg1 / Reg2 ] and store 128 bit result into float RegD"));
            this.processOpCode.put("FSQRT.Q", new RFormat(83L, 0L, 47L, true, RFormatType.CONST_SRC2REG_RM, "FSQRT.Q Compute 128 bit float [ SQRT( Reg1 ) ] and store 128 bit result into float RegD"));
            this.processOpCode.put("FSGNJ.Q", new RFormat(83L, 0L, 19L, true, "FSGNJ.Q Inject 128 bit float Reg2 sign into 128 bit float Reg1 and store 128 bit result into float RegD"));
            this.processOpCode.put("FSGNJN.Q", new RFormat(83L, 1L, 19L, true, "FSGNJN.Q Inject 128 bit float Reg2 negated sign into 128 bit float Reg1 and store 128 bit result into  floatRegD"));
            this.processOpCode.put("FSGNJX.Q", new RFormat(83L, 2L, 19L, true, "FSGNJX.Q Inject 128 bit float Reg2 and Reg1 signs XORed together into 128 bit float Reg1 and store 128 bit result into RegD"));
            this.processOpCode.put("FMIN.Q", new RFormat(83L, 0L, 23L, true, "FMIN.Q Compute 128 bit float [ MIN( Reg1 + Reg2 ) ] and store 128 bit result into RegD"));
            this.processOpCode.put("FMAX.Q", new RFormat(83L, 1L, 23L, true, "FMAX.Q Compute 128 bit float [ MAX( Reg1 + Reg2 ) ] and store 128 bit result into RegD"));
            this.processOpCode.put("FCVT.S.Q", new RFormat(83L, 3L, 32L, true, RFormatType.CONST_SRC2REG_RM, "FCVT.S.Q Convert 128 bit float Reg1 to 32 bit float and store result into 32 bit float RegD"));
            this.processOpCode.put("FCVT.Q.S", new RFormat(83L, 0L, 35L, true, RFormatType.CONST_SRC2REG_RM, "FCVT.Q.S Convert 32 bit float Reg1 to 128 bit float and store result into 128 bit float RegD"));
            this.processOpCode.put("FCVT.D.Q", new RFormat(83L, 3L, 33L, true, RFormatType.CONST_SRC2REG_RM, "FCVT.D.Q Convert 128 bit float Reg1 to 64 bit float and store result into 64 bit float RegD"));
            this.processOpCode.put("FCVT.Q.D", new RFormat(83L, 1L, 35L, true, RFormatType.CONST_SRC2REG_RM, "FCVT.Q.D Convert 64 bit float Reg1 to 128 bit float and store result into 128 bit float RegD"));
            this.processOpCode.put("FEQ.Q", new RFormat(83L, 2L, 83L, "FEQ.Q Compute 128 bit float [ ( Reg1 == Reg2 ) ] and store boolean 0 or 1 result in xLen integer RegD"));
            this.processOpCode.put("FLT.Q", new RFormat(83L, 1L, 83L, "FLT.Q Compute 128 bit float [ ( Reg1 < Reg2 ) ] and store boolean 0 or 1 result in xLen integer RegD"));
            this.processOpCode.put("FLE.Q", new RFormat(83L, 0L, 83L, "FLE.Q Compute 128 bit float [ ( Reg1 <= Reg2 ) ] and store boolean 0 or 1 result in xLen integer RegD"));
            this.processOpCode.put("FCLASS.Q", new RFormat(83L, 1L, 0L, 115L, "FCLASS.Q Compute 128 bit float Reg2 class and store it to low 10 bits of integer RegD zero extended"));
            this.processOpCode.put("FCVT.W.Q", new RFormat(83L, 0L, 99L, RFormatType.CONST_SRC2REG_RM, "FCVT.W.Q Convert 128 bit float Reg1 to 32 bit signed integer and store 32 bit result into integer RegD sign extended"));
            this.processOpCode.put("FCVT.WU.Q", new RFormat(83L, 1L, 99L, RFormatType.CONST_SRC2REG_RM, "FCVT.WU.Q Convert 128 bit float Reg1 to 32 bit unsigned integer and store 32 bit result into integer RegD zero extended"));
            this.processOpCode.put("FCVT.Q.W", new RFormat(83L, 0L, 107L, true, RFormatType.CONST_SRC2REG_RM, "FCVT.Q.W Convert 32 bit signed integer Reg1 to 128 bit float and store result into 128 bit float RegD"));
            this.processOpCode.put("FCVT.Q.WU", new RFormat(83L, 1L, 107L, true, RFormatType.CONST_SRC2REG_RM, "FCVT.Q.WU Convert 32 bit unsigned integer Reg1 to 128 bit float and store result into 128 bit float RegD"));
            if (this.xLen > 32) {
                this.processOpCode.put("FCVT.L.Q", new RFormat(83L, 2L, 99L, RFormatType.CONST_SRC2REG_RM, "FCVT.L.Q Convert 128 bit float Reg1 to 64 bit signed integer and store 64 bit result into integer RegD sign extended"));
                this.processOpCode.put("FCVT.LU.Q", new RFormat(83L, 3L, 99L, RFormatType.CONST_SRC2REG_RM, "FCVT.LU.Q Convert 128 bit float Reg1 to 64 bit unsigned integer and store 64 bit result into integer RegD zero extended"));
                this.processOpCode.put("FCVT.Q.L", new RFormat(83L, 2L, 107L, true, RFormatType.CONST_SRC2REG_RM, "FCVT.Q.L Convert 64 bit signed integer Reg1 to 128 bit float and store result into 128 bit float RegD"));
                this.processOpCode.put("FCVT.Q.LU", new RFormat(83L, 3L, 107L, true, RFormatType.CONST_SRC2REG_RM, "FCVT.Q.LU Convert 64 bit unsigned integer Reg1 to 128 bit float and store result into 128 bit float RegD"));
            }
        }
        if (this.sExt) {
            this.processOpCode.put("SRET", new NPFormat(2097267L, "SRET: Return from supervisor level interrupt"));
            this.processOpCode.put("MRET", new NPFormat(2097267L, "MRET: Return from machine level interrupt"));
            this.processOpCode.put("SFENCE.VMA", new RFormat(9L, 0L, 115L, RFormatType.ZERO_DESTREG, "SFENCE.VMA Clear VM TLB for address in Reg1 (all addresses if R0) and ASID in Reg2 (all ASIDs if R0)"));
            this.processOpCode.put("WFI", new NPFormat(273678451L, "WFI: Wait for interrupt"));
        }
        if (this.zicsrExt) {
            this.processOpCode.put("CSRRW", new IFormat(115L, 1L, immInt, "CSRRW: Atomically store CSR, specified by immediate value, into RegD and store Reg1 content into CSR"));
            this.processOpCode.put("CSRRS", new IFormat(115L, 2L, immInt, "CSRRS: Atomically store CSR, specified by immediate value, into RegD and mask CSR bits using Reg1 content as a sign extended mask (Reg1 OR CSR)"));
            this.processOpCode.put("CSRRC", new IFormat(115L, 3L, immInt, "CSRRC: Atomically store CSR, specified by immediate value, into RegD and clear CSR bits using Reg1 content as a sign extended mask (~ Reg1 AND CSR)"));
            this.processOpCode.put("CSRRWI", new IIFormat(115L, 5L, "CSRRWI: Atomically store CSR, specified by Imm1, into RegD and store Imm2 into CSR"));
            this.processOpCode.put("CSRRSI", new IIFormat(115L, 6L, "CSRRSI: Atomically store CSR, specified in Imm1, into RegD and mask CSR bits using Imm2 \nas a sign extended mask (Reg1 VALUE OR CSR)"));
            this.processOpCode.put("CSRRCI", new IIFormat(115L, 7L, "CSRRCI: Atomically store CSR, specified in Imm1, into RegD and clear CSR bits using Imm2 \nas a sign extended mask (~ Reg1 VALUE AND CSR)"));
        }
        if (this.zifenceiExt) {
            this.processOpCode.put("FENCE.I", new NPFormat(4111L, "FENCE.I: Synchronize data and instruction cache for the current hart"));
        }
    }

    @Override
    public DVOpCodeProcessor getOpCodeProcessor(DVStatements.Statement statement, Token token) {
        return this.processOpCode.get(token.image.toUpperCase());
    }

    private DVCode cRFormat(DVStatements.Statement statement, long l, long l2, long l3) {
        String string = statement.getOpCode();
        if (string.contentEquals("ADD")) {
            if (l == 0L) {
                return null;
            }
            if (l2 == 0L && l3 != 0L) {
                return DVArchOpCodes.crEncode(statement, 32770L, l, l3, statement.getOpCode() + " -> C.MV: copy value from source register to destination register");
            }
            if (l2 != 0L && l3 == 0L) {
                return DVArchOpCodes.crEncode(statement, 32770L, l, l2, statement.getOpCode() + " -> C.MV: copy value from source register to destination register");
            }
            if (l == l2) {
                return DVArchOpCodes.crEncode(statement, 36866L, l, l3, statement.getOpCode() + " -> C.ADD: add value from source register to destination register");
            }
            if (l == l3) {
                return DVArchOpCodes.crEncode(statement, 36866L, l, l2, statement.getOpCode() + " -> C.ADD: add value from source register to destination register");
            }
            return null;
        }
        if (l < 8L || l > 15L || l2 < 8L || l2 > 15L || l3 < 8L || l3 > 15L || l != l2 && l != l3) {
            return null;
        }
        long l4 = l == l2 ? l3 : l2;
        switch (string) {
            case "AND": {
                return DVArchOpCodes.caEncode(statement, 36866L, l, l4, "AND -> C.AND: and value from source register with destination register");
            }
            case "OR": {
                return DVArchOpCodes.caEncode(statement, 36866L, l, l4, "OR -> C.OR: or value from source register with destination register");
            }
            case "XOR": {
                return DVArchOpCodes.caEncode(statement, 36866L, l, l4, "XOR -> C.XOR: xor value from source register with destination register");
            }
            case "SUB": {
                if (l == l2) {
                    return DVArchOpCodes.caEncode(statement, 36866L, l, l3, "SUB -> C.SUB: subtract value of source register from destination register");
                }
                return null;
            }
            case "ADD.W": {
                return DVArchOpCodes.caEncode(statement, 36866L, l, l4, "ADD.W -> C.AND.W: add value from source register with destination register and sign extend low 32 bits");
            }
            case "SUB.W": {
                if (l == l2) {
                    return DVArchOpCodes.caEncode(statement, 36866L, l, l4, "SUB.W -> C.SUB.W: subtract value of source register from destination register and sign extend low 32 bits");
                }
                return null;
            }
        }
        return null;
    }

    private DVCode cIFormat(DVStatements.Statement statement, long l, long l2, BigInteger bigInteger) {
        String string = statement.getOpCode();
        int n = bigInteger.bitLength();
        int n2 = bigInteger.signum();
        if (n2 <= 0) {
            ++n;
        }
        switch (string) {
            case "ADDI": {
                if (l != l2 || l == 0L || n2 == 0) {
                    return null;
                }
                if (n < 6) {
                    return DVArchOpCodes.ciEncode(statement, 1L, l, bigInteger, CiImm.I, "ADDI -> C.ADDI: add immediate value to destination register");
                }
                if (l == 2L) {
                    if (n < 10 && this.immLowBitsZero(bigInteger, 4)) {
                        return DVArchOpCodes.ciEncode(statement, 24577L, l, bigInteger, CiImm.I16, "ADDI -> C.ADDI16SP: add immediate value multiplied by 16 to register 2");
                    }
                    if (this.validCReg(l) && n2 > 0 && n < 11 && this.immLowBitsZero(bigInteger, 2)) {
                        return DVArchOpCodes.ciwEncode(statement, 0L, l, bigInteger, "ADDI -> C.ADDI4SPN: add immediate value multiplied by 4 to register 2 and store result to destination register");
                    }
                }
                return null;
            }
            case "ADDI.W": {
                if (l == l2 && n < 6) {
                    return DVArchOpCodes.ciEncode(statement, 8193L, l, bigInteger, CiImm.I, "ADDI.W -> C.ADDIW: add value from source register to destination register and sign extend low 32 bits");
                }
                return null;
            }
            case "SLLI": {
                if (l == l2 && n2 > 0) {
                    if (this.xLen > 64 && bigInteger.equals(BigInteger.valueOf(64L))) {
                        return DVArchOpCodes.ciEncode(statement, 2L, l, BigInteger.valueOf(64L), CiImm.I, "C.SLLI -> SLLI: left logical shift value of 64 in destination register encoded as zero");
                    }
                    if (n < 5 || this.xLen > 64 && n < 6) {
                        return DVArchOpCodes.ciEncode(statement, 2L, l, bigInteger, CiImm.I, "C.SLLI -> SLLI: left logical shift value in destination register by immediate");
                    }
                }
                return null;
            }
            case "SRLI": {
                if (this.matchCRegPair(l, l2) && n2 > 0) {
                    if (this.xLen > 64 && this.immAllBitsOne(bigInteger, new int[]{6})) {
                        return DVArchOpCodes.ciEncode(statement, 32769L, l, BigInteger.valueOf(64L), CiImm.I, "C.SRLI -> SRLI: right logical shift value of 64 in destination register encoded as zero");
                    }
                    if (n < 5 || this.xLen > 64 && (n2 > 0 && n < 6 || n < 8 && this.immAllBitsOne(bigInteger, new int[]{6, 5}))) {
                        return DVArchOpCodes.ciEncode(statement, 32769L, l, bigInteger, CiImm.I, "C.SRLI -> SRLI: right logical shift value in destination register by immediate (sign extended to 7 bits)");
                    }
                }
                return null;
            }
            case "SRAI": {
                if (this.matchCRegPair(l, l) && n2 > 0) {
                    if (this.xLen > 64 && this.immAllBitsOne(bigInteger, new int[]{6})) {
                        return DVArchOpCodes.cbEncode(statement, 33793L, l, BigInteger.valueOf(64L), CbImm.S, "C.SRAI -> SRAI: right arithmetic shift value in destination register by 64 encoded as zero");
                    }
                    if (n < 5 || this.xLen > 64 && (n2 > 0 && n < 6 || n < 8 && this.immAllBitsOne(bigInteger, new int[]{6, 5}))) {
                        return DVArchOpCodes.cbEncode(statement, 33793L, l, bigInteger, CbImm.S, "C.SRAI -> SRAI: right arithmetic shift value in destination register by immediate (sign extended to 7 bits)");
                    }
                }
                return null;
            }
            case "ANDI": {
                if (this.matchCRegPair(l, l) && n2 > 0) {
                    return DVArchOpCodes.cbEncode(statement, 34817L, l, bigInteger, CbImm.I, "C.ANDI -> SAND: and value in destination register by immediate (sign extended to 7 bits)");
                }
                return null;
            }
            case "JALR": {
                if (l == 0L && l2 != 0L && n2 == 0) {
                    return DVArchOpCodes.crEncode(statement, 32770L, l2, l, "C.J -> JALR: branch to source resgister address");
                }
                if (l == 1L && l2 != 0L && n2 == 0) {
                    return DVArchOpCodes.crEncode(statement, 36866L, l, l2, "C.J -> JALR: branch to source resgister address and store return address in register 1");
                }
                return null;
            }
            case "LW": {
                if (n2 < 0 || n >= 8 || !this.immLowBitsZero(bigInteger, 2)) {
                    return null;
                }
                if (l2 == 2L && l != 0L) {
                    return DVArchOpCodes.ciEncode(statement, 16386L, l, bigInteger, CiImm.L32, "C.LWSP -> LW: load 32 bit value at offset Immediate[7:2] off register 2 into RegD");
                }
                if (this.validCRegPair(l2, l)) {
                    return DVArchOpCodes.clEncode(statement, 16384L, l, l2, bigInteger, ClsImm.L32, "C.LW -> LW: load 32 bit value at offset Immediate[6:2] off Reg1 into RegD");
                }
                return null;
            }
            case "LD": {
                if (n2 < 0 || n >= 9 || !this.immLowBitsZero(bigInteger, 3)) {
                    return null;
                }
                if (l2 == 2L && l != 0L) {
                    return DVArchOpCodes.ciEncode(statement, 24578L, l, bigInteger, CiImm.L64, "C.LDSP -> LD: load 64 bit value at offset Immediate[9:3] off register 2 into RegD");
                }
                if (this.validCRegPair(l2, l)) {
                    return DVArchOpCodes.clEncode(statement, 24576L, l, l2, bigInteger, ClsImm.L64, "C.LD -> LD: load 64 bit value at offset Immediate[7:3] off Reg1 into RegD");
                }
                return null;
            }
            case "LQ": {
                if (n2 < 0 || n >= 10 || !this.immLowBitsZero(bigInteger, 4)) {
                    return null;
                }
                if (l2 == 2L && l != 0L) {
                    return DVArchOpCodes.ciEncode(statement, 8194L, l, bigInteger, CiImm.L128, "C.LQSP -> LQ: load 128 bit value at offset Immediate[10:4] off register 2 into RegD");
                }
                if (this.validCRegPair(l2, l)) {
                    return DVArchOpCodes.clEncode(statement, 24576L, l, l2, bigInteger, ClsImm.L128, "C.LQ -> LQ: load 128 bit value at offset Immediate[8:4] off Reg1 into RegD");
                }
                return null;
            }
            case "FLW": {
                if (n2 < 0 || n >= 8 || !this.immLowBitsZero(bigInteger, 2)) {
                    return null;
                }
                if (this.xLen == 32 && l2 == 2L) {
                    return DVArchOpCodes.ciEncode(statement, 24578L, l, bigInteger, CiImm.L32, "C.FLWSP -> FLW: load 32 bit value at offset Immediate[7:2] off register 2 into float RegD");
                }
                if (this.xLen == 32 && this.validCRegPair(l2, l)) {
                    return DVArchOpCodes.clEncode(statement, 24576L, l, l2, bigInteger, ClsImm.L32, "C.FLW -> FLW: load 32 bit value at offset Immediate[6:2] off Reg1 into float RegD");
                }
                return null;
            }
            case "FLD": {
                if (n2 < 0 || n >= 9 || !this.immLowBitsZero(bigInteger, 3)) {
                    return null;
                }
                if (this.xLen <= 64 && l2 == 2L && l != 0L) {
                    return DVArchOpCodes.ciEncode(statement, 8194L, l, bigInteger, CiImm.L64, "C.FLDSP -> FLD: load 64 bit value at offset Immediate[9:3] off register 2 into float RegD");
                }
                if (this.xLen <= 64 && this.validCRegPair(l2, l)) {
                    return DVArchOpCodes.clEncode(statement, 8192L, l, l2, bigInteger, ClsImm.L64, "C.FLD -> FLD: load 64 bit value at offset Immediate[7:3] off Reg1 into float RegD");
                }
                return null;
            }
        }
        return null;
    }

    private DVCode cSFormat(DVStatements.Statement statement, long l, long l2, BigInteger bigInteger) {
        String string = statement.getOpCode();
        int n = bigInteger.signum();
        int n2 = bigInteger.bitLength();
        switch (string) {
            case "SW": {
                if (l == 2L && n >= 0 && n2 < 8 && this.immLowBitsZero(bigInteger, 2)) {
                    return DVArchOpCodes.cssEncode(statement, 49154L, l2, bigInteger, CssImm.L32, "C.SWSP -> SW: store 32 bit value in Reg2 (Source) at offset Immediate[7:2] off register 2 (Base)");
                }
                if (this.validCRegPair(l, l2) && n >= 0 && n2 < 7 && this.immLowBitsZero(bigInteger, 2)) {
                    return DVArchOpCodes.csEncode(statement, 49152L, l2, l, bigInteger, ClsImm.L32, "C.SW -> SW: store 32 bit value in Reg2 (Source) at offset Immediate[6:2] off Reg1 (Base)");
                }
                return null;
            }
            case "SD": {
                if (l == 2L && n >= 0 && n2 < 9 && this.immLowBitsZero(bigInteger, 3)) {
                    return DVArchOpCodes.cssEncode(statement, 57346L, l2, bigInteger, CssImm.L64, "C.SDSP -> SD: store 64 bit value in Reg2 (Source) at offset Immediate[9:3] off register 2 (Base)");
                }
                if (this.validCRegPair(l, l2) && n >= 0 && n2 < 8 && this.immLowBitsZero(bigInteger, 3)) {
                    return DVArchOpCodes.csEncode(statement, 57344L, l2, l, bigInteger, ClsImm.L64, "C.SD -> SD: store 64 bit value in Reg2 (Source) at offset Immediate[7:3] off Reg1 (Base)");
                }
                return null;
            }
            case "SQ": {
                if (l == 2L && n >= 0 && n2 < 10 && this.immLowBitsZero(bigInteger, 4)) {
                    return DVArchOpCodes.cssEncode(statement, 40962L, l2, bigInteger, CssImm.L128, "C.SQSP -> SQ: store 128 bit value in Reg2 (Source) at offset Immediate[10:4] off register 2 (Base)");
                }
                if (this.validCRegPair(l, l2) && n >= 0 && n2 < 9 && this.immLowBitsZero(bigInteger, 4)) {
                    return DVArchOpCodes.csEncode(statement, 40960L, l2, l, bigInteger, ClsImm.L128, "C.SQ -> SQ: store 128 bit value in Reg2 (Source) at offset Immediate[8:4] off Reg1 (Base)");
                }
                return null;
            }
            case "FSW": {
                if (this.xLen == 32 && l == 2L && n >= 0 && n2 < 8 && this.immLowBitsZero(bigInteger, 2)) {
                    return DVArchOpCodes.cssEncode(statement, 57346L, l2, bigInteger, CssImm.L32, "C.FSWSP -> FSW: store 32 bit value in float Reg2 (Source) at offset Immediate[7:2] off register 2 (Base)");
                }
                if (this.xLen == 32 && this.validCRegPair(l, l2) && n >= 0 && n2 < 7 && this.immLowBitsZero(bigInteger, 2)) {
                    return DVArchOpCodes.csEncode(statement, 57344L, l2, l, bigInteger, ClsImm.L32, "C.FSW -> FSW: store 32 bit value in float Reg2 (Source) at offset Immediate[6:2] off Reg1 (Base)");
                }
                return null;
            }
            case "FSD": {
                if (this.xLen <= 64 && l == 2L && n >= 0 && n2 < 9 && this.immLowBitsZero(bigInteger, 3)) {
                    return DVArchOpCodes.cssEncode(statement, 40962L, l2, bigInteger, CssImm.L64, "C.FSDSP -> FSD: store 64 bit value in float Reg2 (Source) at offset Immediate[9:3] off register 2 (Base)");
                }
                if (this.xLen <= 64 && this.validCRegPair(l, l2) && n >= 0 && n2 < 8 && this.immLowBitsZero(bigInteger, 3)) {
                    return DVArchOpCodes.csEncode(statement, 40960L, l2, l, bigInteger, ClsImm.L64, "C.FSD -> FSD: store 64 bit value in float Reg2 (Source) at offset Immediate[7:3] off Reg1 (Base)");
                }
                return null;
            }
        }
        return null;
    }

    private DVCode cBFormat(DVStatements.Statement statement, long l, long l2, BigInteger bigInteger) {
        String string = statement.getOpCode();
        int n = bigInteger.bitLength();
        switch (string) {
            case "BEQ": {
                if (this.validCReg(l) && l2 == 0L && n < 9) {
                    return DVArchOpCodes.cbEncode(statement, 49153L, l, bigInteger, CbImm.B, "C.BEQZ -> BEQ: branch to relative PC immediate when source register is zero");
                }
                if (this.validCReg(l2) && l == 0L && n < 9) {
                    return DVArchOpCodes.cbEncode(statement, 49153L, l2, bigInteger, CbImm.B, "C.BEQZ -> BEQ: branch to relative PC immediate when source register is zero");
                }
                return null;
            }
            case "BNE": {
                if (this.validCReg(l) && l2 == 0L && n < 9) {
                    return DVArchOpCodes.cbEncode(statement, 57345L, l, bigInteger, CbImm.B, "C.BNEZ -> BNE: branch to relative PC immediate when source register is not equal zero");
                }
                if (this.validCReg(l2) && l == 0L && n < 9) {
                    return DVArchOpCodes.cbEncode(statement, 57345L, l2, bigInteger, CbImm.B, "C.BNEZ -> BNE: branch to relative PC immediate when source register is not equal zero");
                }
                return null;
            }
        }
        return null;
    }

    private DVCode cUFormat(DVStatements.Statement statement, long l, long l2) {
        String string = statement.getOpCode();
        return null;
    }

    private DVCode cJFormat(DVStatements.Statement statement, long l, BigInteger bigInteger) {
        String string;
        switch (string = statement.getOpCode()) {
            case "JAL": {
                if (l == 0L && bigInteger.bitLength() < 12) {
                    return DVArchOpCodes.cjEncode(statement, 40961L, bigInteger, "C.J -> JAL: branch to relative PC immediate without storing return address in any register");
                }
                if (this.xLen == 32 && l == 1L && bigInteger.bitLength() < 12) {
                    return DVArchOpCodes.cjEncode(statement, 8193L, bigInteger, "C.JAL -> JAL: branch to relative PC immediate and store return address in register 1");
                }
                return null;
            }
        }
        return null;
    }

    private static DVCode crEncode(DVStatements.Statement statement, long l, long l2, long l3, String string) {
        long l4 = l | l2 << 7 | l3 << 2;
        return new DVCode(DVArchOpCodes.convertLongToShortCode(l4), String.format("%02X%02X", l4 & 0xFFL, l4 >> 8 & 0xFFL), String.format("At OFFSET=%04X: %s\n Machine Instruction....... %04X [BIG ENDIAN]\n Dest/Src2   Register...... %2d\n Source 1    Register...... %2d", statement.getOffset().intValue(), string, l4, l2, l3));
    }

    private static DVCode ciEncode(DVStatements.Statement statement, long l, long l2, BigInteger bigInteger, CiImm ciImm, String string) {
        long l3 = DVArchOpCodes.maskImmediate(bigInteger, DVArchOpCodes.getCiHighBit(ciImm) + 1);
        long l4 = l | l2 << 7 | DVArchOpCodes.getCiImm(ciImm, l3);
        return new DVCode(DVArchOpCodes.convertLongToShortCode(l4), String.format("%02X%02X", l4 & 0xFFL, l4 >> 8 & 0xFFL), String.format("At OFFSET=%04X: %s\n Machine Instruction....... %04X [BIG ENDIAN]\n Dest/src    Register...... %2d\n Immediate................. %s [HEX]\n Immediate Encoded......... %s [BIN] Bits [%d:%d]", statement.getOffset().intValue(), string, l4, l2, DVArchOpCodes.immediateToHex(bigInteger, 3), DVArchOpCodes.immediateToBinary(bigInteger.shiftRight(DVArchOpCodes.getCiShift(ciImm)), DVArchOpCodes.getCiBitSections(ciImm)), DVArchOpCodes.getCiHighBit(ciImm), DVArchOpCodes.getCiShift(ciImm)));
    }

    private static int getCiShift(CiImm ciImm) {
        return (new int[]{0, 4, 2, 3, 4})[ciImm.ordinal()];
    }

    private static int getCiHighBit(CiImm ciImm) {
        return (new int[]{5, 9, 7, 8, 9})[ciImm.ordinal()];
    }

    private static long getCiImm(CiImm ciImm, long l) {
        switch (ciImm) {
            case I: {
                return (l & 0x20L) << 7 | (l & 0x1FL) << 2;
            }
            case I16: {
                return (l & 0x200L) << 3 | (l & 0x180L) >> 4 | (l & 0x40L) >> 1 | (l & 0x20L) >> 3 | (l & 0x10L) << 2;
            }
            case L32: {
                return (l & 0xC0L) >> 4 | (l & 0x20L) << 7 | (l & 0x1CL) << 2;
            }
            case L64: {
                return (l & 0x1C0L) >> 2 | (l & 0x20L) << 7 | (l & 0x18L) << 2;
            }
        }
        return (l & 0x3C0L) >> 4 | (l & 0x20L) << 7 | (l & 0x10L) << 2;
    }

    private static int[] getCiBitSections(CiImm ciImm) {
        return (new int[][]{{1, 5}, {1, 2, 1, 1, 1}, {2, 1, 3}, {3, 1, 2}, {4, 1, 1}})[ciImm.ordinal()];
    }

    private static DVCode cssEncode(DVStatements.Statement statement, long l, long l2, BigInteger bigInteger, CssImm cssImm, String string) {
        long l3 = l | l2 << 2 | DVArchOpCodes.getCssImm(cssImm, bigInteger.longValue());
        return new DVCode(DVArchOpCodes.convertLongToShortCode(l3), String.format("%02X%02X", l3 & 0xFFL, l3 >> 8 & 0xFFL), String.format("At OFFSET=%04X: %s\n Machine Instruction....... %04X [BIG ENDIAN]\n Dest/src    Register...... %2d\n Immediate................. %s [HEX]\n Immediate Encoded......... %s [BIN] Bits [%d:%d]", statement.getOffset().intValue(), string, l3, l2, DVArchOpCodes.immediateToHex(bigInteger, 3), DVArchOpCodes.immediateToBinary(bigInteger.shiftRight(DVArchOpCodes.getCssShift(cssImm)), DVArchOpCodes.getCssBitSections(cssImm)), DVArchOpCodes.getCssHighBit(cssImm), DVArchOpCodes.getCssShift(cssImm)));
    }

    private static int getCssShift(CssImm cssImm) {
        return (new int[]{2, 3, 4})[cssImm.ordinal()];
    }

    private static int getCssHighBit(CssImm cssImm) {
        return (new int[]{7, 8, 9})[cssImm.ordinal()];
    }

    private static long getCssImm(CssImm cssImm, long l) {
        switch (cssImm) {
            case L32: {
                return (l & 0xC0L) << 1 | (l & 0x1CL) << 8;
            }
            case L64: {
                return (l & 0x1C0L) << 1 | (l & 0x18L) << 7;
            }
        }
        return (l & 0x1E0L) << 1 | (l & 0x10L) << 6;
    }

    private static int[] getCssBitSections(CssImm cssImm) {
        return (new int[][]{{2, 4}, {3, 3}, {4, 2}})[cssImm.ordinal()];
    }

    private static DVCode ciwEncode(DVStatements.Statement statement, long l, long l2, BigInteger bigInteger, String string) {
        long l3 = l | l2 << 2 | (bigInteger.longValue() & 0x3FCL) << 3;
        return new DVCode(DVArchOpCodes.convertLongToShortCode(l3), String.format("%02X%02X", l3 & 0xFFL, l3 >> 8 & 0xFFL), String.format("%s\n Machine Instruction....... %04X [BIG ENDIAN]\n Destination Register...... %2d\n Source      Register......  2\n Immediate................. %s [HEX]\n Immediate Encoded......... %s [BIN] Bits [9:2]", string, l3, l2, DVArchOpCodes.immediateToHex(bigInteger, 3), DVArchOpCodes.immediateToBinary(bigInteger.shiftRight(2), new int[]{4, 2, 1, 1})));
    }

    private static DVCode clEncode(DVStatements.Statement statement, long l, long l2, long l3, BigInteger bigInteger, ClsImm clsImm, String string) {
        long l4 = l | l2 - 8L << 2 | l3 - 8L << 7 | DVArchOpCodes.getClsImm(clsImm, bigInteger.longValue()) >> clsImm.ordinal() + 2;
        return new DVCode(DVArchOpCodes.convertLongToShortCode(l4), String.format("%02X%02X", l4 & 0xFFL, l4 >> 8 & 0xFFL), String.format("%s\n Machine Instruction....... %04X [BIG ENDIAN]\n Destination Register...... %2d\n Source      Register...... %2d\n Immediate................. %s [HEX]\n Immediate Encoded......... %s [BIN] Bits [%d:%d]", string, l4, l2, l3, DVArchOpCodes.immediateToHex(bigInteger, 2), DVArchOpCodes.immediateToBinary(bigInteger.shiftRight(clsImm.ordinal() + 2), DVArchOpCodes.getClsBitSections(clsImm)), 5 + clsImm.ordinal(), clsImm.ordinal()));
    }

    private static DVCode csEncode(DVStatements.Statement statement, long l, long l2, long l3, BigInteger bigInteger, ClsImm clsImm, String string) {
        long l4 = l | l2 - 8L << 2 | l3 - 8L << 7 | DVArchOpCodes.getClsImm(clsImm, bigInteger.longValue()) >> clsImm.ordinal() + 2;
        return new DVCode(DVArchOpCodes.convertLongToShortCode(l4), String.format("%02X%02X", l4 & 0xFFL, l4 >> 8 & 0xFFL), String.format("%s\n Machine Instruction....... %04X [BIG ENDIAN]\n Source      Register...... %2d\n Base        Register...... %2d\n Immediate................. %s [HEX]\n Immediate Encoded......... %s [BIN] Bits [%d:%d]", string, l4, l2, l3, DVArchOpCodes.immediateToHex(bigInteger, 2), DVArchOpCodes.immediateToBinary(bigInteger, DVArchOpCodes.getClsBitSections(clsImm)), 5 + clsImm.ordinal(), clsImm.ordinal()));
    }

    private static long getClsImm(ClsImm clsImm, long l) {
        switch (clsImm) {
            case L32: {
                return (l & 0x40L) >> 1 | (l & 0x38L) << 7 | (l & 4L) << 4;
            }
            case L64: {
                return (l & 0x180L) << 1 | (l & 0x38L) << 7;
            }
        }
        return (l & 0x100L) << 2 | (l & 0xC0L) << 1 | (l & 0x30L) << 7;
    }

    private static int[] getClsBitSections(ClsImm clsImm) {
        return (new int[][]{{1, 3, 1}, {2, 3}, {1, 2, 2}})[clsImm.ordinal()];
    }

    private static DVCode caEncode(DVStatements.Statement statement, long l, long l2, long l3, String string) {
        long l4 = l | l2 - 8L << 7 | l3 - 8L << 2;
        return new DVCode(DVArchOpCodes.convertLongToShortCode(l4), String.format("%02X%02X", l4 & 0xFFL, l4 >> 8 & 0xFFL), String.format("At OFFSET=%04X: %s\n Machine Instruction....... %04X [BIG ENDIAN]\n Destination Register...... %2d\n Source      Register...... %2d", statement.getOffset().intValue(), string, l4, l2, l3));
    }

    private static DVCode cbEncode(DVStatements.Statement statement, long l, long l2, BigInteger bigInteger, CbImm cbImm, String string) {
        long l3 = l | l2 << 7 | DVArchOpCodes.getCbImm(cbImm, bigInteger.longValue());
        return new DVCode(DVArchOpCodes.convertLongToShortCode(l3), String.format("%02X%02X", l3 & 0xFFL, l3 >> 8 & 0xFFL), String.format("At OFFSET=%04X: %s\n Machine Instruction....... %04X [BIG ENDIAN]\n Source      Register...... %2d\n Immediate" + DVArchOpCodes.getCbImmType(cbImm) + "....... %s [HEX]\n Immediate Encoded......... %s [BIN] Bits [%d:%d]", statement.getOffset().intValue(), string, l3, l2, DVArchOpCodes.immediateToHex(bigInteger, 3), DVArchOpCodes.immediateToBinary(bigInteger.shiftRight(DVArchOpCodes.getCbShift(cbImm)), DVArchOpCodes.getCbBitSections(cbImm)), DVArchOpCodes.getCbHighBit(cbImm), DVArchOpCodes.getCbShift(cbImm)));
    }

    private static long getCbImm(CbImm cbImm, long l) {
        switch (cbImm) {
            case B: {
                return (l & 0x100L) << 4 | (l & 0xC0L) >> 1 | (l & 0x20L) >> 3 | (l & 0x18L) << 7 | (l & 6L) << 2;
            }
            case I: {
                return (l & 0x20L) << 7 | (l & 0x1FL) << 2;
            }
        }
        return (l & 0x20L) << 7 | (l & 0x1FL) << 2;
    }

    private static int getCbShift(CbImm cbImm) {
        return (new int[]{1, 0, 0})[cbImm.ordinal()];
    }

    private static int getCbHighBit(CbImm cbImm) {
        return (new int[]{8, 5, 5})[cbImm.ordinal()];
    }

    private static int[] getCbBitSections(CbImm cbImm) {
        return (new int[][]{{1, 2, 1, 1, 2}, {1, 5}, {1, 2, 2}})[cbImm.ordinal()];
    }

    private static String getCbImmType(CbImm cbImm) {
        return (new String[]{" PC Offset", " .........", " Shift...."})[cbImm.ordinal()];
    }

    private static DVCode cjEncode(DVStatements.Statement statement, long l, BigInteger bigInteger, String string) {
        long l2 = DVArchOpCodes.maskImmediate(bigInteger.longValue(), 12);
        long l3 = l | (l2 & 0x800L) << 1 | (l2 & 0x400L) >> 2 | (l2 & 0x300L) << 1 | (l2 & 0x80L) >> 1 | (l2 & 0x40L) << 1 | (l2 & 0x20L) >> 3 | (l2 & 0x10L) << 7 | (l2 & 0xEL) << 2;
        return new DVCode(DVArchOpCodes.convertLongToShortCode(l3), String.format("%02X%02X", l3 & 0xFFL, l3 >> 8 & 0xFFL), String.format("At OFFSET=%04X: %s\n Machine Instruction....... %04X [BIG ENDIAN]\n Immediate PC Offset....... %s [HEX]\n Immediate Sect. Offset.... %08X [HEX]\n Immediate Encoded......... %s [BIN] Bits [11:1]", statement.getOffset().intValue(), string, l3, DVArchOpCodes.immediateToHex(bigInteger, 3), statement.getOffset().add(bigInteger).intValue(), DVArchOpCodes.immediateToBinary(bigInteger.shiftRight(1), new int[]{1, 1, 2, 1, 1, 1, 1, 3})));
    }

    private byte[] convertLongToCode(long l) {
        return new byte[]{(byte)(l & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 24 & 0xFFL)};
    }

    private byte[] convertLongToCode(byte[] byArray, int n, long l) {
        byArray[n] = (byte)(l & 0xFFL);
        byArray[n + 1] = (byte)(l >> 8 & 0xFFL);
        byArray[n + 2] = (byte)(l >> 16 & 0xFFL);
        byArray[n + 3] = (byte)(l >> 24 & 0xFFL);
        return byArray;
    }

    private static byte[] convertLongToShortCode(long l) {
        return new byte[]{(byte)(l & 0xFFL), (byte)(l >> 8 & 0xFFL)};
    }

    private byte[] convertLongToShortCode(byte[] byArray, int n, long l) {
        byArray[n] = (byte)(l & 0xFFL);
        byArray[n + 1] = (byte)(l >> 8 & 0xFFL);
        return byArray;
    }

    private boolean immLowBitsZero(BigInteger bigInteger, int n) {
        return bigInteger.and(BigInteger.ONE.shiftLeft(n).subtract(BigInteger.ONE)).signum() == 0;
    }

    private boolean immAllBitsOne(BigInteger bigInteger, int[] nArray) {
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            bl &= bigInteger.testBit(nArray[i]);
        }
        return true;
    }

    public static long maskImmediate(long l, int n) {
        return l & (1L << n) - 1L;
    }

    public static long maskImmediate(BigInteger bigInteger, int n) {
        return bigInteger.longValue() & (1L << n) - 1L;
    }

    public static String immediateToHex(BigInteger bigInteger, int n) {
        return DVArchOpCodes.immediateToHex(bigInteger.toString(16).toUpperCase(), n);
    }

    public static String immediateToHex(long l, int n) {
        return DVArchOpCodes.immediateToHex(Long.toString(l, 16).toUpperCase(), n);
    }

    private static String immediateToHex(String string, int n) {
        String string2;
        if (string.substring(0, 1).equals("-")) {
            string = string.substring(1);
            string2 = "-";
        } else {
            string2 = "+";
        }
        if (string.length() < n) {
            string = String.format("%" + Integer.toString(n) + "s", string).replace(' ', '0');
        }
        return string2 + string;
    }

    public static String immediateToBinary(long l, int[] nArray) {
        return DVArchOpCodes.immediateToBinary(BigInteger.valueOf(l), nArray);
    }

    public static String immediateToBinary(BigInteger bigInteger, int[] nArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            n2 += nArray[n];
        }
        n = bigInteger.bitLength();
        String string = bigInteger.signum() < 0 ? "1" : "0";
        Object object = "";
        --n2;
        for (int i = 0; i < nArray.length; ++i) {
            object = (String)object + "_";
            for (int j = 0; j < nArray[i]; ++j) {
                object = n2 > n ? (String)object + string : (String)object + (bigInteger.testBit(n2) ? "1" : "0");
                --n2;
            }
        }
        return ((String)object).substring(1);
    }

    private boolean validCReg(long l) {
        return l > 7L && l < 16L;
    }

    private boolean validCRegPair(long l, long l2) {
        return l > 7L && l < 16L && l2 > 7L && l2 < 16L;
    }

    private boolean matchCRegPair(long l, long l2) {
        return l == l2 && l > 7L && l < 16L;
    }

    static enum CbImm {
        B,
        I,
        S;

    }

    static enum ClsImm {
        L32,
        L64,
        L128;

    }

    static enum CssImm {
        L32,
        L64,
        L128;

    }

    static enum CiImm {
        I,
        I16,
        L32,
        L64,
        L128;

    }

    public class JFormat
    extends DVOpCodeProcessor {
        private final long mask;
        private final String description;
        private final int[] bitSections = new int[]{1, 8, 1, 10};

        public JFormat(long l, String string) {
            this.mask = l;
            this.description = string;
        }

        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            DVCode dVCode;
            DVImmediateOperand dVImmediateOperand;
            Long l = null;
            if (statement.getOpCodeParm().getPositionalParmListSize() > 1) {
                l = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 0);
                if (l == null) {
                    return null;
                }
                if (DVArchOpCodes.this.regUpdateFlags != null) {
                    DVArchOpCodes.this.regUpdateFlags[l.intValue()] = true;
                }
            }
            if ((dVImmediateOperand = DVUtil.getImmediate(statement, l == null ? 0 : 1, 21, true, immIntExtPCRel)) == null) {
                return null;
            }
            if (l == null) {
                l = 0L;
            }
            if (dVImmediateOperand.immType == DVUtil.ImmType.EXTERNAL) {
                Object object = "";
                DVAbi.RelocationID[] relocationIDArray = DVArchOpCodes.this.abi.getRelocationID(statement, dVImmediateOperand.externalToken.getQualifier(), "J");
                if (relocationIDArray == null) {
                    return null;
                }
                for (int i = 0; i < relocationIDArray.length; ++i) {
                    object = (String)object + " : " + relocationIDArray[i].nameID;
                    statement.addRelocation(dVImmediateOperand.externalToken.getSymbol(), dVImmediateOperand.externalToken.getIntConstant(), relocationIDArray[i]);
                }
                long l2 = this.mask | l << 7;
                return new DVCode(DVArchOpCodes.this.convertLongToCode(l2), String.format("%02X%02X%02X%02X", l2 & 0xFFL, l2 >> 8 & 0xFFL, l2 >> 16 & 0xFFL, l2 >> 24 & 0xFFL), String.format("%s\n Machine Instruction....... %08X [BIG ENDIAN]\n Destination Register...... %2d\n External Symbol........... %s\n Relocation Add-on......... %s [HEX]\n Relocation ID............. %s", this.description, l2, l, dVImmediateOperand.externalToken.getSymbol().getName(), DVArchOpCodes.immediateToHex(dVImmediateOperand.externalToken.getIntConstant(), 6), ((String)object).substring(3)));
            }
            long l3 = DVArchOpCodes.maskImmediate(dVImmediateOperand.integer.longValue(), 21);
            if ((l3 & 1L) != 0L) {
                return statement.putErrorNoCode("Immediate low bit [%05X] low bit is on", l3);
            }
            LinkedList<BranchStmt> linkedList = DVArchOpCodes.this.branchStmtList.get(statement.getOffset());
            if (linkedList == null) {
                linkedList = new LinkedList();
                DVArchOpCodes.this.branchStmtList.put(statement.getOffset(), linkedList);
            }
            linkedList.add(new BranchStmt(statement, dVImmediateOperand.integer.add(statement.getOffset()), false));
            if (DVArchOpCodes.this.useCExtension && (dVCode = DVArchOpCodes.this.cJFormat(statement, l, dVImmediateOperand.integer)) != null) {
                return dVCode;
            }
            long l4 = this.mask | l << 7 | (l3 & 0x100000L) << 11 | (l3 & 0x7FEL) << 20 | (l3 & 0x800L) << 9 | l3 & 0xFF000L;
            return new DVCode(DVArchOpCodes.this.convertLongToCode(l4), String.format("%02X%02X%02X%02X", l4 & 0xFFL, l4 >> 8 & 0xFFL, l4 >> 16 & 0xFFL, l4 >> 24 & 0xFFL), String.format("%s\n Machine Instruction....... %08X [BIG ENDIAN]\n Destination Register...... %2d\n Immediate PCRel........... %s [HEX]\n Immediate Sect. Offset.... %08X [HEX]\n Immediate Encoded......... %s [BIN] Bits [20:1]", this.description, l4, l, DVArchOpCodes.immediateToHex(dVImmediateOperand.integer, 6), dVImmediateOperand.integer.add(statement.getOffset()), DVArchOpCodes.immediateToBinary(dVImmediateOperand.integer.shiftRight(1), this.bitSections)));
        }

        @Override
        public BigInteger getLength() {
            return BI_4;
        }

        @Override
        public BigInteger getAlign() {
            return DVArchOpCodes.this.cExt ? BI_2 : BI_4;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{1, 2};
        }
    }

    public class UFormat
    extends DVOpCodeProcessor {
        private final long mask;
        private final UFormatType formatType;
        private final String description;
        private final int[] bitSections = new int[]{20};

        public UFormat(long l, String string) {
            this.mask = l;
            this.formatType = UFormatType.NORMAL;
            this.description = string;
        }

        public UFormat(long l, UFormatType uFormatType, String string) {
            this.mask = l;
            this.formatType = uFormatType;
            this.description = string;
        }

        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            DVCode dVCode;
            int n;
            Long l;
            if (this.formatType == UFormatType.NORMAL) {
                l = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, destRegExclList, 0);
                if (l == null) {
                    return null;
                }
                if (DVArchOpCodes.this.regUpdateFlags != null) {
                    DVArchOpCodes.this.regUpdateFlags[l.intValue()] = true;
                }
                n = 1;
            } else {
                l = 0L;
                n = 0;
            }
            DVImmediateOperand dVImmediateOperand = DVUtil.getImmediate(statement, n, 32, true, immIntExtPCRel);
            if (dVImmediateOperand == null) {
                return null;
            }
            if (dVImmediateOperand.immType == DVUtil.ImmType.EXTERNAL) {
                Object object = "";
                DVAbi.RelocationID[] relocationIDArray = DVArchOpCodes.this.abi.getRelocationID(statement, dVImmediateOperand.externalToken.getQualifier(), "U");
                if (relocationIDArray == null) {
                    return null;
                }
                for (int i = 0; i < relocationIDArray.length; ++i) {
                    object = (String)object + " : " + relocationIDArray[i].nameID;
                    statement.addRelocation(dVImmediateOperand.externalToken.getSymbol(), dVImmediateOperand.externalToken.getIntConstant(), relocationIDArray[i]);
                }
                long l2 = this.mask | l << 7;
                return new DVCode(DVArchOpCodes.this.convertLongToCode(l2), String.format("%02X%02X%02X%02X", l2 & 0xFFL, l2 >> 8 & 0xFFL, l2 >> 16 & 0xFFL, l2 >> 24 & 0xFFL), String.format("%s\n Machine Instruction....... %08X [BIG ENDIAN]\n Destination Register...... %2d\n External Symbol........... %s\n Relocation Add-on......... %s [HEX]\n Relocation ID............. %s", this.description, l2, l, dVImmediateOperand.externalToken.getSymbol().getName(), DVArchOpCodes.immediateToHex(dVImmediateOperand.externalToken.getIntConstant(), 5), ((String)object).substring(3)));
            }
            long l3 = dVImmediateOperand.integer.longValue();
            if ((l3 & 0xFFFL) != 0L) {
                return statement.putErrorNoCode("Immediate [%05X] 12 low bits are not zero", l3);
            }
            l3 = DVArchOpCodes.maskImmediate(l3, 32);
            if (DVArchOpCodes.this.useCExtension && (dVCode = DVArchOpCodes.this.cUFormat(statement, l, l3)) != null) {
                return dVCode;
            }
            long l4 = this.mask | l << 7 | l3;
            return new DVCode(DVArchOpCodes.this.convertLongToCode(l4), String.format("%02X%02X%02X%02X", l4 & 0xFFL, l4 >> 8 & 0xFFL, l4 >> 16 & 0xFFL, l4 >> 24 & 0xFFL), String.format("%s\n Machine Instruction....... %08X [BIG ENDIAN]\n Destination Register...... %2d\n Immediate PCRel........... %06X [HEX]\n Immediate Sect. Offset.... %s [HEX]\n Immediate Encoded......... %s [BIN] Bits [31:12]", this.description, l4, l, dVImmediateOperand.integer, DVArchOpCodes.immediateToHex(dVImmediateOperand.integer.add(statement.getOffset()), 5), DVArchOpCodes.immediateToBinary(dVImmediateOperand.integer.shiftRight(12), this.bitSections)));
        }

        @Override
        public BigInteger getLength() {
            return BI_4;
        }

        @Override
        public BigInteger getAlign() {
            return DVArchOpCodes.this.cExt ? BI_2 : BI_4;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{this.formatType == UFormatType.NORMAL ? 2 : 1, 2};
        }
    }

    public class BFormat
    extends DVOpCodeProcessor {
        private final long mask;
        private final String description;
        private final int[] bitSections = new int[]{1, 1, 6, 4};

        public BFormat(long l, long l2, String string) {
            this.mask = l2 << 12 | l;
            this.description = string;
        }

        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            DVCode dVCode;
            Long l = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 0);
            if (l == null) {
                return null;
            }
            Long l2 = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 1);
            if (l2 == null) {
                return null;
            }
            DVImmediateOperand dVImmediateOperand = DVUtil.getImmediate(statement, 2, 12, true, immIntPCRel);
            if (dVImmediateOperand == null) {
                return null;
            }
            long l3 = DVArchOpCodes.maskImmediate(dVImmediateOperand.integer.longValue(), 13);
            if ((l3 & 1L) != 0L) {
                return statement.putErrorNoCode("Immediate PC relative displacement low bit is not zero", new Object[0]);
            }
            LinkedList<BranchStmt> linkedList = DVArchOpCodes.this.branchStmtList.get(statement.getOffset());
            if (linkedList == null) {
                linkedList = new LinkedList();
                DVArchOpCodes.this.branchStmtList.put(statement.getOffset(), linkedList);
            }
            linkedList.add(new BranchStmt(statement, dVImmediateOperand.integer.add(statement.getOffset()), true));
            if (DVArchOpCodes.this.useCExtension && (dVCode = DVArchOpCodes.this.cBFormat(statement, l, l2, dVImmediateOperand.integer)) != null) {
                return dVCode;
            }
            long l4 = this.mask | (l3 & 0x1000L) << 19 | (l3 & 0x800L) >> 4 | (l3 & 0x7E0L) << 20 | (l3 & 0x1EL) << 7 | l2 << 20 | l << 15;
            return new DVCode(DVArchOpCodes.this.convertLongToCode(l4), String.format("%02X%02X%02X%02X", l4 & 0xFFL, l4 >> 8 & 0xFFL, l4 >> 16 & 0xFFL, l4 >> 24 & 0xFFL), String.format("%s\n Machine Instruction....... %08X [BIG ENDIAN]\n Source 1    Register...... %2d\n Source 2    Register...... %2d\n Immediate PCRel........... %03X [HEX]\n Immediate Sect. Offset.... %08X [HEX]\n Immediate Bits [12:1]..... %s [BIN] bits [12:1]\n", this.description, l4, l, l2, dVImmediateOperand.integer, dVImmediateOperand.integer.add(statement.getOffset()), DVArchOpCodes.immediateToBinary(dVImmediateOperand.integer.shiftRight(1), this.bitSections)));
        }

        @Override
        public BigInteger getLength() {
            return DVArchOpCodes.this.cExt ? BI_2 : BI_4;
        }

        @Override
        public BigInteger getAlign() {
            return DVArchOpCodes.this.cExt ? BI_2 : BI_4;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{3, 3};
        }
    }

    public class SFormat
    extends DVOpCodeProcessor {
        private final long mask;
        private final String description;
        private final EnumSet<DVUtil.ImmType> immType;
        private final EnumSet<DVUtil.ImmType> immTypeNoBase;
        private final boolean conditional;
        private final boolean floatReg;
        private final int[] bitSections = new int[]{7, 5};

        public SFormat(long l, long l2, EnumSet<DVUtil.ImmType> enumSet, String string) {
            this.mask = l2 << 12 | l;
            this.immType = enumSet;
            Object object = enumSet.clone();
            ((AbstractCollection)object).remove((Object)DVUtil.ImmType.BASEDSP);
            this.immTypeNoBase = object;
            this.conditional = false;
            this.floatReg = false;
            this.description = string;
        }

        public SFormat(long l, long l2, EnumSet<DVUtil.ImmType> enumSet, EnumSet<SFormatType> enumSet2, String string) {
            this.mask = l2 << 12 | l;
            this.immType = enumSet;
            Object object = enumSet.clone();
            ((AbstractCollection)object).remove((Object)DVUtil.ImmType.BASEDSP);
            this.immTypeNoBase = object;
            this.conditional = enumSet2.contains((Object)SFormatType.CONDITIONAL);
            this.floatReg = enumSet2.contains((Object)SFormatType.FLOAT_REG);
            this.description = string;
        }

        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            DVImmediateOperand dVImmediateOperand;
            Long l;
            Long l2 = null;
            Long l3 = 0L;
            if (statement.getOpCodeParm().getKeyWordParmListSize() > 0) {
                if (!this.conditional) {
                    return statement.putErrorNoCode("Key-word parameter [COND] specified but not allowed for this opCode", new Object[0]);
                }
                l3 = DVUtil.getBooleanKeyWordValue(statement, 0, "COND", 0L);
                if (l3 == null) {
                    return null;
                }
            }
            if ((l = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 0)) == null) {
                return null;
            }
            if (!(l3 != 1L || DVArchOpCodes.this.regUpdateFlags != null && DVArchOpCodes.this.regUpdateFlags[l.intValue() + (this.floatReg ? 32 : 0)])) {
                return new DVCode(null, null, String.format("OpCode [%s] skipped due to source register not having been updated", statement.getOpCode()));
            }
            if (statement.getOpCodeParm().getSubParmListSize(1) > 0) {
                l2 = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 1, (Integer)0);
                if (l2 == null) {
                    return null;
                }
                dVImmediateOperand = DVUtil.getImmediate(statement, 1, 12, true, this.immTypeNoBase);
                if (dVImmediateOperand == null) {
                    return null;
                }
            } else {
                dVImmediateOperand = DVUtil.getImmediate(statement, 1, 12, true, this.immType);
                if (dVImmediateOperand == null) {
                    return null;
                }
                if (dVImmediateOperand.immType != DVUtil.ImmType.BASEDSP) {
                    return statement.putErrorNoCode("Base register not specified but immediate resolve to type [%s]", dVImmediateOperand.immType.name());
                }
            }
            if (dVImmediateOperand.immType == DVUtil.ImmType.INTEGER || dVImmediateOperand.immType == DVUtil.ImmType.BASEDSP) {
                DVCode dVCode;
                long l4 = DVArchOpCodes.maskImmediate(dVImmediateOperand.integer.longValue(), 12);
                if (l2 == null) {
                    l2 = dVImmediateOperand.baseReg;
                }
                if (l2 == null) {
                    return statement.putErrorNoCode("Explicit base register required when using a displacement", new Object[0]);
                }
                if (DVArchOpCodes.this.useCExtension && (dVCode = DVArchOpCodes.this.cSFormat(statement, l2, l, dVImmediateOperand.integer)) != null) {
                    return dVCode;
                }
                long l5 = this.mask | (l4 & 0xFE0L) << 20 | (l4 & 0x1FL) << 7 | l << 20 | l2 << 15;
                return new DVCode(DVArchOpCodes.this.convertLongToCode(l5), String.format("%02X%02X%02X%02X", l5 & 0xFFL, l5 >> 8 & 0xFFL, l5 >> 16 & 0xFFL, l5 >> 24 & 0xFFL), String.format("%s\n Machine Instruction....... %08X [BIG ENDIAN]\n Source 2    Register...... %2d\n Src. 1/Base Register...... %2d\n Immediate Displacement.... %s [HEX]\n%s Immediate Encoded......... %s [BIN] Bits [11:0]", this.description, l5, l, l2, DVArchOpCodes.immediateToHex(dVImmediateOperand.integer, 3), dVImmediateOperand.sectOffset != null ? String.format(" Immediate Offset.......... %s [HEX]\n", DVArchOpCodes.immediateToHex(dVImmediateOperand.sectOffset, 6)) : "", DVArchOpCodes.immediateToBinary(dVImmediateOperand.integer, this.bitSections)));
            }
            Object object = "";
            DVAbi.RelocationID[] relocationIDArray = DVArchOpCodes.this.abi.getRelocationID(statement, dVImmediateOperand.externalToken.getQualifier(), "S");
            if (relocationIDArray == null) {
                return null;
            }
            for (int i = 0; i < relocationIDArray.length; ++i) {
                object = (String)object + " : " + relocationIDArray[i].nameID;
                statement.addRelocation(dVImmediateOperand.externalToken.getSymbol(), dVImmediateOperand.externalToken.getIntConstant(), relocationIDArray[i]);
            }
            if (dVImmediateOperand.immType != DVUtil.ImmType.EXTERNAL) {
                return statement.putErrorNoCode("Immediate type [%s] is invalid", new Object[]{dVImmediateOperand.immType});
            }
            l2 = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 1, (Integer)0);
            if (l2 == null) {
                return statement.putErrorNoCode("Explicit base register required when using a relocated symbol", new Object[0]);
            }
            object = ((String)object).substring(3);
            long l6 = this.mask | l << 20 | l2 << 15;
            return new DVCode(DVArchOpCodes.this.convertLongToCode(l6), String.format("%02X%02X%02X%02X", l6 & 0xFFL, l6 >> 8 & 0xFFL, l6 >> 16 & 0xFFL, l6 >> 24 & 0xFFL), String.format("%s\n Machine Instruction....... %08X [BIG ENDIAN]\n Source 2    Register...... %2d\n Src. 1/Base Register...... %2d\n External Symbol........... %s\n Relocation Add-on......... %s [HEX]\n Relocation ID(s).......... %s", this.description, l6, l, l2, dVImmediateOperand.externalToken.getSymbol().getName(), DVArchOpCodes.immediateToHex(dVImmediateOperand.integer, 3), object));
        }

        @Override
        public BigInteger getLength() {
            return this.conditional ? BigInteger.ZERO : (DVArchOpCodes.this.cExt ? BI_2 : BI_4);
        }

        @Override
        public BigInteger getAlign() {
            return DVArchOpCodes.this.cExt ? BI_2 : BI_4;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{2, 2};
        }

        @Override
        public int[][] getSubParmMinMax() {
            return new int[][]{{0, 0}, {0, 1}};
        }

        @Override
        public String[] getKeyWordList() {
            return new String[]{"COND"};
        }
    }

    public class SHFormat
    extends DVOpCodeProcessor {
        private final long mask;
        private final int noBits;
        private final String description;

        public SHFormat(long l, long l2, int n, String string) {
            this.mask = l2 << 12 | l;
            this.noBits = n;
            this.description = string;
        }

        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            DVCode dVCode;
            DVImmediateOperand dVImmediateOperand;
            Long l;
            Long l2 = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 0);
            if (l2 == null) {
                return null;
            }
            if (DVArchOpCodes.this.regUpdateFlags != null) {
                DVArchOpCodes.this.regUpdateFlags[l2.intValue()] = true;
            }
            if (statement.getOpCodeParm().getSubParmListSize(1) > 0) {
                l = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 1, (Integer)0);
                if (l == null) {
                    return null;
                }
            } else {
                l = l2;
            }
            if ((dVImmediateOperand = DVUtil.getImmediate(statement, 1, "Shift Amount", this.noBits, false, immInt)) == null) {
                return null;
            }
            long l3 = DVArchOpCodes.maskImmediate(dVImmediateOperand.integer.longValue(), this.noBits);
            if (DVArchOpCodes.this.useCExtension && (dVCode = DVArchOpCodes.this.cIFormat(statement, l2, l, dVImmediateOperand.integer)) != null) {
                return dVCode;
            }
            long l4 = this.mask | l3 << 20 | l << 15 | l2 << 7;
            int[] nArray = new int[]{this.noBits == 32 ? 5 : 6};
            return new DVCode(DVArchOpCodes.this.convertLongToCode(l4), String.format("%02X%02X%02X%02X", l4 & 0xFFL, l4 >> 8 & 0xFFL, l4 >> 16 & 0xFFL, l4 >> 24 & 0xFFL), String.format("%s\n Machine Instruction....... %08X [BIG ENDIAN]\n Destination Register...... %2d\n Source 1    Register...... %2d\n Shift Amount.............. %s [HEX]\n Shift Amount Encoded...... %s [BIN] Bits [" + String.format("%d", nArray[0]) + ":0]\n", this.description, l4, l2, l, DVArchOpCodes.immediateToHex(dVImmediateOperand.integer, 2), DVArchOpCodes.immediateToBinary(dVImmediateOperand.integer, nArray)));
        }

        @Override
        public BigInteger getLength() {
            return DVArchOpCodes.this.cExt ? BI_2 : BI_4;
        }

        @Override
        public BigInteger getAlign() {
            return DVArchOpCodes.this.cExt ? BI_2 : BI_4;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{2, 2};
        }

        @Override
        public int[][] getSubParmMinMax() {
            return new int[][]{{0, 0}, {0, 1}};
        }
    }

    public class IIFormat
    extends DVOpCodeProcessor {
        private final long mask;
        private final String description;
        private final int[] bitSections1 = new int[]{12};
        private final int[] bitSections2 = new int[]{5};

        public IIFormat(long l, long l2, String string) {
            this.mask = l2 << 12 | l;
            this.description = string;
        }

        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            DVImmediateOperand dVImmediateOperand;
            Long l = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 0);
            if (l == null) {
                return null;
            }
            if (DVArchOpCodes.this.regUpdateFlags != null) {
                DVArchOpCodes.this.regUpdateFlags[l.intValue()] = true;
            }
            if ((dVImmediateOperand = DVUtil.getImmediate(statement, 1, 12, false, immInt)) == null) {
                return null;
            }
            long l2 = DVArchOpCodes.maskImmediate(dVImmediateOperand.integer.longValue(), 12);
            DVImmediateOperand dVImmediateOperand2 = DVUtil.getImmediate(statement, 2, 5, false, immInt);
            if (dVImmediateOperand2 == null) {
                return null;
            }
            Long l3 = DVArchOpCodes.maskImmediate(dVImmediateOperand2.integer.longValue(), 5);
            long l4 = this.mask | l3 << 20 | l2 << 15 | l << 7;
            return new DVCode(DVArchOpCodes.this.convertLongToCode(l4), String.format("%02X%02X%02X%02X", l4 & 0xFFL, l4 >> 8 & 0xFFL, l4 >> 16 & 0xFFL, l4 >> 24 & 0xFFL), String.format("%s\n Machine Instruction....... %08X [BIG ENDIAN]\n Destination Register...... %2d\n Immediate 1st operand..... %s [HEX]\n Immediate 1st encoded..... %s [BIN] Bits [11:0]\n Immediate 2nd operand..... %s [HEX]\n Immediate 2nd encoded..... %s [BIN] Bits [4:0]\n", this.description, l4, l, DVArchOpCodes.immediateToHex(dVImmediateOperand.integer, 3), DVArchOpCodes.immediateToBinary(dVImmediateOperand.integer, this.bitSections1), DVArchOpCodes.immediateToHex(dVImmediateOperand2.integer, 2), DVArchOpCodes.immediateToBinary(dVImmediateOperand2.integer, this.bitSections2)));
        }

        @Override
        public BigInteger getLength() {
            return BI_4;
        }

        @Override
        public BigInteger getAlign() {
            return BI_4;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{3, 3};
        }
    }

    public class IFormat
    extends DVOpCodeProcessor {
        private final long mask;
        private final boolean conditional;
        private final EnumSet<DVUtil.ImmType> immType;
        private final EnumSet<DVUtil.ImmType> immTypeNoBase;
        private final boolean immNZ;
        private final boolean floatReg;
        private final String description;
        private final int[] bitSections = new int[]{12};

        public IFormat(long l, long l2, EnumSet<DVUtil.ImmType> enumSet, String string) {
            this.mask = l2 << 12 | l;
            this.immType = enumSet;
            Object object = enumSet.clone();
            ((AbstractCollection)object).remove((Object)DVUtil.ImmType.BASEDSP);
            this.immTypeNoBase = object;
            this.conditional = false;
            this.immNZ = false;
            this.floatReg = false;
            this.description = string;
        }

        public IFormat(long l, long l2, EnumSet<DVUtil.ImmType> enumSet, EnumSet<IFormatType> enumSet2, String string) {
            this.mask = l2 << 12 | l;
            this.immType = enumSet;
            Object object = enumSet.clone();
            ((AbstractCollection)object).remove((Object)DVUtil.ImmType.BASEDSP);
            this.immTypeNoBase = object;
            this.conditional = enumSet2.contains((Object)IFormatType.CONDITIONAL);
            this.immNZ = enumSet2.contains((Object)IFormatType.IMM_NOT_ZERO);
            this.floatReg = enumSet2.contains((Object)IFormatType.FLOAT_REG);
            this.description = string;
        }

        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            DVImmediateOperand dVImmediateOperand;
            Long l;
            Long l2 = null;
            Long l3 = 0L;
            if (statement.getOpCodeParm().getKeyWordParmListSize() > 0) {
                if (!this.conditional) {
                    return statement.putErrorNoCode("Key-word parameter [COND] specified but not allowed for this opCode", new Object[0]);
                }
                l3 = DVUtil.getBooleanKeyWordValue(statement, 0, "COND", 0L);
                if (l3 == null) {
                    return null;
                }
            }
            if ((l = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 0)) == null) {
                return null;
            }
            if (l3 == 0L) {
                DVArchOpCodes.this.regUpdateFlags[l.intValue() + (this.floatReg ? 32 : 0)] = true;
            }
            if (l3 == 1L && !DVArchOpCodes.this.regUpdateFlags[l.intValue() + (this.floatReg ? 32 : 0)]) {
                return new DVCode(null, null, String.format("OpCode [%s] skipped due to destination register not having been updated", statement.getOpCode()));
            }
            if (statement.getOpCodeParm().getSubParmListSize(1) > 0) {
                l2 = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 1, (Integer)0);
                if (l2 == null) {
                    return null;
                }
                dVImmediateOperand = DVUtil.getImmediate(statement, 1, 12, true, this.immTypeNoBase);
                if (dVImmediateOperand == null) {
                    return null;
                }
            } else {
                dVImmediateOperand = DVUtil.getImmediate(statement, 1, 12, true, this.immType);
                if (dVImmediateOperand == null) {
                    return null;
                }
            }
            if (dVImmediateOperand.immType == DVUtil.ImmType.BASEDSP) {
                DVCode dVCode;
                long l4 = DVArchOpCodes.maskImmediate(dVImmediateOperand.integer.longValue(), 12);
                l2 = dVImmediateOperand.baseReg;
                if (DVArchOpCodes.this.useCExtension && (dVCode = DVArchOpCodes.this.cIFormat(statement, l, l2, dVImmediateOperand.integer)) != null) {
                    return dVCode;
                }
                if (this.immNZ && dVImmediateOperand.integer.equals(BigInteger.ZERO)) {
                    return statement.putErrorNoCode("Immediate for this opCode cannot be zero", new Object[0]);
                }
                if (this.immNZ && (l != 0L || l2 != 0L)) {
                    return statement.putErrorNoCode("Registers for this opCode must be zero", new Object[0]);
                }
                long l5 = this.mask | l4 << 20 | l2 << 15 | l << 7;
                return new DVCode(DVArchOpCodes.this.convertLongToCode(l5), String.format("%02X%02X%02X%02X", l5 & 0xFFL, l5 >> 8 & 0xFFL, l5 >> 16 & 0xFFL, l5 >> 24 & 0xFFL), String.format("%s\n Machine Instruction....... %08X [BIG ENDIAN]\n Destination Register...... %2d\n Src 1/Base  Register...... %2d\n Immediate Displacement.... %s [HEX]\n%s Immediate Encoded......... %s [BIN] Bits [11:0]", this.description, l5, l, l2, DVArchOpCodes.immediateToHex(dVImmediateOperand.integer, 3), dVImmediateOperand.sectOffset != null ? String.format(" Immediate Offset.......... %s [HEX]\n", DVArchOpCodes.immediateToHex(dVImmediateOperand.sectOffset, 6)) : "", DVArchOpCodes.immediateToBinary(dVImmediateOperand.integer, this.bitSections)));
            }
            if (l2 == null) {
                l2 = l;
            }
            if (dVImmediateOperand.immType == DVUtil.ImmType.INTEGER) {
                DVCode dVCode;
                long l6 = DVArchOpCodes.maskImmediate(dVImmediateOperand.integer.longValue(), 12);
                if (DVArchOpCodes.this.useCExtension && (dVCode = DVArchOpCodes.this.cIFormat(statement, l, l2, dVImmediateOperand.integer)) != null) {
                    return dVCode;
                }
                if (this.immNZ && dVImmediateOperand.integer.equals(BigInteger.ZERO)) {
                    return statement.putErrorNoCode("Immediate for this opCode cannot be zero", new Object[0]);
                }
                long l7 = this.mask | l6 << 20 | l2 << 15 | l << 7;
                return new DVCode(DVArchOpCodes.this.convertLongToCode(l7), String.format("%02X%02X%02X%02X", l7 & 0xFFL, l7 >> 8 & 0xFFL, l7 >> 16 & 0xFFL, l7 >> 24 & 0xFFL), String.format("%s\n Machine Instruction....... %08X [BIG ENDIAN]\n Destination Register...... %2d\n Source 1    Register...... %2d\n Immediate................. %s [HEX]\n Immediate Encoded......... %s [BIN] Bits [11:0]", this.description, l7, l, l2, DVArchOpCodes.immediateToHex(dVImmediateOperand.integer, 3), DVArchOpCodes.immediateToBinary(dVImmediateOperand.integer, this.bitSections)));
            }
            Object object = "";
            DVAbi.RelocationID[] relocationIDArray = DVArchOpCodes.this.abi.getRelocationID(statement, dVImmediateOperand.externalToken.getQualifier(), "I");
            if (relocationIDArray == null) {
                return null;
            }
            for (int i = 0; i < relocationIDArray.length; ++i) {
                object = (String)object + " : " + relocationIDArray[i].nameID;
                statement.addRelocation(dVImmediateOperand.externalToken.getSymbol(), dVImmediateOperand.externalToken.getIntConstant(), relocationIDArray[i]);
            }
            object = ((String)object).substring(3);
            long l8 = this.mask | l2 << 15 | l << 7;
            return new DVCode(DVArchOpCodes.this.convertLongToCode(l8), String.format("%02X%02X%02X%02X", l8 & 0xFFL, l8 >> 8 & 0xFFL, l8 >> 16 & 0xFFL, l8 >> 24 & 0xFFL), String.format("%s\n Machine Instruction....... %08X [BIG ENDIAN]\n Destination Register...... %2d\n Source      Register...... %2d\n External Symbol........... %s\n Relocation Add-on......... %s [HEX]\n Relocation ID(s).......... %s", this.description, l8, l, l2, dVImmediateOperand.externalToken.getSymbol().getName(), DVArchOpCodes.immediateToHex(dVImmediateOperand.integer, 3), object));
        }

        @Override
        public BigInteger getLength() {
            return this.conditional ? BigInteger.ZERO : (DVArchOpCodes.this.cExt ? BI_2 : BI_4);
        }

        @Override
        public BigInteger getAlign() {
            return DVArchOpCodes.this.cExt ? BI_2 : BI_4;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{2, 2};
        }

        @Override
        public int[][] getSubParmMinMax() {
            return new int[][]{{0, 0}, {0, 1}};
        }

        @Override
        public String[] getKeyWordList() {
            return new String[]{"COND"};
        }
    }

    public class R4Format
    extends DVOpCodeProcessor {
        private final long mask;
        private final boolean rmFlag;
        private final boolean floatDestReg;
        private final String description;
        private final long[] validRM = new long[]{0L, 1L, 2L, 3L, 4L, 7L};

        public R4Format(long l, String string) {
            this.mask = l;
            this.rmFlag = true;
            this.floatDestReg = false;
            this.description = string;
        }

        public R4Format(long l, boolean bl, String string) {
            this.mask = l;
            this.rmFlag = true;
            this.floatDestReg = bl;
            this.description = string;
        }

        public R4Format(long l, long l2, String string) {
            this.mask = l | l2 << 12;
            this.rmFlag = false;
            this.floatDestReg = false;
            this.description = string;
        }

        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            Long l;
            Long l2;
            Long l3;
            Long l4 = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, destRegExclList, 0);
            if (l4 == null) {
                return null;
            }
            if (DVArchOpCodes.this.regUpdateFlags != null) {
                DVArchOpCodes.this.regUpdateFlags[l4.intValue() + (this.floatDestReg ? 32 : 0)] = true;
            }
            if (statement.getOpCodeParm().getPositionalParmListSize() < 4) {
                l3 = l4;
                l2 = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 1);
                if (l2 == null) {
                    return null;
                }
                l = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 2);
                if (l == null) {
                    return null;
                }
            } else {
                l3 = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 1);
                if (l3 == null) {
                    return null;
                }
                l2 = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 2);
                if (l2 == null) {
                    return null;
                }
                l = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 3);
                if (l == null) {
                    return null;
                }
            }
            Long l5 = null;
            if (this.rmFlag && (l5 = DVUtil.getAbsoluteKeyWordValue(statement, 0, "RM", this.validRM, 7L)) == null) {
                return null;
            }
            long l6 = this.mask | l3 << 27 | l << 20 | l2 << 15 | l5 << 12 | l4 << 7;
            return new DVCode(DVArchOpCodes.this.convertLongToCode(l6), String.format("%02X%02X%02X%02X", l6 & 0xFFL, l6 >> 8 & 0xFFL, l6 >> 16 & 0xFFL, l6 >> 24 & 0xFFL), String.format("%s\n Machine Instruction....... %08X [BIG ENDIAN]\n Destination Register...... %2d\n Source 3    Register...... %2d\n Source 1    Register...... %2d\n Source 2    Register...... %2d" + (l5 != null ? String.format("\n Round Mode................ %03s", Long.toString(l5, 2)) : ""), this.description, l6, l4, l3, l2, l, l5));
        }

        @Override
        public BigInteger getLength() {
            return DVArchOpCodes.this.cExt ? BI_2 : BI_4;
        }

        @Override
        public BigInteger getAlign() {
            return DVArchOpCodes.this.cExt ? BI_2 : BI_4;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{3, 4};
        }

        @Override
        public String[] getKeyWordList() {
            return new String[]{"RM"};
        }
    }

    public class RFormat
    extends DVOpCodeProcessor {
        private final long mask;
        private final RFormatType formatType;
        private final boolean floatDestReg;
        private final String description;
        private final long[] validRM;

        public RFormat(long l, long l2, long l3, String string) {
            this.validRM = new long[]{0L, 1L, 2L, 3L, 4L, 7L};
            this.mask = l3 << 25 | l2 << 12 | l;
            this.formatType = RFormatType.NORMAL;
            this.floatDestReg = false;
            this.description = string;
        }

        public RFormat(long l, long l2, long l3, boolean bl, String string) {
            this.validRM = new long[]{0L, 1L, 2L, 3L, 4L, 7L};
            this.mask = l3 << 25 | l2 << 12 | l;
            this.formatType = RFormatType.NORMAL;
            this.floatDestReg = bl;
            this.description = string;
        }

        public RFormat(long l, long l2, boolean bl, String string) {
            this.validRM = new long[]{0L, 1L, 2L, 3L, 4L, 7L};
            this.mask = l2 << 25 | l;
            this.formatType = RFormatType.RM;
            this.floatDestReg = bl;
            this.description = string;
        }

        public RFormat(long l, long l2, long l3, RFormatType rFormatType, String string) {
            this.validRM = new long[]{0L, 1L, 2L, 3L, 4L, 7L};
            this.mask = rFormatType == RFormatType.CONST_SRC2REG_RM ? l3 << 25 | l2 << 20 | l : l3 << 25 | l2 << 12 | l;
            this.formatType = rFormatType;
            this.floatDestReg = false;
            this.description = string;
        }

        public RFormat(long l, long l2, long l3, boolean bl, RFormatType rFormatType, String string) {
            this.validRM = new long[]{0L, 1L, 2L, 3L, 4L, 7L};
            this.mask = rFormatType == RFormatType.CONST_SRC2REG_RM ? l3 << 25 | l2 << 20 | l : l3 << 25 | l2 << 12 | l;
            this.formatType = rFormatType;
            this.floatDestReg = bl;
            this.description = string;
        }

        public RFormat(long l, long l2, long l3, long l4, String string) {
            this.validRM = new long[]{0L, 1L, 2L, 3L, 4L, 7L};
            this.mask = l4 << 25 | l3 << 20 | l2 << 12 | l;
            this.formatType = RFormatType.CONST_SRC2REG;
            this.floatDestReg = false;
            this.description = string;
        }

        public RFormat(long l, long l2, long l3, long l4, boolean bl, String string) {
            this.validRM = new long[]{0L, 1L, 2L, 3L, 4L, 7L};
            this.mask = l4 << 25 | l2 << 20 | l3 << 12 | l;
            this.formatType = RFormatType.CONST_SRC2REG;
            this.floatDestReg = bl;
            this.description = string;
        }

        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            DVCode dVCode;
            Long l;
            Long l2;
            Long l3;
            if (this.formatType == RFormatType.ZERO_DESTREG_OK) {
                l3 = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 0);
                if (l3 == null) {
                    return null;
                }
            } else if (this.formatType == RFormatType.ZERO_DESTREG) {
                l3 = 0L;
            } else {
                l3 = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, destRegExclList, 0);
                if (l3 == null) {
                    return null;
                }
            }
            if (DVArchOpCodes.this.regUpdateFlags != null) {
                DVArchOpCodes.this.regUpdateFlags[l3.intValue() + (this.floatDestReg ? 32 : 0)] = true;
            }
            if (statement.getOpCodeParm().getPositionalParmListSize() > 2) {
                if (this.formatType == RFormatType.CONST_SRC2REG || this.formatType == RFormatType.CONST_SRC2REG_RM) {
                    return statement.putErrorNoCode("Reg2 is used as opCode extension for this opCode - only two positional parameters are allowed", new Object[0]);
                }
                if (this.formatType == RFormatType.ZERO_DESTREG) {
                    return statement.putErrorNoCode("RegD is used as opCode extension for this opCode - only two positional parameters are allowed", new Object[0]);
                }
                l2 = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 1);
                if (l2 == null) {
                    return null;
                }
                l = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 2);
                if (l == null) {
                    return null;
                }
            } else {
                if (this.formatType == RFormatType.FBOOLEAN) {
                    return statement.putErrorNoCode("For floating boolean opCodes three register parameters are required", new Object[0]);
                }
                if (this.formatType == RFormatType.CONST_SRC2REG || this.formatType == RFormatType.CONST_SRC2REG_RM) {
                    l2 = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 1);
                    if (l2 == null) {
                        return null;
                    }
                    l = 0L;
                } else if (this.formatType == RFormatType.ZERO_DESTREG) {
                    l2 = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 0);
                    if (l2 == null) {
                        return null;
                    }
                    l = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 1);
                    if (l == null) {
                        return null;
                    }
                } else {
                    l2 = l3;
                    l = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, 1);
                    if (l == null) {
                        return null;
                    }
                }
            }
            Long l4 = null;
            if ((this.formatType == RFormatType.RM || this.formatType == RFormatType.CONST_SRC2REG_RM) && (l4 = DVUtil.getAbsoluteKeyWordValue(statement, 0, "RM", this.validRM, 7L)) == null) {
                return null;
            }
            if (DVArchOpCodes.this.useCExtension && (dVCode = DVArchOpCodes.this.cRFormat(statement, l3, l2, l)) != null) {
                return dVCode;
            }
            long l5 = this.mask | (l4 != null ? l4 << 12 : 0L) | l << 20 | l2 << 15 | l3 << 7;
            return new DVCode(DVArchOpCodes.this.convertLongToCode(l5), String.format("%02X%02X%02X%02X", l5 & 0xFFL, l5 >> 8 & 0xFFL, l5 >> 16 & 0xFFL, l5 >> 24 & 0xFFL), String.format("%s\n Machine Instruction....... %08X [BIG ENDIAN]\n" + (this.formatType == RFormatType.ZERO_DESTREG ? "" : String.format(" Destination Register...... %2d\n", l3)) + (this.formatType == RFormatType.CONST_SRC2REG || this.formatType == RFormatType.CONST_SRC2REG_RM ? "" : String.format(" Source 2    Register...... %2d\n", l)) + " Source 1    Register...... %2d\n" + (l4 != null ? String.format(" Round Mode................ %3s", Long.toString(l4, 2)) : ""), this.description, l5, l2));
        }

        @Override
        public BigInteger getLength() {
            return DVArchOpCodes.this.cExt ? BI_2 : BI_4;
        }

        @Override
        public BigInteger getAlign() {
            return DVArchOpCodes.this.cExt ? BI_2 : BI_4;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{2, 3};
        }

        @Override
        public String[] getKeyWordList() {
            return new String[]{"RM"};
        }
    }

    public class NPFormat
    extends DVOpCodeProcessor {
        private final long mask;
        private final String description;
        private final Long maskC;
        private final String descriptionC;

        public NPFormat(long l, String string) {
            this.mask = l;
            this.description = string;
            this.maskC = null;
            this.descriptionC = null;
        }

        public NPFormat(long l, String string, Long l2, String string2) {
            this.mask = l;
            this.description = string;
            this.maskC = l2;
            this.descriptionC = string2;
        }

        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            if (DVArchOpCodes.this.useCExtension && this.maskC != null) {
                return new DVCode(DVArchOpCodes.convertLongToShortCode(this.mask), String.format("%02X%02X", this.mask & 0xFFL, this.mask >> 8 & 0xFFL), String.format("%s\n Machine Instruction.... %04X [BIG ENDIAN]", statement.getOpCode() + " -> C." + statement.getOpCode() + " " + this.descriptionC, this.maskC));
            }
            return new DVCode(DVArchOpCodes.this.convertLongToCode(this.mask), String.format("%02X%02X%02X%02X", this.mask & 0xFFL, this.mask >> 8 & 0xFFL, this.mask >> 16 & 0xFFL, this.mask >> 24 & 0xFFL), String.format("%s\n Machine Instruction.... %08X [BIG ENDIAN]", statement.getOpCode() + " " + this.description, this.mask));
        }

        @Override
        public BigInteger getLength() {
            return BI_4;
        }

        @Override
        public BigInteger getAlign() {
            return BI_4;
        }
    }

    public class FloatRegSaveArea
    extends DVOpCodeProcessor {
        private final String description;

        public FloatRegSaveArea(String string) {
            this.description = string;
        }

        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            Long l = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, destRegExclList, 0);
            if (l == null) {
                return null;
            }
            if (!DVArchOpCodes.this.regUpdateFlags[32 + l.intValue()]) {
                return new DVCode(null, null, String.format(String.format("Float Register Save Area skipped for register [%d] due to register not being updated", l), new Object[0]));
            }
            return new DVCode(new byte[DVArchOpCodes.this.abiFLen >> 3], DVArchOpCodes.this.abiFLen >> 3 == 4 ? "00000000" : "00000000 00000000", String.format(this.description + "\n Float Register Save Area for register [%d] due to register being updated", l));
        }

        @Override
        public BigInteger getLength() {
            return BigInteger.valueOf(0L);
        }

        @Override
        public BigInteger getAlign() {
            return BigInteger.valueOf(DVArchOpCodes.this.abiFLen >> 3);
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{1, 1};
        }
    }

    public class RegSaveArea
    extends DVOpCodeProcessor {
        private final String description;

        public RegSaveArea(String string) {
            this.description = string;
        }

        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            Long l = DVUtil.getRegister(statement, DVArchOpCodes.this.regFileNoBits, destRegExclList, 0);
            if (l == null) {
                return null;
            }
            if (!DVArchOpCodes.this.regUpdateFlags[l.intValue()]) {
                return new DVCode(null, null, String.format(this.description + "\n Register Save Area skipped for register [%d] due to register not being updated", l));
            }
            return new DVCode(new byte[DVArchOpCodes.this.xLen >> 3], DVArchOpCodes.this.xLen == 4 ? "00000000" : "00000000 00000000", String.format(this.description + "\n Register Save Area for register [%d] due to register being updated", l));
        }

        @Override
        public BigInteger getLength() {
            return BigInteger.valueOf(0L);
        }

        @Override
        public BigInteger getAlign() {
            return BigInteger.valueOf(DVArchOpCodes.this.xLen >> 3);
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{1, 1};
        }
    }

    public class OpCodeAlign
    extends DVOpCodeProcessor {
        private final String description;

        public OpCodeAlign(String string) {
            this.description = string;
        }

        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            DVImmediateOperand dVImmediateOperand = DVUtil.getImmediate(statement, 0, "Align", 9, false, immInt);
            if (dVImmediateOperand == null) {
                return null;
            }
            if (dVImmediateOperand.integer.bitCount() != 1) {
                return statement.putErrorNoCode("Align [%s] is not power of two", dVImmediateOperand.integer.toString());
            }
            long l = dVImmediateOperand.integer.longValue();
            int n = statement.getOffset().intValue();
            if (!DVArchOpCodes.this.cExt && (n & 3) != 0) {
                return statement.putErrorNoCode("Current offset is not 4 byte aligned and C extension is not available", new Object[0]);
            }
            if ((n & 1) != 0) {
                return statement.putErrorNoCode("Current offset is not 2 byte aligned", new Object[0]);
            }
            if ((long)n % l == 0L) {
                return new DVCode(null, null, String.format("Already aligned - No alignemnt NOOP instructions needed", new Object[0]));
            }
            statement.guaranteeAlignment(dVImmediateOperand.integer);
            int n2 = (int)l - n % (int)l;
            int n3 = n2 >> 1 & 1;
            int n4 = n2 >> 2;
            byte[] byArray = new byte[n3 * 2 + n4 * 4];
            int n5 = 0;
            if (n3 > 0) {
                DVArchOpCodes.this.convertLongToShortCode(byArray, n5, 1L);
                n5 += 2;
            }
            while (n5 < n2) {
                DVArchOpCodes.this.convertLongToCode(byArray, n5, 28691L);
                n5 += 4;
            }
            Long l2 = DVUtil.getAbsoluteKeyWordValue(statement, 0, "BRCOND", 0L, 127L, 0L);
            if (l2 == null) {
                return null;
            }
            if (l2 != 0L && (long)(n2 + 2 >> 2) >= l2) {
                if (n3 > 0) {
                    DVArchOpCodes.this.convertLongToShortCode(byArray, 0, 0xA001 | (n2 & 0x20) >> 3 | (n2 & 0xE) << 2 | (n2 & 0x80) >> 1 | (n2 & 0x40) << 1 | (n2 & 0x400) >> 2 | (n2 & 0x300) << 1 | (n2 & 0x10) << 7 | (n2 & 0x800) << 1);
                } else {
                    DVArchOpCodes.this.convertLongToCode(byArray, 0, 0x6F | (n2 & 0xFF000) << 0 | (n2 & 0x800) << 9 | (n2 & 0x7FE) << 20 | (n2 & 0x100000) << 11);
                }
            }
            n5 = 0;
            Object object = "";
            Object object2 = "";
            if (n3 > 0) {
                object = (String)object + String.format(" %02X%02X    ", byArray[0], byArray[1]);
                object2 = (String)object2 + String.format(" %02X%02X", byArray[0], byArray[1]);
                n5 += 2;
            }
            while (n5 < n2) {
                if (n5 < 6) {
                    object = (String)object + String.format(" %02X%02X%02X%02X", byArray[n5], byArray[n5 + 1], byArray[n5 + 2], byArray[n5 + 3]);
                }
                object2 = (String)object2 + String.format(" %02X%02X%02X%02X", byArray[n5], byArray[n5 + 1], byArray[n5 + 2], byArray[n5 + 3]);
                n5 += 4;
            }
            object = ((String)object).substring(1);
            object2 = ((String)object2).substring(1);
            return new DVCode(byArray, (String)object, String.format("%s\n Align Code............. %s\n Length of Code......... %04X", this.description, object2, n2));
        }

        @Override
        public BigInteger getLength() {
            return BigInteger.ZERO;
        }

        @Override
        public BigInteger getAlign() {
            return DVArchOpCodes.this.cExt ? BI_2 : BI_4;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{1, 1};
        }

        @Override
        public String[] getKeyWordList() {
            return new String[]{"BRCOND"};
        }
    }

    public class ClearRegUpdateFlags
    extends DVOpCodeProcessor {
        private final String description;

        public ClearRegUpdateFlags(String string) {
            this.description = string;
        }

        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            DVArchOpCodes.this.regUpdateFlags = new boolean[64];
            return new DVCode(null, this.description + "\n Regsiter upadate flags have been cleared");
        }

        @Override
        public boolean getNeedSection() {
            return false;
        }
    }

    public class ResumeCExtension
    extends DVOpCodeProcessor {
        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            DVArchOpCodes.this.useCExtension = true & DVArchOpCodes.this.cExt;
            return new DVCode(null, null, DVArchOpCodes.this.cExt ? "Use of C extension has been resumed" : "C extension not specified: directive ignored ");
        }

        @Override
        public boolean getNeedSection() {
            return false;
        }

        @Override
        public boolean getNoLabel() {
            return true;
        }
    }

    public class SuspendCExtension
    extends DVOpCodeProcessor {
        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            DVArchOpCodes.this.useCExtension = false;
            return new DVCode(null, null, DVArchOpCodes.this.cExt ? "Use of C extension has been suspended" : "C extension not specified: directive ignored ");
        }

        @Override
        public boolean getNeedSection() {
            return false;
        }

        @Override
        public boolean getNoLabel() {
            return true;
        }
    }

    public class Abi
    extends DVAbi {
        private final HashMap<String, RelocationEntry> relocationMap = this.getRelocationMap();
        private final String abiName;
        private final int processorFlags;

        private Abi(DVStatements.Statement statement, String string, int n) {
            this.abiName = string;
            this.processorFlags = n;
        }

        @Override
        public String getEnv() {
            Object[] objectArray = new Object[8];
            objectArray[0] = DVArchOpCodes.this.noRegs;
            objectArray[1] = DVArchOpCodes.this.fLen == 0 ? 0 : 32;
            objectArray[2] = DVArchOpCodes.this.xLen;
            objectArray[3] = DVArchOpCodes.this.abiFLen;
            objectArray[4] = DVArchOpCodes.this.xLen >> 3;
            objectArray[5] = DVArchOpCodes.this.abiFLen >> 3;
            Object object = DVArchOpCodes.this.xLen == 32 ? "W" : (objectArray[6] = DVArchOpCodes.this.xLen == 64 ? "D" : "Q");
            objectArray[7] = DVArchOpCodes.this.abiFLen == 0 ? "" : (DVArchOpCodes.this.abiFLen == 32 ? "S" : (DVArchOpCodes.this.abiFLen == 64 ? "D" : "Q"));
            return String.format("abiNoRegs=%d;abiNoFRegs=%d;abiXLen=%d;abiFLen=%d;abiWLen=%d;abiFWLen=%d;abiWID=\"%s\";abiFWID=\"%s\";", objectArray);
        }

        @Override
        public String getDetails() {
            DVArchOpCodes.this.branchStmtList.clear();
            return String.format("Architecture is................................. RISCV\nNumber of registers............................. %d\nRegister bit length (XLEN)...................... %d\nNumber of floating registers.................... %d\nFloating register bit length (FLEN)............. %d\n(A) atomic extension............................ %s\n(C) two byte opCode encoding extension.......... %s\n(M) integer multiply/divide extension........... %s\n(N) user level interrupt extension.............. %s\n(ZTSO) total store ordering..................... %s\n(ZICSR) control/status registers extension...... %s\n(ZIFENCEI) instruction fetch fence extension.... %s\nABI............................................. %s\nOperating System................................ %s", DVArchOpCodes.this.noRegs, DVArchOpCodes.this.xLen, DVArchOpCodes.this.fLen == 0 ? 0 : 32, DVArchOpCodes.this.fLen, DVArchOpCodes.this.aExt ? "Used" : "Not Used", DVArchOpCodes.this.cExt ? "Used" : "Not Used", DVArchOpCodes.this.mExt ? "Used" : "Not Used", DVArchOpCodes.this.nExt ? "Used" : "Not Used", DVArchOpCodes.this.zTsoExt ? "Used" : "Not Used", DVArchOpCodes.this.zicsrExt ? "Used" : "Not Used", DVArchOpCodes.this.zifenceiExt ? "Used" : "Not Used", this.abiName, DVArchOpCodes.this.os != null ? DVArchOpCodes.this.os : "Not Specified");
        }

        @Override
        public boolean verifySectionType(BigInteger bigInteger) {
            return DVUtil.verifySectionType(bigInteger);
        }

        @Override
        public boolean verifySectionAttribute(BigInteger bigInteger) {
            return DVUtil.verifySectionAttribute(bigInteger);
        }

        @Override
        public boolean verifyExternalSymbolBind(BigInteger bigInteger) {
            return DVUtil.verifyExternalSymbolBind(bigInteger);
        }

        @Override
        public boolean verifyExportedSymbolBind(BigInteger bigInteger) {
            return DVUtil.verifyExportedSymbolBind(bigInteger);
        }

        @Override
        public boolean verifySymbolType(BigInteger bigInteger) {
            return DVUtil.verifySymbolType(bigInteger);
        }

        @Override
        public boolean verifyBaseRegister(BigInteger bigInteger) {
            return bigInteger.compareTo(BigInteger.ZERO) >= 0 && bigInteger.bitLength() <= DVArchOpCodes.this.regFileNoBits;
        }

        @Override
        public DVAbi.RelocationID getRelocationID(DVStatements.Statement statement, String string, String string2, boolean bl) {
            statement.putError("Software error - getRelocationID called with unsupported arguments");
            return null;
        }

        @Override
        public DVAbi.RelocationID[] getRelocationID(DVStatements.Statement statement, String string, String string2) {
            if (string == null) {
                statement.putError("No relocation type has been provided for external symbol");
                return null;
            }
            if (!string.startsWith("@")) {
                statement.putError("Relocation type [%s] does not start with '@' character", string);
                return null;
            }
            String[] stringArray = string.substring(1).split(".@");
            DVAbi.RelocationID[] relocationIDArray = new DVAbi.RelocationID[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                RelocationEntry relocationEntry = this.relocationMap.get(string3.toUpperCase());
                if (relocationEntry == null) {
                    statement.putError("Relocation type [" + string3 + "] is not supported");
                    return null;
                }
                if (!relocationEntry.format.equals(string2.toUpperCase())) {
                    statement.putError("Relocation type [" + string3 + "] is not supported for format [" + string2 + "]");
                    return null;
                }
                relocationIDArray[i] = new DVAbi.RelocationID(relocationEntry.id, "R_RISCV" + string3);
            }
            return relocationIDArray;
        }

        private HashMap<String, RelocationEntry> getRelocationMap() {
            HashMap<String, RelocationEntry> hashMap = new HashMap<String, RelocationEntry>();
            hashMap.put("_32", new RelocationEntry("WORD_32", 1));
            hashMap.put("_64", new RelocationEntry("WORD_64", 2));
            hashMap.put("_RELATIVE", new RelocationEntry("WORD_" + Integer.toString(DVArchOpCodes.this.xLen), 3));
            hashMap.put("_JUMP_SLOT", new RelocationEntry("WORD_" + Integer.toString(DVArchOpCodes.this.xLen), 5));
            hashMap.put("_TLS_DTPMOD32", new RelocationEntry("WORD_32", 6));
            hashMap.put("_TLS_DTPMOD64", new RelocationEntry("WORD_64", 7));
            hashMap.put("_TLS_DTPREL32", new RelocationEntry("WORD_32", 8));
            hashMap.put("_TLS_DTPREL64", new RelocationEntry("WORD_64", 9));
            hashMap.put("_TLS_TPREL32", new RelocationEntry("WORD_32", 10));
            hashMap.put("_TLS_TPREL64", new RelocationEntry("WORD_64", 11));
            hashMap.put("_JAL", new RelocationEntry("J", 17));
            hashMap.put("_CALL", new RelocationEntry("U", 18));
            hashMap.put("_CALL_PLT", new RelocationEntry("U", 19));
            hashMap.put("_GOT_HI20", new RelocationEntry("U", 20));
            hashMap.put("_TLS_GOT_HI20", new RelocationEntry("U", 21));
            hashMap.put("_TLS_GD_HI20", new RelocationEntry("U", 22));
            hashMap.put("_PCREL_HI20", new RelocationEntry("U", 23));
            hashMap.put("_PCREL_LO12_I", new RelocationEntry("I", 24));
            hashMap.put("_PCREL_LO12_S", new RelocationEntry("S", 25));
            hashMap.put("_HI20", new RelocationEntry("U", 26));
            hashMap.put("_LO12_I", new RelocationEntry("I", 27));
            hashMap.put("_LO12_S", new RelocationEntry("S", 28));
            hashMap.put("_TPREL_HI20", new RelocationEntry("U", 29));
            hashMap.put("_TPREL_LO12_I", new RelocationEntry("I", 30));
            hashMap.put("_TPREL_LO12_S", new RelocationEntry("S", 31));
            hashMap.put("_GPREL_I", new RelocationEntry("I", 47));
            hashMap.put("_GPREL_S", new RelocationEntry("S", 48));
            hashMap.put("_TPREL_I", new RelocationEntry("I", 49));
            hashMap.put("_TPREL_S", new RelocationEntry("S", 50));
            hashMap.put("_32_PCREL", new RelocationEntry("WORD_32", 57));
            return hashMap;
        }

        @Override
        public int getElfBits() {
            return DVArchOpCodes.this.xLen;
        }

        @Override
        public int getAddrBits() {
            return DVArchOpCodes.this.xLen;
        }

        @Override
        public DVUtil.Endianness getElfEndianness() {
            return DVUtil.Endianness.LITTLE;
        }

        @Override
        public DVUtil.Endianness getDefaultEndianness() {
            return DVUtil.Endianness.LITTLE;
        }

        @Override
        public int getOsAbi() {
            return 0;
        }

        @Override
        public int getAbiVersion() {
            return 1;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public int getMachine() {
            return 243;
        }

        @Override
        public int getVersion() {
            return 1;
        }

        @Override
        public int getProcessorFlags() {
            return this.processorFlags;
        }

        @Override
        public long getRelocationSectionAttributes() {
            return 64L;
        }

        class RelocationEntry {
            protected String format;
            protected int id;

            protected RelocationEntry(String string, int n) {
                this.format = string;
                this.id = n;
            }
        }
    }

    private static enum UFormatType {
        NORMAL,
        ZERO_DESTREG;

    }

    public static enum SFormatType {
        NORMAL,
        CONDITIONAL,
        FLOAT_REG;

    }

    public static enum IFormatType {
        NORMAL,
        CONDITIONAL,
        IMM_NOT_ZERO,
        FLOAT_REG;

    }

    private static enum RFormatType {
        NORMAL,
        CONST_SRC2REG,
        ZERO_DESTREG,
        ZERO_DESTREG_OK,
        FBOOLEAN,
        RM,
        CONST_SRC2REG_RM;

    }

    private class BranchStmt {
        private final DVStatements.Statement owner;
        private final BigInteger toOffset;
        private final boolean conditional;

        private BranchStmt(DVStatements.Statement statement, BigInteger bigInteger, boolean bl) {
            this.owner = statement;
            this.toOffset = bigInteger;
            this.conditional = bl;
        }
    }
}

