/*
 * Decompiled with CFR 0.152.
 */
package framework;

import framework.DVHtmlListing;
import framework.DVMacros;
import framework.DVParseInput;
import framework.DVStatements;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DVDriver
implements Runnable {
    private LinkedList<String> inputFiles;
    private ArrayList<String> macroDirectories;
    private LinkedList<String> outputFiles;
    private LinkedList<String> listFiles;
    private String archDirectory;
    private String archExtDirectory;
    private DVMacros macros;
    private Lock fileListLock;

    public DVDriver(LinkedList<String> linkedList, ArrayList<String> arrayList, LinkedList<String> linkedList2, LinkedList<String> linkedList3, String string, String string2, DVMacros dVMacros, ReentrantLock reentrantLock) {
        this.inputFiles = linkedList;
        this.outputFiles = linkedList2;
        this.macroDirectories = arrayList;
        this.archDirectory = string;
        this.archExtDirectory = string2;
        this.listFiles = linkedList3;
        this.macros = dVMacros;
        this.fileListLock = reentrantLock;
    }

    @Override
    public void run() {
        while (true) {
            boolean bl = false;
            this.fileListLock.lock();
            if (this.inputFiles.isEmpty()) {
                this.fileListLock.unlock();
                return;
            }
            String string = this.inputFiles.pop();
            String string2 = this.outputFiles.pop();
            String string3 = this.listFiles.pop();
            this.fileListLock.unlock();
            long l = System.currentTimeMillis();
            DVParseInput dVParseInput = null;
            try {
                dVParseInput = new DVParseInput(string, this.macroDirectories, this.archDirectory, this.archExtDirectory, this.macros);
            }
            catch (IOException iOException) {
                System.err.println("\n*** Unable to read input file [" + string + "] - Error: " + iOException.getMessage());
            }
            if (dVParseInput == null) continue;
            DVStatements dVStatements = dVParseInput.parse();
            dVStatements.logMsg(String.format("Parse elapsed time is: %d milliseconds\n", System.currentTimeMillis() - l));
            l = System.currentTimeMillis();
            if (dVStatements.errors > 0) {
                dVStatements.logMsg("Input parsing completed with errors");
            } else if (dVStatements.firstPhaseWarnings > 0) {
                dVStatements.logMsg("Input parsing completed with warnings");
            } else {
                dVStatements.logMsg("Input parsing completed succesfully");
            }
            if (dVStatements.errors == 0) {
                dVStatements.symbols.setDependencies();
                if (dVStatements.errors > 0) {
                    dVStatements.logMsg("Dependencies preprocessing failed due to error(s)");
                } else {
                    dVStatements.logMsg("Dependencies preprocessing completed successfully");
                    dVStatements.setSecondPhase();
                    for (int i = 0; i < 256; ++i) {
                        dVStatements.symbols.evaluate();
                        if (dVStatements.errors > 0) {
                            dVStatements.logMsg("Dependencies resolution failed due to error(s)");
                            break;
                        }
                        dVStatements.logMsg("Dependencies resolution completed successfully");
                        dVStatements.genCode();
                        if (dVStatements.errors > 0) {
                            dVStatements.logMsg("Code generation failed due to error(s)");
                            break;
                        }
                        if (dVStatements.warnings > 0) {
                            dVStatements.logMsg("Code generation completed with warnings");
                        } else {
                            dVStatements.logMsg("Code generation completed successfully");
                        }
                        if (!dVStatements.changedLengthFlag) break;
                        dVStatements.resetSecondPhase();
                    }
                    if (dVStatements.errors == 0) {
                        byte[] byArray = dVStatements.generateElfBinary();
                        try {
                            FileOutputStream fileOutputStream = new FileOutputStream(new File(string2));
                            fileOutputStream.write(byArray);
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            dVStatements.logMsg("Error writing ELF file [" + string2 + "] - Error: " + iOException.toString());
                        }
                    }
                }
                dVStatements.logMsg(String.format("Code generation elapsed time is: %d milliseconds\n", System.currentTimeMillis() - l));
            }
            try {
                FileWriter fileWriter = new FileWriter(string3);
                fileWriter.write(new DVHtmlListing().getListing(dVStatements));
                fileWriter.close();
            }
            catch (IOException iOException) {
                dVStatements.logErr("Error while writing listing file [" + string3 + "] - Error: " + iOException.toString());
            }
            System.err.format("    DVASM execution completed with [%3d] warnings and [%3d] errors for input file [%s]\n", dVStatements.warnings, dVStatements.errors, string);
        }
    }
}

