/*
 * Decompiled with CFR 0.152.
 */
package framework;

import framework.DVSections;
import framework.DVStatements;
import framework.DVSymbols;
import framework.DVUtil;
import framework.ParseException;
import framework.Token;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Set;

public class DVExpression {
    private final DVStatements.Statement owner;
    private final LinkedList<ExprToken> exprList = new LinkedList();
    private final LinkedList<ExprToken> exprStack = new LinkedList();
    private static final String escapeChar = "0btnvfr\"'\\";
    private static final short[] escapeCharCode = new short[]{0, 8, 9, 10, 11, 12, 13, 34, 39, 92};
    public static Set<TokenType> INT_VALUE = EnumSet.of(TokenType.ABSOLUTE, TokenType.DISPLACEMENT);
    private static final Set<OperType> OneParmOperator = EnumSet.of(OperType.UPLUS, OperType.UMINUS, OperType.BNOT, OperType.LNOT);
    private static final int[] operPriority = new int[]{13, 12, 12, 12, 12, 11, 10, 10, 10, 9, 9, 8, 8, 7, 7, 7, 7, 6, 6, 5, 4, 3, 2, 1, 0, -1, -1};
    private static final boolean[] operLeftAssociation = new boolean[]{true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    public static final MathContext floatMC = new MathContext(45);
    private static final Method[] bIOper;
    private static final Method[] bIBIOper;
    private static final Method[] bIBDOper;
    private static final Method[] bDOper;
    private static final Method[] bDBDOper;
    private static final Method[] bDBIOper;

    protected DVExpression(DVStatements.Statement statement) {
        this.owner = statement;
    }

    protected void addPostfixOperatorToken(OperType operType) {
        ExprToken exprToken = new ExprToken(TokenType.OPERATOR, null);
        exprToken.operType = operType;
        exprToken.operPriority = operPriority[exprToken.operType.ordinal()];
        exprToken.operLeftAssociation = operLeftAssociation[exprToken.operType.ordinal()];
        this.exprList.add(exprToken);
    }

    protected void addOperatorToken(Token token, OperType operType) {
        ExprToken exprToken = new ExprToken(TokenType.OPERATOR, token);
        exprToken.operType = operType;
        exprToken.operPriority = operPriority[exprToken.operType.ordinal()];
        exprToken.operLeftAssociation = operLeftAssociation[exprToken.operType.ordinal()];
        if (exprToken.operType == OperType.RPAREN) {
            while (this.exprStack.peekFirst().operType != OperType.LPAREN) {
                this.exprList.add(this.exprStack.pop());
            }
            this.exprStack.pop();
            return;
        }
        if (exprToken.operType != OperType.LPAREN) {
            while (this.exprStack.peekFirst() != null && (exprToken.operPriority < this.exprStack.peekFirst().operPriority || exprToken.operPriority == this.exprStack.peekFirst().operPriority && exprToken.operLeftAssociation)) {
                this.exprList.add(this.exprStack.pop());
            }
        }
        this.exprStack.push(exprToken);
    }

    protected void addBaseSymbolToken(Token token) {
        ExprToken exprToken = new ExprToken(TokenType.BASE_SYMBOL, token);
        exprToken.baseID = token.image.substring(0, token.image.indexOf(58));
        exprToken.symbol = this.owner.getSymbols().getSymbol(token.image.substring(token.image.indexOf(58) + 1));
        this.exprList.add(exprToken);
    }

    protected void addQualifiedSymbolToken(Token token) {
        ExprToken exprToken = new ExprToken(TokenType.SYMBOL, token);
        exprToken.qualifier = token.image.substring(token.image.indexOf(64));
        exprToken.symbol = this.owner.getSymbols().getSymbol(token.image.substring(0, token.image.indexOf(64)));
        this.exprList.add(exprToken);
    }

    protected void addSymbolToken(Token token, DVSymbols.SymbolComponent symbolComponent) {
        int n;
        if (token != null && (n = token.image.indexOf(".$")) > 0) {
            token.image = token.image.substring(0, n);
        }
        this.addSymbolToken(token, this.owner.getSymbols().getSymbol(token.image), symbolComponent);
    }

    protected void addSymbolToken(DVSymbols.Symbol symbol, DVSymbols.SymbolComponent symbolComponent) {
        this.addSymbolToken(null, symbol, symbolComponent);
    }

    protected void addSymbolToken(Token token, DVSymbols.Symbol symbol, DVSymbols.SymbolComponent symbolComponent) {
        ExprToken exprToken = new ExprToken(TokenType.SYMBOL, token);
        exprToken.symbol = symbol;
        exprToken.symbolComponent = symbolComponent;
        this.exprList.add(exprToken);
        if (token != null) {
            exprToken.symbol.addReference(this.owner);
        }
    }

    protected void addCounterToken(Token token) {
        if (this.owner.ownerSection != null) {
            this.exprList.add(new ExprToken(this.owner.symbol, DVSymbols.SymbolComponent.VALUE));
            return;
        }
        DVStatements.Statement statement = this.owner.getPrevSectStatement();
        if (statement == null) {
            this.owner.putError("Program Counter used in expression but no Section or MMap is active");
            return;
        }
        this.exprList.add(new ExprToken(statement.symbol, DVSymbols.SymbolComponent.VALUE));
        this.exprList.add(new ExprToken(statement.symbol, DVSymbols.SymbolComponent.LENGTH));
        this.exprList.add(new ExprToken(statement.symbol, DVSymbols.SymbolComponent.REPL));
        this.exprList.add(new ExprToken(OperType.MULTIPLY));
        this.exprList.add(new ExprToken(OperType.PLUS));
    }

    protected void addFloatToken(Token token) throws ParseException {
        ExprToken exprToken = new ExprToken(TokenType.FLOAT, token);
        boolean bl = false;
        try {
            exprToken.floatConstant = new BigDecimal(token.image);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            this.owner.putError(String.format("Exponent too large for floatig point constant on line %d column %d", token.beginLine, token.beginColumn));
            return;
        }
        this.exprList.add(exprToken);
    }

    protected void addIntegerToken(Token token) {
        ExprToken exprToken = new ExprToken(TokenType.ABSOLUTE, token);
        exprToken.intConstant = new BigInteger(token.image);
        this.exprList.add(exprToken);
    }

    protected void addIntegerToken(BigInteger bigInteger) {
        ExprToken exprToken = new ExprToken(TokenType.ABSOLUTE, null);
        exprToken.intConstant = bigInteger;
        this.exprList.add(exprToken);
    }

    protected void addHexToken(Token token) {
        ExprToken exprToken = new ExprToken(TokenType.ABSOLUTE, token);
        exprToken.intConstant = new BigInteger(token.image.substring(2).replace("_", ""), 16);
        this.exprList.add(exprToken);
    }

    protected void addBinToken(Token token) {
        ExprToken exprToken = new ExprToken(TokenType.ABSOLUTE, token);
        exprToken.intConstant = new BigInteger(token.image.substring(2).replace("_", ""), 2);
        this.exprList.add(exprToken);
    }

    protected void addCharToken(Token token) {
        char c = token.image.charAt(1);
        short s = c == '\\' ? ((c = token.image.charAt(2)) == 'x' ? Short.parseShort(token.image.substring(3, 5)) : escapeCharCode[escapeChar.indexOf(c)]) : (short)c;
        ExprToken exprToken = new ExprToken(TokenType.ABSOLUTE, token);
        exprToken.intConstant = BigInteger.valueOf(s);
        this.exprList.add(exprToken);
    }

    protected void addOffsetIntegerToken(DVSections.Section section, BigInteger bigInteger) {
        ExprToken exprToken = new ExprToken(TokenType.OFFSET, null);
        exprToken.intConstant = bigInteger;
        exprToken.offsetRecordList = new ArrayList();
        exprToken.offsetRecordList.add(new OffsetRecord(section, 1));
        this.exprList.add(exprToken);
    }

    protected String addStringToken(Token token) {
        ExprToken exprToken = new ExprToken(TokenType.STRING, token);
        try {
            exprToken.stringConstant = DVUtil.unescapeString(token.image.substring(1, token.image.length() - 1));
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
        this.exprList.add(exprToken);
        return null;
    }

    protected void expressionEnd() {
        while (!this.exprStack.isEmpty()) {
            this.exprList.add(this.exprStack.pop());
        }
    }

    protected DVExpression addExpression(DVExpression dVExpression) {
        if (dVExpression.exprList.isEmpty()) {
            return this;
        }
        boolean bl = this.isEmpty();
        for (ExprToken exprToken : dVExpression.exprList) {
            this.exprList.add(exprToken);
        }
        if (!bl) {
            this.addPostfixOperatorToken(OperType.PLUS);
        }
        return this;
    }

    protected DVExpression maxExpression(DVExpression dVExpression) {
        if (dVExpression.exprList.isEmpty()) {
            return this;
        }
        boolean bl = this.isEmpty();
        for (ExprToken exprToken : dVExpression.exprList) {
            this.exprList.add(exprToken);
        }
        if (!bl) {
            this.addPostfixOperatorToken(OperType.MAX);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.exprList.isEmpty();
    }

    protected ExprToken getFirstTokenIfSingle() {
        if (this.isEmpty() || this.exprList.size() > 1) {
            return null;
        }
        return this.exprList.peekFirst();
    }

    protected void setValueDependencies(DVSymbols.Symbol symbol) {
        this.owner.logTrace("--- Set value dependencies - Symbol: " + symbol.name);
        for (ExprToken exprToken : this.exprList) {
            if (exprToken.type != TokenType.SYMBOL || exprToken.symbol.isExternal || exprToken.symbol.isCommon) continue;
            if (exprToken.symbolComponent == DVSymbols.SymbolComponent.VALUE) {
                exprToken.symbol.setValueValueDependency(symbol);
                this.owner.logTrace("---                    Value Symbol: " + exprToken.symbol.name);
                continue;
            }
            if (exprToken.symbolComponent != DVSymbols.SymbolComponent.REPL && exprToken.symbolComponent != DVSymbols.SymbolComponent.SIZE) continue;
            exprToken.symbol.setReplValueDependency(symbol);
            this.owner.logTrace("---                    Repl  Symbol: " + exprToken.symbol.name);
        }
    }

    protected void setReplDependencies(DVSymbols.Symbol symbol) {
        for (ExprToken exprToken : this.exprList) {
            if (exprToken.type != TokenType.SYMBOL) continue;
            if (exprToken.symbolComponent == DVSymbols.SymbolComponent.VALUE) {
                exprToken.symbol.setValueReplDependency(symbol);
                continue;
            }
            if (exprToken.symbolComponent != DVSymbols.SymbolComponent.REPL && exprToken.symbolComponent != DVSymbols.SymbolComponent.SIZE) continue;
            exprToken.symbol.setReplReplDependency(symbol);
        }
    }

    protected static DVExpression getNewSymbolValueExpression(DVSymbols.Symbol symbol, DVSymbols.Symbol symbol2) {
        DVExpression dVExpression = new DVExpression(symbol2.owner);
        dVExpression.addSymbolToken(symbol, DVSymbols.SymbolComponent.VALUE);
        dVExpression.addSymbolToken(symbol, DVSymbols.SymbolComponent.LENGTH);
        dVExpression.addSymbolToken(symbol, DVSymbols.SymbolComponent.REPL);
        dVExpression.addPostfixOperatorToken(OperType.MULTIPLY);
        dVExpression.addPostfixOperatorToken(OperType.PLUS);
        if (symbol2.align != null) {
            dVExpression.addIntegerToken(symbol2.align);
            dVExpression.addPostfixOperatorToken(OperType.ALIGN);
        }
        return dVExpression;
    }

    protected static DVExpression getEndValueExpression(DVStatements.Statement statement) {
        DVExpression dVExpression = new DVExpression(statement);
        DVSymbols.Symbol symbol = statement.symbol;
        dVExpression.addSymbolToken(symbol, DVSymbols.SymbolComponent.VALUE);
        dVExpression.addSymbolToken(symbol, DVSymbols.SymbolComponent.LENGTH);
        dVExpression.addSymbolToken(symbol, DVSymbols.SymbolComponent.REPL);
        dVExpression.addPostfixOperatorToken(OperType.MULTIPLY);
        dVExpression.addPostfixOperatorToken(OperType.PLUS);
        return dVExpression;
    }

    protected static DVExpression getConstantExpression(BigInteger bigInteger, DVStatements.Statement statement) {
        DVExpression dVExpression = new DVExpression(statement);
        dVExpression.addIntegerToken(bigInteger);
        return dVExpression;
    }

    public static ExprToken getConstantExprToken(BigInteger bigInteger, DVStatements.Statement statement) {
        DVExpression dVExpression = DVExpression.getConstantExpression(bigInteger, statement);
        dVExpression.addIntegerToken(bigInteger);
        return dVExpression.getFirstExprToken();
    }

    protected static DVExpression getOffsetConstantExpression(DVStatements.Statement statement, DVSections.Section section, BigInteger bigInteger) {
        DVExpression dVExpression = new DVExpression(statement);
        dVExpression.addOffsetIntegerToken(section, bigInteger);
        return dVExpression;
    }

    protected ExprToken getFirstExprToken() {
        return this.exprList.peek();
    }

    protected void setSymbolReferences(DVStatements.Statement statement) {
        for (ExprToken exprToken : this.exprList) {
            if (exprToken.type != TokenType.SYMBOL) continue;
            exprToken.symbol.addReference(statement);
        }
    }

    protected void list(String string) {
        System.out.println("--- Start expression dump:  " + string);
        for (ExprToken exprToken : this.exprList) {
            if (exprToken.type == TokenType.SYMBOL) {
                DVSymbols.Symbol symbol = exprToken.symbol;
                System.out.format("    Token type: SYMBOL  %s  - Comp: %s -> ", symbol.name, exprToken.symbolComponent.name());
                if (exprToken.symbolComponent == DVSymbols.SymbolComponent.VALUE) {
                    System.out.format("%s\n", symbol.resultValue != null && symbol.resultValue.intConstant != null ? symbol.resultValue.intConstant : "N/A");
                    continue;
                }
                if (exprToken.symbolComponent == DVSymbols.SymbolComponent.REPL) {
                    System.out.format("%s\n", symbol.resultRepl != null && symbol.resultRepl.intConstant != null ? symbol.resultRepl.intConstant : "N/A");
                    continue;
                }
                if (exprToken.symbolComponent == DVSymbols.SymbolComponent.LENGTH) {
                    System.out.format("%s\n", symbol.length != null ? symbol.length : "N/A");
                    continue;
                }
                System.out.format("%s\n", symbol.resultValue != null && symbol.resultValue.intConstant != null && symbol.resultRepl != null && symbol.resultRepl.intConstant != null ? symbol.resultValue.intConstant.multiply(symbol.resultRepl.intConstant).toString() : "N/A");
                continue;
            }
            if (exprToken.type == TokenType.OPERATOR) {
                System.out.format("    Token type: OPERATOR  %s\n", exprToken.operType.name());
                continue;
            }
            System.out.format("    Token type: %s   %s\n", exprToken.type.name(), exprToken.intConstant == null ? "N/A" : exprToken.intConstant.toString());
        }
    }

    protected void dump() {
        this.owner.logMsg("--- Start expression dump");
        for (ExprToken exprToken : this.exprList) {
            if (exprToken.type == TokenType.SYMBOL) {
                this.owner.logMsg(String.format("    Token type: SYMBOL  %s  %s  %s  %s\n", exprToken.symbol.name, exprToken.symbol.resultValue != null && exprToken.symbol.resultValue.intConstant != null ? exprToken.symbol.resultValue.intConstant.toString() : "N/A", exprToken.symbol.resultRepl != null && exprToken.symbol.resultRepl.intConstant != null ? exprToken.symbol.resultRepl.intConstant.toString() : "N/A", exprToken.symbol.length != null ? exprToken.symbol.length.toString() : "N/A"));
                continue;
            }
            if (exprToken.type == TokenType.OPERATOR) {
                this.owner.logMsg(String.format("    Token type: OPERATOR  %s\n", exprToken.operType.name()));
                continue;
            }
            this.owner.logMsg(String.format("    Token type: %s   %s\n", exprToken.type.name(), exprToken.intConstant == null ? "N/A" : exprToken.intConstant.toString()));
        }
        this.owner.logMsg(" -  End Expression Dump");
    }

    protected ExprToken evaluate(boolean bl) {
        ExprToken exprToken = null;
        ExprToken exprToken2 = null;
        ExprToken exprToken3 = null;
        ExprToken exprToken4 = null;
        Exception exception = null;
        Method method = null;
        if (this.exprList.size() == 0) {
            return null;
        }
        LinkedList<ExprToken> linkedList = new LinkedList<ExprToken>(this.exprList);
        this.exprStack.clear();
        exprToken2 = this.getFirstExprToken();
        if (exprToken2 != null && exprToken2.type == TokenType.SYMBOL && (exprToken2.symbol.isExternal || exprToken2.symbol.isCommon || exprToken2.qualifier != null || exprToken2.symbol.owner != null && exprToken2.symbol.owner.ownerSection != null && this.owner.ownerSection != null && exprToken2.symbol.owner.ownerSection.type != DVSections.SectionType.MMAP && exprToken2.symbol.owner.ownerSection != this.owner.ownerSection)) {
            if (exprToken2.qualifier == null && exprToken2.symbolComponent != DVSymbols.SymbolComponent.VALUE) {
                this.owner.putError("Symbol [" + exprToken2.symbol.name + "] is EXTERNAL or COMMON with component [" + exprToken2.symbolComponent.name() + "] - only [VALUE] is allowed" + this.evalDump(linkedList, exprToken, method, exprToken2, exprToken3, exception));
                return null;
            }
            this.owner.logTrace(String.format("-------- External symbol   %s\n", exprToken2.symbol.name));
            this.owner.logTrace(String.format("                           %b   %b\n", exprToken2.symbol.isExternal, exprToken2.symbol.isCommon));
            this.owner.logTrace(String.format("                           %s\n", this.owner.ownerSection));
            exprToken4 = new ExprToken(TokenType.EXTERNAL_VALUE, exprToken2.parseToken);
            exprToken4.symbol = exprToken2.symbol;
            exprToken4.qualifier = exprToken2.qualifier;
            exprToken4.symbolComponent = exprToken2.symbolComponent;
            exprToken2 = linkedList.pop();
            exprToken3 = new ExprToken(TokenType.EXTERNAL_ZERO);
            exprToken3.intConstant = BigInteger.ZERO;
            linkedList.push(exprToken3);
        }
        while (!linkedList.isEmpty()) {
            ExprToken exprToken5;
            method = null;
            exception = null;
            exprToken2 = linkedList.pop();
            exprToken3 = null;
            if (exprToken2.type == TokenType.SYMBOL) {
                if (exprToken2.symbol.isExternal || exprToken2.symbol.isCommon || exprToken2.qualifier != null || exprToken2.symbol.owner != null && exprToken2.symbol.owner.ownerSection != null && this.owner.ownerSection != null && exprToken2.symbol.owner.ownerSection != this.owner.ownerSection && exprToken2.symbol.owner.ownerSection.type != DVSections.SectionType.MMAP && exprToken2.symbolComponent == DVSymbols.SymbolComponent.VALUE) {
                    this.owner.putError("Symbol [" + exprToken2.symbol.name + "] is external to current section or relocation qualified and is not first token in expression" + this.evalDump(linkedList, exprToken, method, exprToken2, exprToken3, exception));
                    return null;
                }
                if (exprToken2.symbolComponent == DVSymbols.SymbolComponent.VALUE) {
                    if (exprToken2.symbol.resultValue == null) {
                        this.owner.putError("Unresolved symbol [" + exprToken2.symbol.name + "] Value" + this.evalDump(linkedList, exprToken, method, exprToken2, exprToken3, exception));
                        return null;
                    }
                    this.exprStack.push(exprToken2.symbol.resultValue);
                    continue;
                }
                if (exprToken2.symbolComponent == DVSymbols.SymbolComponent.REPL || exprToken2.symbolComponent == DVSymbols.SymbolComponent.SIZE) {
                    ExprToken exprToken6;
                    if (exprToken2.symbol.resultRepl == null) {
                        this.owner.putError("Unresolved symbol [" + exprToken2.symbol.name + "] Repl" + this.evalDump(linkedList, exprToken, method, exprToken2, exprToken3, exception));
                        return null;
                    }
                    if (exprToken2.symbolComponent == DVSymbols.SymbolComponent.REPL) {
                        exprToken6 = new ExprToken(TokenType.DISPLACEMENT);
                        exprToken6.intConstant = exprToken2.symbol.resultRepl.intConstant;
                        this.exprStack.push(exprToken6);
                        continue;
                    }
                    exprToken6 = new ExprToken(TokenType.DISPLACEMENT);
                    exprToken6.intConstant = exprToken2.symbol.resultRepl.intConstant.multiply(exprToken2.symbol.length);
                    this.exprStack.push(exprToken6);
                    continue;
                }
                exprToken5 = new ExprToken(TokenType.DISPLACEMENT, null);
                exprToken5.intConstant = exprToken2.symbol.length;
                this.exprStack.push(exprToken5);
                continue;
            }
            if (exprToken2.type == TokenType.BASE_SYMBOL) {
                if (exprToken2.symbol.resultValue.type != TokenType.OFFSET) {
                    this.owner.putError(String.format("Symbol [%s] in BASE:SYMBOL does not resolve to OFFSET\n", exprToken2.symbol.name));
                    return null;
                }
                exprToken5 = new ExprToken(TokenType.BASE_DISPLACEMENT, exprToken2.parseToken);
                exprToken5.baseID = exprToken2.baseID;
                exprToken5.baseSection = exprToken2.symbol.owner.ownerSection;
                exprToken5.intConstant = exprToken2.symbol.resultValue.intConstant;
                exprToken5.baseRegisterValue = null;
                this.exprStack.push(exprToken5);
                continue;
            }
            if (exprToken2.type != TokenType.OPERATOR) {
                this.exprStack.push(exprToken2);
                continue;
            }
            if (this.exprStack.size() == 0) {
                this.owner.putError("Expression Software Error - Data Stack Empty when Data Expected\n" + this.evalDump(linkedList, exprToken, method, exprToken2, exprToken3, exception));
                return null;
            }
            exprToken = exprToken2;
            exprToken2 = this.exprStack.pop();
            if (OneParmOperator.contains((Object)exprToken.operType)) {
                exprToken2 = exprToken2.clone();
                if (exprToken2.type == TokenType.STRING) {
                    this.owner.putError("No unary operator can be used on STRING" + this.evalDump(linkedList, exprToken, method, exprToken2, exprToken3, exception));
                    return null;
                }
                if (exprToken.operType == OperType.UPLUS) {
                    this.exprStack.push(exprToken2);
                    continue;
                }
                if (exprToken2.type == TokenType.BASE_DISPLACEMENT) {
                    this.owner.putError("Invalid unary operator for integer of type BASE_DISPLACEMENT" + this.evalDump(linkedList, exprToken, method, exprToken2, exprToken3, exception));
                    return null;
                }
                if ((exprToken2.type == TokenType.OFFSET || exprToken2.type == TokenType.FLOAT) && exprToken.operType != OperType.UMINUS) {
                    this.owner.putError("Invalid unary operator for integer of type OFFSET or for FLOAT" + this.evalDump(linkedList, exprToken, method, exprToken2, exprToken3, exception));
                    return null;
                }
                if (exprToken2.type == TokenType.OFFSET) {
                    exprToken2.switchOffsetRecordSign();
                } else {
                    try {
                        if (exprToken2.type == TokenType.FLOAT) {
                            method = bDOper[exprToken.operType.ordinal()];
                            if (method == null) {
                                this.owner.putError("Unary operator not allowed for given value type" + this.evalDump(linkedList, exprToken, method, exprToken2, exprToken3, exception));
                                return null;
                            }
                            exprToken2.floatConstant = (BigDecimal)method.invoke(null, exprToken2.floatConstant);
                        } else {
                            method = bIOper[exprToken.operType.ordinal()];
                            if (method == null) {
                                this.owner.putError("Unary operator not allowed for given value type" + this.evalDump(linkedList, exprToken, method, exprToken2, exprToken3, exception));
                                return null;
                            }
                            exprToken2.intConstant = (BigInteger)method.invoke(null, exprToken2.intConstant);
                        }
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                    }
                }
                if (exception != null) {
                    this.owner.putError("Operator Exception" + this.evalDump(linkedList, exprToken, method, exprToken2, exprToken3, exception));
                    return null;
                }
                this.exprStack.push(exprToken2);
                continue;
            }
            exprToken3 = exprToken2;
            if (this.exprStack.size() == 0) {
                this.owner.putError("+++ Software error in postfix expression" + this.evalDump(linkedList, exprToken, method, exprToken2, exprToken3, exception));
                return null;
            }
            exprToken2 = this.exprStack.pop();
            if (exprToken2.type == TokenType.EXTERNAL_ZERO) {
                if (exprToken.operType != OperType.PLUS && exprToken.operType != OperType.MINUS) {
                    this.owner.putError("Binary operator following external symbol can only be PLUS or MINUS");
                    return null;
                }
                exprToken2 = new ExprToken(TokenType.ABSOLUTE);
                exprToken2.intConstant = BigInteger.ZERO;
            }
            if (exprToken2.type == TokenType.STRING || exprToken3.type == TokenType.STRING) {
                if (exprToken2.type != TokenType.STRING || exprToken3.type != TokenType.STRING || exprToken.operType != OperType.PLUS) {
                    this.owner.putError("Binary operator is not PLUS or is operating on a STRING and NON-STRING" + this.evalDump(linkedList, exprToken, method, exprToken2, exprToken3, exception));
                    return null;
                }
                exprToken5 = new ExprToken(TokenType.STRING);
                exprToken5.stringConstant = exprToken2.stringConstant + exprToken3.stringConstant;
                this.exprStack.push(exprToken5);
                continue;
            }
            if (exprToken2.type == TokenType.BASE_DISPLACEMENT) {
                this.owner.putError("BASE_DISPLACEMENT cannot be the second operand of any binary operator");
                return null;
            }
            if (exprToken2.type == TokenType.BASE_DISPLACEMENT) {
                if (exprToken.operType != OperType.PLUS && exprToken.operType != OperType.MINUS) {
                    this.owner.putError("Bianry operator following BASE_DISPLACEMENT token must be PLUS or MINUS");
                    return null;
                }
                if (!INT_VALUE.contains((Object)exprToken3.type)) {
                    this.owner.putError("Second operand for bianry operation to first operand BASE_DISPLACEMENT does not resolve to ABSOLUTE or DISPLACEMENT");
                    return null;
                }
                exprToken5 = new ExprToken(TokenType.BASE_DISPLACEMENT, null);
                exprToken5.baseID = exprToken2.baseID;
                exprToken5.baseRegisterValue = exprToken2.baseRegisterValue;
                exprToken5.baseSection = exprToken2.baseSection;
                method = bIBIOper[exprToken.operType.ordinal()];
            } else if (exprToken2.type == TokenType.OFFSET || exprToken3.type == TokenType.OFFSET) {
                if (exprToken2.type == TokenType.FLOAT || exprToken3.type == TokenType.FLOAT) {
                    this.owner.putError("Binary operator cannot be used between OFFSET and FLOAT" + this.evalDump(linkedList, exprToken, method, exprToken2, exprToken3, exception));
                    return null;
                }
                if (exprToken.operType != OperType.PLUS && exprToken.operType != OperType.MINUS && exprToken.operType != OperType.MAX && exprToken.operType != OperType.ALIGN) {
                    this.owner.putError("Binary operator following OFFSETs can only be PLUS, MINUS, MAX or ALIGN");
                    return null;
                }
                if (exprToken.operType == OperType.ALIGN && exprToken3.type != TokenType.ABSOLUTE) {
                    this.owner.putError("Operator ALIGN requires second operand to be ABSOLUTE" + this.evalDump(linkedList, exprToken, method, exprToken2, exprToken3, exception));
                    return null;
                }
                if (exprToken.operType == OperType.MAX && (exprToken2.type != TokenType.OFFSET || exprToken3.type != TokenType.OFFSET)) {
                    this.owner.putError("Operator MAX requires both operands to be OFFSET" + this.evalDump(linkedList, exprToken, method, exprToken2, exprToken3, exception));
                    return null;
                }
                exprToken5 = exprToken2.type != TokenType.OFFSET ? exprToken3.clone() : (exprToken3.type != TokenType.OFFSET ? exprToken2.clone() : (exprToken.operType == OperType.MAX ? exprToken2.clone() : this.mergeOffsetRecord(exprToken2, exprToken3, exprToken.operType)));
                method = bIBIOper[exprToken.operType.ordinal()];
            } else if (exprToken2.type == TokenType.FLOAT || exprToken3.type == TokenType.FLOAT) {
                if (exprToken2.type != TokenType.ABSOLUTE && exprToken3.type != TokenType.FLOAT) {
                    this.owner.putError("FLOAT type can be binary operated only with another FLOAT or ABSOLUTE type" + this.evalDump(linkedList, exprToken, method, exprToken2, exprToken3, exception));
                    return null;
                }
                exprToken5 = new ExprToken(TokenType.FLOAT, null);
                method = exprToken2.type == TokenType.FLOAT && exprToken3.type == TokenType.FLOAT ? bDBDOper[exprToken.operType.ordinal()] : (exprToken2.type == TokenType.FLOAT ? bDBIOper[exprToken.operType.ordinal()] : bIBDOper[exprToken.operType.ordinal()]);
                exprToken5 = method.getReturnType() == BigInteger.class ? new ExprToken(TokenType.ABSOLUTE, null) : new ExprToken(TokenType.FLOAT, null);
            } else if (INT_VALUE.contains((Object)exprToken2.type) && INT_VALUE.contains((Object)exprToken3.type)) {
                if (exprToken.operType == OperType.ALIGN || exprToken.operType == OperType.MAX) {
                    this.owner.putError("Operators ALIGN and MAX require first operand to be type OFFSET" + this.evalDump(linkedList, exprToken, method, exprToken2, exprToken3, exception));
                    return null;
                }
                exprToken5 = exprToken2.type == TokenType.DISPLACEMENT || exprToken3.type == TokenType.DISPLACEMENT ? new ExprToken(TokenType.DISPLACEMENT, null) : new ExprToken(TokenType.ABSOLUTE, null);
                exprToken5.baseRegisterValue = exprToken2.baseRegisterValue;
                if (exprToken5.baseRegisterValue == null) {
                    exprToken5.baseRegisterValue = exprToken3.baseRegisterValue;
                }
                method = bIBIOper[exprToken.operType.ordinal()];
            } else {
                this.owner.putError("Unexpected expression token encountered" + this.evalDump(linkedList, exprToken, method, exprToken2, exprToken3, exception));
                return null;
            }
            if (method == null) {
                this.owner.putError("Binary operator not allowed for given value types" + this.evalDump(linkedList, exprToken, method, exprToken2, exprToken3, exception));
                return null;
            }
            exception = null;
            try {
                if (exprToken5.type == TokenType.FLOAT) {
                    exprToken5.floatConstant = exprToken2.type != TokenType.FLOAT ? (BigDecimal)method.invoke(null, exprToken2.intConstant, exprToken3.floatConstant) : (exprToken3.type != TokenType.FLOAT ? (BigDecimal)method.invoke(null, exprToken2.floatConstant, exprToken3.intConstant) : (BigDecimal)method.invoke(null, exprToken2.floatConstant, exprToken3.floatConstant));
                } else {
                    exprToken5.intConstant = (BigInteger)method.invoke(null, exprToken2.intConstant, exprToken3.intConstant);
                }
            }
            catch (Exception exception3) {
                exception = exception3;
            }
            if (exception != null) {
                this.owner.putError("Call exception" + this.evalDump(linkedList, exprToken, method, exprToken2, exprToken3, exception));
                return null;
            }
            this.exprStack.push(exprToken5);
        }
        if (this.exprStack.size() == 1) {
            exprToken2 = this.exprStack.peek();
            if (bl && !INT_VALUE.contains((Object)exprToken2.type)) {
                this.owner.putError("Result for REPL must be of type ABSOLUTE or DISPLACEMENT" + this.evalDump(null, null, null, null, null, null));
                return null;
            }
            if (exprToken4 != null) {
                if (exprToken2.type != TokenType.EXTERNAL_ZERO && !INT_VALUE.contains((Object)exprToken2.type)) {
                    this.owner.putError("Expression starting with external symbol must resolve to ABSOLUTE or DISPLACEMENT" + this.evalDump(null, null, null, null, null, null));
                    return null;
                }
                exprToken4.intConstant = exprToken2.intConstant;
                return exprToken4;
            }
            if (exprToken2.type != TokenType.OFFSET) {
                return exprToken2;
            }
            if (exprToken2.offsetRecordList.size() > 1) {
                this.owner.putError("Multiple OFFSET components in final result" + this.evalDump(null, null, null, null, null, null));
                return null;
            }
            return exprToken2;
        }
        this.owner.putError("Operator missing - value stack contains more than one value" + this.evalDump(linkedList, exprToken, method, exprToken2, exprToken3, exception));
        return null;
    }

    protected void dumpTokenList(String string, LinkedList<ExprToken> linkedList) {
        String string2 = "\n" + string + "\n";
        for (ExprToken exprToken : linkedList) {
            string2 = string2 + this.formatToken(exprToken, "  ");
        }
        System.err.println(string2);
    }

    protected void dump(String string) {
        this.owner.logMsg(string + this.evalDump(null, null, null, null, null, null));
    }

    private String evalDump(LinkedList<ExprToken> linkedList, ExprToken exprToken, Method method, ExprToken exprToken2, ExprToken exprToken3, Exception exception) {
        Object object = "";
        if (exprToken != null) {
            object = (String)object + "\n--Operator Token" + this.formatToken(exprToken, "  ");
        }
        if (exprToken2 != null) {
            object = (String)object + "\n--First Operand Token" + this.formatToken(exprToken2, "  ");
        }
        if (exprToken3 != null) {
            object = (String)object + "\n--Second Operand Token" + this.formatToken(exprToken3, "  ");
        }
        object = (String)object + "\n--Original Postfix Expression Content";
        for (ExprToken exprToken4 : this.exprList) {
            object = (String)object + this.formatToken(exprToken4, "  ");
        }
        object = (String)object + "\n--Value Stack Content";
        for (ExprToken exprToken4 : this.exprStack) {
            object = (String)object + this.formatToken(exprToken4, "  ");
        }
        if (linkedList != null) {
            object = (String)object + "\n--Unprocessed Postfix Expression Content";
            for (ExprToken exprToken4 : linkedList) {
                object = (String)object + this.formatToken(exprToken4, "  ");
            }
        }
        if (exception != null) {
            object = (String)object + "\n--Operator Exception\n";
            Object object2 = exception.getMessage();
            if (object2 != null) {
                while (((String)object2).length() > 0) {
                    int n = ((String)object2).indexOf("\n");
                    if (n < 0) {
                        object = (String)object + "  " + (String)object2 + "\n";
                        object2 = "";
                        continue;
                    }
                    object = (String)object + "  " + ((String)object2).substring(0, n + 1);
                    object2 = ((String)object2).substring(n + 1);
                }
            }
        }
        if (method != null) {
            object = (String)object + String.format("--Operator Method Name [%s]", method.getName());
        }
        return (String)object + "\n";
    }

    private String formatToken(ExprToken exprToken, String string) {
        String string2 = "\n" + string;
        string2 = exprToken.parseToken == null ? string2 + "------- Generated Token --------  " : string2 + String.format("Line [%12s] Column [%4d]  ", this.owner.lines[exprToken.parseToken.beginLine - 1].lineNo, exprToken.parseToken.beginColumn);
        string2 = string2 + String.format("Token Type [%-12s]  ", exprToken.type.name());
        switch (exprToken.type) {
            case OPERATOR: {
                string2 = string2 + String.format("Operator Type [%-12s]", exprToken.operType.name());
                break;
            }
            case OFFSET: 
            case DISPLACEMENT: 
            case ABSOLUTE: 
            case EXTERNAL_ZERO: {
                string2 = string2 + String.format("Value [%s]", exprToken.intConstant.toString());
                if (exprToken.type == TokenType.ABSOLUTE) break;
                if (exprToken.type == TokenType.DISPLACEMENT) {
                    if (exprToken.baseRegisterValue != null) {
                        string2 = string2 + String.format("  Base Register Value [%s]", exprToken.baseRegisterValue.toString());
                        break;
                    }
                    string2 = string2 + "  Base Regster Value [*** None ***]";
                    break;
                }
                if (exprToken.offsetRecordList == null) break;
                string2 = string2 + "\n" + string + "--Offset records for Token";
                for (OffsetRecord offsetRecord : exprToken.offsetRecordList) {
                    string2 = string2 + "\n" + string + String.format("  Section [%s]  Sign Add[%d]", offsetRecord.section.owner.symbol.name, offsetRecord.signAdd);
                }
                break;
            }
            case FLOAT: {
                string2 = string2 + String.format("Value [%s]  ", exprToken.floatConstant.toString());
                break;
            }
            case STRING: {
                string2 = string2 + String.format("Value [%s]", exprToken.stringConstant);
                break;
            }
            case SYMBOL: {
                string2 = string2 + String.format("Component [%s]  Symbol [%s]", exprToken.symbolComponent == null ? "NULL" : exprToken.symbolComponent.name(), exprToken.symbol.name);
                break;
            }
            case BASE_SYMBOL: {
                string2 = string2 + String.format("ID@Symbol [%s]", exprToken.parseToken.image);
                break;
            }
            case BASE_DISPLACEMENT: {
                string2 = string2 + String.format("BaseID [%s]  Base Register [%s]  Base Displacement [%s]  Base Section [%s]", exprToken.baseID != null ? exprToken.baseID : "N/A", exprToken.baseRegisterValue, exprToken.intConstant.toString(16), exprToken.baseSection.getName());
            }
            case EXTERNAL_VALUE: 
            case EXTERNAL_SIZE: {
                string2 = string2 + "Symbol[@qualifier]  [" + exprToken.parseToken.image + "]";
            }
        }
        return string2;
    }

    protected ExprToken mergeOffsetRecord(ExprToken exprToken, ExprToken exprToken2, OperType operType) {
        ExprToken exprToken3 = exprToken.clone();
        block0: for (OffsetRecord offsetRecord : exprToken2.offsetRecordList) {
            for (OffsetRecord offsetRecord2 : exprToken3.offsetRecordList) {
                if (offsetRecord.section != offsetRecord2.section) continue;
                offsetRecord2.signAdd = offsetRecord2.signAdd + (operType == OperType.PLUS ? 1 : -1) * offsetRecord.signAdd;
                if (offsetRecord2.signAdd != 0) continue block0;
                exprToken3.offsetRecordList.remove(offsetRecord2);
                continue block0;
            }
            exprToken3.offsetRecordList.add(new OffsetRecord(offsetRecord.section, (operType == OperType.PLUS ? 1 : -1) * offsetRecord.signAdd));
        }
        if (exprToken3.offsetRecordList.size() == 0) {
            return new ExprToken(TokenType.DISPLACEMENT);
        }
        return exprToken3;
    }

    private static BigInteger bIUPLUS(BigInteger bigInteger) {
        return bigInteger;
    }

    private static BigInteger bIUMINUS(BigInteger bigInteger) {
        return bigInteger.negate();
    }

    private static BigInteger bIBNOT(BigInteger bigInteger) {
        return bigInteger.not();
    }

    private static BigInteger bILNOT(BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) == 0 ? BigInteger.ZERO : BigInteger.ONE;
    }

    private static BigInteger bIBIPOWER(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.pow(bigInteger2.intValue());
    }

    private static BigInteger bIBIMULTIPLY(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.multiply(bigInteger2);
    }

    private static BigInteger bIBIDIVIDE(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.divide(bigInteger2);
    }

    private static BigInteger bIBIREMINDER(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.mod(bigInteger2);
    }

    private static BigInteger bIBIPLUS(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.add(bigInteger2);
    }

    private static BigInteger bIBIMINUS(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.subtract(bigInteger2);
    }

    private static BigInteger bIBISHIFTLEFT(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.shiftLeft(bigInteger2.intValue());
    }

    private static BigInteger bIBISHIFTRIGHT(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.shiftRight(bigInteger2.intValue());
    }

    private static BigInteger bIBIGT(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.compareTo(bigInteger2) > 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bIBILT(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.compareTo(bigInteger2) < 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bIBIGE(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.compareTo(bigInteger2) >= 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bIBILE(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.compareTo(bigInteger2) <= 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bIBIEQ(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.compareTo(bigInteger2) == 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bIBINE(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.compareTo(bigInteger2) != 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bIBIBAND(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.and(bigInteger2);
    }

    private static BigInteger bIBIBXOR(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.xor(bigInteger2);
    }

    private static BigInteger bIBIBOR(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.or(bigInteger2);
    }

    private static BigInteger bIBILAND(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.compareTo(BigInteger.ZERO) != 0 && bigInteger2.compareTo(BigInteger.ZERO) != 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bIBILOR(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.compareTo(BigInteger.ZERO) != 0 || bigInteger2.compareTo(BigInteger.ZERO) != 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bIBIMAX(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.max(bigInteger2);
    }

    private static BigInteger bIBIALIGN(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.add(bigInteger2.subtract(BigInteger.ONE)).divide(bigInteger2).multiply(bigInteger2);
    }

    private static BigDecimal bIBDMULTIPLY(BigInteger bigInteger, BigDecimal bigDecimal) {
        return new BigDecimal(bigInteger, floatMC).multiply(bigDecimal, floatMC);
    }

    private static BigDecimal bIBDDIVIDE(BigInteger bigInteger, BigDecimal bigDecimal) {
        return new BigDecimal(bigInteger, floatMC).divide(bigDecimal, floatMC);
    }

    private static BigDecimal bIBDPLUS(BigInteger bigInteger, BigDecimal bigDecimal) {
        return new BigDecimal(bigInteger, floatMC).add(bigDecimal, floatMC);
    }

    private static BigDecimal bIBDMINUS(BigInteger bigInteger, BigDecimal bigDecimal) {
        return new BigDecimal(bigInteger, floatMC).subtract(bigDecimal, floatMC);
    }

    private static BigInteger bIBDGT(BigInteger bigInteger, BigDecimal bigDecimal) {
        return new BigDecimal(bigInteger, floatMC).compareTo(bigDecimal) > 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bIBDLT(BigInteger bigInteger, BigDecimal bigDecimal) {
        return new BigDecimal(bigInteger, floatMC).compareTo(bigDecimal) < 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bIBDGE(BigInteger bigInteger, BigDecimal bigDecimal) {
        return new BigDecimal(bigInteger, floatMC).compareTo(bigDecimal) >= 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bIBDLE(BigInteger bigInteger, BigDecimal bigDecimal) {
        return new BigDecimal(bigInteger, floatMC).compareTo(bigDecimal) <= 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bIBDEQ(BigInteger bigInteger, BigDecimal bigDecimal) {
        return new BigDecimal(bigInteger, floatMC).compareTo(bigDecimal) == 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bIBDNE(BigInteger bigInteger, BigDecimal bigDecimal) {
        return new BigDecimal(bigInteger, floatMC).compareTo(bigDecimal) != 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigDecimal bDUPLUS(BigDecimal bigDecimal) {
        return bigDecimal;
    }

    private static BigDecimal bDUMINUS(BigDecimal bigDecimal) {
        return bigDecimal.negate(floatMC);
    }

    private static BigDecimal bDBDMULTIPLY(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.multiply(bigDecimal2, floatMC);
    }

    private static BigDecimal bDBDDIVIDE(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.divide(bigDecimal2, floatMC);
    }

    private static BigDecimal bDBDPLUS(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.add(bigDecimal2, floatMC);
    }

    private static BigDecimal bDBDMINUS(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.subtract(bigDecimal2, floatMC);
    }

    private static BigInteger bDBDGT(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.compareTo(bigDecimal2) > 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bDBDLT(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.compareTo(bigDecimal2) < 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bDBDGE(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.compareTo(bigDecimal2) >= 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bDBDLE(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.compareTo(bigDecimal2) <= 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bDBDEQ(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.compareTo(bigDecimal2) == 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bDBDNE(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.compareTo(bigDecimal2) != 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigDecimal bDBIPOWER(BigDecimal bigDecimal, BigInteger bigInteger) {
        return bigDecimal.pow(bigInteger.intValue(), floatMC);
    }

    private static BigDecimal bDBIMULTIPLY(BigDecimal bigDecimal, BigInteger bigInteger) {
        return bigDecimal.multiply(new BigDecimal(bigInteger, floatMC), floatMC);
    }

    private static BigDecimal bDBIDIVIDE(BigDecimal bigDecimal, BigInteger bigInteger) {
        return bigDecimal.divide(new BigDecimal(bigInteger, floatMC), floatMC);
    }

    private static BigDecimal bDBIPLUS(BigDecimal bigDecimal, BigInteger bigInteger) {
        return bigDecimal.add(new BigDecimal(bigInteger, floatMC), floatMC);
    }

    private static BigDecimal bDBIMINUS(BigDecimal bigDecimal, BigInteger bigInteger) {
        return bigDecimal.subtract(new BigDecimal(bigInteger, floatMC), floatMC);
    }

    private static BigInteger bDBIGT(BigDecimal bigDecimal, BigInteger bigInteger) {
        return bigDecimal.compareTo(new BigDecimal(bigInteger)) > 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bDBILT(BigDecimal bigDecimal, BigInteger bigInteger) {
        return bigDecimal.compareTo(new BigDecimal(bigInteger)) < 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bDBIGE(BigDecimal bigDecimal, BigInteger bigInteger) {
        return bigDecimal.compareTo(new BigDecimal(bigInteger)) >= 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bDBILE(BigDecimal bigDecimal, BigInteger bigInteger) {
        return bigDecimal.compareTo(new BigDecimal(bigInteger)) <= 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bDBIEQ(BigDecimal bigDecimal, BigInteger bigInteger) {
        return bigDecimal.compareTo(new BigDecimal(bigInteger)) == 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    private static BigInteger bDBINE(BigDecimal bigDecimal, BigInteger bigInteger) {
        return bigDecimal.compareTo(new BigDecimal(bigInteger)) != 0 ? BigInteger.ONE : BigInteger.ZERO;
    }

    static {
        Method[] methodArray = null;
        Method[] methodArray2 = null;
        Method[] methodArray3 = null;
        Method[] methodArray4 = null;
        Method[] methodArray5 = null;
        Method[] methodArray6 = null;
        try {
            methodArray = new Method[]{null, DVExpression.class.getDeclaredMethod("bIUPLUS", BigInteger.class), DVExpression.class.getDeclaredMethod("bIUMINUS", BigInteger.class), DVExpression.class.getDeclaredMethod("bIBNOT", BigInteger.class), DVExpression.class.getDeclaredMethod("bILNOT", BigInteger.class), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
            methodArray2 = new Method[]{null, null, null, null, null, DVExpression.class.getDeclaredMethod("bIBIPOWER", BigInteger.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bIBIMULTIPLY", BigInteger.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bIBIDIVIDE", BigInteger.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bIBIREMINDER", BigInteger.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bIBIPLUS", BigInteger.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bIBIMINUS", BigInteger.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bIBISHIFTLEFT", BigInteger.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bIBISHIFTRIGHT", BigInteger.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bIBIGT", BigInteger.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bIBILT", BigInteger.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bIBIGE", BigInteger.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bIBILE", BigInteger.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bIBIEQ", BigInteger.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bIBINE", BigInteger.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bIBIBAND", BigInteger.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bIBIBXOR", BigInteger.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bIBIBOR", BigInteger.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bIBILAND", BigInteger.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bIBILOR", BigInteger.class, BigInteger.class), null, DVExpression.class.getDeclaredMethod("bIBIALIGN", BigInteger.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bIBIMAX", BigInteger.class, BigInteger.class)};
            methodArray3 = new Method[]{null, null, null, null, null, null, DVExpression.class.getDeclaredMethod("bIBDMULTIPLY", BigInteger.class, BigDecimal.class), DVExpression.class.getDeclaredMethod("bIBDDIVIDE", BigInteger.class, BigDecimal.class), null, DVExpression.class.getDeclaredMethod("bIBDPLUS", BigInteger.class, BigDecimal.class), DVExpression.class.getDeclaredMethod("bIBDMINUS", BigInteger.class, BigDecimal.class), null, null, DVExpression.class.getDeclaredMethod("bIBDGT", BigInteger.class, BigDecimal.class), DVExpression.class.getDeclaredMethod("bIBDLT", BigInteger.class, BigDecimal.class), DVExpression.class.getDeclaredMethod("bIBDGE", BigInteger.class, BigDecimal.class), DVExpression.class.getDeclaredMethod("bIBDLE", BigInteger.class, BigDecimal.class), DVExpression.class.getDeclaredMethod("bIBDEQ", BigInteger.class, BigDecimal.class), DVExpression.class.getDeclaredMethod("bIBDNE", BigInteger.class, BigDecimal.class), null, null, null, null, null, null, null, null};
            methodArray4 = new Method[]{null, DVExpression.class.getDeclaredMethod("bDUPLUS", BigDecimal.class), DVExpression.class.getDeclaredMethod("bDUMINUS", BigDecimal.class), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
            methodArray5 = new Method[]{null, null, null, null, null, null, DVExpression.class.getDeclaredMethod("bDBDMULTIPLY", BigDecimal.class, BigDecimal.class), DVExpression.class.getDeclaredMethod("bDBDDIVIDE", BigDecimal.class, BigDecimal.class), null, DVExpression.class.getDeclaredMethod("bDBDPLUS", BigDecimal.class, BigDecimal.class), DVExpression.class.getDeclaredMethod("bDBDMINUS", BigDecimal.class, BigDecimal.class), null, null, DVExpression.class.getDeclaredMethod("bDBDGT", BigDecimal.class, BigDecimal.class), DVExpression.class.getDeclaredMethod("bDBDLT", BigDecimal.class, BigDecimal.class), DVExpression.class.getDeclaredMethod("bDBDGE", BigDecimal.class, BigDecimal.class), DVExpression.class.getDeclaredMethod("bDBDLE", BigDecimal.class, BigDecimal.class), DVExpression.class.getDeclaredMethod("bDBDEQ", BigDecimal.class, BigDecimal.class), DVExpression.class.getDeclaredMethod("bDBDNE", BigDecimal.class, BigDecimal.class), null, null, null, null, null, null, null, null};
            methodArray6 = new Method[]{null, null, null, null, null, DVExpression.class.getDeclaredMethod("bDBIPOWER", BigDecimal.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bDBIMULTIPLY", BigDecimal.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bDBIDIVIDE", BigDecimal.class, BigInteger.class), null, DVExpression.class.getDeclaredMethod("bDBIPLUS", BigDecimal.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bDBIMINUS", BigDecimal.class, BigInteger.class), null, null, DVExpression.class.getDeclaredMethod("bDBIGT", BigDecimal.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bDBILT", BigDecimal.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bDBIGE", BigDecimal.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bDBILE", BigDecimal.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bDBIEQ", BigDecimal.class, BigInteger.class), DVExpression.class.getDeclaredMethod("bDBINE", BigDecimal.class, BigInteger.class), null, null, null, null, null, null, null, null};
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("Expression Class initialization failed due to exception\n" + DVUtil.formatException("Initialization Exception: ", noSuchMethodException) + "\n");
            throw new RuntimeException(noSuchMethodException);
        }
        bIOper = methodArray;
        bIBIOper = methodArray2;
        bIBDOper = methodArray3;
        bDOper = methodArray4;
        bDBDOper = methodArray5;
        bDBIOper = methodArray6;
    }

    protected static enum OperType {
        RPAREN,
        UPLUS,
        UMINUS,
        BNOT,
        LNOT,
        POWER,
        MULTIPLY,
        DIVIDE,
        REMINDER,
        PLUS,
        MINUS,
        SHIFTLEFT,
        SHIFTRIGHT,
        GT,
        LT,
        GE,
        LE,
        EQ,
        NE,
        BAND,
        BXOR,
        BOR,
        LAND,
        LOR,
        LPAREN,
        ALIGN,
        MAX;

    }

    public static enum TokenType {
        OPERATOR,
        OFFSET,
        DISPLACEMENT,
        ABSOLUTE,
        FLOAT,
        STRING,
        SYMBOL,
        BASE_SYMBOL,
        BASE_DISPLACEMENT,
        EXTERNAL_SIZE,
        EXTERNAL_VALUE,
        EXTERNAL_ZERO;

    }

    class OffsetRecord {
        protected DVSections.Section section;
        protected int signAdd;

        protected OffsetRecord(DVSections.Section section, int n) {
            this.section = section;
            this.signAdd = n;
        }
    }

    public class ExprToken
    implements Cloneable {
        protected final TokenType type;
        protected final Token parseToken;
        protected BigInteger intConstant = null;
        protected BigDecimal floatConstant = null;
        protected String stringConstant = null;
        protected DVSymbols.Symbol symbol = null;
        protected DVSymbols.SymbolComponent symbolComponent;
        protected ArrayList<OffsetRecord> offsetRecordList = null;
        protected String qualifier;
        protected String baseID = null;
        protected DVSections.Section baseSection;
        protected BigInteger baseRegisterValue = null;
        protected OperType operType;
        protected int operPriority;
        protected boolean operLeftAssociation;

        protected ExprToken(TokenType tokenType, Token token) {
            this.type = tokenType;
            this.parseToken = token;
        }

        protected ExprToken(TokenType tokenType) {
            this.type = tokenType;
            this.parseToken = null;
        }

        protected ExprToken(OperType operType) {
            this.type = TokenType.OPERATOR;
            this.parseToken = null;
            this.operType = operType;
        }

        protected ExprToken(DVSymbols.Symbol symbol, DVSymbols.SymbolComponent symbolComponent) {
            this.type = TokenType.SYMBOL;
            this.parseToken = null;
            this.symbol = symbol;
            this.symbolComponent = symbolComponent;
        }

        protected ExprToken clone() {
            ExprToken exprToken = new ExprToken(this.type, this.parseToken);
            exprToken.intConstant = this.intConstant;
            exprToken.floatConstant = this.floatConstant;
            exprToken.stringConstant = this.stringConstant;
            exprToken.symbol = this.symbol;
            exprToken.symbolComponent = this.symbolComponent;
            if (this.offsetRecordList != null) {
                exprToken.offsetRecordList = new ArrayList();
                for (OffsetRecord offsetRecord : this.offsetRecordList) {
                    exprToken.offsetRecordList.add(new OffsetRecord(offsetRecord.section, offsetRecord.signAdd));
                }
            }
            exprToken.qualifier = this.qualifier;
            exprToken.baseID = this.baseID;
            exprToken.baseSection = this.baseSection;
            exprToken.baseRegisterValue = this.baseRegisterValue;
            exprToken.operType = this.operType;
            exprToken.operPriority = this.operPriority;
            exprToken.operLeftAssociation = this.operLeftAssociation;
            return exprToken;
        }

        protected void switchOffsetRecordSign() {
            for (OffsetRecord offsetRecord : this.offsetRecordList) {
                offsetRecord.signAdd = -offsetRecord.signAdd;
            }
        }

        protected String getValue() {
            if (this.type == TokenType.STRING) {
                return "\"" + DVUtil.escapeString(this.stringConstant) + "\"";
            }
            if (this.type == TokenType.FLOAT) {
                return this.floatConstant.toString();
            }
            if (INT_VALUE.contains((Object)this.type) || this.type == TokenType.OFFSET) {
                return this.intConstant.toString();
            }
            return "Invalid type: " + this.type.name();
        }

        public TokenType getType() {
            return this.type;
        }

        public BigInteger getIntConstant() {
            return this.intConstant;
        }

        public BigDecimal getFloatConstant() {
            return this.floatConstant;
        }

        public String getStringConstant() {
            return this.stringConstant;
        }

        public DVSymbols.Symbol getSymbol() {
            return this.symbol;
        }

        public DVSymbols.SymbolComponent getSymbolComponent() {
            return this.symbolComponent;
        }

        public String getQualifier() {
            return this.qualifier;
        }

        public DVSections.Section getOffsetSection() {
            return this.offsetRecordList.get((int)0).section;
        }

        public String getBaseID() {
            return this.baseID;
        }

        public DVSections.Section getBaseSection() {
            return this.baseSection;
        }

        public BigInteger getBaseRegisterValue() {
            return this.baseRegisterValue;
        }
    }
}

