/*
 * Decompiled with CFR 0.152.
 */
package framework;

import framework.DVAbi;
import framework.DVCode;
import framework.DVExpression;
import framework.DVOpCodeParm;
import framework.DVOpCodeProcessor;
import framework.DVOpCodes;
import framework.DVSections;
import framework.DVStatements;
import framework.DVSymbols;
import framework.DVUtil;
import framework.Token;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.HashMap;

public class DVFrameworkOpCodes
extends DVOpCodes {
    private String hexCodeHeader = "--- Architecture/Abi no found ---";
    private final HashMap<String, DVOpCodeProcessor> processOpCode = new HashMap(32);
    private final BigDecimal BD_2 = new BigDecimal(2);
    private static final MathContext precision = new MathContext(18);

    protected DVFrameworkOpCodes() {
        this.processOpCode.put("ASSERT", new OC_ASSERT());
        this.processOpCode.put("BASECLEAR", new OC_BASECLEAR());
        this.processOpCode.put("BASEDROP", new OC_BASEDROP());
        this.processOpCode.put("BASESET", new OC_BASESET());
        this.processOpCode.put("BIGENDIAN", new OC_BIGENDIAN());
        this.processOpCode.put("PCRES", new OC_PCRES());
        this.processOpCode.put("PCSET", new OC_PCSET());
        this.processOpCode.put("COMMON", new OC_COMMON());
        this.processOpCode.put("DEFENDIAN", new OC_DEFENDIAN());
        this.processOpCode.put("END", new OC_END());
        this.processOpCode.put("EQU", new OC_EQU());
        this.processOpCode.put("EXPORT", new OC_EXPORT());
        this.processOpCode.put("EXTERNAL", new OC_EXTERNAL());
        this.processOpCode.put("LITTLEENDIAN", new OC_LITTLEENDIAN());
        this.processOpCode.put("MMAP", new OC_MMAP());
        this.processOpCode.put("SECTION", new OC_SECTION());
        this.processOpCode.put("SETENV", new OC_SETENV());
        this.processOpCode.put("SETFILE", new OC_SETFILE());
        this.processOpCode.put("TRACEON", new OC_TRACEON());
        OC_BYTE_1 oC_BYTE_1 = new OC_BYTE_1();
        this.processOpCode.put("BYTE_1", oC_BYTE_1);
        this.processOpCode.put("WRD_1", oC_BYTE_1);
        this.processOpCode.put("BYTE", oC_BYTE_1);
        this.processOpCode.put("UTF_8", new OC_UTF_8());
        this.processOpCode.put("BYTE_2", new OC_BYTE_2());
        oC_BYTE_1 = new OC_WRD_2();
        this.processOpCode.put("WRD_2", oC_BYTE_1);
        this.processOpCode.put("HWRD", oC_BYTE_1);
        this.processOpCode.put("UTF_16", new OC_UTF_16());
        this.processOpCode.put("BYTE_4", new OC_BYTE_4());
        oC_BYTE_1 = new OC_WRD_4();
        this.processOpCode.put("WRD_4", oC_BYTE_1);
        this.processOpCode.put("FWRD", oC_BYTE_1);
        this.processOpCode.put("UTF_32", new OC_UTF_32());
        this.processOpCode.put("BYTE_8", new OC_BYTE_8());
        oC_BYTE_1 = new OC_WRD_8();
        this.processOpCode.put("WRD_8", oC_BYTE_1);
        this.processOpCode.put("DWRD", oC_BYTE_1);
        this.processOpCode.put("BYTE_16", new OC_BYTE_16());
        oC_BYTE_1 = new OC_WRD_16();
        this.processOpCode.put("WRD_16", oC_BYTE_1);
        this.processOpCode.put("QWRD", oC_BYTE_1);
        this.processOpCode.put("BYTE_32", new OC_BYTE_32());
        this.processOpCode.put("WRD_32", new OC_WRD_32());
        this.processOpCode.put("BYTE_64", new OC_BYTE_64());
        this.processOpCode.put("WRD_64", new OC_WRD_64());
        this.processOpCode.put("BYTE_128", new OC_BYTE_128());
        this.processOpCode.put("WRD_128", new OC_WRD_128());
        this.processOpCode.put("BYTE_256", new OC_BYTE_256());
        this.processOpCode.put("WRD_256", new OC_WRD_256());
        this.processOpCode.put("BYTE_512", new OC_BYTE_512());
        this.processOpCode.put("WRD_512", new OC_WRD_512());
        this.processOpCode.put("BYTE_1K", new OC_BYTE_1K());
        this.processOpCode.put("WRD_1K", new OC_WRD_1K());
        this.processOpCode.put("BYTE_2K", new OC_BYTE_2K());
        this.processOpCode.put("WRD_2K", new OC_WRD_2K());
        this.processOpCode.put("BYTE_4K", new OC_BYTE_4K());
        this.processOpCode.put("WRD_4K", new OC_WRD_4K());
        this.processOpCode.put("BYTE_8K", new OC_BYTE_8K());
        this.processOpCode.put("WRD_8K", new OC_WRD_8K());
        this.processOpCode.put("BYTE_16K", new OC_BYTE_16K());
        this.processOpCode.put("WRD_16K", new OC_WRD_16K());
        this.processOpCode.put("BYTE_32K", new OC_BYTE_32K());
        this.processOpCode.put("WRD_32K", new OC_WRD_32K());
        this.processOpCode.put("BYTE_64K", new OC_BYTE_64K());
        this.processOpCode.put("WRD_64K", new OC_WRD_64K());
    }

    @Override
    public DVOpCodeProcessor getOpCodeProcessor(DVStatements.Statement statement, Token token) {
        return this.processOpCode.get(token.image.toUpperCase());
    }

    @Override
    public boolean verifyArchitecture(DVStatements.Statement statement, String string) {
        return true;
    }

    @Override
    public boolean verifyExtension(DVStatements.Statement statement, String string) {
        return false;
    }

    @Override
    public String getExtension() {
        return null;
    }

    @Override
    public DVAbi getAbi() {
        return null;
    }

    @Override
    public String getHexCodeHeader() {
        return this.hexCodeHeader;
    }

    @Override
    public int getHexCodeLength() {
        return this.hexCodeHeader.length();
    }

    @Override
    public void postProcess() {
    }

    protected void putHexCodeHeader(String string) {
        this.hexCodeHeader = string;
    }

    private String formatCode(byte[] byArray) {
        int n;
        Object object = DVUtil.convertCodeToHexPlain(byArray, Math.min(byArray.length, this.hexCodeHeader.length()));
        for (n = 0; n < ((String)object).length() - 8; n += 9) {
            object = ((String)object).substring(0, n + 8) + " " + ((String)object).substring(n + 8);
        }
        for (n = 0; n < ((String)object).length() - 8; n += 9) {
            object = ((String)object).substring(0, n + 8) + " " + ((String)object).substring(n + 8);
        }
        if (((String)object).length() > this.hexCodeHeader.length()) {
            return ((String)object).substring(0, this.hexCodeHeader.length());
        }
        for (n = ((String)object).length(); n < this.hexCodeHeader.length(); ++n) {
            object = (String)object + " ";
        }
        return object;
    }

    public class OC_UTF_32
    extends DVOpCodeProcessor {
        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            int n;
            Object object;
            int n2;
            DVOpCodeParm dVOpCodeParm = statement.getOpCodeParm();
            if (statement.endianness == DVUtil.Endianness.UNDEFINED) {
                return statement.putErrorNoCode("Default ENDIANNESS not defined", new Object[0]);
            }
            DVExpression.ExprToken exprToken = dVOpCodeParm.getPositionalParameterValue(0);
            if (exprToken.type != DVExpression.TokenType.STRING) {
                return statement.putErrorNoCode("Positional parameter 1 resolve to type [%s] - Type STRING is required", exprToken.operType.name());
            }
            int n3 = exprToken.stringConstant.codePointCount(0, exprToken.stringConstant.length());
            boolean bl = DVUtil.getBooleanKeyWordValue(statement, 0, "BOM", 0L) == 1L;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(256);
            if (bl) {
                arrayList.add(65279);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = exprToken.stringConstant.codePointAt(n2);
                if (n4 > 65535) {
                    ++n2;
                }
                arrayList.add(n4);
            }
            n2 = 0;
            byte[] byArray = new byte[arrayList.size() * 4];
            byte[] byArray2 = new byte[arrayList.size() * 4];
            for (int i = 0; i < byArray.length >> 2; ++i) {
                if (statement.endianness == DVUtil.Endianness.LITTLE) {
                    DVUtil.addIntegerToCode(byArray2, n2, (Integer)arrayList.get(i), DVUtil.Endianness.LITTLE);
                }
                n2 = DVUtil.addIntegerToCode(byArray, n2, (Integer)arrayList.get(i), DVUtil.Endianness.BIG);
            }
            Object object2 = String.format("Unicode UTF-32 SRTING, length [%d]\nString -> \"" + DVUtil.escapeString(exprToken.stringConstant) + "\"\n", byArray.length >> 2);
            object2 = (String)object2 + (bl ? "Byte Order Mark (BOM) is required\n" : "Byter Order Mark (BOM) is not required\n");
            if (statement.endianness == DVUtil.Endianness.LITTLE) {
                object = DVUtil.convertCodeToHexPlain(byArray2, byArray2.length * 2);
                for (n = 0; n < ((String)object).length() - 8; n += 9) {
                    object = ((String)object).substring(0, n + 8) + " " + ((String)object).substring(n + 8);
                }
                object2 = (String)object2 + "Code [LITTLE ENDIAN] -> " + (String)object + "\n";
            }
            object = DVUtil.convertCodeToHexPlain(byArray, byArray.length * 2);
            for (n = 0; n < ((String)object).length() - 8; n += 9) {
                object = ((String)object).substring(0, n + 8) + " " + ((String)object).substring(n + 8);
            }
            object2 = (String)object2 + "Code [BIG    ENDIAN] -> " + (String)object + "\n";
            return new DVCode(byArray, DVFrameworkOpCodes.this.formatCode(byArray), (String)object2);
        }

        @Override
        public BigInteger getAlign() {
            return BI_4;
        }

        @Override
        public BigInteger getLength() {
            return BI_4;
        }

        @Override
        public BigInteger getRepl() {
            return BigInteger.ONE;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{1, 1};
        }

        @Override
        public boolean[] getPosParmDefault() {
            return new boolean[]{false};
        }

        @Override
        public int[][] getSubParmMinMax() {
            return new int[][]{{0, 0}};
        }

        @Override
        public String[] getKeyWordList() {
            return new String[]{"BOM"};
        }
    }

    public class OC_UTF_16
    extends DVOpCodeProcessor {
        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            int n;
            Object object;
            DVOpCodeParm dVOpCodeParm = statement.getOpCodeParm();
            if (statement.endianness == DVUtil.Endianness.UNDEFINED) {
                return statement.putErrorNoCode("Default ENDIANNESS not defined", new Object[0]);
            }
            DVExpression.ExprToken exprToken = dVOpCodeParm.getPositionalParameterValue(0);
            if (exprToken.type != DVExpression.TokenType.STRING) {
                return statement.putErrorNoCode("Positional parameter 1 resolve to type [%s] - Type STRING is required", exprToken.operType.name());
            }
            int n2 = exprToken.stringConstant.codePointCount(0, exprToken.stringConstant.length());
            boolean bl = DVUtil.getBooleanKeyWordValue(statement, 0, "BOM", 0L) == 1L;
            int n3 = bl ? 2 : 0;
            byte[] byArray = new byte[n3 + exprToken.stringConstant.length() * 2];
            byte[] byArray2 = new byte[n3 + exprToken.stringConstant.length() * 2];
            if (bl) {
                byArray[0] = -2;
                byArray[1] = -1;
                byArray2[0] = -1;
                byArray2[1] = -2;
            }
            for (int i = 0; i < exprToken.stringConstant.length(); ++i) {
                if (statement.endianness == DVUtil.Endianness.LITTLE) {
                    DVUtil.addHalfIntegerToCode(byArray2, n3, exprToken.stringConstant.charAt(i), DVUtil.Endianness.LITTLE);
                }
                n3 = DVUtil.addHalfIntegerToCode(byArray, n3, exprToken.stringConstant.charAt(i), DVUtil.Endianness.BIG);
            }
            Object object2 = String.format("Unicode UTF-16 SRTING, length [%d]\nString -> \"" + DVUtil.escapeString(exprToken.stringConstant) + "\"\n", byArray.length >> 1);
            object2 = (String)object2 + (bl ? "Byte Order Mark (BOM) is required\n" : "Byter Order Mark (BOM) is not required\n");
            if (statement.endianness == DVUtil.Endianness.LITTLE) {
                object = DVUtil.convertCodeToHexPlain(byArray2, byArray2.length * 2);
                for (n = 0; n < ((String)object).length() - 8; n += 9) {
                    object = ((String)object).substring(0, n + 8) + " " + ((String)object).substring(n + 8);
                }
                object2 = (String)object2 + "Code [LITTLE ENDIAN] -> " + (String)object + "\n";
            }
            object = DVUtil.convertCodeToHexPlain(byArray, byArray.length * 2);
            for (n = 0; n < ((String)object).length() - 8; n += 9) {
                object = ((String)object).substring(0, n + 8) + " " + ((String)object).substring(n + 8);
            }
            object2 = (String)object2 + "Code [BIG    ENDIAN] -> " + (String)object + "\n";
            return new DVCode(byArray, DVFrameworkOpCodes.this.formatCode(byArray), (String)object2);
        }

        @Override
        public BigInteger getAlign() {
            return BI_2;
        }

        @Override
        public BigInteger getLength() {
            return BI_2;
        }

        @Override
        public BigInteger getRepl() {
            return BigInteger.ONE;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{1, 1};
        }

        @Override
        public boolean[] getPosParmDefault() {
            return new boolean[]{false};
        }

        @Override
        public int[][] getSubParmMinMax() {
            return new int[][]{{0, 0}};
        }

        @Override
        public String[] getKeyWordList() {
            return new String[]{"BOM"};
        }
    }

    public class OC_UTF_8
    extends DVOpCodeProcessor {
        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            int n;
            DVOpCodeParm dVOpCodeParm = statement.getOpCodeParm();
            if (statement.endianness == DVUtil.Endianness.UNDEFINED) {
                return statement.putErrorNoCode("Default ENDIANNESS not defined", new Object[0]);
            }
            DVExpression.ExprToken exprToken = dVOpCodeParm.getPositionalParameterValue(0);
            if (exprToken.type != DVExpression.TokenType.STRING) {
                return statement.putErrorNoCode("Positional parameter 1 resolve to type [%s] - Type STRING is required", exprToken.operType.name());
            }
            int n2 = exprToken.stringConstant.codePointCount(0, exprToken.stringConstant.length());
            boolean bl = DVUtil.getBooleanKeyWordValue(statement, 0, "BOM", 0L) == 1L;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(256);
            int n3 = 1;
            for (n = 0; n < n2; ++n) {
                int n4 = exprToken.stringConstant.codePointAt(n);
                if (n4 <= 127) {
                    arrayList.add(n4);
                    continue;
                }
                if (n4 < 2047) {
                    arrayList.add((n4 & 0x37) + 128);
                    arrayList.add((n4 >> 6) + 192);
                    n3 = Math.max(n3, 2);
                    continue;
                }
                if (n4 <= 65535) {
                    arrayList.add((n4 & 0x3F) + 128);
                    arrayList.add((n4 >> 6 & 0x3F) + 128);
                    arrayList.add((n4 >> 12) + 224);
                    n3 = Math.max(n3, 3);
                    continue;
                }
                ++n;
                arrayList.add((n4 & 0x3F) + 128);
                arrayList.add((n4 >> 6 & 0x3F) + 128);
                arrayList.add((n4 >> 12 & 0x3F) + 128);
                arrayList.add((n4 >> 18) + 240);
                n3 = Math.max(n3, 4);
            }
            n = bl ? 3 : 0;
            byte[] byArray = new byte[n + arrayList.size()];
            if (bl) {
                byArray[0] = -17;
                byArray[1] = -69;
                byArray[2] = -65;
            }
            for (int i = 0; i < byArray.length - n; ++i) {
                byArray[n + i] = ((Integer)arrayList.get(i)).byteValue();
            }
            Object object = DVUtil.convertCodeToHexPlain(byArray, byArray.length * 2);
            for (int i = 0; i < ((String)object).length() - 8; i += 9) {
                object = ((String)object).substring(0, i + 8) + " " + ((String)object).substring(i + 8);
            }
            String string = String.format("Unicode UTF-8 STRING, length [%d]\nString -> %s\n" + (bl ? "Byte Order Mark (BOM) is required\n" : "Byte Order Mark (BOM) is not required\n") + "Code   -> " + (String)object + "\nMaximum Unicode Code Point length used for encoding is [%d] -> " + (n3 == 1 ? "All characters are ASCII\n" : "Some characters are non-ASCII\n"), byArray.length, "\"" + DVUtil.escapeString(exprToken.stringConstant) + "\"", n3);
            return new DVCode(byArray, DVFrameworkOpCodes.this.formatCode(byArray), string);
        }

        @Override
        public BigInteger getLength() {
            return BigInteger.ONE;
        }

        @Override
        public BigInteger getRepl() {
            return BigInteger.ONE;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{1, 1};
        }

        @Override
        public boolean[] getPosParmDefault() {
            return new boolean[]{false};
        }

        @Override
        public int[][] getSubParmMinMax() {
            return new int[][]{{0, 0}};
        }

        @Override
        public String[] getKeyWordList() {
            return new String[]{"BOM"};
        }
    }

    public class OC_WRD_64K
    extends OC_BYTE_64K {
        @Override
        public BigInteger getAlign() {
            return BI_64K;
        }
    }

    public class OC_BYTE_64K
    extends OC_BYTE_1 {
        @Override
        public BigInteger getLength() {
            return BI_64K;
        }
    }

    public class OC_WRD_32K
    extends OC_BYTE_32K {
        @Override
        public BigInteger getAlign() {
            return BI_32K;
        }
    }

    public class OC_BYTE_32K
    extends OC_BYTE_1 {
        @Override
        public BigInteger getLength() {
            return BI_32K;
        }
    }

    public class OC_WRD_16K
    extends OC_BYTE_16K {
        @Override
        public BigInteger getAlign() {
            return BI_16K;
        }
    }

    public class OC_BYTE_16K
    extends OC_BYTE_1 {
        @Override
        public BigInteger getLength() {
            return BI_16K;
        }
    }

    public class OC_WRD_8K
    extends OC_BYTE_8K {
        @Override
        public BigInteger getAlign() {
            return BI_8K;
        }
    }

    public class OC_BYTE_8K
    extends OC_BYTE_1 {
        @Override
        public BigInteger getLength() {
            return BI_8K;
        }
    }

    public class OC_WRD_4K
    extends OC_BYTE_4K {
        @Override
        public BigInteger getAlign() {
            return BI_4K;
        }
    }

    public class OC_BYTE_4K
    extends OC_BYTE_1 {
        @Override
        public BigInteger getLength() {
            return BI_4K;
        }
    }

    public class OC_WRD_2K
    extends OC_BYTE_2K {
        @Override
        public BigInteger getAlign() {
            return BI_2K;
        }
    }

    public class OC_BYTE_2K
    extends OC_BYTE_1 {
        @Override
        public BigInteger getLength() {
            return BI_2K;
        }
    }

    public class OC_WRD_1K
    extends OC_BYTE_1K {
        @Override
        public BigInteger getAlign() {
            return BI_1K;
        }
    }

    public class OC_BYTE_1K
    extends OC_BYTE_1 {
        @Override
        public BigInteger getLength() {
            return BI_1K;
        }
    }

    public class OC_WRD_512
    extends OC_BYTE_512 {
        @Override
        public BigInteger getAlign() {
            return BI_512;
        }
    }

    public class OC_BYTE_512
    extends OC_BYTE_1 {
        @Override
        public BigInteger getLength() {
            return BI_512;
        }
    }

    public class OC_WRD_256
    extends OC_BYTE_256 {
        @Override
        public BigInteger getAlign() {
            return BI_256;
        }
    }

    public class OC_BYTE_256
    extends OC_BYTE_1 {
        @Override
        public BigInteger getLength() {
            return BI_256;
        }
    }

    public class OC_WRD_128
    extends OC_BYTE_128 {
        @Override
        public BigInteger getAlign() {
            return BI_128;
        }
    }

    public class OC_BYTE_128
    extends OC_BYTE_1 {
        @Override
        public BigInteger getLength() {
            return BI_128;
        }
    }

    public class OC_WRD_64
    extends OC_BYTE_64 {
        @Override
        public BigInteger getAlign() {
            return BI_64;
        }
    }

    public class OC_BYTE_64
    extends OC_BYTE_1 {
        @Override
        public BigInteger getLength() {
            return BI_64;
        }
    }

    public class OC_WRD_32
    extends OC_BYTE_32 {
        @Override
        public BigInteger getAlign() {
            return BI_32;
        }
    }

    public class OC_BYTE_32
    extends OC_BYTE_1 {
        @Override
        public BigInteger getLength() {
            return BI_32;
        }

        @Override
        public int getExponentLength() {
            return 19;
        }
    }

    public class OC_WRD_16
    extends OC_BYTE_16 {
        @Override
        public BigInteger getAlign() {
            return BI_16;
        }
    }

    public class OC_BYTE_16
    extends OC_BYTE_1 {
        @Override
        public BigInteger getLength() {
            return BI_16;
        }

        @Override
        public int getExponentLength() {
            return 15;
        }
    }

    public class OC_WRD_8
    extends OC_BYTE_8 {
        @Override
        public BigInteger getAlign() {
            return BI_8;
        }
    }

    public class OC_BYTE_8
    extends OC_BYTE_1 {
        @Override
        public BigInteger getLength() {
            return BI_8;
        }

        @Override
        public int getExponentLength() {
            return 11;
        }
    }

    public class OC_WRD_4
    extends OC_BYTE_4 {
        @Override
        public BigInteger getAlign() {
            return BI_4;
        }
    }

    public class OC_BYTE_4
    extends OC_BYTE_1 {
        @Override
        public BigInteger getLength() {
            return BI_4;
        }

        @Override
        public int getExponentLength() {
            return 8;
        }
    }

    public class OC_WRD_2
    extends OC_BYTE_2 {
        @Override
        public BigInteger getAlign() {
            return BI_2;
        }
    }

    public class OC_BYTE_2
    extends OC_BYTE_1 {
        @Override
        public BigInteger getLength() {
            return BI_2;
        }

        @Override
        public int getExponentLength() {
            return 5;
        }
    }

    public class OC_BYTE_1
    extends DVOpCodeProcessor {
        private static final int guardLength = 12;

        @Override
        public DVExpression getReplExpression(DVOpCodeParm dVOpCodeParm, DVStatements.Statement statement) {
            DVOpCodeParm.PositionalParm[] positionalParmArray;
            DVExpression dVExpression = new DVExpression(statement);
            for (DVOpCodeParm.PositionalParm positionalParm : positionalParmArray = statement.getOpCodeParm().getPositionalParmList()) {
                DVExpression dVExpression2;
                DVOpCodeParm.SubParm[] subParmArray = positionalParm.getSubParmList();
                if (subParmArray.length == 0 || (dVExpression2 = subParmArray[0].getSubParm()) == null) {
                    dVExpression.addExpression(DVExpression.getConstantExpression(BigInteger.ONE, statement));
                    continue;
                }
                dVExpression.addExpression(dVExpression2);
            }
            if (dVExpression.isEmpty()) {
                dVExpression.addExpression(DVExpression.getConstantExpression(BigInteger.ONE, statement));
            }
            return dVExpression;
        }

        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            DVOpCodeParm dVOpCodeParm = statement.getOpCodeParm();
            int n = this.getAlign().intValue();
            int n2 = this.getLength().intValue();
            if (statement.endianness == DVUtil.Endianness.UNDEFINED) {
                return statement.putErrorNoCode("Default ENDIANNESS not defined", new Object[0]);
            }
            int n3 = statement.symbol.resultRepl.intConstant.intValue();
            byte[] byArray = new byte[n3 * n2];
            int n4 = 0;
            byte[] byArray2 = null;
            int n5 = statement.symbol.resultValue.intConstant.intValue();
            Object object = "";
            int n6 = dVOpCodeParm.getPositionalParmListSize();
            for (int i = 0; i < n6; ++i) {
                DVOpCodeParm.SubParm[] subParmArray;
                DVExpression.ExprToken exprToken = dVOpCodeParm.getPositionalParameterValue(i);
                if (exprToken == null) {
                    exprToken = DVExpression.getConstantExprToken(BigInteger.ZERO, statement);
                }
                if ((subParmArray = dVOpCodeParm.getSubParmList(i)).length == 0) {
                    n3 = 1;
                }
                switch (exprToken.type) {
                    case FLOAT: {
                        if (n2 < 2 || n2 > 32) {
                            return statement.putErrorNoCode("FLOAT constant allowed only for DATA OpCodes of length between 2 and 32", new Object[0]);
                        }
                        int n7 = 0;
                        BigDecimal bigDecimal = exprToken.floatConstant;
                        int n8 = bigDecimal.compareTo(BigDecimal.ZERO);
                        int n9 = this.getExponentLength();
                        if (bigDecimal.equals(BigDecimal.ZERO)) {
                            byArray2 = new byte[n2];
                            break;
                        }
                        BigInteger bigInteger = BigInteger.ZERO;
                        if (n8 < 0) {
                            bigDecimal = bigDecimal.negate(DVExpression.floatMC);
                            bigInteger = BigInteger.ONE.shiftLeft(n2 * 8 - 1);
                        }
                        n7 += (1 << n9 - 1) - 1;
                        while (bigDecimal.compareTo(BigDecimal.ONE) == -1) {
                            bigDecimal = bigDecimal.multiply(DVFrameworkOpCodes.this.BD_2, DVExpression.floatMC);
                            --n7;
                        }
                        while (bigDecimal.compareTo(DVFrameworkOpCodes.this.BD_2) >= 0) {
                            bigDecimal = bigDecimal.divide(DVFrameworkOpCodes.this.BD_2, DVExpression.floatMC);
                            ++n7;
                        }
                        int n10 = n2 * 8 - n9;
                        int n11 = n10 + 12;
                        BigInteger bigInteger2 = bigDecimal.multiply(DVFrameworkOpCodes.this.BD_2.pow(n11), DVExpression.floatMC).toBigInteger();
                        BigDecimal bigDecimal2 = bigDecimal.multiply(DVFrameworkOpCodes.this.BD_2.pow(n11), DVExpression.floatMC);
                        n11 = bigInteger2.bitLength() - n10;
                        if (bigInteger2.testBit(n11 - 1)) {
                            if ((bigInteger2 = bigInteger2.shiftRight(n11).add(BigInteger.ONE)).bitLength() > n10) {
                                bigInteger2.shiftRight(1);
                                ++n7;
                            }
                        } else {
                            bigInteger2 = bigInteger2.shiftRight(n11);
                        }
                        if (n7 <= 0) {
                            if (bigInteger2.testBit(-n7) && (bigInteger2 = bigInteger2.shiftRight(-n7).add(BigInteger.ONE)).bitLength() > n10) {
                                bigInteger2.shiftRight(1);
                                ++n7;
                            }
                            bigInteger = bigInteger.or(bigInteger2.shiftRight(-n7 + 1));
                        } else if (n7 > (1 << n9) - 2) {
                            bigInteger = bigInteger.or(BigInteger.valueOf((1 << n9) - 1).shiftLeft(n10 - 1));
                        } else {
                            bigInteger2 = bigInteger2.clearBit(n10 - 1);
                            bigInteger = bigInteger.or(bigInteger2).or(BigInteger.valueOf(n7).shiftLeft(n10 - 1));
                        }
                        byArray2 = bigInteger.toByteArray();
                        object = (String)object + String.format("FLOAT, alignment [%d], length [%d], replication [%d], endianness %s\n", n, n2, n3, statement.endianness.name());
                        object = (String)object + String.format(" Code [%6s ENDIAN] -> %s\n", statement.endianness.name(), DVUtil.convertCodeToHex(byArray2, n2, statement.endianness == DVUtil.Endianness.BIG));
                        if (statement.endianness == DVUtil.Endianness.LITTLE) {
                            object = (String)object + String.format(" Code [BIG    ENDIAN] -> %s\n", DVUtil.convertCodeToHex(byArray2, n2, true));
                        }
                        object = (String)object + String.format(" Code [DECIMAL      ] -> %s\n", exprToken.floatConstant.round(precision).toString());
                        break;
                    }
                    case ABSOLUTE: 
                    case DISPLACEMENT: {
                        byArray2 = exprToken.intConstant.toByteArray();
                        if (!DVUtil.verifyOverflow(byArray2, n2)) {
                            return statement.putErrorNoCode("Data overflow", new Object[0]);
                        }
                        object = (String)object + String.format("%s, alignment [%d], length [%d], replication [%d], endianness %s\n", exprToken.type.name(), n, n2, n3, statement.endianness.name());
                        object = (String)object + String.format(" Code [%6s ENDIAN] -> %s\n", statement.endianness.name(), DVUtil.convertCodeToHex(byArray2, n2, statement.endianness == DVUtil.Endianness.BIG));
                        if (statement.endianness == DVUtil.Endianness.LITTLE && n2 > 1) {
                            object = (String)object + String.format(" Code [BIG    ENDIAN] -> %s\n", DVUtil.convertCodeToHex(byArray2, n2, true));
                        }
                        object = (String)object + String.format(" Code [DECIMAL      ] -> %s\n", exprToken.intConstant.toString());
                        break;
                    }
                    case OFFSET: 
                    case EXTERNAL_SIZE: 
                    case EXTERNAL_VALUE: {
                        if (n3 != 1) {
                            return statement.putErrorNoCode("Relocatable data can only have a replication value of one", new Object[0]);
                        }
                        if (n2 < 4 || n2 > 8) {
                            return statement.putErrorNoCode("Relocatable value accepted only for 4 and 8 byte length fields", new Object[0]);
                        }
                        DVAbi.RelocationID[] relocationIDArray = exprToken.type == DVExpression.TokenType.EXTERNAL_SIZE ? statement.statements.abi.getRelocationID(statement, "SIZE", "WORD_" + Integer.toString(n2 * 8)) : statement.statements.abi.getRelocationID(statement, exprToken.qualifier == null ? "ABS" : exprToken.qualifier.toUpperCase(), "WORD_" + Integer.toString(n2 * 8));
                        if (relocationIDArray == null) {
                            return null;
                        }
                        byArray2 = new byte[n2];
                        Object object2 = "";
                        for (int j = 0; j < relocationIDArray.length; ++j) {
                            statement.addRelocation(exprToken.symbol, exprToken.intConstant, relocationIDArray[j]);
                            object2 = (String)object2 + " : " + relocationIDArray[j].nameID;
                        }
                        object2 = ((String)object2).substring(3);
                        object = (String)object + String.format("%s, align [%d], length [%d], replication [%d],  endianness %s\n", exprToken.type.name(), n, n2, n3, statement.endianness.name());
                        object = (String)object + String.format(" Code   [%6s ENDIAN] -> %s\n", statement.endianness.name(), DVUtil.convertCodeToHex(byArray2, n2, statement.endianness == DVUtil.Endianness.BIG));
                        if (statement.endianness == DVUtil.Endianness.LITTLE) {
                            object = (String)object + String.format(" Code   [BIG    ENDIAN] -> %s\n", DVUtil.convertCodeToHex(byArray2, n2, true));
                        }
                        object = (String)object + String.format(" Code   [DECIMAL      ] -> 0\n", new Object[0]);
                        if (exprToken.type == DVExpression.TokenType.OFFSET) {
                            object = (String)object + String.format(" Relocation ID type %s, Add-End 0x%s, for LOCAL symbol [%s]\n", object2, DVUtil.formatHex(exprToken.intConstant, 8), exprToken.symbol.name);
                            break;
                        }
                        String string = exprToken.symbol.externalName;
                        if (string == null) {
                            string = exprToken.symbol.name;
                        }
                        object = (String)object + String.format(" Relocation ID type %s, Add-End 0x%s, for EXTERNAL symbol [%s] - external name [%s]\n", object2, DVUtil.formatHex(exprToken.intConstant, 8), exprToken.symbol.name, string);
                        break;
                    }
                    default: {
                        return statement.putErrorNoCode(String.format("Positional paramter %d resolves to %s and is not allowed for DATA OpCode", i + 1, exprToken.type.name()), new Object[0]);
                    }
                }
                n4 = DVUtil.addCode(byArray, n4, byArray2, n2, n3, statement.endianness);
            }
            return new DVCode(byArray, DVFrameworkOpCodes.this.formatCode(byArray), (String)object);
        }

        @Override
        public BigInteger getLength() {
            return BigInteger.ONE;
        }

        @Override
        public BigInteger getRepl() {
            return null;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{1, 256};
        }

        @Override
        public boolean[] getPosParmDefault() {
            return new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
        }

        @Override
        public int[][] getSubParmMinMax() {
            return new int[][]{{0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}};
        }

        public int getExponentLength() {
            return 0;
        }
    }

    public class OC_TRACEON
    extends DVOpCodeProcessor {
        @Override
        public boolean preProcessOpCode(DVStatements.Statement statement) {
            statement.statements.setLogTrace(true);
            return true;
        }

        @Override
        public boolean getNeedSection() {
            return false;
        }

        @Override
        public boolean getNoLabel() {
            return true;
        }
    }

    public class OC_SETFILE
    extends DVOpCodeProcessor {
        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            if (statement.statements.setFile) {
                return statement.putErrorNoCode("Duplicate SETFILE opCode found - statement ignored", new Object[0]);
            }
            statement.statements.setFile = true;
            return null;
        }

        @Override
        public boolean getNeedSection() {
            return false;
        }

        @Override
        public boolean getNoLabel() {
            return true;
        }
    }

    public class OC_SETENV
    extends DVOpCodeProcessor {
        @Override
        public boolean preProcessOpCode(DVStatements.Statement statement) {
            DVOpCodeParm dVOpCodeParm = statement.getOpCodeParm();
            boolean bl = true;
            DVExpression.ExprToken exprToken = dVOpCodeParm.getPositionalFirstTokenIfSingle(0);
            DVExpression.ExprToken exprToken2 = dVOpCodeParm.getPositionalFirstTokenIfSingle(1);
            DVExpression.ExprToken exprToken3 = dVOpCodeParm.getPositionalFirstTokenIfSingle(2);
            DVExpression.ExprToken exprToken4 = dVOpCodeParm.getPositionalFirstTokenIfSingle(3);
            String string = "";
            String string2 = "";
            if (exprToken.type != DVExpression.TokenType.STRING) {
                bl = statement.putErrorFalse("Environment architecture must be a single STRING with no operators", new Object[0]);
            }
            if (exprToken2 != null) {
                if (exprToken2.type != DVExpression.TokenType.STRING) {
                    bl = statement.putErrorFalse("Abi options must be a single STRING with no operators", new Object[0]);
                }
                string = exprToken2.stringConstant;
            }
            if (exprToken3.type != DVExpression.TokenType.STRING) {
                bl = statement.putErrorFalse("Environment abi must be a single STRING with no operators", new Object[0]);
            }
            if (exprToken4 != null) {
                if (exprToken4.type != DVExpression.TokenType.STRING) {
                    bl = statement.putErrorFalse("Environment os must be a single STRING with no operators", new Object[0]);
                }
                string2 = exprToken4.stringConstant;
            }
            if (bl) {
                statement.setEnv(exprToken.stringConstant, string, exprToken3.stringConstant, string2);
            }
            return bl;
        }

        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            return new DVCode(null, null, statement.statements.abi.getDetails());
        }

        @Override
        public boolean getNeedSection() {
            return false;
        }

        @Override
        public boolean getNoLabel() {
            return true;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{2, 4};
        }

        @Override
        public boolean[] getPosParmDefault() {
            return new boolean[]{false, false, true, true};
        }
    }

    public class OC_SECTION
    extends DVOpCodeProcessor {
        @Override
        public boolean preProcessOpCode(DVStatements.Statement statement) {
            statement.getSections().setExpressionLength();
            statement.getOpCodeParm().setPrivateObject(statement.getSections().startSection(statement, statement.symbol.token, DVSections.SectionType.SECTION));
            return true;
        }

        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            String string;
            BigInteger bigInteger;
            DVOpCodeParm dVOpCodeParm = statement.getOpCodeParm();
            if (statement.statements.abi == null) {
                statement.putErrorNoCode("Abi not previously specified or invalid", new Object[0]);
            }
            DVExpression.ExprToken exprToken = dVOpCodeParm.getPositionalParameterValue(0);
            DVExpression.ExprToken exprToken2 = dVOpCodeParm.getPositionalParameterValue(1);
            DVExpression.ExprToken exprToken3 = dVOpCodeParm.getPositionalParameterValue(2);
            DVExpression.ExprToken exprToken4 = dVOpCodeParm.getPositionalParameterValue(3);
            if (exprToken.type != DVExpression.TokenType.ABSOLUTE) {
                return statement.putErrorNoCode("Section type must resolve to type ABSOLUTE", new Object[0]);
            }
            BigInteger bigInteger2 = exprToken.intConstant;
            if (exprToken2.type != DVExpression.TokenType.ABSOLUTE) {
                return statement.putErrorNoCode("Section attribute must resolve to type ABSOLUTE", new Object[0]);
            }
            BigInteger bigInteger3 = exprToken2.intConstant;
            if (exprToken3 == null) {
                bigInteger = BigInteger.ONE;
            } else {
                if (exprToken3.type != DVExpression.TokenType.ABSOLUTE) {
                    return statement.putErrorNoCode("Section alignment must resolves to type ABSOLUTE", new Object[0]);
                }
                bigInteger = exprToken3.intConstant;
                if (bigInteger.compareTo(BigInteger.ZERO) < 0 || bigInteger.bitCount() > 1 || bigInteger.compareTo(BigInteger.valueOf(65536L)) > 0) {
                    return statement.putErrorNoCode("Align value [" + bigInteger.toString() + "] must be zero or non-negative power of 2", new Object[0]);
                }
            }
            if (exprToken4 == null) {
                string = null;
            } else {
                if (exprToken4.type != DVExpression.TokenType.STRING) {
                    return statement.putErrorNoCode("Exported symbol external name must resolve to type STRING", new Object[0]);
                }
                string = exprToken4.stringConstant;
            }
            if (string.startsWith(".rel")) {
                return statement.putErrorNoCode("Section external names starting with <.rel> are reserved and cannot be used", new Object[0]);
            }
            ((DVSections.Section)dVOpCodeParm.getPrivateObject()).setAttributes(bigInteger2, bigInteger3, bigInteger, string);
            return null;
        }

        @Override
        public boolean getNeedSection() {
            return false;
        }

        @Override
        public boolean getNeedLabel() {
            return true;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{2, 4};
        }

        @Override
        public boolean[] getPosParmDefault() {
            return new boolean[]{false, false, true, true};
        }
    }

    public class OC_MMAP
    extends DVOpCodeProcessor {
        @Override
        public boolean preProcessOpCode(DVStatements.Statement statement) {
            statement.getSections().setExpressionLength();
            statement.getSections().startSection(statement, statement.symbol.token, DVSections.SectionType.MMAP);
            return true;
        }

        @Override
        public boolean getNeedSection() {
            return false;
        }

        @Override
        public boolean getNeedLabel() {
            return true;
        }
    }

    public class OC_LITTLEENDIAN
    extends DVOpCodeProcessor {
        @Override
        public boolean preProcessOpCode(DVStatements.Statement statement) {
            statement.setLittleEndianness();
            return true;
        }

        @Override
        public boolean getNeedSection() {
            return false;
        }

        @Override
        public boolean getNoLabel() {
            return true;
        }
    }

    public class OC_BIGENDIAN
    extends DVOpCodeProcessor {
        @Override
        public boolean preProcessOpCode(DVStatements.Statement statement) {
            statement.setBigEndianness();
            return true;
        }

        @Override
        public boolean getNeedSection() {
            return false;
        }

        @Override
        public boolean getNoLabel() {
            return true;
        }
    }

    public class OC_DEFENDIAN
    extends DVOpCodeProcessor {
        @Override
        public boolean preProcessOpCode(DVStatements.Statement statement) {
            if (statement.endianness == DVUtil.Endianness.UNDEFINED) {
                return statement.putErrorFalse("Default ENDIANNESS not defined", new Object[0]);
            }
            statement.statements.currentEndianness = statement.statements.defaultEndianness;
            return true;
        }

        @Override
        public boolean getNeedSection() {
            return false;
        }

        @Override
        public boolean getNoLabel() {
            return true;
        }
    }

    public class OC_EXTERNAL
    extends DVOpCodeProcessor {
        @Override
        public boolean preProcessOpCode(DVStatements.Statement statement) {
            DVExpression.ExprToken exprToken = statement.getOpCodeParm().getPositionalFirstTokenIfSingle(0);
            if (exprToken == null || exprToken.type != DVExpression.TokenType.SYMBOL) {
                return statement.putErrorFalse("First parameter must be a single symbol with no operators", new Object[0]);
            }
            exprToken.symbol.markSymbolExternal(statement);
            return true;
        }

        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            String string;
            BigInteger bigInteger;
            DVOpCodeParm dVOpCodeParm = statement.getOpCodeParm();
            DVExpression.ExprToken exprToken = dVOpCodeParm.getPositionalFirstTokenIfSingle(0);
            DVExpression.ExprToken exprToken2 = dVOpCodeParm.getPositionalParameterValue(1);
            DVExpression.ExprToken exprToken3 = dVOpCodeParm.getPositionalParameterValue(2);
            DVSymbols.Symbol symbol = exprToken.symbol;
            if (exprToken2 == null) {
                bigInteger = DVUtil.symbolBindGlobal;
            } else {
                if (exprToken2.type != DVExpression.TokenType.ABSOLUTE) {
                    return statement.putErrorNoCode("External symbol bind must resolve to type ABSOLUTE", new Object[0]);
                }
                bigInteger = exprToken2.intConstant;
            }
            if (exprToken3 == null) {
                string = dVOpCodeParm.getPositionalFirstTokenIfSingle((int)0).parseToken.image;
            } else {
                if (exprToken3.type != DVExpression.TokenType.STRING) {
                    return statement.putErrorNoCode("External symbol external name must resolve to type STRING", new Object[0]);
                }
                string = exprToken3.stringConstant;
            }
            symbol.setSymbolExternal(bigInteger, string);
            return null;
        }

        @Override
        public boolean getNeedSection() {
            return false;
        }

        @Override
        public boolean getNoLabel() {
            return true;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{1, 3};
        }

        @Override
        public boolean[] getPosParmDefault() {
            return new boolean[]{false, true, true};
        }
    }

    public class OC_EXPORT
    extends DVOpCodeProcessor {
        @Override
        public boolean preProcessOpCode(DVStatements.Statement statement) {
            DVExpression.ExprToken exprToken = statement.getOpCodeParm().getPositionalFirstTokenIfSingle(0);
            if (exprToken == null || exprToken.type != DVExpression.TokenType.SYMBOL) {
                return statement.putErrorFalse("First parameter must be a single symbol with no operators", new Object[0]);
            }
            exprToken.symbol.markSymbolExported(statement);
            return true;
        }

        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            String string;
            BigInteger bigInteger;
            BigInteger bigInteger2;
            BigInteger bigInteger3;
            DVOpCodeParm dVOpCodeParm = statement.getOpCodeParm();
            DVSymbols.Symbol symbol = dVOpCodeParm.getPositionalFirstTokenIfSingle((int)0).symbol;
            DVExpression.ExprToken exprToken = dVOpCodeParm.getPositionalParameterValue(1);
            DVExpression.ExprToken exprToken2 = dVOpCodeParm.getPositionalParameterValue(2);
            DVExpression.ExprToken exprToken3 = dVOpCodeParm.getPositionalParameterValue(3);
            DVExpression.ExprToken exprToken4 = dVOpCodeParm.getPositionalParameterValue(4);
            if (exprToken == null) {
                bigInteger3 = BigInteger.ONE;
            } else {
                if (exprToken.type != DVExpression.TokenType.ABSOLUTE) {
                    return statement.putErrorNoCode("Exported symbol type must resolve to type ABSOLUTE", new Object[0]);
                }
                bigInteger3 = exprToken.intConstant;
            }
            if (exprToken2 == null) {
                bigInteger2 = DVUtil.symbolBindGlobal;
            } else {
                if (exprToken2.type != DVExpression.TokenType.ABSOLUTE) {
                    return statement.putErrorNoCode("Exported symbol bind must resolves to type ABSOLUTE", new Object[0]);
                }
                bigInteger2 = exprToken2.intConstant;
            }
            if (exprToken3 == null) {
                bigInteger = BigInteger.ZERO;
            } else {
                if (!DVExpression.INT_VALUE.contains((Object)exprToken3.type)) {
                    return statement.putErrorNoCode("Exported symbol size must resolves to an ABSOLUTE or DISPLACEMENT", new Object[0]);
                }
                bigInteger = exprToken3.intConstant;
                if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
                    return statement.putErrorNoCode("Exported symbol size resolves to a negative value", new Object[0]);
                }
            }
            if (exprToken4 == null) {
                string = dVOpCodeParm.getPositionalFirstTokenIfSingle((int)0).parseToken.image;
            } else {
                if (exprToken4.type != DVExpression.TokenType.STRING) {
                    return statement.putErrorNoCode("Exported symbol external name must resolve to type STRING", new Object[0]);
                }
                string = exprToken4.stringConstant;
            }
            symbol.exportSymbol(statement, bigInteger3, bigInteger2, bigInteger, string);
            return null;
        }

        @Override
        public boolean getNeedSection() {
            return false;
        }

        @Override
        public boolean getNoLabel() {
            return true;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{1, 5};
        }

        @Override
        public boolean[] getPosParmDefault() {
            return new boolean[]{false, true, true, true, true};
        }
    }

    public class OC_EQU
    extends DVOpCodeProcessor {
        @Override
        public DVExpression getValueExpression(DVStatements.Statement statement) {
            DVExpression dVExpression = statement.getOpCodeParm().getPositionalParm(0).getParameter();
            if (dVExpression != null && dVExpression.getFirstExprToken().qualifier != null) {
                statement.putError("Relocatable expression not allowed for opCode [EQU]");
                return null;
            }
            return dVExpression;
        }

        @Override
        public boolean getValueInParm() {
            return true;
        }

        @Override
        public boolean getNeedSection() {
            return false;
        }

        @Override
        public boolean getNeedLabel() {
            return true;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{1, 1};
        }
    }

    public class OC_END
    extends DVOpCodeProcessor {
        @Override
        public boolean preProcessOpCode(DVStatements.Statement statement) {
            statement.getSections().setExpressionLength();
            statement.statements.endOpCode = true;
            return true;
        }

        @Override
        public boolean getNoLabel() {
            return true;
        }
    }

    public class OC_COMMON
    extends DVOpCodeProcessor {
        @Override
        public boolean preProcessOpCode(DVStatements.Statement statement) {
            DVOpCodeParm dVOpCodeParm = statement.getOpCodeParm();
            DVExpression.ExprToken exprToken = statement.getOpCodeParm().getPositionalFirstTokenIfSingle(0);
            if (exprToken == null || exprToken.getType() != DVExpression.TokenType.SYMBOL) {
                return statement.putErrorFalse("First parameter must be a single symbol with no operators", new Object[0]);
            }
            exprToken.symbol.markSymbolCommon(statement);
            return true;
        }

        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            String string;
            BigInteger bigInteger;
            BigInteger bigInteger2;
            DVOpCodeParm dVOpCodeParm = statement.getOpCodeParm();
            DVSymbols.Symbol symbol = dVOpCodeParm.getPositionalFirstTokenIfSingle(0).getSymbol();
            DVExpression.ExprToken exprToken = dVOpCodeParm.getPositionalParameterValue(1);
            DVExpression.ExprToken exprToken2 = dVOpCodeParm.getPositionalParameterValue(2);
            DVExpression.ExprToken exprToken3 = dVOpCodeParm.getPositionalParameterValue(3);
            if (exprToken == null) {
                bigInteger2 = BigInteger.ONE;
            } else {
                if (exprToken.type != DVExpression.TokenType.ABSOLUTE) {
                    return statement.putErrorNoCode("Common alignment must resolves to type ABSOLUTE", new Object[0]);
                }
                bigInteger2 = exprToken.intConstant;
                if (bigInteger2.compareTo(BigInteger.ZERO) < 0 || bigInteger2.bitCount() > 1 || bigInteger2.compareTo(BigInteger.valueOf(65536L)) > 0) {
                    return statement.putErrorNoCode("Align value [" + bigInteger2.toString() + "] must be zero or non-negative power of 2", new Object[0]);
                }
            }
            if (exprToken2 == null) {
                bigInteger = BigInteger.ZERO;
            } else {
                if (!DVExpression.INT_VALUE.contains((Object)exprToken2.type)) {
                    return statement.putErrorNoCode("Common size must resolve to an ABSOLUTE or DISPLACEMENT", new Object[0]);
                }
                bigInteger = exprToken2.intConstant;
                if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
                    return statement.putErrorNoCode("Size resolves to a negative value", new Object[0]);
                }
            }
            if (exprToken3 == null) {
                string = null;
            } else {
                if (exprToken3.type != DVExpression.TokenType.STRING) {
                    return statement.putErrorNoCode("Common external name must resolve to type STRING", new Object[0]);
                }
                string = exprToken3.stringConstant;
            }
            symbol.setSymbolCommon(bigInteger, bigInteger2, string);
            return null;
        }

        @Override
        public boolean getNeedSection() {
            return false;
        }

        @Override
        public boolean getNoLabel() {
            return true;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{1, 4};
        }

        @Override
        public boolean[] getPosParmDefault() {
            return new boolean[]{false, true, true, true};
        }
    }

    public class OC_PCSET
    extends DVOpCodeProcessor {
        @Override
        public DVExpression getValueExpression(DVStatements.Statement statement) {
            DVOpCodeParm dVOpCodeParm = statement.getOpCodeParm();
            statement.getSections().setCounter(statement);
            return dVOpCodeParm.getPositionalParm((int)0).parameter;
        }

        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            return new DVCode(null, null, "Program Counter has been set to new offset");
        }

        @Override
        public boolean getValueInParm() {
            return true;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{1, 1};
        }
    }

    public class OC_PCRES
    extends DVOpCodeProcessor {
        @Override
        public DVExpression getValueExpression(DVStatements.Statement statement) {
            return statement.getSections().resetCounter();
        }

        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            return new DVCode(null, null, "Program Counter has been reset to highest possible offset");
        }

        @Override
        public boolean getValueInParm() {
            return true;
        }
    }

    public class OC_BASESET
    extends DVOpCodeProcessor {
        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            DVSections.Section section;
            DVOpCodeParm dVOpCodeParm = statement.getOpCodeParm();
            String string = null;
            DVExpression.ExprToken exprToken = dVOpCodeParm.getPositionalParameterValue(0);
            DVExpression.ExprToken exprToken2 = dVOpCodeParm.getPositionalParameterValue(1);
            if (exprToken.type == DVExpression.TokenType.OFFSET) {
                section = exprToken.getOffsetSection();
            } else if (exprToken.type == DVExpression.TokenType.BASE_DISPLACEMENT) {
                section = exprToken.baseSection;
                string = exprToken.baseID;
            } else {
                return statement.putErrorNoCode("First parameter must resolve to either type OFFSET or type BASE_DISPLACEMENT", new Object[0]);
            }
            BigInteger bigInteger = exprToken.intConstant;
            if (exprToken2 == null) {
                return statement.putErrorNoCode("Parameter No 2 not specified, but default not available", new Object[0]);
            }
            if (exprToken2.type != DVExpression.TokenType.ABSOLUTE) {
                return statement.putErrorNoCode("Second parameter base register must resolve to type ABSOLUTE", new Object[0]);
            }
            if (!statement.statements.abi.verifyBaseRegister(exprToken2.intConstant)) {
                return statement.putErrorNoCode(String.format("Base register [0x%s] is out of bound\n", DVUtil.formatHex(exprToken2.intConstant, 2)), new Object[0]);
            }
            statement.addBase(string, section, bigInteger, exprToken2.intConstant);
            return null;
        }

        @Override
        public boolean getNeedSection() {
            return false;
        }

        @Override
        public boolean getNoLabel() {
            return true;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{2, 2};
        }
    }

    public class OC_BASEDROP
    extends DVOpCodeProcessor {
        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            DVOpCodeParm.PositionalParm[] positionalParmArray = statement.getOpCodeParm().getPositionalParmList();
            for (int i = 0; i < positionalParmArray.length; ++i) {
                DVExpression.ExprToken exprToken = positionalParmArray[i].getParameterValue();
                if (exprToken == null) {
                    return statement.putErrorNoCode(String.format("Parameter No %d not specified, but default not available", i + 1), new Object[0]);
                }
                if (exprToken.type != DVExpression.TokenType.ABSOLUTE) {
                    return statement.putErrorNoCode(String.format("Parameter No %d must resolve to type ABSOLUTE", i + 1), new Object[0]);
                }
                statement.dropBase(exprToken.intConstant);
            }
            return null;
        }

        @Override
        public boolean getNoLabel() {
            return true;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{1, 256};
        }
    }

    public class OC_BASECLEAR
    extends DVOpCodeProcessor {
        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            statement.dropAllBases();
            return null;
        }

        @Override
        public boolean getNoLabel() {
            return true;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{0, 0};
        }
    }

    public class OC_ASSERT
    extends DVOpCodeProcessor {
        @Override
        public DVCode generateCode(DVStatements.Statement statement) {
            DVExpression.ExprToken exprToken = statement.getOpCodeParm().getPositionalParameterValue(0);
            if (!DVExpression.INT_VALUE.contains((Object)exprToken.type)) {
                return statement.putErrorNoCode("Expression for opCode ASSERT must resolve to ABSOLUTE or DISPLACEMENT without base", new Object[0]);
            }
            if (exprToken.intConstant.equals(BigInteger.ZERO)) {
                statement.putError("ASSERT opCode failed");
            }
            return null;
        }

        @Override
        public boolean getNeedSection() {
            return false;
        }

        @Override
        public boolean getNoLabel() {
            return true;
        }

        @Override
        public int[] getPosParmMinMax() {
            return new int[]{1, 1};
        }
    }
}

