/*
 * Decompiled with CFR 0.152.
 */
package framework;

import framework.DVExpression;
import framework.DVInputParserConstants;
import framework.DVInputParserTokenManager;
import framework.DVMacroJSApi;
import framework.DVMacroParm;
import framework.DVMacros;
import framework.DVOpCodeParm;
import framework.DVStatements;
import framework.DVSymbols;
import framework.DVUtil;
import framework.ParseException;
import framework.SimpleCharStream;
import framework.Token;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.script.ScriptException;

public class DVInputParser
implements DVInputParserConstants {
    private DVStatements statements;
    private DVMacroJSApi jSApi;
    private DVMacros macros;
    private DVStatements.Statement currStatement;
    private Token currLabel = null;
    private DVOpCodeParm opCodeParm = null;
    private Token currKey = null;
    private boolean subParmState = false;
    private boolean subParmEnd = false;
    private DVExpression currExpression = null;
    private DVMacros.Macro currMacro = null;
    private int macroPosParmNo;
    private int macroParmListNo;
    private String macroEvalParm;
    LinkedList<Character> macroNestStack = new LinkedList();
    HashMap<String, DVMacroParm> macroKeyParm;
    public DVInputParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[36];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private boolean trace_enabled;

    protected String getState() {
        return DVInputParserTokenManager.lexStateNames[this.token_source.curLexState];
    }

    public final void start(DVStatements dVStatements) throws ParseException {
        this.statements = dVStatements;
        this.currStatement = dVStatements.currStatement;
        this.jSApi = dVStatements.jSApi;
        this.macros = this.jSApi.macros;
        this.token_source.statements = dVStatements;
        this.token_source.jSApi = this.jSApi;
        this.token_source.macros = this.jSApi.macros;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 1: {
                Token token;
                this.currLabel = token = this.jj_consume_token(1);
                block17: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 2: {
                            break;
                        }
                        default: {
                            this.jj_la1[0] = this.jj_gen;
                            break block17;
                        }
                    }
                    this.jj_consume_token(2);
                }
                token = this.jj_consume_token(3);
                this.processMacroOpcode(token);
                break;
            }
            case 0: 
            case 2: 
            case 3: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 2: {
                        block18: while (true) {
                            this.jj_consume_token(2);
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 2: {
                                    continue block18;
                                }
                            }
                            break;
                        }
                        this.jj_la1[1] = this.jj_gen;
                        this.currLabel = null;
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 3: {
                        Token token = this.jj_consume_token(3);
                        this.processMacroOpcode(token);
                        break block0;
                    }
                    case 0: {
                        this.jj_consume_token(0);
                        break block0;
                    }
                }
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void processMacroOpcode(Token token) throws ParseException {
        this.currMacro = this.token_source.currMacro == null || !this.token_source.currMacro.macroName.equals(token.image.toUpperCase()) ? this.macros.get(this.jSApi, token.image) : this.token_source.currMacro;
        if (this.currMacro == null) {
            this.getOpCodeParms(token);
            return;
        }
        this.currMacro.read();
        if (this.currMacro.permError != null) {
            this.throwParseException(this.currMacro.permError, new Object[0]);
        }
        this.currStatement.initializeMacro(this.currLabel, token);
        this.getMacroParms();
        this.macroEvalParm = this.macroEvalParm + ";";
        if (this.currMacro.minPosParmSize > this.macroPosParmNo) {
            this.throwParseException("Number of positional parameters [%d] is too small, [%d] expected", this.macroPosParmNo, this.currMacro.minPosParmSize);
        }
        for (int i = this.macroPosParmNo; i < this.currMacro.posParm.size(); ++i) {
            DVMacroParm dVMacroParm = this.currMacro.posParm.get(i);
            this.macroEvalParm = this.macroEvalParm + "var " + dVMacroParm.name + "=null;";
        }
        for (DVMacroParm dVMacroParm : this.macroKeyParm.values()) {
            if (dVMacroParm.isList && dVMacroParm.defaultValueEmpty && dVMacroParm.minListSize != null) {
                this.throwParseException("Key-word parameter [%s] not defined and default is empty list - minimum list size is [%d]", dVMacroParm.name, dVMacroParm.minListSize);
            }
            this.macroEvalParm = this.macroEvalParm + "var " + dVMacroParm.defaultValue;
        }
        try {
            this.currMacro.execute(this.currStatement, this.jSApi, this.macroEvalParm);
        }
        catch (ScriptException scriptException) {
            this.throwParseException("JavaScript Error while executing macro [%s]\n%s", this.currMacro.macroName, scriptException.getMessage());
        }
    }

    public final void getMacroParms() throws ParseException {
        this.macroEvalParm = "var Label=\"" + (Serializable)(this.currLabel == null ? "" : this.currLabel) + "\"";
        this.macroPosParmNo = 0;
        this.macroKeyParm = (HashMap)this.currMacro.keyParm.clone();
        this.macroNestStack.clear();
        this.getMacroParm();
    }

    public final void getMacroParm() throws ParseException {
        Token token = null;
        DVMacroParm dVMacroParm = null;
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 67: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(67);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 0: {
                this.jj_consume_token(0);
                return;
            }
        }
        this.jj_la1[6] = this.jj_gen;
        this.macroEvalParm = this.macroEvalParm + ";";
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 53: {
                token = this.jj_consume_token(53);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        if (token != null) {
            dVMacroParm = this.macroKeyParm.remove(token.image.substring(0, token.image.length() - 1).toUpperCase());
            if (dVMacroParm == null) {
                this.throwParseException("Invalid or duplicate keyword parameter [%s] encountered at position [%d]", token.image, token.beginColumn);
            }
        } else {
            if (this.macroPosParmNo >= this.currMacro.posParm.size()) {
                if (this.token == null) {
                    this.throwParseException("Extra positional parameter encountered", new Object[0]);
                } else {
                    this.throwParseException("Extra positional parameter encountered at line %s position %d", this.currStatement.lines[this.token.beginLine - 1].lineNo, this.token.beginColumn);
                }
            }
            dVMacroParm = this.currMacro.posParm.get(this.macroPosParmNo);
            ++this.macroPosParmNo;
        }
        this.macroEvalParm = this.macroEvalParm + "var " + dVMacroParm.name + "=";
        if (dVMacroParm.isList) {
            this.macroEvalParm = this.macroEvalParm + "[";
            this.macroParmListNo = 0;
            this.getMacroParmList(dVMacroParm);
        } else if (dVMacroParm.isBool || dVMacroParm.isInt) {
            this.getMacroParmBoolInt(dVMacroParm);
        } else {
            this.getMacroParmString(dVMacroParm);
        }
    }

    public final void getMacroParmList(DVMacroParm dVMacroParm) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 67: {
                this.jj_consume_token(67);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 0: {
                this.jj_consume_token(0);
                if (dVMacroParm.isList) {
                    this.throwParseException("End of statement encountered before completion of list parameter value", new Object[0]);
                }
                return;
            }
        }
        this.jj_la1[9] = this.jj_gen;
        this.jj_consume_token(61);
        if (dVMacroParm.isBool || dVMacroParm.isInt) {
            this.getMacroParmBoolInt(dVMacroParm);
        } else {
            this.macroNestStack.push(Character.valueOf('['));
            this.getMacroParmString(dVMacroParm);
        }
    }

    public final void getMacroParmBoolInt(DVMacroParm dVMacroParm) throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 67: {
                this.jj_consume_token(67);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 54: {
                String string;
                token = this.jj_consume_token(54);
                if (!dVMacroParm.isBool) {
                    this.throwParseException("<MACRO_BOOLEAN> token encountered when <MACRO_INTEGER> expected at line %s column %d", this.currStatement.lines[token.beginLine - 1], token.beginColumn);
                }
                if ((string = token.image.toLowerCase()).equals("yes")) {
                    this.macroEvalParm = this.macroEvalParm + "true";
                    break;
                }
                if (string.equals("no")) {
                    this.macroEvalParm = this.macroEvalParm + "false";
                    break;
                }
                this.macroEvalParm = this.macroEvalParm + string;
                break;
            }
            case 55: {
                token = this.jj_consume_token(55);
                if (!dVMacroParm.isInt) {
                    this.throwParseException("<MACRO_INTEGER> token encountered when <MACRO_BOOLEAN> expected at line %s column %d", this.currStatement.lines[token.beginLine - 1], token.beginColumn);
                }
                this.macroEvalParm = this.macroEvalParm + token.image;
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 67: {
                this.jj_consume_token(67);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 62: {
                token = this.jj_consume_token(62);
                if (dVMacroParm.isList) {
                    this.macroEvalParm = this.macroEvalParm + "]";
                    ++this.macroParmListNo;
                    this.endMacroParmList(dVMacroParm);
                    return;
                }
                this.throwParseException("Invalib character ']' encountered when expecting %s token at line %s column %d", dVMacroParm.isInt ? "<MACRO_INTEGER>" : "<MACRO_BOOLEAN>", this.currStatement.lines[token.beginLine - 1], token.beginColumn);
                break;
            }
            case 65: {
                this.jj_consume_token(65);
                if (dVMacroParm.isList) {
                    this.macroEvalParm = this.macroEvalParm + ",";
                    ++this.macroParmListNo;
                    this.getMacroParmBoolInt(dVMacroParm);
                }
                this.getMacroParm();
                break;
            }
            case 0: {
                this.jj_consume_token(0);
                if (dVMacroParm.isList) {
                    this.throwParseException("End of statement encountered with an uncompleted boolean/integer list", new Object[0]);
                }
                return;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void getMacroParmString(DVMacroParm dVMacroParm) throws ParseException {
        Object object = "";
        boolean bl = false;
        boolean bl2 = true;
        block33: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 0: {
                    this.jj_consume_token(0);
                    if (this.macroNestStack.size() > 0) {
                        this.throwParseException("Missing bracket '%s' at end of macro header", Character.valueOf("0]}".charAt("([{".indexOf(this.macroNestStack.pop().charValue()))));
                    }
                    if (dVMacroParm.isList) {
                        this.throwParseException("End of statement encountered before and of string list", new Object[0]);
                    }
                    this.macroEvalParm = this.macroEvalParm + "\"" + ((String)object).strip().replace("\\", "\\\\").replace("\"", "\\\"").replace("'", "\\'") + "\"";
                    return;
                }
                case 53: 
                case 54: 
                case 55: 
                case 66: 
                case 67: {
                    Token token;
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 53: {
                            token = this.jj_consume_token(53);
                            break;
                        }
                        case 67: {
                            token = this.jj_consume_token(67);
                            break;
                        }
                        case 54: {
                            token = this.jj_consume_token(54);
                            break;
                        }
                        case 55: {
                            token = this.jj_consume_token(55);
                            break;
                        }
                        case 66: {
                            token = this.jj_consume_token(66);
                            break;
                        }
                        default: {
                            this.jj_la1[14] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    object = (String)object + token.image;
                    break;
                }
                case 59: 
                case 61: 
                case 63: {
                    Token token;
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 59: {
                            token = this.jj_consume_token(59);
                            break;
                        }
                        case 61: {
                            token = this.jj_consume_token(61);
                            break;
                        }
                        case 63: {
                            token = this.jj_consume_token(63);
                            break;
                        }
                        default: {
                            this.jj_la1[15] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    object = (String)object + token.image;
                    this.macroNestStack.push(Character.valueOf(token.image.charAt(0)));
                    break;
                }
                case 60: 
                case 64: {
                    Token token;
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 60: {
                            token = this.jj_consume_token(60);
                            break;
                        }
                        case 64: {
                            token = this.jj_consume_token(64);
                            break;
                        }
                        default: {
                            this.jj_la1[16] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    object = (String)object + token.image;
                    if (this.macroNestStack.isEmpty()) {
                        this.throwParseException("Extra bracket '%s' found at position %d", token.image, token.beginColumn);
                    }
                    char c = this.macroNestStack.pop().charValue();
                    char c2 = token.image.charAt(0);
                    if (c == '(' && c2 == ')' || c == '{' && c2 == '}') break;
                    this.throwParseException("Bracket mismatch - bracket '%c' at position [%d] does not match bracket '%c'", Character.valueOf(c2), token.beginColumn, Character.valueOf(c));
                    break;
                }
                case 57: 
                case 58: {
                    Token token;
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 57: {
                            token = this.jj_consume_token(57);
                            break;
                        }
                        case 58: {
                            token = this.jj_consume_token(58);
                            break;
                        }
                        default: {
                            this.jj_la1[17] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    object = (String)object + token.image;
                    break;
                }
                case 56: {
                    Token token = this.jj_consume_token(56);
                    object = (String)object + token.image.substring(2, token.image.length() - 1);
                    bl = true;
                    bl2 = false;
                    break;
                }
                case 62: {
                    char c;
                    Token token = this.jj_consume_token(62);
                    if (this.macroNestStack.isEmpty()) {
                        this.throwParseException(String.format("Unmatched square bracket ']' found at position[%d]", token.beginColumn), new Object[0]);
                    }
                    if ((c = this.macroNestStack.pop().charValue()) != '[') {
                        this.throwParseException("Bracket mismatch - square bracket ']' at position [%d] does not match bracket '%c'", token.beginColumn, Character.valueOf(c));
                    }
                    if (dVMacroParm.isList && this.macroNestStack.isEmpty()) {
                        if (bl2) {
                            int n;
                            String[] stringArray = DVUtil.expandList(((String)object).strip().replace("\\", "\\\\").replace("\"", "\\\"").replace("'", "\\'"));
                            for (n = 0; n < stringArray.length - 1; ++n) {
                                this.macroEvalParm = this.macroEvalParm + "\"" + stringArray[n] + "\",";
                            }
                            this.macroEvalParm = this.macroEvalParm + "\"" + stringArray[n] + "\"]";
                            this.macroParmListNo += stringArray.length;
                        } else {
                            this.macroEvalParm = this.macroEvalParm + "\"" + ((String)object).strip().replace("\\", "\\\\").replace("\"", "\\\"").replace("'", "\\'") + "\"]";
                            ++this.macroParmListNo;
                        }
                        int n = this.macroEvalParm.length();
                        if (this.macroEvalParm.substring(n - 4).equals("[\"\"]") && !bl) {
                            this.macroEvalParm = this.macroEvalParm.substring(0, n - 4) + "[]";
                        }
                        this.endMacroParmList(dVMacroParm);
                        return;
                    }
                    object = (String)object + token.image;
                    break;
                }
                case 65: {
                    Token token = this.jj_consume_token(65);
                    if (dVMacroParm.isList && this.macroNestStack.size() > 1 || !dVMacroParm.isList && this.macroNestStack.size() > 0) {
                        this.throwParseException("Missing bracket '%s' at position [%d]", Character.valueOf("0]}".charAt("([{".indexOf(this.macroNestStack.pop().charValue()))), token.beginColumn);
                    }
                    if (dVMacroParm.isList && this.macroNestStack.size() == 1) {
                        if (bl2) {
                            String[] stringArray = DVUtil.expandList(((String)object).strip().replace("\\", "\\\\").replace("\"", "\\\"").replace("'", "\\'"));
                            for (int i = 0; i < stringArray.length; ++i) {
                                this.macroEvalParm = this.macroEvalParm + "\"" + stringArray[i] + "\",";
                            }
                            this.macroParmListNo += stringArray.length;
                        } else {
                            this.macroEvalParm = this.macroEvalParm + "\"" + ((String)object).strip().replace("\\", "\\\\").replace("\"", "\\\"").replace("'", "\\'") + "\",";
                            ++this.macroParmListNo;
                            bl2 = true;
                        }
                        this.getMacroParmString(dVMacroParm);
                        return;
                    }
                    if (!dVMacroParm.isList && this.macroNestStack.isEmpty()) {
                        this.macroEvalParm = this.macroEvalParm + "\"" + ((String)object).strip().replace("\\", "\\\\").replace("\"", "\\\"").replace("'", "\\'") + "\"";
                        this.getMacroParm();
                        return;
                    }
                    object = (String)object + token.image;
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 0: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: {
                    continue block33;
                }
            }
            break;
        }
        this.jj_la1[19] = this.jj_gen;
    }

    public final void endMacroParmList(DVMacroParm dVMacroParm) throws ParseException {
        if (dVMacroParm.minListSize != null) {
            if (dVMacroParm.maxListSize != null && (this.macroParmListNo < dVMacroParm.minListSize || this.macroParmListNo > dVMacroParm.maxListSize)) {
                this.throwParseException("List size [%d] for parameter [%s] is out of range - range is [%d-%d]", this.macroParmListNo, dVMacroParm.name, dVMacroParm.minListSize, dVMacroParm.maxListSize);
            }
            if (dVMacroParm.maxListSize == null && this.macroParmListNo != dVMacroParm.minListSize) {
                this.throwParseException("List size [%d] for parameter [%s] is incorrect - correct size is [%d]", this.macroParmListNo, dVMacroParm.name, dVMacroParm.minListSize);
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 67: {
                this.jj_consume_token(67);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 65: {
                this.jj_consume_token(65);
                this.getMacroParm();
                break;
            }
            case 0: {
                this.jj_consume_token(0);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void getOpCodeParms(Token token) throws ParseException {
        DVStatements.Statement statement = this.currStatement;
        this.opCodeParm = new DVOpCodeParm();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 0: {
                this.jj_consume_token(0);
                statement.processOpCode(this.currLabel, token, this.opCodeParm);
                break;
            }
            case 4: {
                block10: while (true) {
                    this.jj_consume_token(4);
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            continue block10;
                        }
                    }
                    break;
                }
                this.jj_la1[22] = this.jj_gen;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 0: {
                        this.jj_consume_token(0);
                        statement.processOpCode(this.currLabel, token, this.opCodeParm);
                        return;
                    }
                }
                this.jj_la1[23] = this.jj_gen;
                this.getOpCodeParm();
                statement.processOpCode(this.currLabel, token, this.opCodeParm);
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void getOpCodeParm() throws ParseException {
        DVStatements.Statement statement = this.currStatement;
        this.subParmState = false;
        this.currKey = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 29: {
                Token token;
                this.currKey = token = this.jj_consume_token(29);
                String string = token.image.substring(0, token.image.length() - 1).toUpperCase();
                for (DVOpCodeParm.KeyWordParm keyWordParm : this.opCodeParm.keyWordParmList) {
                    if (!string.equals(keyWordParm.keyValue)) continue;
                    this.throwParseException("Duplicate keyword <%s> at line %s column %d", token.image, this.currStatement.lines[token.beginLine - 1].lineNo, token.beginColumn);
                }
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        this.currExpression = new DVExpression(this.currStatement);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 0: 
            case 49: 
            case 51: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 51: {
                        this.jj_consume_token(51);
                        this.addOpCodeExpression();
                        this.getOpCodeParm();
                        return;
                    }
                    case 49: {
                        this.jj_consume_token(49);
                        this.addOpCodeExpression();
                        this.subParmState = true;
                        this.getOpCodeSubParm();
                        return;
                    }
                    case 0: {
                        this.jj_consume_token(0);
                        this.addOpCodeExpression();
                        return;
                    }
                }
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_la1[27] = this.jj_gen;
        this.getOpCodeUnaryOperator();
    }

    public final void getOpCodeSubParm() throws ParseException {
        this.currExpression = new DVExpression(this.currStatement);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 51: {
                this.jj_consume_token(51);
                this.getOpCodeSubParm();
                return;
            }
        }
        this.jj_la1[28] = this.jj_gen;
        this.getOpCodeUnaryOperator();
    }

    public final void getOpCodeUnaryOperator() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        Token token = this.jj_consume_token(5);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.UPLUS);
                        break block0;
                    }
                    case 6: {
                        Token token = this.jj_consume_token(6);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.UMINUS);
                        break block0;
                    }
                    case 7: {
                        Token token = this.jj_consume_token(7);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.BNOT);
                        break block0;
                    }
                    case 8: {
                        Token token = this.jj_consume_token(8);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.LNOT);
                        break block0;
                    }
                }
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
            }
        }
        this.getOpCodeValue();
    }

    public final void getOpCodeValue() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 9: {
                        Token token = this.jj_consume_token(9);
                        this.currExpression.addBaseSymbolToken(token);
                        break;
                    }
                    case 10: {
                        Token token = this.jj_consume_token(10);
                        this.currExpression.addQualifiedSymbolToken(token);
                        break;
                    }
                    case 11: {
                        Token token = this.jj_consume_token(11);
                        this.currExpression.addSymbolToken(token, DVSymbols.SymbolComponent.VALUE);
                        break;
                    }
                    case 12: {
                        Token token = this.jj_consume_token(12);
                        this.currExpression.addSymbolToken(token, DVSymbols.SymbolComponent.LENGTH);
                        break;
                    }
                    case 13: {
                        Token token = this.jj_consume_token(13);
                        this.currExpression.addSymbolToken(token, DVSymbols.SymbolComponent.REPL);
                        break;
                    }
                    case 14: {
                        Token token = this.jj_consume_token(14);
                        this.currExpression.addSymbolToken(token, DVSymbols.SymbolComponent.SIZE);
                        break;
                    }
                    case 15: {
                        Token token = this.jj_consume_token(15);
                        this.currExpression.addCounterToken(token);
                        break;
                    }
                    case 16: {
                        Token token = this.jj_consume_token(16);
                        this.currExpression.addFloatToken(token);
                        break;
                    }
                    case 17: {
                        Token token = this.jj_consume_token(17);
                        this.currExpression.addIntegerToken(token);
                        break;
                    }
                    case 18: {
                        Token token = this.jj_consume_token(18);
                        this.currExpression.addBinToken(token);
                        break;
                    }
                    case 19: {
                        Token token = this.jj_consume_token(19);
                        this.currExpression.addHexToken(token);
                        break;
                    }
                    case 20: {
                        Token token = this.jj_consume_token(20);
                        this.currExpression.addCharToken(token);
                        break;
                    }
                    case 21: {
                        Token token = this.jj_consume_token(21);
                        String string = this.currExpression.addStringToken(token);
                        if (string == null) break;
                        this.throwParseException("Parse string error for string on line %s column %d\nParse error message is: %s", this.currStatement.lines[token.beginLine - 1].lineNo, token.beginColumn, string);
                        break;
                    }
                    default: {
                        this.jj_la1[31] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.getOpCodeBinaryOperator();
                return;
            }
            case 22: {
                Token token = this.jj_consume_token(22);
                this.currExpression.addOperatorToken(token, DVExpression.OperType.LPAREN);
                this.getOpCodeUnaryOperator();
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void getOpCodeBinaryOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 30: {
                        Token token = this.jj_consume_token(30);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.POWER);
                        break;
                    }
                    case 31: {
                        Token token = this.jj_consume_token(31);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.MULTIPLY);
                        break;
                    }
                    case 32: {
                        Token token = this.jj_consume_token(32);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.DIVIDE);
                        break;
                    }
                    case 33: {
                        Token token = this.jj_consume_token(33);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.REMINDER);
                        break;
                    }
                    case 34: {
                        Token token = this.jj_consume_token(34);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.PLUS);
                        break;
                    }
                    case 35: {
                        Token token = this.jj_consume_token(35);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.MINUS);
                        break;
                    }
                    case 36: {
                        Token token = this.jj_consume_token(36);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.SHIFTLEFT);
                        break;
                    }
                    case 37: {
                        Token token = this.jj_consume_token(37);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.SHIFTRIGHT);
                        break;
                    }
                    case 38: {
                        Token token = this.jj_consume_token(38);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.GT);
                        break;
                    }
                    case 40: {
                        Token token = this.jj_consume_token(40);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.GE);
                        break;
                    }
                    case 39: {
                        Token token = this.jj_consume_token(39);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.LT);
                        break;
                    }
                    case 41: {
                        Token token = this.jj_consume_token(41);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.LE);
                        break;
                    }
                    case 42: {
                        Token token = this.jj_consume_token(42);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.EQ);
                        break;
                    }
                    case 43: {
                        Token token = this.jj_consume_token(43);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.NE);
                        break;
                    }
                    case 44: {
                        Token token = this.jj_consume_token(44);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.BAND);
                        break;
                    }
                    case 45: {
                        Token token = this.jj_consume_token(45);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.BXOR);
                        break;
                    }
                    case 46: {
                        Token token = this.jj_consume_token(46);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.BOR);
                        break;
                    }
                    case 47: {
                        Token token = this.jj_consume_token(47);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.LAND);
                        break;
                    }
                    case 48: {
                        Token token = this.jj_consume_token(48);
                        this.currExpression.addOperatorToken(token, DVExpression.OperType.LOR);
                        break;
                    }
                    default: {
                        this.jj_la1[33] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.getOpCodeValue();
                return;
            }
            case 52: {
                Token token = this.jj_consume_token(52);
                this.currExpression.addOperatorToken(token, DVExpression.OperType.RPAREN);
                this.getOpCodeBinaryOperator();
                return;
            }
            case 49: {
                this.jj_consume_token(49);
                this.addOpCodeExpression();
                this.subParmState = true;
                this.getOpCodeSubParm();
                return;
            }
            case 50: {
                this.jj_consume_token(50);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 51: {
                        this.jj_consume_token(51);
                        this.addOpCodeExpression();
                        this.subParmState = false;
                        this.getOpCodeParm();
                        return;
                    }
                    case 0: {
                        this.jj_consume_token(0);
                        this.addOpCodeExpression();
                        this.subParmState = false;
                        return;
                    }
                }
                this.jj_la1[34] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 51: {
                this.jj_consume_token(51);
                this.addOpCodeExpression();
                if (this.subParmState) {
                    this.getOpCodeSubParm();
                } else {
                    this.getOpCodeParm();
                }
                return;
            }
            case 0: {
                Token token = this.jj_consume_token(0);
                this.addOpCodeExpression();
                if (this.subParmState) {
                    this.throwParseException("Umatched square bracket", new Object[0]);
                }
                return;
            }
        }
        this.jj_la1[35] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void addOpCodeExpression() throws ParseException {
        this.currExpression.expressionEnd();
        if (this.subParmState) {
            DVOpCodeParm.PositionalParm positionalParm = this.opCodeParm.posParmList.get(this.opCodeParm.posParmList.size() - 1);
            positionalParm.addSubParameter(this.currExpression);
        } else if (this.currKey != null) {
            DVOpCodeParm dVOpCodeParm = this.opCodeParm;
            Objects.requireNonNull(dVOpCodeParm);
            new DVOpCodeParm.KeyWordParm(dVOpCodeParm, this.currKey, this.currExpression);
        } else {
            DVOpCodeParm dVOpCodeParm = this.opCodeParm;
            Objects.requireNonNull(dVOpCodeParm);
            new DVOpCodeParm.PositionalParm(dVOpCodeParm, this.currExpression);
        }
    }

    public final void throwParseException(String string, Object ... objectArray) throws ParseException {
        throw new ParseException(String.format(string, objectArray));
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{4, 4, 4, 9, 15, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 1, 16, 1, 17, 0x20000000, 1, 1, 0, 480, 480, 4193792, 8388096, -1073741824, 1, -1073741823};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0, 0, 0xC00000, 0, 0x40000000, 0xE00000, -1476395008, 0x10000000, 0x6000000, -2097152, -2097152, 0, 0, 0, 0, 0, 0, 655360, 655360, 524288, 0, 0, 0, 0, 131071, 524288, 0x1FFFFF};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 8, 0, 0, 8, 0, 8, 0, 8, 2, 12, 0, 1, 0, 15, 15, 8, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public DVInputParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public DVInputParser(InputStream inputStream, String string) {
        try {
            this.jj_input_stream = new SimpleCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source = new DVInputParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 36; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, null);
    }

    public void ReInit(InputStream inputStream, String string) {
        try {
            this.jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 36; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public DVInputParser(Reader reader) {
        this.jj_input_stream = new SimpleCharStream(reader, 1, 1);
        this.token_source = new DVInputParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 36; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader reader) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(reader, 1, 1);
        } else {
            this.jj_input_stream.ReInit(reader, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new DVInputParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 36; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public DVInputParser(DVInputParserTokenManager dVInputParserTokenManager) {
        this.token_source = dVInputParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 36; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(DVInputParserTokenManager dVInputParserTokenManager) {
        this.token_source = dVInputParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 36; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.clear();
        boolean[] blArray = new boolean[71];
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 36; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) != 0) {
                    blArray[32 + n] = true;
                }
                if ((jj_la1_2[n2] & 1 << n) == 0) continue;
                blArray[64 + n] = true;
            }
        }
        for (n2 = 0; n2 < 71; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = this.jj_expentries.get(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        DVInputParser.jj_la1_init_0();
        DVInputParser.jj_la1_init_1();
        DVInputParser.jj_la1_init_2();
    }
}

