/*
 * Decompiled with CFR 0.152.
 */
package framework;

import framework.DVMacros;
import framework.DVParseInput;
import framework.DVStatements;
import framework.DVThread;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.ResourceLimits;

public class DVMacroJSApi {
    private final DVParseInput parseInput;
    private Context context;
    protected DVMacros macros = null;
    private DVStatements.Statement evalOwner;
    private String macroName;
    private String evalParm;
    private String jsCode;
    private HashMap<String, DVMacros.Macro> inlineMacroSet;
    private HashMap<String, Object> jSGlobal = new HashMap();
    private int labelNo = 0;
    private final Pattern expRegister = Pattern.compile("(?<prefix>.*)(?<begin>[0-9]+)[-](?<end>[0-9]+)$");

    protected DVMacroJSApi(DVParseInput dVParseInput, DVMacros dVMacros) {
        this.parseInput = dVParseInput;
        this.macros = dVMacros;
        this.context = Context.newBuilder((String[])new String[]{"js"}).engine(dVMacros.getJSEngine()).allowHostClassLookup(string -> string.equals("framework.DVMacroJSApi") || string.equals("java.math.BigInteger") || string.equals("java.math.BigDecimal") || string.equals("java.util.regex.Pattern") || string.equals("java.util.regex.Matcher")).allowHostClassLoading(true).allowHostAccess(HostAccess.ALL).allowPolyglotAccess(PolyglotAccess.ALL).resourceLimits(ResourceLimits.newBuilder().statementLimit(Integer.MAX_VALUE, null).build()).build();
        this.context.getBindings("js").putMember("__dvasm", (Object)this);
    }

    public void insertLine(String string) {
        this.parseInput.insertLine((string + "\n").getBytes());
    }

    public void formatLine(String string, String string2, String string3, String string4) {
        this.parseInput.formatLine(string, string2, string3, string4);
    }

    public void formatLeft(String string, String string2, String string3, String string4) {
        this.parseInput.formatLeft(string, string2, string3, string4);
    }

    public void formatComm(String string, int n) {
        this.parseInput.formatComm(string, n);
    }

    public void setIndentIn() {
        this.parseInput.setIndentIn();
    }

    public void setIndentOut() {
        this.parseInput.setIndentOut();
    }

    protected void startMacro(DVStatements.Statement statement, String string, String string2, String string3) {
        this.evalOwner = statement;
        ((DVThread)DVThread.currentThread()).setEvalOwner(statement);
        this.parseInput.startMacro(string, statement);
        this.macroName = string;
        this.evalParm = string2;
        this.jsCode = string3;
    }

    protected void endMacro() {
        this.parseInput.endMacro();
    }

    protected DVMacros.Macro getMacro(String string) {
        DVMacros.Macro macro = null;
        if (this.inlineMacroSet != null) {
            macro = this.inlineMacroSet.get(string);
        }
        return macro;
    }

    protected void addInlineMacro(DVStatements.Statement statement, DVMacros.Macro macro) {
        if (this.inlineMacroSet == null) {
            this.inlineMacroSet = new HashMap();
        }
        if (this.inlineMacroSet.putIfAbsent(macro.macroName, macro) != null) {
            statement.putError(String.format("In-line macro [%s] already exists - new macro definition ignored", macro.macroName));
        }
    }

    protected Context getContext() {
        return this.context;
    }

    public String getMacroName() {
        return this.macroName;
    }

    public String getEvalParm() {
        return this.evalParm;
    }

    public String getCode() {
        return this.jsCode;
    }

    public String[] getEnv() {
        return this.macros.getEnv();
    }

    protected void setEnv(DVMacros dVMacros) {
        this.macros = dVMacros;
    }

    public void putInfo(String string) {
        this.evalOwner.putInfo(string);
    }

    public void putWarning(String string) {
        this.evalOwner.putWarning(string);
    }

    public void putError(String string) {
        this.evalOwner.putError(string);
    }

    public void putJSGlobal(String string, Object object) {
        this.jSGlobal.put(string, object);
    }

    public Object getJSGlobal(String string) {
        return this.jSGlobal.get(string);
    }

    public Object dropJSGlobal(String string) {
        return this.jSGlobal.remove(string);
    }

    public String getLanguage() {
        return "ASM";
    }

    public String getNewLabel() {
        ++this.labelNo;
        return String.format("Asm%06d", this.labelNo);
    }
}

