/*
 * Decompiled with CFR 0.152.
 */
package framework;

import framework.DVCode;
import framework.DVInputString;
import framework.DVMacroHeaderParser;
import framework.DVMacroInlineParser;
import framework.DVMacroJSApi;
import framework.DVMacroParm;
import framework.DVOpCodes;
import framework.DVStatements;
import framework.DVUtil;
import framework.ParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import org.graalvm.polyglot.Engine;

public class DVMacros {
    private String architecture = null;
    private String options = null;
    private String abi = null;
    private String os = null;
    private String extension = null;
    private DVOpCodes archOpCodes = null;
    private String archDirectory = null;
    private DVOpCodes extOpCodes = null;
    private String extDirectory = null;
    private final HashMap<String, Macro> userMacroSet = new HashMap(1024);
    private HashMap<String, Macro> extMacroSet = null;
    private HashMap<String, Macro> archMacroSet = null;
    private final HashMap<String, Macro> frameworkMacroSet = new HashMap(1024);
    private String abiEnv = null;
    private final ReentrantLock architectureLock = new ReentrantLock();
    private final Engine jsEngine;
    private final Pattern matchHeader = Pattern.compile("(?:^//macro[\\s\\t]+)", 2);
    private final Pattern matchMacroName = Pattern.compile("(?:(?<macroName>(([a-z_][0-9a-z_]*)([\\.][a-z_][0-9a-z_]*)*))[\\s\\t]+)", 2);
    private static final BigInteger jsMaxInt = new BigInteger("+9007199254740991");
    private static final BigInteger jsMinInt = new BigInteger("-9007199254740991");

    /*
     * WARNING - void declaration
     */
    protected DVMacros(ArrayList<String> arrayList) throws IOException, URISyntaxException {
        Object object;
        File[] fileArray;
        this.jsEngine = Engine.newBuilder().build();
        for (String object22 : arrayList) {
            fileArray = new File(object22);
            object = fileArray.listFiles();
            for (File file : object) {
                this.addMacro(file.getName(), file, null, file.getPath(), (int)file.length(), this.userMacroSet);
            }
        }
        URL uRL = DVUtil.getClassLocation(this.getClass());
        if (!DVUtil.isClassInJar(this.getClass())) {
            void var6_14;
            File file;
            Object exception = null;
            try {
                file = new File(Paths.get(Paths.get(uRL.toURI()).toString(), "framework/macros").toString());
            }
            catch (Exception exception2) {
                System.err.println(DVUtil.formatException("\n*** Software error - unable to read framework macro names from Java resource path [" + uRL.toString() + "]", exception2) + "\n");
                throw exception2;
            }
            fileArray = file.listFiles();
            int n = fileArray.length;
            boolean bl = false;
            while (var6_14 < n) {
                File file2 = fileArray[var6_14];
                String string = file2.getName();
                this.addMacro(string, file2, null, file2.getPath(), (int)file2.length(), this.frameworkMacroSet);
                ++var6_14;
            }
        } else {
            try {
                InputStream inputStream = this.getClass().getResourceAsStream("/framework/macros/index");
                fileArray = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                object = fileArray.readLine();
                while (object != null && !((String)object).equals("")) {
                    InputStream inputStream2;
                    String string = "/framework/macros/" + (String)object;
                    this.addMacro((String)object, null, inputStream2, (String)((inputStream2 = this.getClass().getResourceAsStream(string)) == null ? "*** Unavailable ***" : "JAR: " + string), 0, this.frameworkMacroSet);
                    object = fileArray.readLine();
                }
            }
            catch (Exception exception) {
                System.err.println(DVUtil.formatException("\n*** Software error - unable to read framework macro index from main JAR file", exception) + "\n");
                throw exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addArchitectureMacro(DVStatements.Statement statement, DVMacroJSApi dVMacroJSApi, String string, String string2, String string3, String string4, String string5, String string6, DVOpCodes dVOpCodes, String string7, DVOpCodes dVOpCodes2, String string8) {
        this.archOpCodes = dVOpCodes;
        this.archDirectory = string7;
        this.extOpCodes = dVOpCodes2;
        this.extDirectory = string8;
        boolean bl = true;
        try {
            this.architectureLock.lock();
            if (this.archMacroSet == null) {
                this.getArchMacros(statement, string, string2, true);
                if (this.archMacroSet == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                if (this.extOpCodes != null) {
                    this.getArchMacros(statement, string, string2, false);
                    if (this.extMacroSet == null) {
                        boolean bl3 = false;
                        return bl3;
                    }
                }
            } else if (!(string.equals(this.architecture) && string3.equals(this.options) && string4.equals(this.abi) && string5.equals(this.os))) {
                boolean bl4 = bl = statement.putErrorFalse("Multiple architectures error - macros already loaded for architecture [%s], options [%s], abi [%s], os [%s]", this.architecture, this.options, this.abi, this.os);
                return bl4;
            }
        }
        finally {
            if (bl && this.archMacroSet != null) {
                this.architecture = string;
                this.extension = string2;
                this.options = string3;
                this.abi = string4;
                this.os = string5;
                this.abiEnv = string6;
            }
            this.architectureLock.unlock();
        }
        return true;
    }

    protected void getArchMacros(DVStatements.Statement statement, String string, String string2, boolean bl) {
        String string3 = bl ? "/arch/" + string + "/macros" : "/arch/" + string + "/ext/" + string2 + "/macros";
        DVOpCodes dVOpCodes = bl ? this.archOpCodes : this.extOpCodes;
        String string4 = bl ? "architectural" : "architectural extension";
        HashMap<String, Macro> hashMap = new HashMap<String, Macro>(1024);
        URL uRL = DVUtil.getClassLocation(dVOpCodes.getClass());
        if (!DVUtil.isClassInJar(dVOpCodes.getClass())) {
            File file = null;
            try {
                file = new File(Paths.get(Paths.get(uRL.toURI()).toString(), string3.substring(1)).toString());
            }
            catch (Exception exception) {
                statement.putError(DVUtil.formatException("\n*** Software error - unable to read framework macro names from Java resource path [" + uRL.toString() + "]\nDirectory [" + string3 + "]", exception) + "\n");
                return;
            }
            for (File file2 : file.listFiles()) {
                String string5 = file2.getName();
                this.addMacro(string5, file2, null, file2.getPath(), (int)file2.length(), hashMap);
            }
        } else {
            try {
                InputStream inputStream = dVOpCodes.getClass().getResourceAsStream(string3 + "/index");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                String string6 = bufferedReader.readLine();
                while (string6 != null) {
                    InputStream inputStream2;
                    String string7 = string3 + "/" + string6;
                    this.addMacro(string6, null, inputStream2, (String)((inputStream2 = dVOpCodes.getClass().getResourceAsStream(string7)) == null ? "*** Unavailable ***" : "JAR: " + string7), 0, hashMap);
                    string6 = bufferedReader.readLine();
                }
            }
            catch (Exception exception) {
                statement.putError(DVUtil.formatException("\nUnable to read " + string4 + " macro index from JAR file [" + string3 + "]\n", exception) + "\n");
                return;
            }
        }
        if (bl) {
            this.archMacroSet = hashMap;
        } else {
            this.extMacroSet = hashMap;
        }
    }

    private void addMacro(String string, File file, InputStream inputStream, String string2, int n, HashMap<String, Macro> hashMap) {
        if (!(string = string.toUpperCase()).endsWith(".MAC")) {
            return;
        }
        if (!this.userMacroSet.containsKey(string = string.substring(0, string.length() - 4).toUpperCase())) {
            hashMap.put(string, new Macro(string, file, inputStream, string2, n));
        }
    }

    protected void addInlineMacro(DVStatements.Statement statement, DVMacroJSApi dVMacroJSApi, String string, String string2) {
        Matcher matcher = this.matchHeader.matcher(string2);
        if (!matcher.lookingAt()) {
            statement.putError("In line macro has an invalid header");
            return;
        }
        Matcher matcher2 = this.matchMacroName.matcher(string2);
        matcher2.region(matcher.end(), string2.length());
        if (!matcher2.lookingAt()) {
            statement.putError("In line macro name is either missing or invalid");
            return;
        }
        String string3 = matcher2.group("macroName").toUpperCase();
        dVMacroJSApi.addInlineMacro(statement, new Macro(string3, string, string2));
    }

    protected Macro get(DVMacroJSApi dVMacroJSApi, String string) {
        Macro macro = dVMacroJSApi.getMacro(string = string.toUpperCase());
        if (macro != null) {
            return macro;
        }
        macro = this.userMacroSet.get(string);
        if (macro != null) {
            return macro;
        }
        if (this.extMacroSet != null && (macro = this.userMacroSet.get(string)) != null) {
            return macro;
        }
        if (this.archMacroSet != null && (macro = this.archMacroSet.get(string)) != null) {
            return macro;
        }
        return this.frameworkMacroSet.get(string);
    }

    protected String[] getEnv() {
        return new String[]{this.architecture, this.options, this.abi, this.os, this.abiEnv};
    }

    protected Engine getJSEngine() {
        return this.jsEngine;
    }

    class Macro {
        protected String macroName;
        protected final File file;
        protected final InputStream inputStream;
        protected int codeLength;
        protected final String sourceLocation;
        protected final String inlineCode;
        protected String jsCode = null;
        protected ArrayList<DVMacroParm> posParm = new ArrayList();
        protected Integer minPosParmSize = null;
        protected HashMap<String, DVMacroParm> keyParm = new HashMap();
        protected String permError = null;
        private final ReentrantLock readLock = new ReentrantLock();

        Macro(String string, File file, InputStream inputStream, String string2, int n) {
            this.macroName = string;
            this.file = file;
            this.inputStream = inputStream;
            this.codeLength = n;
            this.sourceLocation = string2;
            this.inlineCode = null;
        }

        Macro(String string, String string2, String string3) {
            this.macroName = string;
            this.file = null;
            this.inputStream = null;
            this.sourceLocation = string2;
            this.inlineCode = string3;
        }

        protected void execute(DVStatements.Statement statement, DVMacroJSApi dVMacroJSApi, String string) throws ScriptException {
            statement.genCode = new DVCode(null, "Macro [" + this.macroName + "] source location is [" + this.sourceLocation + "]");
            dVMacroJSApi.startMacro(statement, this.macroName, string, this.jsCode);
            try {
                dVMacroJSApi.getContext().eval("js", (CharSequence)this.jsCode);
            }
            catch (Exception exception) {
                StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
                String string2 = exception.getMessage() + "\nTrace back:";
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    string2 = string2 + String.format("\n  Line: %5d in method: %s", stackTraceElementArray[i].getLineNumber(), stackTraceElementArray[i].getMethodName());
                    if (stackTraceElementArray[i].getMethodName().startsWith("$_DVASM_$")) break;
                }
                throw new ScriptException(string2);
            }
            finally {
                dVMacroJSApi.endMacro();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void read() {
            boolean bl = false;
            try {
                Object object;
                Object object2;
                Object object3;
                this.readLock.lock();
                if (this.jsCode != null || this.permError != null) {
                    return;
                }
                if (this.inlineCode == null) {
                    if (this.file != null) {
                        object3 = new byte[this.codeLength];
                        object2 = new FileInputStream(this.file);
                        int n = 0;
                        while (n < this.codeLength) {
                            n = ((InputStream)object2).read((byte[])object3, n, this.codeLength - n);
                        }
                        ((InputStream)object2).close();
                    } else {
                        object3 = this.inputStream.readAllBytes();
                        this.inputStream.close();
                    }
                    object = new String((byte[])object3);
                } else {
                    object = this.inlineCode;
                }
                if (!((String)object).endsWith("\n")) {
                    object = (String)object + "\n";
                }
                object3 = new DVMacroHeaderParser(new DVInputString((String)object));
                ((DVMacroHeaderParser)object3).start(this);
                bl = true;
                object = this.convertEmbeddedCode((String)object);
                object2 = "$_DVASM_$_" + this.macroName.replace(".", "_") + "_$$_";
                this.jsCode = "function " + (String)object2 + "() { const DVASM= __dvasm; if (DVASM.getMacroName() != \"" + this.macroName + "\") {DVASM.putError(\"Code of macro [" + this.macroName + "] invoked by code of macro [\" + DVASM.getMacroName() + \"]\"); return; } const BigInteger= Java.type(\"java.math.BigInteger\"); const BigDecimal= Java.type(\"java.math.BigDecimal\"); const Pattern= Java.type(\"java.util.regex.Pattern\"); const Matcher= Java.type(\"java.util.regex.Matcher\"); eval(DVASM.getEvalParm());\n" + (String)object + "} " + (String)object2 + "();\n";
            }
            catch (ParseException | ScriptException exception) {
                this.permError = bl ? String.format("Error while parsing embedded code of macro [%s]\n%s", this.macroName, exception.getMessage()) : String.format("Error while parsing header of macro [%s]\n%s", this.macroName, exception.getMessage().replace("<EOF>", "<END_OF_HEADER>"));
            }
            catch (IOException iOException) {
                this.permError = String.format("I/O Error while reading macro [%s]\n%s", this.macroName, iOException.getMessage());
            }
            finally {
                this.readLock.unlock();
            }
        }

        String convertEmbeddedCode(String string) throws ParseException, ScriptException {
            int n;
            Object object = "";
            int n2 = string.indexOf(10) + 1;
            int n3 = 2;
            while (n2 < string.length() && (n = string.indexOf(10, n2)) >= 0) {
                Object object2;
                String string2 = string.substring(n2, n);
                if (string2.strip().equals("") || string2.charAt(0) != '\\') {
                    object2 = string2;
                } else {
                    DVMacroInlineParser dVMacroInlineParser = new DVMacroInlineParser(new DVInputString(string2.substring(1)));
                    dVMacroInlineParser.start();
                    if (!dVMacroInlineParser.error.equals("")) {
                        throw new ScriptException(String.format("Error found while parsing line[%d]\n%s", n3, dVMacroInlineParser.error));
                    }
                    if ((dVMacroInlineParser.retString[0] + dVMacroInlineParser.retString[1] + dVMacroInlineParser.retString[2]).strip().equals("") && !dVMacroInlineParser.retString[3].strip().equals("")) {
                        int n4;
                        int n5 = 0;
                        int n6 = 0;
                        String string3 = string2.substring(0, string2.indexOf(47));
                        while ((n4 = string3.indexOf(9, n5)) >= 0) {
                            n6 = n6 + n4 - n5 + 4 >> 2 << 2;
                            n5 = n4 + 1;
                        }
                        object2 = "DVASM.formatComm(\"" + dVMacroInlineParser.retString[3] + "\", " + Integer.toString(n6 += string3.length() - n5) + ");";
                    } else {
                        if (dVMacroInlineParser.retString[1].startsWith("<")) {
                            object2 = "DVASM.formatLeft(\"";
                            dVMacroInlineParser.retString[1] = dVMacroInlineParser.retString[1].substring(1);
                        } else {
                            object2 = "DVASM.formatLine(\"";
                        }
                        object2 = (String)object2 + dVMacroInlineParser.retString[0].strip() + "\", \"" + dVMacroInlineParser.retString[1].strip() + "\", \"" + dVMacroInlineParser.retString[2].strip() + "\", \"" + dVMacroInlineParser.retString[3].strip() + "\");";
                    }
                }
                object = (String)object + (String)object2 + "\n";
                n2 = n + 1;
                ++n3;
            }
            return object;
        }

        protected void setPermError(String string) {
            this.readLock.lock();
            if (this.permError != null) {
                this.permError = string;
            }
            this.readLock.unlock();
        }
    }
}

