/*
 * Decompiled with CFR 0.152.
 */
package framework;

import framework.DVInputParser;
import framework.DVMacros;
import framework.DVStatements;
import framework.ParseException;
import framework.TokenMgrError;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;

public class DVParseInput {
    private String inputFileName;
    private ArrayList<String> macroDirectories;
    private String archDirectory;
    private String archExtDirectory;
    private DVMacros macros;
    private ArrayList<Line> inputLines = new ArrayList();
    private int lineNo = 1;
    private int totalByteUsed = 0;
    private int totalLineUsed = 0;
    private DVStatements.Statement currStatement;
    private String macroName;
    private int macroLineNo;
    private String macroExtendedName = "|";
    private String macroLineNoPrefix;
    private int indent = 12;
    private int commIndent = 12;
    private DVStatements.Statement macroParent;

    public DVParseInput(String string, ArrayList<String> arrayList, String string2, String string3, DVMacros dVMacros) throws IOException {
        this.inputFileName = string;
        this.macroDirectories = arrayList;
        this.archDirectory = string2;
        this.archExtDirectory = string3;
        this.macros = dVMacros;
        byte[] byArray = Files.readAllBytes(Paths.get(string, new String[0]));
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 10) continue;
            if (i > 0 && byArray[i - 1] == 13) {
                this.inputLines.add(new Line(byArray, n, i - 1));
            } else {
                this.inputLines.add(new Line(byArray, n, i));
            }
            n = i + 1;
        }
        if (n < byArray.length) {
            this.inputLines.add(new Line(byArray, n, byArray.length));
        }
    }

    protected DVStatements parse() {
        DVStatements dVStatements = new DVStatements(this.inputFileName, this.macroDirectories, this.archDirectory, this.archExtDirectory, this, this.macros);
        InputData inputData = new InputData();
        ArrayList<Line> arrayList = new ArrayList<Line>(4);
        while (!this.inputLines.isEmpty()) {
            int n;
            DVStatements.Statement statement;
            Line line = this.inputLines.remove(0);
            arrayList.add(line);
            byte[] byArray = line.getLine();
            if (byArray.length >= 6 && byArray[0] == 35 & new String(byArray).stripTrailing().equalsIgnoreCase("#MACRO")) {
                if (arrayList.size() > 1) {
                    statement = dVStatements.add(arrayList.toArray(new Line[arrayList.size()]));
                    statement.putError("Line % is a Start Inline Macro line but follows a line with continuation comment", line.lineNo);
                } else {
                    Object object = "";
                    while (!this.inputLines.isEmpty()) {
                        line = this.inputLines.remove(0);
                        arrayList.add(line);
                        byArray = line.getLine();
                        if (byArray.length >= 4 && byArray[0] == 35 & new String(byArray).stripTrailing().equalsIgnoreCase("#END")) break;
                        object = (String)object + new String(line.line) + "\n";
                        line = null;
                    }
                    if (line == null) {
                        statement = dVStatements.add(arrayList.toArray(new Line[arrayList.size()]));
                        statement.putError("End of input reached while reading an In_Line macro");
                        arrayList.clear();
                        break;
                    }
                    statement = dVStatements.add(arrayList.toArray(new Line[arrayList.size()]));
                    arrayList.clear();
                    this.macros.addInlineMacro(statement, dVStatements.jSApi, String.format("Inline macro from line %s to line %s included", dVStatements.currStatement.lines[0].lineNo, dVStatements.currStatement.lines[dVStatements.currStatement.lines.length - 1].lineNo), (String)object);
                    continue;
                }
            }
            for (n = 0; n < byArray.length; ++n) {
                if (byArray[n] == 34 || byArray[n] == 39) {
                    byte by = byArray[n];
                    int n2 = n++;
                    while (n < byArray.length && byArray[n] != by) {
                        ++n;
                    }
                    if (n < byArray.length) continue;
                    statement = dVStatements.add(arrayList.toArray(new Line[arrayList.size()]));
                    statement.putError("String on line %s starting at position %d is missing ending quote", line.lineNo, n);
                    arrayList.clear();
                    n = byArray.length;
                    continue;
                }
                if (byArray[n] == 47 && n < byArray.length - 1 && (byArray[n + 1] == 47 || byArray[n + 1] == 62)) break;
            }
            if (n < byArray.length - 1) {
                line.dataLength = n;
                if (byArray[n + 1] == 62) {
                    continue;
                }
            } else {
                line.dataLength = line.line.length;
            }
            statement = dVStatements.add(arrayList.toArray(new Line[arrayList.size()]));
            arrayList.clear();
            if (statement.error) continue;
            this.currStatement = statement;
            inputData.reStart(statement.lines);
            DVInputParser dVInputParser = new DVInputParser(inputData);
            try {
                dVInputParser.start(dVStatements);
            }
            catch (ParseException parseException) {
                String string = new String(parseException.getMessage() + "\n");
                String string2 = new String("");
                while (string.length() > 0) {
                    int n3 = string.indexOf(10);
                    string2 = new String(string2 + "         " + string.substring(0, n3 + 1)).replace("<EOF>", "<END_OF_STATEMENT>");
                    string = new String(string.substring(n3 + 1));
                }
                statement.putError("Input Parsing Exception\n   Last line Processed [%s]\n   Error: %s\n", statement.lines[statement.lines.length - 1].lineNo, string2);
            }
            catch (TokenMgrError tokenMgrError) {
                statement.putError("Input Token Manager Error\n   Last line Processed [%s]\n   Lexical state: %s\n   Error: %s", statement.lines[statement.lines.length - 1].lineNo, dVInputParser.getState(), tokenMgrError.toString().replace("<EOF>", "<END_OF_STATEMENT>"));
            }
        }
        return dVStatements;
    }

    protected String getFileName() {
        return this.inputFileName;
    }

    protected void startMacro(String string, DVStatements.Statement statement) {
        this.macroExtendedName = this.currStatement.lines[this.currStatement.lines.length - 1].macroExtendedName + ":" + string;
        if (this.macroExtendedName.startsWith("|:")) {
            this.macroExtendedName = "|" + this.macroExtendedName.substring(2);
        }
        this.macroLineNoPrefix = this.currStatement.lines[this.currStatement.lines.length - 1].lineNo + ".";
        this.macroLineNo = 0;
        this.commIndent = this.indent;
        this.macroParent = statement;
    }

    protected void endMacro() {
        this.macroExtendedName = "|";
        this.macroParent = null;
        this.macroLineNoPrefix = "";
    }

    protected void insertLine(byte[] byArray) {
        this.inputLines.add(this.macroLineNo, new Line(byArray));
    }

    protected void setIndentIn() {
        this.indent += 4;
    }

    protected void setIndentOut() {
        this.indent -= 4;
        if (this.indent < 12) {
            this.indent = 12;
        }
    }

    protected void formatLeft(String string, String string2, String string3, String string4) {
        this.formatLine(string, string2, string3, string4, -4);
    }

    protected void formatLine(String string, String string2, String string3, String string4) {
        this.formatLine(string, string2, string3, string4, 0);
    }

    private void formatLine(String string, String string2, String string3, String string4, int n) {
        this.inputLines.add(this.macroLineNo, new Line(string == null ? "" : string, string2 == null ? "" : string2, string3 == null ? "" : string3, string4 == null ? "" : string4, n));
    }

    protected void formatComm(String string, int n) {
        this.inputLines.add(this.macroLineNo, new Line((" ".repeat(n + this.commIndent - 12) + string).getBytes()));
    }

    public class InputData
    extends InputStream {
        private Line[] lines;
        private int line = 0;
        private int column = 0;
        private int markLine = 0;
        private int markColumn = 0;

        public void reStart(Line[] lineArray) {
            this.lines = lineArray;
            this.line = 0;
            this.column = 0;
            this.markLine = 0;
            this.markColumn = 0;
        }

        @Override
        public int read() {
            if (this.line >= this.lines.length) {
                return -1;
            }
            if (this.column < this.lines[this.line].dataLength) {
                ++this.column;
                return this.lines[this.line].line[this.column - 1];
            }
            ++this.line;
            this.column = 0;
            return this.line < this.lines.length ? 10 : -1;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) {
            int n3;
            if (this.line >= this.lines.length) {
                return -1;
            }
            for (n3 = n; n3 < n + n2; ++n3) {
                if (this.column < this.lines[this.line].dataLength) {
                    byArray[n3] = this.lines[this.line].line[this.column];
                    ++this.column;
                    continue;
                }
                ++this.line;
                if (this.line >= this.lines.length) break;
                this.column = 0;
                byArray[n3] = 10;
            }
            return n3 - n > 0 ? n3 - n : -1;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int n) {
            this.markLine = this.line;
            this.markColumn = this.column;
        }

        @Override
        public void reset() {
            this.line = this.markLine;
            this.column = this.markColumn;
        }
    }

    protected class Line {
        protected String macroExtendedName;
        protected DVStatements.Statement macroParent;
        protected String lineNo;
        protected byte[] line;
        protected int dataLength = 0;
        protected String[] comp = null;
        protected String comm = null;
        protected int indAdjust = 0;

        private Line(byte[] byArray, int n, int n2) {
            this.macroExtendedName = "|";
            this.lineNo = Integer.toString(DVParseInput.this.lineNo);
            ++DVParseInput.this.lineNo;
            this.line = Arrays.copyOfRange(byArray, n, n2);
            for (int i = 0; i < this.line.length - 1; ++i) {
                if (this.line[i] > 31 && this.line[i] < 127) continue;
                this.line[i] = 32;
            }
        }

        private Line(byte[] byArray) {
            this.macroExtendedName = DVParseInput.this.macroExtendedName;
            this.macroParent = DVParseInput.this.macroParent;
            this.lineNo = DVParseInput.this.macroLineNoPrefix + Integer.toString(DVParseInput.this.macroLineNo);
            ++DVParseInput.this.macroLineNo;
            this.line = byArray;
            for (int i = 0; i < byArray.length - 1; ++i) {
                if (byArray[i] > 31 && byArray[i] < 127) continue;
                byArray[i] = 32;
            }
        }

        private Line(String string, String string2, String string3, String string4, int n) {
            this.macroExtendedName = DVParseInput.this.macroExtendedName;
            this.macroParent = DVParseInput.this.macroParent;
            ++DVParseInput.this.macroLineNo;
            this.lineNo = DVParseInput.this.macroLineNoPrefix + Integer.toString(DVParseInput.this.macroLineNo);
            this.line = null;
            this.comp = new String[]{string, string2, string3, string4};
            this.indAdjust = n;
        }

        private byte[] getLine() {
            if (this.line == null || this.indAdjust > 0) {
                this.expandComp();
            }
            return this.line;
        }

        private void expandComp() {
            if (this.line != null) {
                return;
            }
            String string = this.comp[0] + " ";
            int n = Math.max(DVParseInput.this.indent + this.indAdjust - 1, 11) - this.comp[0].length();
            if (n > 0) {
                string = string + " ".repeat(n);
                n = 0;
            }
            string = string + this.comp[1] + " ";
            if ((n = 11 + n - this.comp[1].length()) > 0) {
                string = string + " ".repeat(n);
                n = 0;
            }
            string = string + this.comp[2] + " ";
            if ((n = 35 + n - this.comp[2].length()) > 0) {
                string = string + " ".repeat(n);
            }
            string = string + this.comp[3];
            this.line = string.getBytes();
            for (int i = 0; i < this.line.length - 1; ++i) {
                if (this.line[i] > 31 && this.line[i] < 127) continue;
                this.line[i] = 32;
            }
        }
    }
}

