/*
 * Decompiled with CFR 0.152.
 */
package framework;

import framework.DVAbi;
import framework.DVSections;
import framework.DVSymbols;
import framework.DVUtil;
import java.math.BigInteger;
import java.util.ArrayList;

public class DVSectionTable {
    private final DVAbi abi;
    private final int elfBits;
    private final DVUtil.Endianness elfEndianness;
    private final DVSections sections;
    private final DVSymbols symbols;
    private final StringSection stringSection = new StringSection();
    private final SymbolSection symbolSection;
    private final String inputFileName;
    private final int symbolSectionAlign;
    private final int relocationSectionAlign;
    private final int headerAlign;
    private final int elfHeaderLength;
    private final int sectionTableEntryLength;
    private final int relocationSectionEntryLength;
    private final int symbolTableEntryLength;
    private int maxIndex = 0;
    private final StringSection sectionStringSection = new StringSection();
    private final ArrayList<byte[]> sectionTableList = new ArrayList();
    private final ArrayList<ElfSection> elfSectionList = new ArrayList();

    protected DVSectionTable(DVAbi dVAbi, DVSections dVSections, DVSymbols dVSymbols, String string) {
        this.abi = dVAbi;
        this.elfBits = dVAbi.getElfBits();
        this.elfEndianness = dVAbi.getElfEndianness();
        this.sections = dVSections;
        this.symbols = dVSymbols;
        this.inputFileName = string;
        if (this.elfBits == 32) {
            this.elfHeaderLength = 52;
            this.sectionTableEntryLength = 40;
            this.relocationSectionEntryLength = 12;
            this.symbolTableEntryLength = 16;
            this.headerAlign = 4;
            this.symbolSectionAlign = 4;
            this.relocationSectionAlign = 4;
        } else {
            this.elfHeaderLength = 64;
            this.sectionTableEntryLength = 64;
            this.relocationSectionEntryLength = 24;
            this.symbolTableEntryLength = 24;
            this.headerAlign = 8;
            this.symbolSectionAlign = 8;
            this.relocationSectionAlign = 8;
        }
        this.symbolSection = new SymbolSection();
        this.sectionTableList.add(new byte[this.sectionTableEntryLength]);
    }

    protected byte[] getElfBinary() {
        byte[] byArray;
        int n;
        int n2;
        int n3;
        this.sections.buildBinaries(this);
        BigInteger bigInteger = BigInteger.valueOf(this.maxIndex + 1);
        BigInteger bigInteger2 = BigInteger.valueOf(this.maxIndex + 2);
        int n4 = this.elfHeaderLength;
        for (ElfSection object2 : this.elfSectionList) {
            n3 = object2.align.intValue();
            n4 = (n4 + n3 - 1) / n3 * n3;
            object2.setOffset(n4);
            this.symbolSection.addSymbol(null, BigInteger.ZERO, BigInteger.ZERO, DVUtil.symbolBindLocal, DVUtil.symbolTypeSection, object2.index);
            BigInteger bigInteger3 = this.sectionStringSection.addString(object2.name);
            this.addSectionTableEntry(bigInteger3, object2.type, object2.attribute, BigInteger.valueOf(n4), BigInteger.valueOf(object2.binary.length), BigInteger.ZERO, BigInteger.ZERO, object2.align, BigInteger.ZERO);
            if (object2.attribute.equals(DVUtil.sectionTypeNobits)) continue;
            n4 += object2.binary.length;
            if (object2.relocationSection == null) continue;
            n4 = (n4 + this.relocationSectionAlign - 1) / this.relocationSectionAlign * this.relocationSectionAlign;
            object2.relocationSection.setOffset(n4);
            bigInteger3 = this.sectionStringSection.addString(".rela" + object2.name);
            this.addSectionTableEntry(bigInteger3, DVUtil.sectionTypeRela, BigInteger.valueOf(this.abi.getRelocationSectionAttributes()), BigInteger.valueOf(n4), BigInteger.valueOf(this.relocationSectionEntryLength * object2.relocationSection.relocationList.size()), bigInteger2, object2.index, BigInteger.valueOf(this.relocationSectionAlign), BigInteger.valueOf(this.relocationSectionEntryLength));
            n4 += this.relocationSectionEntryLength * object2.relocationSection.relocationList.size();
        }
        this.symbols.fillElfSymbolSection(this.symbolSection, this.inputFileName);
        int n5 = n4;
        BigInteger bigInteger4 = this.sectionStringSection.addString(".strtab");
        this.addSectionTableEntry(bigInteger4, DVUtil.sectionTypeStrtab, BigInteger.ZERO, BigInteger.valueOf(n4), BigInteger.valueOf(this.stringSection.length), BigInteger.ZERO, BigInteger.ZERO, BigInteger.ONE, BigInteger.ZERO);
        n4 += this.stringSection.length;
        n3 = n4 = (n4 + this.symbolSectionAlign - 1) / this.symbolSectionAlign * this.symbolSectionAlign;
        BigInteger bigInteger5 = this.sectionStringSection.addString(".symtab");
        this.addSectionTableEntry(bigInteger5, DVUtil.sectionTypeSymtab, BigInteger.ZERO, BigInteger.valueOf(n4), BigInteger.valueOf(this.symbolSection.length), bigInteger, this.symbolSection.endLocalIndex, BigInteger.valueOf(this.symbolSectionAlign), BigInteger.valueOf(this.symbolTableEntryLength));
        int n6 = n4 += this.symbolSection.length;
        BigInteger bigInteger6 = this.sectionStringSection.addString(".shstrtab");
        this.addSectionTableEntry(bigInteger6, DVUtil.sectionTypeStrtab, BigInteger.ZERO, BigInteger.valueOf(n4), BigInteger.valueOf(this.sectionStringSection.length), BigInteger.ZERO, BigInteger.ZERO, BigInteger.ONE, BigInteger.ZERO);
        n4 += this.sectionStringSection.length;
        int n7 = n4 = (n4 + this.headerAlign - 1) / this.headerAlign * this.headerAlign;
        int n8 = this.sectionTableEntryLength * this.sectionTableList.size();
        byte[] byArray2 = new byte[n4 += n8];
        byArray2[0] = 127;
        byArray2[1] = 69;
        byArray2[2] = 76;
        byArray2[3] = 70;
        if (this.elfBits == 32) {
            byArray2[4] = 1;
            DVUtil.addCode(byArray2, 32, BigInteger.valueOf(n7).toByteArray(), 4, 1, this.elfEndianness);
            DVUtil.addCode(byArray2, 40, BigInteger.valueOf(52L).toByteArray(), 2, 1, this.elfEndianness);
            n2 = 36;
        } else {
            byArray2[4] = 2;
            DVUtil.addCode(byArray2, 40, BigInteger.valueOf(n7).toByteArray(), 8, 1, this.elfEndianness);
            DVUtil.addCode(byArray2, 52, BigInteger.valueOf(64L).toByteArray(), 2, 1, this.elfEndianness);
            n2 = 48;
        }
        byArray2[5] = this.elfEndianness == DVUtil.Endianness.LITTLE ? 1 : 2;
        byArray2[6] = 1;
        byArray2[7] = (byte)this.abi.getOsAbi();
        byArray2[8] = (byte)this.abi.getAbiVersion();
        DVUtil.addCode(byArray2, 16, BigInteger.valueOf(this.abi.getType()).toByteArray(), 2, 1, this.elfEndianness);
        DVUtil.addCode(byArray2, 18, BigInteger.valueOf(this.abi.getMachine()).toByteArray(), 2, 1, this.elfEndianness);
        DVUtil.addCode(byArray2, 20, BigInteger.valueOf(this.abi.getVersion()).toByteArray(), 4, 1, this.elfEndianness);
        DVUtil.addCode(byArray2, n2, BigInteger.valueOf(this.abi.getProcessorFlags()).toByteArray(), 4, 1, this.elfEndianness);
        DVUtil.addCode(byArray2, n2 + 10, BigInteger.valueOf(this.sectionTableEntryLength).toByteArray(), 2, 1, this.elfEndianness);
        DVUtil.addCode(byArray2, n2 + 12, BigInteger.valueOf(this.maxIndex + 4).toByteArray(), 2, 1, this.elfEndianness);
        DVUtil.addCode(byArray2, n2 + 14, BigInteger.valueOf(this.maxIndex + 3).toByteArray(), 2, 1, this.elfEndianness);
        for (ElfSection elfSection : this.elfSectionList) {
            if (elfSection.attribute.equals(DVUtil.sectionTypeNobits)) continue;
            System.arraycopy(elfSection.binary, 0, byArray2, elfSection.offset, elfSection.binary.length);
            if (elfSection.relocationSection == null) continue;
            System.arraycopy(elfSection.relocationSection.getBinary(), 0, byArray2, elfSection.relocationSection.offset, elfSection.relocationSection.length);
        }
        ArrayList<byte[]> arrayList = this.stringSection.getBinary();
        n2 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            byArray = (byte[])arrayList.get(n);
            System.arraycopy(byArray, 0, byArray2, n5 + n2, byArray.length);
            n2 += byArray.length;
        }
        arrayList = this.symbolSection.getSection();
        n2 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            byArray = arrayList.get(n);
            System.arraycopy(byArray, 0, byArray2, n3 + n2, byArray.length);
            n2 += byArray.length;
        }
        arrayList = this.sectionStringSection.getBinary();
        n2 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            byArray = arrayList.get(n);
            System.arraycopy(byArray, 0, byArray2, n6 + n2, byArray.length);
            n2 += byArray.length;
        }
        n2 = 0;
        for (n = 0; n < this.sectionTableList.size(); ++n) {
            byArray = this.sectionTableList.get(n);
            System.arraycopy(byArray, 0, byArray2, n7 + n2, byArray.length);
            n2 += byArray.length;
        }
        return byArray2;
    }

    private void addSectionTableEntry(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8, BigInteger bigInteger9) {
        byte[] byArray = new byte[this.sectionTableEntryLength];
        if (this.elfBits == 32) {
            DVUtil.addCode(byArray, 0, bigInteger.toByteArray(), 4, 1, this.elfEndianness);
            DVUtil.addCode(byArray, 4, bigInteger2.toByteArray(), 4, 1, this.elfEndianness);
            DVUtil.addCode(byArray, 8, bigInteger3.toByteArray(), 4, 1, this.elfEndianness);
            DVUtil.addCode(byArray, 16, bigInteger4.toByteArray(), 4, 1, this.elfEndianness);
            DVUtil.addCode(byArray, 20, bigInteger5.toByteArray(), 4, 1, this.elfEndianness);
            DVUtil.addCode(byArray, 24, bigInteger6.toByteArray(), 4, 1, this.elfEndianness);
            DVUtil.addCode(byArray, 28, bigInteger7.toByteArray(), 4, 1, this.elfEndianness);
            DVUtil.addCode(byArray, 32, bigInteger8.toByteArray(), 4, 1, this.elfEndianness);
            DVUtil.addCode(byArray, 36, bigInteger9.toByteArray(), 4, 1, this.elfEndianness);
        } else {
            DVUtil.addCode(byArray, 0, bigInteger.toByteArray(), 4, 1, this.elfEndianness);
            DVUtil.addCode(byArray, 4, bigInteger2.toByteArray(), 4, 1, this.elfEndianness);
            DVUtil.addCode(byArray, 8, bigInteger3.toByteArray(), 8, 1, this.elfEndianness);
            DVUtil.addCode(byArray, 24, bigInteger4.toByteArray(), 8, 1, this.elfEndianness);
            DVUtil.addCode(byArray, 32, bigInteger5.toByteArray(), 8, 1, this.elfEndianness);
            DVUtil.addCode(byArray, 40, bigInteger6.toByteArray(), 4, 1, this.elfEndianness);
            DVUtil.addCode(byArray, 44, bigInteger7.toByteArray(), 4, 1, this.elfEndianness);
            DVUtil.addCode(byArray, 48, bigInteger8.toByteArray(), 8, 1, this.elfEndianness);
            DVUtil.addCode(byArray, 56, bigInteger9.toByteArray(), 8, 1, this.elfEndianness);
        }
        this.sectionTableList.add(byArray);
    }

    protected ElfSection startSection(String string, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n) {
        return new ElfSection(string, bigInteger, bigInteger2, bigInteger3, n);
    }

    public class RelocationSection {
        private final ArrayList<DVSections.Section.Relocation> relocationList;
        private final BigInteger index;
        private int offset;
        private final int length;

        protected RelocationSection(ArrayList<DVSections.Section.Relocation> arrayList) {
            this.index = BigInteger.valueOf(DVSectionTable.this.maxIndex);
            this.relocationList = arrayList;
            this.length = DVSectionTable.this.elfBits == 32 ? 12 * this.relocationList.size() : 24 * this.relocationList.size();
        }

        protected byte[] getBinary() {
            byte[] byArray = new byte[this.length];
            int n = 0;
            for (DVSections.Section.Relocation relocation : this.relocationList) {
                BigInteger bigInteger = BigInteger.valueOf(relocation.relocationID.ID);
                if (DVSectionTable.this.elfBits == 32) {
                    DVUtil.addCode(byArray, n, relocation.offset.toByteArray(), 4, 1, DVSectionTable.this.elfEndianness);
                    DVUtil.addCode(byArray, 4, relocation.symbol.index.shiftLeft(8).or(bigInteger).toByteArray(), 4, 1, DVSectionTable.this.elfEndianness);
                    DVUtil.addCode(byArray, 8, relocation.addEnd.toByteArray(), 4, 1, DVSectionTable.this.elfEndianness);
                    n += 16;
                    continue;
                }
                DVUtil.addCode(byArray, n, relocation.offset.toByteArray(), 8, 1, DVSectionTable.this.elfEndianness);
                DVUtil.addCode(byArray, n + 8, relocation.symbol.index.shiftLeft(32).or(bigInteger).toByteArray(), 8, 1, DVSectionTable.this.elfEndianness);
                DVUtil.addCode(byArray, n + 16, relocation.addEnd.toByteArray(), 8, 1, DVSectionTable.this.elfEndianness);
                n += 24;
            }
            return byArray;
        }

        private void setOffset(int n) {
            this.offset = n;
        }

        protected BigInteger length() {
            return BigInteger.valueOf(this.length);
        }
    }

    public class SymbolSection {
        private BigInteger endLocalIndex;
        private int length;
        private final ArrayList<byte[]> binaryList = new ArrayList();

        protected SymbolSection() {
            if (DVSectionTable.this.elfBits == 32) {
                this.binaryList.add(new byte[16]);
                this.length = 16;
            } else {
                this.binaryList.add(new byte[24]);
                this.length = 24;
            }
        }

        protected BigInteger addSymbol(String string, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5) {
            byte[] byArray = DVSectionTable.this.stringSection.addString(string).toByteArray();
            byte[] byArray2 = bigInteger4.or(bigInteger3.shiftLeft(4)).toByteArray();
            if (DVSectionTable.this.elfBits == 32) {
                byte[] byArray3 = new byte[16];
                DVUtil.addCode(byArray3, 0, byArray, 4, 1, DVSectionTable.this.elfEndianness);
                DVUtil.addCode(byArray3, 4, bigInteger.toByteArray(), 4, 1, DVSectionTable.this.elfEndianness);
                DVUtil.addCode(byArray3, 8, bigInteger2.toByteArray(), 4, 1, DVSectionTable.this.elfEndianness);
                DVUtil.addCode(byArray3, 12, byArray2, 1, 1, DVSectionTable.this.elfEndianness);
                DVUtil.addCode(byArray3, 13, new byte[1], 1, 1, DVSectionTable.this.elfEndianness);
                DVUtil.addCode(byArray3, 14, bigInteger5.toByteArray(), 2, 1, DVSectionTable.this.elfEndianness);
                this.binaryList.add(byArray3);
                this.length += 16;
            } else {
                byte[] byArray4 = new byte[24];
                DVUtil.addCode(byArray4, 0, byArray, 4, 1, DVSectionTable.this.elfEndianness);
                DVUtil.addCode(byArray4, 4, byArray2, 1, 1, DVSectionTable.this.elfEndianness);
                DVUtil.addCode(byArray4, 5, new byte[1], 1, 1, DVSectionTable.this.elfEndianness);
                DVUtil.addCode(byArray4, 6, bigInteger5.toByteArray(), 2, 1, DVSectionTable.this.elfEndianness);
                DVUtil.addCode(byArray4, 8, bigInteger.toByteArray(), 8, 1, DVSectionTable.this.elfEndianness);
                DVUtil.addCode(byArray4, 16, bigInteger2.toByteArray(), 8, 1, DVSectionTable.this.elfEndianness);
                this.binaryList.add(byArray4);
                this.length += 24;
            }
            return BigInteger.valueOf(this.binaryList.size() - 1);
        }

        protected void markLocal() {
            this.endLocalIndex = BigInteger.valueOf(this.binaryList.size());
        }

        protected ArrayList<byte[]> getSection() {
            return this.binaryList;
        }
    }

    public class StringSection {
        private int length = 1;
        private final ArrayList<byte[]> stringList = new ArrayList();

        protected StringSection() {
            this.stringList.add(new byte[1]);
        }

        protected BigInteger addString(String string) {
            if (string == null) {
                return BigInteger.ZERO;
            }
            int n = this.length;
            this.length += string.length() + 1;
            this.stringList.add((string + "\u0000").getBytes());
            return BigInteger.valueOf(n);
        }

        protected ArrayList<byte[]> getBinary() {
            return this.stringList;
        }
    }

    public class ElfSection {
        private final String name;
        private final BigInteger type;
        private final BigInteger attribute;
        private final BigInteger align;
        private final BigInteger index;
        private int offset;
        private RelocationSection relocationSection = null;
        private final byte[] binary;

        private ElfSection(String string, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n) {
            this.name = string;
            this.type = bigInteger;
            this.attribute = bigInteger2;
            this.align = bigInteger3;
            ++DVSectionTable.this.maxIndex;
            this.index = BigInteger.valueOf(DVSectionTable.this.maxIndex);
            this.binary = new byte[n];
            DVSectionTable.this.elfSectionList.add(this);
        }

        protected BigInteger getIndex() {
            return this.index;
        }

        protected void copyBytes(byte[] byArray, int n) {
            System.arraycopy(byArray, 0, this.binary, n, byArray.length);
        }

        private void setOffset(int n) {
            this.offset = n;
        }

        protected void addRelocationSection(ArrayList<DVSections.Section.Relocation> arrayList) {
            ++DVSectionTable.this.maxIndex;
            this.relocationSection = new RelocationSection(arrayList);
        }
    }
}

