/*
 * Decompiled with CFR 0.152.
 */
package framework;

import framework.DVAbi;
import framework.DVExpression;
import framework.DVSectionTable;
import framework.DVStatements;
import framework.DVSymbols;
import framework.DVUtil;
import framework.Token;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class DVSections {
    protected final DVStatements statements;
    protected final DVSymbols symbols;
    protected Section currSection = null;
    protected final LinkedHashMap<String, Section> sectionMap = new LinkedHashMap();

    protected DVSections(DVStatements dVStatements, DVSymbols dVSymbols) {
        this.statements = dVStatements;
        this.symbols = dVSymbols;
    }

    protected Section startSection(DVStatements.Statement statement, Token token, SectionType sectionType) {
        return new Section(statement, token, sectionType);
    }

    protected void setNextSymbolValueExpression(DVStatements.Statement statement) {
        statement.sectionIndex = this.currSection.addStatement(statement);
        if (statement.symbol.valueExpression == null) {
            statement.symbol.valueExpression = DVExpression.getNewSymbolValueExpression(this.currSection.statementList.get((int)(this.currSection.statementList.size() - 2)).symbol, statement.symbol);
        }
    }

    protected void setCounter(DVStatements.Statement statement) {
        this.currSection.resetExpression.maxExpression(DVExpression.getEndValueExpression(this.currSection.statementList.get(this.currSection.statementList.size() - 1)));
    }

    protected DVExpression resetCounter() {
        DVExpression dVExpression = this.currSection.resetExpression.maxExpression(DVExpression.getEndValueExpression(this.currSection.statementList.get(this.currSection.statementList.size() - 1)));
        this.currSection.resetExpression = new DVExpression(this.currSection.owner);
        return dVExpression;
    }

    protected void setExpressionLength() {
        if (this.currSection == null) {
            return;
        }
        this.currSection.lengthExpression = this.resetCounter();
    }

    protected byte[] buildBinaries(DVSectionTable dVSectionTable) {
        for (Map.Entry<String, Section> entry : this.sectionMap.entrySet()) {
            Section section = entry.getValue();
            section.size = section.lengthExpression.evaluate((boolean)false).intConstant.intValue();
            if (section.type != SectionType.SECTION) continue;
            section.elfSection = dVSectionTable.startSection(section.externalName, section.typeValue, section.attributeValue, section.alignValue, section.size);
            for (int i = 1; i < section.statementList.size(); ++i) {
                DVStatements.Statement statement = section.statementList.get(i);
                if (statement.genCode == null || statement.genCode.code == null) continue;
                section.elfSection.copyBytes(statement.genCode.code, statement.symbol.resultValue.intConstant.intValue());
            }
            if (section.relocationList.isEmpty()) continue;
            section.elfSection.addRelocationSection(section.relocationList);
        }
        return null;
    }

    protected void resetSections() {
        for (Map.Entry<String, Section> entry : this.sectionMap.entrySet()) {
            entry.getValue().resetSection();
        }
    }

    public static enum SectionType {
        MMAP,
        SECTION,
        NONE;

    }

    public class Section {
        protected final Token name;
        protected String externalName = null;
        protected final DVStatements.Statement owner;
        protected SectionType type = SectionType.NONE;
        protected BigInteger attributeValue;
        protected BigInteger typeValue;
        protected BigInteger alignValue = BigInteger.ZERO;
        protected DVExpression lengthExpression;
        protected int size;
        protected DVSectionTable.ElfSection elfSection;
        protected DVExpression resetExpression;
        protected final ArrayList<Relocation> relocationList = new ArrayList();
        protected final ArrayList<DVStatements.Statement> statementList = new ArrayList();

        protected Section(DVStatements.Statement statement, Token token, SectionType sectionType) {
            this.name = token;
            this.owner = statement;
            this.type = sectionType;
            this.resetExpression = new DVExpression(this.owner);
            this.owner.ownerSection = this;
            this.owner.symbol.valueExpression = DVExpression.getOffsetConstantExpression(statement, this, BigInteger.ZERO);
            this.owner.symbol.replExpression = DVExpression.getConstantExpression(BigInteger.ONE, statement);
            DVSections.this.sectionMap.put(this.name.image, this);
            DVSections.this.currSection = this;
            this.owner.sectionIndex = this.addStatement(this.owner);
        }

        protected void setAttributes(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, String string) {
            this.typeValue = bigInteger;
            this.attributeValue = bigInteger2;
            if (this.alignValue.compareTo(bigInteger3) < 0) {
                this.alignValue = bigInteger3;
            }
            if ((this.externalName = string) == null) {
                this.externalName = this.name.image;
            }
        }

        protected int addStatement(DVStatements.Statement statement) {
            this.statementList.add(statement);
            return this.statementList.size();
        }

        protected DVStatements.Statement getNextStatement(int n) {
            if (n >= this.statementList.size() || n < -1) {
                return null;
            }
            return this.statementList.get(n + 1);
        }

        protected DVStatements.Statement getPrevStatement(int n) {
            if (n >= this.statementList.size() + 1 || n < 1) {
                return null;
            }
            return this.statementList.get(n - 1);
        }

        protected void clearRelocation() {
            this.relocationList.clear();
        }

        protected void addRelocation(DVStatements.Statement statement, DVSymbols.Symbol symbol, BigInteger bigInteger, BigInteger bigInteger2, DVAbi.RelocationID relocationID) {
            if (statement.ownerSection.typeValue.equals(DVUtil.sectionTypeNobits) || this.type == SectionType.MMAP) {
                statement.putError("A relocation cannot be added to an MMAP or an ELF section marked with type NOBITS");
                return;
            }
            if (!symbol.isExternal && !symbol.isCommon) {
                if (symbol.owner == null) {
                    statement.putError("Symbol [" + symbol.name + "] is not EXTERNAL nor COMMON and has not been defined");
                    return;
                }
                if (symbol.owner.ownerSection.type == SectionType.MMAP) {
                    statement.putError("Symbol [" + symbol.name + "] cannot be marked locally exported - it is defined in a MMAP");
                    return;
                }
                if (!(symbol.isExported || symbol.isExternal || symbol.isCommon)) {
                    symbol.setLocalExport();
                }
            }
            this.relocationList.add(new Relocation(symbol, bigInteger, bigInteger2, relocationID));
        }

        public DVStatements.Statement getOwner() {
            return this.owner;
        }

        public String getName() {
            return this.name.image;
        }

        public SectionType getSectionType() {
            return this.type;
        }

        protected void resetSection() {
            this.resetExpression = new DVExpression(this.owner);
            this.relocationList.clear();
        }

        public class Relocation {
            protected final DVSymbols.Symbol symbol;
            protected final BigInteger offset;
            protected final BigInteger addEnd;
            protected final DVAbi.RelocationID relocationID;

            private Relocation(DVSymbols.Symbol symbol, BigInteger bigInteger, BigInteger bigInteger2, DVAbi.RelocationID relocationID) {
                this.symbol = symbol;
                this.offset = bigInteger;
                this.addEnd = bigInteger2;
                this.relocationID = relocationID;
            }
        }
    }
}

