/*
 * Decompiled with CFR 0.152.
 */
package framework;

import framework.DVAbi;
import framework.DVCode;
import framework.DVExpression;
import framework.DVFrameworkOpCodes;
import framework.DVMacroJSApi;
import framework.DVMacros;
import framework.DVOpCodeParm;
import framework.DVOpCodeProcessor;
import framework.DVOpCodes;
import framework.DVParseInput;
import framework.DVSectionTable;
import framework.DVSections;
import framework.DVSymbols;
import framework.DVUtil;
import framework.Token;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedList;

public class DVStatements {
    protected final String inputFileName;
    protected final String archDirectory;
    protected final String extDirectory;
    protected final DVParseInput parseInput;
    protected final DVMacros macros;
    protected final DVMacroJSApi jSApi;
    protected String hexCodeHeader = "--- Architecture/Abi no found ---";
    protected final DVFrameworkOpCodes frameworkOpCodes = new DVFrameworkOpCodes();
    protected DVOpCodes architectureOpCodes = null;
    protected DVOpCodes extensionOpCodes = null;
    protected DVAbi abi = null;
    protected final DVSymbols symbols;
    protected final DVSections sections;
    protected DVUtil.Endianness defaultEndianness = DVUtil.Endianness.UNDEFINED;
    protected DVUtil.Endianness currentEndianness = DVUtil.Endianness.UNDEFINED;
    protected int currStatementFirstLineIndex = 0;
    protected Statement currStatement = new Statement();
    protected boolean endOpCode = false;
    protected boolean setFile = false;
    protected final ArrayList<Statement> statementList = new ArrayList();
    protected boolean changedLengthFlag = false;
    protected int firstPhaseWarnings = 0;
    protected int warnings = 0;
    protected int errors = 0;
    protected final ArrayList<Base> activeBaseList = new ArrayList();
    protected final LinkedList<String> logListFirstPhase = new LinkedList();
    protected final LinkedList<String> logListSecondPhase = new LinkedList();
    protected boolean secondPhase = false;
    protected boolean traceFlag = false;

    protected DVStatements(String string, ArrayList<String> arrayList, String string2, String string3, DVParseInput dVParseInput, DVMacros dVMacros) {
        this.parseInput = dVParseInput;
        this.inputFileName = string;
        this.archDirectory = string2;
        this.extDirectory = string3;
        this.macros = dVMacros;
        this.jSApi = new DVMacroJSApi(dVParseInput, dVMacros);
        this.symbols = new DVSymbols(this);
        this.sections = new DVSections(this, this.symbols);
        if (DVUtil.isClassInJar(this.getClass())) {
            this.logMsg(String.format("Framework JAR file is [%s]", DVUtil.getClassLocation(this.getClass())));
        } else {
            this.logMsg(String.format("Framework base directory is [%s]", DVUtil.getClassLocation(this.getClass())));
        }
        if (this.archDirectory != null) {
            this.logMsg(String.format("User architectural directory is [%s]", this.archDirectory));
        }
        if (this.extDirectory != null) {
            this.logMsg(String.format("User arch. extension directory is [%s]", this.extDirectory));
        }
        int n = 1;
        for (String string4 : arrayList) {
            this.logMsg(String.format("User macro directory[%d] is: [%s]", n, string4));
            ++n;
        }
    }

    protected Statement getLastStatement() {
        int n = this.statementList.size() - 1;
        if (n < 0) {
            return null;
        }
        return this.statementList.get(n);
    }

    protected Statement add(DVParseInput.Line[] lineArray) {
        this.currStatement = new Statement();
        this.currStatement.lines = lineArray;
        this.statementList.add(this.currStatement);
        return this.currStatement;
    }

    protected void checkEndStatement() {
        if (!this.endOpCode) {
            Statement statement = this.getLastStatement();
            if (statement == null) {
                return;
            }
            statement.putError("Missing END statement");
        }
    }

    public void logMsg(String string) {
        this.log(string, false);
    }

    public void logErr(String string) {
        this.log(string, true);
    }

    public void logTrace(String string) {
        if (this.traceFlag) {
            this.log(string, false);
        }
    }

    protected void log(String object, boolean bl) {
        if (!((String)object).endsWith("\n")) {
            object = (String)object + "\n";
        }
        if (bl) {
            System.err.print((String)object);
        }
        if (this.secondPhase) {
            this.logListSecondPhase.add((String)object);
        } else {
            this.logListFirstPhase.add((String)object);
        }
    }

    public void setLogTrace(boolean bl) {
        this.traceFlag = bl;
    }

    protected void genCode() {
        for (Statement statement : this.statementList) {
            if (statement.opCodeProcessor == null) continue;
            if (statement.opCodeParm != null) {
                for (DVOpCodeParm.PositionalParm positionalParm : statement.opCodeParm.posParmList) {
                    positionalParm.parameterValue = positionalParm.parameter.evaluate(false);
                    for (DVOpCodeParm.SubParm subParm : positionalParm.subParmList) {
                        subParm.subParmValue = subParm.subParm.evaluate(false);
                    }
                }
                for (DVOpCodeParm.KeyWordParm keyWordParm : statement.opCodeParm.keyWordParmList) {
                    keyWordParm.value = keyWordParm.parameter.evaluate(false);
                }
            }
            if (statement.error) continue;
            statement.opCodeCurr = null;
            statement.opCodeParmCurr = null;
            statement.offsetCurr = null;
            statement.genCode = statement.opCodeProcessor.generateCode(statement);
            statement.opCodeCurr = null;
            statement.opCodeParmCurr = null;
            statement.offsetCurr = null;
            if (statement.genCode == null) continue;
            if (statement.genCode.next != null) {
                Object object = statement.genCode.next;
                while (object != null) {
                    if (statement.genCode.code == null) {
                        if (((DVCode)object).code != null) {
                            statement.genCode.code = ((DVCode)object).code;
                        }
                    } else if (((DVCode)object).code != null) {
                        int n;
                        byte[] byArray = statement.genCode.code;
                        int n2 = statement.genCode.code.length;
                        statement.genCode.code = new byte[n2 + ((DVCode)object).code.length];
                        for (n = 0; n < n2; ++n) {
                            statement.genCode.code[n] = byArray[n];
                        }
                        for (n = 0; n < ((DVCode)object).code.length; ++n) {
                            statement.genCode.code[n2 + n] = ((DVCode)object).code[n];
                        }
                    }
                    object = ((DVCode)object).next;
                }
            }
            if (statement.genCode.code == null || statement.genCode.code.length == statement.symbol.length.multiply(statement.symbol.resultRepl.intConstant).intValue()) continue;
            this.changedLengthFlag = true;
            statement.symbol.length = BigInteger.valueOf(statement.genCode.code.length).divide(statement.symbol.resultRepl.intConstant);
        }
        this.architectureOpCodes.postProcess();
    }

    protected byte[] generateElfBinary() {
        DVSectionTable dVSectionTable = new DVSectionTable(this.abi, this.sections, this.symbols, this.setFile ? this.inputFileName : null);
        return dVSectionTable.getElfBinary();
    }

    protected void setSecondPhase() {
        this.secondPhase = true;
    }

    protected void resetSecondPhase() {
        this.changedLengthFlag = false;
        this.activeBaseList.clear();
        this.warnings = this.firstPhaseWarnings;
        for (Statement statement : this.statementList) {
            statement.resetStatement();
        }
        this.sections.resetSections();
    }

    public class Base {
        protected final Statement owner;
        protected final String id;
        protected final DVSections.Section section;
        protected final BigInteger offset;
        protected final BigInteger register;

        protected Base(Statement statement, String string, DVSections.Section section, BigInteger bigInteger, BigInteger bigInteger2) {
            this.owner = statement;
            this.id = string;
            this.section = section;
            this.offset = bigInteger;
            this.register = bigInteger2;
        }

        public Statement getOwner() {
            return this.getOwner();
        }

        public String getID() {
            return this.id;
        }

        public DVSections.Section getSection() {
            return this.section;
        }

        public BigInteger getOffset() {
            return this.offset;
        }

        public BigInteger getRegister() {
            return this.register;
        }
    }

    public class Statement {
        protected final DVStatements statements;
        protected boolean isMacro;
        protected int sectionIndex;
        protected DVParseInput.Line[] lines;
        protected ArrayList<String> firstPhaseMessages;
        protected ArrayList<String> secondPhaseMessages;
        protected boolean firstPhaseWarning;
        protected boolean warning;
        protected boolean error;
        protected Token label;
        protected Token opCode;
        protected String opCodeCurr;
        protected DVOpCodeParm opCodeParm;
        protected DVOpCodeParm opCodeParmCurr;
        protected BigInteger offsetCurr;
        protected DVOpCodeProcessor opCodeProcessor;
        protected DVCode genCode;
        protected DVSymbols.Symbol symbol;
        protected DVUtil.Endianness endianness;
        protected DVSections.Section ownerSection;
        protected Object userObject;

        public Statement() {
            this.statements = DVStatements.this;
            this.isMacro = false;
            this.sectionIndex = -1;
            this.lines = null;
            this.firstPhaseMessages = new ArrayList();
            this.secondPhaseMessages = new ArrayList();
            this.firstPhaseWarning = false;
            this.warning = false;
            this.error = false;
            this.opCode = null;
            this.symbol = null;
            this.endianness = DVUtil.Endianness.UNDEFINED;
            this.ownerSection = null;
            this.userObject = null;
        }

        public void putInfo(String string, Object ... objectArray) {
            this.putInfo(String.format(string, objectArray));
        }

        public void putInfo(String string) {
            this.addMessage("Note:    " + string);
        }

        public void putWarning(String string, Object ... objectArray) {
            this.putWarning(String.format(string, objectArray));
        }

        public void putWarning(String string) {
            this.addMessage("Warning: " + string);
            if (DVStatements.this.secondPhase) {
                this.warning = true;
                ++DVStatements.this.warnings;
            } else {
                this.firstPhaseWarning = true;
                ++DVStatements.this.firstPhaseWarnings;
            }
        }

        public boolean putErrorFalse(String string, Object ... objectArray) {
            this.putError(String.format(string, objectArray));
            return false;
        }

        public DVCode putErrorNoCode(String string, Object ... objectArray) {
            this.putError(String.format(string, objectArray));
            return null;
        }

        public void putError(String string, Object ... objectArray) {
            this.putError(String.format(string, objectArray));
        }

        public void putError(String string) {
            this.addMessage("Error:   " + string);
            this.error = true;
            ++DVStatements.this.errors;
        }

        private void addMessage(String object) {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = arrayList = DVStatements.this.secondPhase ? this.secondPhaseMessages : this.firstPhaseMessages;
            if (!((String)object).endsWith("\n")) {
                object = (String)object + "\n";
            }
            while (true) {
                int n = ((String)object).indexOf(10);
                arrayList.add(((String)object).substring(0, n));
                if (n == ((String)object).length() - 1) {
                    return;
                }
                object = "         " + ((String)object).substring(n + 1);
            }
        }

        public BigInteger getOffset() {
            if (this.offsetCurr != null) {
                return this.symbol.resultValue.intConstant.add(this.offsetCurr);
            }
            return this.symbol.resultValue.intConstant;
        }

        public BigInteger getAlignment() {
            return this.symbol.align;
        }

        public String getOpCode() {
            if (this.opCodeCurr != null) {
                return this.opCodeCurr;
            }
            return this.opCode.image.toUpperCase();
        }

        public DVOpCodeParm getOpCodeParm() {
            if (this.opCodeParmCurr != null) {
                return this.opCodeParmCurr;
            }
            return this.opCodeParm;
        }

        public DVSections.Section getOwnerSection() {
            return this.ownerSection;
        }

        public String getFirstLineNumber() {
            return this.lines[0].lineNo;
        }

        protected boolean setEnv(String string, String string2, String string3, String string4) {
            if (DVStatements.this.architectureOpCodes != null) {
                return this.putErrorFalse("Duplicate SETENV opcope", new Object[0]);
            }
            DVStatements.this.architectureOpCodes = this.getOpCodes(string, DVStatements.this.archDirectory, string2, string3, string4);
            if (DVStatements.this.architectureOpCodes == null) {
                return false;
            }
            if (DVUtil.isClassInJar(DVStatements.this.architectureOpCodes.getClass())) {
                this.logMsg(String.format("Architecture JAR file selected  is [%s]", DVUtil.getClassLocation(DVStatements.this.architectureOpCodes.getClass())));
            } else {
                this.logMsg(String.format("Architecture directory selected is [%s]", DVUtil.getClassLocation(DVStatements.this.architectureOpCodes.getClass())));
            }
            if (!DVStatements.this.architectureOpCodes.verifyArchitecture(this, string)) {
                return false;
            }
            DVStatements.this.hexCodeHeader = DVStatements.this.architectureOpCodes.getHexCodeHeader();
            DVStatements.this.frameworkOpCodes.putHexCodeHeader(DVStatements.this.hexCodeHeader);
            DVStatements.this.abi = DVStatements.this.architectureOpCodes.getAbi();
            if (DVStatements.this.abi == null) {
                return this.putErrorFalse("Abi [" + string3 + "] not supported by architecture [" + string + "]", new Object[0]);
            }
            String string5 = DVStatements.this.architectureOpCodes.getExtension();
            if (string5 != null) {
                DVStatements.this.extensionOpCodes = this.getOpCodes(string, DVStatements.this.archDirectory);
                if (DVStatements.this.extensionOpCodes == null) {
                    return false;
                }
                if (DVUtil.isClassInJar(DVStatements.this.architectureOpCodes.getClass())) {
                    this.logMsg(String.format("Architecture extension JAR file selected is [%s]", DVUtil.getClassLocation(DVStatements.this.architectureOpCodes.getClass())));
                } else {
                    this.logMsg(String.format("Architecture extension directory selected is [%s]", DVUtil.getClassLocation(DVStatements.this.architectureOpCodes.getClass())));
                }
                if (!DVStatements.this.extensionOpCodes.verifyArchitecture(this, string)) {
                    return false;
                }
                if (!DVStatements.this.extensionOpCodes.verifyExtension(this, string5)) {
                    return false;
                }
            } else {
                this.logMsg("No architecture extension used");
            }
            if (!DVStatements.this.macros.addArchitectureMacro(this, DVStatements.this.jSApi, string, string5, string2, string3, string4, DVStatements.this.abi.getEnv(), DVStatements.this.architectureOpCodes, DVStatements.this.archDirectory, DVStatements.this.extensionOpCodes, DVStatements.this.extDirectory)) {
                return false;
            }
            this.setEndianness(DVStatements.this.abi.getDefaultEndianness());
            return true;
        }

        private DVOpCodes getOpCodes(String string, String string2, String string3, String string4, String string5) {
            return this.getOpCodes(string, string2, string3, string4, string5, true);
        }

        private DVOpCodes getOpCodes(String string, String string2) {
            return this.getOpCodes(string, string2, null, null, null, false);
        }

        private DVOpCodes getOpCodes(String string, String string2, String string3, String string4, String string5, boolean bl) {
            String string6 = bl ? "arch." + string + ".DVArchOpCodes" : "arch." + string + ".ext.DVExtOpCodes";
            DVOpCodes dVOpCodes = null;
            Object object = "";
            try {
                if (string2 == null) {
                    dVOpCodes = bl ? (DVOpCodes)Class.forName(string6).getConstructor(Statement.class, String.class, String.class, String.class).newInstance(this, string3, string4, string5) : (DVOpCodes)Class.forName(string6).getConstructor(Statement.class).newInstance(this);
                } else {
                    URLClassLoader uRLClassLoader = URLClassLoader.newInstance(new URL[]{new File(DVStatements.this.archDirectory).toURI().toURL()});
                    object = "\n  URL [" + string2 + "]";
                    dVOpCodes = bl ? (DVOpCodes)uRLClassLoader.loadClass(string6).getConstructor(Statement.class, String.class, String.class, String.class).newInstance(this, string3, string4, string5) : (DVOpCodes)uRLClassLoader.loadClass(string6).getConstructor(Statement.class).newInstance(this);
                }
            }
            catch (Exception exception) {
                Exception exception2 = (Exception)exception.getCause();
                if (exception2 == null) {
                    this.putError(DVUtil.formatException("Unable to load DVOpCodes class [" + string6 + "]" + (String)object + "\n", exception));
                } else {
                    StringWriter stringWriter = new StringWriter();
                    exception2.printStackTrace(new PrintWriter(stringWriter));
                    this.putError("Unable to load DVOpCodes class [" + string6 + "]" + (String)object + "\n%s\n%s\n", exception2.toString(), stringWriter.toString());
                }
                return null;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.putError("Unable to load DVOpCodes class [" + string6 + "]" + (String)object + "\n", noClassDefFoundError);
                return null;
            }
            return dVOpCodes;
        }

        protected void setBigEndianness() {
            this.setEndianness(DVUtil.Endianness.BIG);
        }

        protected void setLittleEndianness() {
            this.setEndianness(DVUtil.Endianness.LITTLE);
        }

        protected void setEndianness(DVUtil.Endianness endianness) {
            if (DVStatements.this.defaultEndianness == DVUtil.Endianness.UNDEFINED) {
                DVStatements.this.defaultEndianness = endianness;
            }
            DVStatements.this.currentEndianness = endianness;
        }

        protected void setDefEndianness(DVUtil.Endianness endianness) {
            DVStatements.this.currentEndianness = endianness = DVStatements.this.defaultEndianness;
        }

        public DVUtil.Endianness getEndianness() {
            return DVStatements.this.currentEndianness;
        }

        protected boolean initializeMacro(Token token, Token token2) {
            this.isMacro = true;
            this.label = token;
            this.opCode = token2;
            return true;
        }

        protected void addBase(String string, DVSections.Section section, BigInteger bigInteger, BigInteger bigInteger2) {
            for (Base base : DVStatements.this.activeBaseList) {
                if (bigInteger2.equals(base.register)) {
                    this.putError("Base for register [%s] already active - defined in statement [%s]\n", bigInteger2.toString(), base.owner.lines[0].lineNo);
                    return;
                }
                if (string == null || !string.equals(base.id)) continue;
                this.putError(String.format("Base for id [%s] already active - defined in statement [%s]\n", string, base.owner.lines[0].lineNo));
                return;
            }
            DVStatements.this.activeBaseList.add(new Base(this, string, section, bigInteger, bigInteger2));
            if (string == null) {
                this.putInfo("Base register [%d] added for section [%s] at offset [%012X]", bigInteger2.intValue(), section.name, bigInteger.longValue());
            } else {
                this.putInfo("Base register [%d] added for section [%s] at offset [%012X] with ID [%s]", bigInteger2.intValue(), section.name, bigInteger.longValue(), string);
            }
        }

        protected boolean dropBase(BigInteger bigInteger) {
            for (int i = 0; i < DVStatements.this.activeBaseList.size(); ++i) {
                Base base = DVStatements.this.activeBaseList.get(i);
                if (!bigInteger.equals(base.register)) continue;
                this.putInfo("Base set in statement " + base.owner.lines[0].lineNo + " dropped");
                DVStatements.this.activeBaseList.remove(i);
                return true;
            }
            this.putError("Base with base register " + bigInteger.toString() + " not droppped: it was not set");
            return true;
        }

        protected boolean dropAllBases() {
            int n = 0;
            while (!DVStatements.this.activeBaseList.isEmpty()) {
                Base base = DVStatements.this.activeBaseList.get(0);
                this.putInfo("Base register [%d] set in statement %s dropped", base.register, base.owner.lines[0].lineNo);
                DVStatements.this.activeBaseList.remove(0);
                ++n;
            }
            if (n == 0) {
                this.putWarning("NO active base registers found");
            }
            return true;
        }

        public Base getBase(String string) {
            for (int i = 0; i < DVStatements.this.activeBaseList.size(); ++i) {
                Base base = DVStatements.this.activeBaseList.get(i);
                if (base.id == null || !string.equals(base.id)) continue;
                return base;
            }
            return null;
        }

        public Base getBase(DVSections.Section section, BigInteger bigInteger, boolean bl) {
            Base base = null;
            BigInteger bigInteger2 = null;
            for (int i = 0; i < DVStatements.this.activeBaseList.size(); ++i) {
                BigInteger bigInteger3;
                Base base2 = DVStatements.this.activeBaseList.get(i);
                if (base2.id != null || section != base2.section || (bigInteger3 = bigInteger.subtract(base2.offset)).signum() < 0 && bl || base != null && bigInteger3.abs().compareTo(bigInteger2.abs()) >= 0) continue;
                base = base2;
                bigInteger2 = bigInteger3;
            }
            return base;
        }

        protected boolean processOpCode(Token token, Token token2, DVOpCodeParm dVOpCodeParm) {
            int n;
            Object object;
            Object object2;
            Object[] objectArray;
            boolean bl;
            this.label = token;
            this.opCode = token2;
            this.opCodeParm = dVOpCodeParm;
            this.endianness = DVStatements.this.currentEndianness;
            if (DVStatements.this.endOpCode) {
                this.putError("Only comments allowed after END opCode");
                return false;
            }
            if (DVStatements.this.abi == null && !this.opCode.image.toUpperCase().equals("SETENV")) {
                return this.putErrorFalse("Missing or failed preeceding SETENV statement - only macros are allowed before SETENV opCode", new Object[0]);
            }
            this.opCodeProcessor = DVStatements.this.frameworkOpCodes.getOpCodeProcessor(this, token2);
            if (this.opCodeProcessor == null && DVStatements.this.extensionOpCodes != null) {
                this.opCodeProcessor = DVStatements.this.extensionOpCodes.getOpCodeProcessor(this, token2);
            }
            if (this.opCodeProcessor == null) {
                this.opCodeProcessor = DVStatements.this.architectureOpCodes.getOpCodeProcessor(this, token2);
            }
            if (this.opCodeProcessor == null) {
                return this.putErrorFalse(String.format("Invalid opCode [%s] at line %s column %d", token2.image, this.lines[token2.beginLine - 1].lineNo, token2.beginColumn), new Object[0]);
            }
            boolean bl2 = this.opCodeProcessor.getNoLabel();
            boolean bl3 = this.opCodeProcessor.getNeedSection();
            boolean bl4 = this.opCodeProcessor.getNeedLabel();
            boolean bl5 = bl = !bl2 || bl3;
            if (this.opCodeProcessor.getNoLabel() && this.label != null) {
                return this.putErrorFalse("Label specified but not allowed for this opCode", new Object[0]);
            }
            int n2 = dVOpCodeParm.getPositionalParmListSize();
            int[] nArray = this.opCodeProcessor.getPosParmMinMax();
            if (nArray == null) {
                if (n2 > 0) {
                    return this.putErrorFalse("No positional parameters allowed for this opCode\n", new Object[0]);
                }
            } else {
                if (n2 < nArray[0] || n2 > nArray[1]) {
                    if (nArray[0] == nArray[1]) {
                        return this.putErrorFalse(String.format("Number of positional parameters is [%d] - it must be %d\n", n2, nArray[0]), new Object[0]);
                    }
                    return this.putErrorFalse(String.format("Number of positional parameters is [%d] - it must be between %d and %d included\n", n2, nArray[0], nArray[1]), new Object[0]);
                }
                objectArray = this.opCodeProcessor.getPosParmDefault();
                object2 = this.opCodeProcessor.getSubParmMinMax();
                object = this.opCodeProcessor.getSubParmDefault();
                for (n = 0; n < n2; ++n) {
                    if ((objectArray == null || objectArray != null && objectArray[n] == false) && dVOpCodeParm.getPositionalParameter(n).isEmpty()) {
                        return this.putErrorFalse(String.format("Positional parameter in position [%d] is defaulted - default not available", n + 1), new Object[0]);
                    }
                    int n3 = dVOpCodeParm.getSubParmListSize(n);
                    if (object2 == null) {
                        if (n3 <= 0) continue;
                        return this.putErrorFalse(String.format("Positional parameter [%d] cannot have any sub-parameters\n", n + 1), new Object[0]);
                    }
                    if (n3 < object2[n][0] || n3 > object2[n][1]) {
                        if (object2[n][0] == object2[n][1]) {
                            return this.putErrorFalse(String.format("Number of sub-parameters for positional parameter [%d] is [%d] - it must be %d\n", n + 1, n3, (int)object2[n][0]), new Object[0]);
                        }
                        return this.putErrorFalse(String.format("Number of sub-parameters for positional parameter [%d] is [%d] - it must be between %d and %d included\n", n + 1, n3, nArray[0], nArray[1]), new Object[0]);
                    }
                    DVOpCodeParm.SubParm[] subParmArray = dVOpCodeParm.getSubParmList(n);
                    for (int i = 0; i < n3; ++i) {
                        if (object != null && (object == null || object[n][i] != false) || !subParmArray[i].getSubParm().isEmpty()) continue;
                        return this.putErrorFalse(String.format("Sub-parameter for positional parameter [%d] in position [%d] is defaulted - default not available", n, i), new Object[0]);
                    }
                }
            }
            if ((objectArray = this.opCodeProcessor.getKeyWordList()) != null) {
                n2 = dVOpCodeParm.getKeyWordParmListSize();
                object2 = new DVOpCodeParm.KeyWordParm[objectArray.length];
                object = dVOpCodeParm.getKeyWordParmList();
                for (n = 0; n < n2; ++n) {
                    int n4;
                    String string = object[n].getKeyValue().toUpperCase();
                    if (object[n].parameter.isEmpty()) {
                        return this.putErrorFalse("Key-word paramter [%s=] has not been assigned any valaue", string);
                    }
                    for (n4 = 0; n4 < ((DVOpCodeParm.KeyWordParm[])object).length; ++n4) {
                        if (!string.equals(objectArray[n4])) continue;
                        object2[n4] = object[n];
                        break;
                    }
                    if (n4 < ((DVOpCodeParm.KeyWordParm[])object).length) continue;
                    Object object3 = "";
                    for (n4 = 0; n4 < objectArray.length; ++n4) {
                        object3 = (String)object3 + " " + objectArray[n4];
                    }
                    return this.putErrorFalse(String.format("Key-word parameter [%s=] is not allowed - possible key-words are" + (String)object3, string), new Object[0]);
                }
                dVOpCodeParm.keyWordParmIndex = object2;
            }
            if (bl) {
                this.symbol = DVStatements.this.symbols.getSymbol(token, this);
                if (this.symbol == null) {
                    return this.putErrorFalse("Duplicate symbol [" + token + "]", new Object[0]);
                }
                if (bl4 && this.symbol.name.startsWith("#")) {
                    return this.putErrorFalse("Label required but missing", new Object[0]);
                }
                this.symbol.align = this.opCodeProcessor.getAlign();
                this.symbol.length = this.opCodeProcessor.getLength();
                if (this.opCodeProcessor.getValueInParm()) {
                    this.symbol.valueExpression = this.opCodeProcessor.getValueExpression(this);
                }
                this.symbol.replExpression = this.opCodeProcessor.getRepl() != null ? DVExpression.getConstantExpression(this.opCodeProcessor.getRepl(), this) : this.opCodeProcessor.getReplExpression(dVOpCodeParm, this);
            }
            if (bl3) {
                if (DVStatements.this.sections.currSection == null) {
                    this.putError("An active section/memory map is required but none has been started");
                    return false;
                }
                DVStatements.this.sections.currSection.alignValue = DVStatements.this.sections.currSection.alignValue.max(this.symbol.align);
                this.ownerSection = DVStatements.this.sections.currSection;
                DVStatements.this.sections.setNextSymbolValueExpression(this);
            }
            if (this.symbol != null && this.symbol.valueExpression == null) {
                this.symbol.valueExpression = DVExpression.getConstantExpression(BigInteger.ZERO, this);
            }
            return this.opCodeProcessor.preProcessOpCode(this);
        }

        public void guaranteeAlignment(BigInteger bigInteger) {
            this.ownerSection.alignValue = this.ownerSection.alignValue.max(bigInteger);
        }

        protected DVSections getSections() {
            return DVStatements.this.sections;
        }

        protected DVSymbols getSymbols() {
            return DVStatements.this.symbols;
        }

        public String getLabel() {
            return this.getLabel();
        }

        public DVSymbols.Symbol getSymbol() {
            return this.symbol;
        }

        public void setUserObject(Object object) {
            this.userObject = object;
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public void addRelocation(DVSymbols.Symbol symbol, BigInteger bigInteger, DVAbi.RelocationID relocationID) {
            this.ownerSection.addRelocation(this, symbol, this.getOffset(), bigInteger, relocationID);
        }

        public Object getRelativeDisplacement(int n, int n2) {
            return this.getRelativeDisplacement(n, n2, 0);
        }

        public Object getRelativeDisplacement(int n, int n2, int n3) {
            BigInteger bigInteger;
            DVExpression.ExprToken exprToken = this.getOpCodeParm().getPositionalParameterValue(n);
            if (exprToken == null) {
                this.putError("PC Relative displacement is required but it is missing");
                return null;
            }
            if (DVExpression.INT_VALUE.contains((Object)exprToken.type)) {
                bigInteger = exprToken.intConstant;
            } else if (exprToken.type == DVExpression.TokenType.OFFSET) {
                if (exprToken.getOffsetSection() != this.ownerSection) {
                    return exprToken;
                }
                bigInteger = exprToken.intConstant.subtract(this.symbol.resultValue.intConstant);
            } else {
                if (exprToken.type == DVExpression.TokenType.EXTERNAL_VALUE) {
                    return exprToken;
                }
                this.putError("PC Relative displacement resolves to invalid type [%s]", exprToken.type.name());
                return null;
            }
            if (bigInteger.bitLength() >= n2) {
                this.putError("PC Relative displacement is [%d] wide - maximum allowed is [%d]", bigInteger.bitLength() + 1, n2);
                return null;
            }
            if (n3 > 0 && bigInteger.divideAndRemainder(BigInteger.valueOf(n3))[1].intValue() > 0) {
                this.putError("PC Relative displacement is out of alignment");
                return null;
            }
            return bigInteger.and(BigInteger.valueOf((1L << n2) - 1L));
        }

        protected Statement getPrevSectStatement() {
            for (int i = this.statements.statementList.indexOf(this); i >= 0; --i) {
                Statement statement = this.statements.statementList.get(i);
                if (statement.ownerSection == null) continue;
                return statement;
            }
            return null;
        }

        public void logMsg(String string) {
            DVStatements.this.log(string, false);
        }

        public void logErr(String string) {
            DVStatements.this.log(string, true);
        }

        public void logTrace(String string) {
            if (DVStatements.this.traceFlag) {
                DVStatements.this.log(string, false);
            }
        }

        protected void resetStatement() {
            this.secondPhaseMessages.clear();
            this.warning = this.firstPhaseWarning;
        }
    }
}

