/*
 * Decompiled with CFR 0.152.
 */
package framework;

import framework.DVExpression;
import framework.DVSectionTable;
import framework.DVSections;
import framework.DVStatements;
import framework.DVUtil;
import framework.Token;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class DVSymbols {
    protected final DVStatements statements;
    protected final TreeMap<String, Symbol> symbolMap = new TreeMap();

    protected DVSymbols(DVStatements dVStatements) {
        this.statements = dVStatements;
    }

    protected Symbol getSymbol(String string) {
        Symbol symbol = this.symbolMap.get(string.toUpperCase());
        if (symbol == null) {
            symbol = new Symbol(null, string);
        }
        return symbol;
    }

    protected Symbol getSymbol(Token token, DVStatements.Statement statement) {
        if (token == null) {
            return this.getHiddenSymbol(statement);
        }
        Symbol symbol = this.symbolMap.get(token.image.toUpperCase());
        if (symbol == null) {
            symbol = new Symbol(token);
            symbol.owner = statement;
            return symbol;
        }
        if (symbol.owner != null) {
            return null;
        }
        if (symbol.isExternal) {
            statement.putError("Symbol [" + symbol.name + "] has been defined as External");
            return null;
        }
        if (symbol.isCommon) {
            statement.putError("Symbol [" + symbol.name + "] has been defined as Common");
            return null;
        }
        if (symbol.isExported && statement.ownerSection != null && statement.ownerSection.type == DVSections.SectionType.MMAP) {
            statement.putError("Symbol [" + symbol.name + "] is defined in an MMAP and cannot be exported");
            return null;
        }
        symbol.owner = statement;
        if (symbol.token == null) {
            symbol.token = token;
        }
        return symbol;
    }

    protected void setDependencies() {
        for (Symbol symbol : this.symbolMap.values()) {
            symbol.valueNumberDependencies = 0;
            symbol.replNumberDependencies = 0;
            symbol.externalName = null;
        }
        for (Symbol symbol : this.symbolMap.values()) {
            if (symbol.isExternal || symbol.isCommon || symbol.owner == null) continue;
            symbol.valueExpression.setValueDependencies(symbol);
            symbol.replExpression.setReplDependencies(symbol);
            symbol.externalName = null;
            symbol.exportName = null;
            symbol.exportType = null;
            symbol.exportSize = null;
            symbol.isLocalExported = false;
        }
        for (Symbol symbol : this.symbolMap.values()) {
            if (symbol.valueValueDependentList != null) {
                this.statements.logTrace("Value on Value dependent list - Symbol: " + symbol.name);
                for (Symbol symbol2 : symbol.valueValueDependentList) {
                    this.statements.logTrace("                          Dependent Symbol: " + symbol2.name);
                }
            }
            if (symbol.valueReplDependentList != null) {
                this.statements.logTrace("Value on Repl  dependent list - Symbol: " + symbol.name);
                for (Symbol symbol2 : symbol.valueReplDependentList) {
                    this.statements.logTrace("                          Dependent Symbol: " + symbol2.name);
                }
            }
            if (symbol.replValueDependentList != null) {
                this.statements.logTrace("Repl  on Value dependent list - Symbol: " + symbol.name);
                for (Symbol symbol2 : symbol.replValueDependentList) {
                    this.statements.logTrace("                          Dependent Symbol: " + symbol2.name);
                }
            }
            if (symbol.replReplDependentList == null) continue;
            this.statements.logTrace("Repl  on Repl  dependent list - Symbol: " + symbol.name);
            for (Symbol symbol2 : symbol.replValueDependentList) {
                this.statements.logTrace("                          Dependent Symbol: " + symbol2.name);
            }
        }
    }

    protected boolean evaluate() {
        LinkedList<Symbol> linkedList = new LinkedList<Symbol>();
        int n = 0;
        for (Symbol iterator : this.symbolMap.values()) {
            boolean bl;
            if (iterator.owner == null) {
                if (iterator.isExternal || iterator.isCommon) continue;
                for (Map.Entry<String, DVStatements.Statement> entry : iterator.referenceMap.entrySet()) {
                    entry.getValue().putError("Symbol [%s] has not been defined and is unresolved", iterator.name);
                }
                ++n;
                continue;
            }
            iterator.resultValue = null;
            iterator.valueNumberDependencies = iterator.originalValueNumberDependencies;
            iterator.resultRepl = null;
            iterator.replNumberDependencies = iterator.originalReplNumberDependencies;
            boolean bl2 = false;
            if (iterator.valueNumberDependencies == 0) {
                boolean bl3 = true;
            } else {
                ++n;
            }
            if (iterator.replNumberDependencies == 0) {
                bl = true;
            } else {
                ++n;
            }
            if (bl) {
                linkedList.addLast(iterator);
            }
            this.statements.logTrace(String.format("*** Symbol %16s is resdy to be solved: %b", iterator.name, bl));
            iterator.prevLength = iterator.length;
        }
        while (!linkedList.isEmpty()) {
            Iterator<Symbol> iterator = (Symbol)linkedList.removeFirst();
            if (((Symbol)((Object)iterator)).resultValue == null && ((Symbol)((Object)iterator)).valueNumberDependencies <= 0) {
                this.statements.logTrace("--- Resolving value: " + ((Symbol)((Object)iterator)).name);
                ((Symbol)((Object)iterator)).resultValue = ((Symbol)((Object)iterator)).valueExpression.evaluate(false);
                if (((Symbol)((Object)iterator)).valueValueDependentList != null) {
                    for (Symbol symbol : ((Symbol)((Object)iterator)).valueValueDependentList) {
                        --symbol.valueNumberDependencies;
                        if (symbol.valueNumberDependencies > 0) continue;
                        --n;
                        linkedList.addLast(symbol);
                    }
                }
                if (((Symbol)((Object)iterator)).valueReplDependentList != null) {
                    for (Symbol symbol : ((Symbol)((Object)iterator)).valueReplDependentList) {
                        --symbol.replNumberDependencies;
                        if (symbol.replNumberDependencies > 0) continue;
                        --n;
                        linkedList.addLast(symbol);
                    }
                }
            }
            if (((Symbol)((Object)iterator)).resultRepl != null || ((Symbol)((Object)iterator)).replNumberDependencies > 0) continue;
            this.statements.logTrace("--- Resolving repl : " + ((Symbol)((Object)iterator)).name);
            ((Symbol)((Object)iterator)).resultRepl = ((Symbol)((Object)iterator)).replExpression.evaluate(true);
            if (!DVExpression.INT_VALUE.contains((Object)((Symbol)((Object)iterator)).resultRepl.type)) {
                ((Symbol)((Object)iterator)).owner.putError(String.format("Replication for symbol [%s] resolves to [%s} - must resolve to either ABSOLUTE or DISPLACEMEN", ((Symbol)((Object)iterator)).name, ((Symbol)((Object)iterator)).resultRepl.type.name()));
                continue;
            }
            if (((Symbol)((Object)iterator)).replValueDependentList != null) {
                for (Symbol symbol : ((Symbol)((Object)iterator)).replValueDependentList) {
                    --symbol.valueNumberDependencies;
                    if (symbol.valueNumberDependencies > 0) continue;
                    --n;
                    linkedList.addLast(symbol);
                }
            }
            if (((Symbol)((Object)iterator)).replReplDependentList == null) continue;
            for (Symbol symbol : ((Symbol)((Object)iterator)).replReplDependentList) {
                --symbol.replNumberDependencies;
                if (symbol.replNumberDependencies > 0) continue;
                --n;
                linkedList.addLast(symbol);
            }
        }
        this.statements.logTrace("--- List of symbols");
        for (Symbol symbol : this.symbolMap.values()) {
            if (symbol.isExternal || symbol.isCommon) continue;
            if (symbol.resultValue == null) {
                this.statements.logTrace("--- Unresolved value: " + symbol.name);
                if (symbol.valueValueDependentList != null) {
                    for (Symbol symbol2 : symbol.valueValueDependentList) {
                        if (symbol.owner == null) {
                            symbol2.owner.putError("Symbol [" + symbol2.name + "->Value] unresolved due to undefined symbol [" + symbol.name + "]");
                            continue;
                        }
                        symbol2.owner.putError("Symbol [" + symbol2.name + "->Value] unresolved due to unresolved symbol [" + symbol.name + "->Value]");
                    }
                }
                if (symbol.valueReplDependentList != null) {
                    for (Symbol symbol3 : symbol.valueReplDependentList) {
                        if (symbol.owner == null) {
                            symbol3.owner.putError("Symbol [" + symbol3.name + "->Repl] unresolved due to undefined symbol [" + symbol.name + "]");
                            continue;
                        }
                        symbol3.owner.putError("Symbol [" + symbol3.name + "->Repl] unresolved due to unresolved symbol [" + symbol.name + "->Value]");
                    }
                }
            } else {
                this.statements.logTrace("--- Resolved   value: " + symbol.name + " Value: " + symbol.resultValue.getValue());
            }
            if (symbol.resultRepl == null) {
                this.statements.logTrace("--- Unresolved repl : " + symbol.name);
                if (symbol.replValueDependentList != null) {
                    for (Symbol symbol4 : symbol.replValueDependentList) {
                        if (symbol.owner == null) {
                            symbol4.owner.putError("Symbol [" + symbol4.name + "->Value] unresolved due to undefined symbol [" + symbol.name + "]");
                            continue;
                        }
                        symbol4.owner.putError("Symbol [" + symbol4.name + "->Value] unresolved due to unresolved symbol [" + symbol.name + "->Repl]");
                    }
                }
                if (symbol.replReplDependentList == null) continue;
                for (Symbol symbol5 : symbol.replReplDependentList) {
                    if (symbol.owner == null) {
                        symbol5.owner.putError("Symbol [" + symbol5.name + "->Repl] unresolved due to undefined symbol [" + symbol.name + "]");
                        continue;
                    }
                    symbol5.owner.putError("Symbol [" + symbol5.name + "->Repl] unresolved due to unresolved symbol [" + symbol.name + "->Repl]");
                }
                continue;
            }
            this.statements.logTrace("--- Resolved   repl : " + symbol.name + " Repl:  " + symbol.resultRepl.getValue());
        }
        return n == 0;
    }

    protected static Token getParseToken(String string) {
        Token token = new Token(-1, string);
        token.beginColumn = -1;
        token.beginLine = -1;
        return token;
    }

    protected Symbol getHiddenSymbol(DVStatements.Statement statement) {
        Symbol symbol = new Symbol(DVSymbols.getParseToken("#" + statement.lines[0].lineNo.trim()));
        symbol.owner = statement;
        return symbol;
    }

    protected void fillElfSymbolSection(DVSectionTable.SymbolSection symbolSection, String string) {
        Object object;
        Symbol symbol;
        if (string != null) {
            symbolSection.addSymbol(string, BigInteger.ZERO, BigInteger.ZERO, DVUtil.symbolBindLocal, DVUtil.symbolTypeFile, DVUtil.specialSectionIndexAbsolute);
        }
        for (Map.Entry<String, Symbol> entry : this.symbolMap.entrySet()) {
            symbol = entry.getValue();
            if (!symbol.isLocalExported) continue;
            object = DVExpression.INT_VALUE.contains((Object)symbol.resultValue.type) ? DVUtil.specialSectionIndexAbsolute : symbol.owner.ownerSection.elfSection.getIndex();
            symbol.index = symbolSection.addSymbol(symbol.exportName, symbol.resultValue.intConstant, symbol.exportSize == null ? symbol.length : symbol.exportSize, DVUtil.symbolBindLocal, DVUtil.symbolTypeObject, (BigInteger)object);
        }
        symbolSection.markLocal();
        for (Map.Entry<String, Symbol> entry : this.symbolMap.entrySet()) {
            symbol = entry.getValue();
            object = null;
            BigInteger bigInteger = BigInteger.ZERO;
            BigInteger bigInteger2 = BigInteger.ZERO;
            BigInteger bigInteger3 = null;
            BigInteger bigInteger4 = null;
            BigInteger bigInteger5 = null;
            if (symbol.isExternal || symbol.isCommon) {
                object = symbol.externalName;
                bigInteger3 = symbol.externalBind;
                bigInteger4 = DVUtil.symbolTypeNoType;
                bigInteger5 = symbol.isExternal ? DVUtil.specialSectionIndexUndefined : DVUtil.specialSectionIndexCommon;
            } else {
                if (!symbol.isExported) continue;
                object = symbol.exportName;
                bigInteger = symbol.resultValue.intConstant;
                bigInteger2 = symbol.exportSize;
                bigInteger3 = symbol.exportBind;
                bigInteger4 = symbol.exportType;
                bigInteger5 = DVExpression.INT_VALUE.contains((Object)symbol.resultValue.type) ? DVUtil.specialSectionIndexAbsolute : symbol.owner.ownerSection.elfSection.getIndex();
            }
            symbol.index = symbolSection.addSymbol((String)object, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5);
        }
    }

    protected static enum SymbolComponent {
        VALUE,
        LENGTH,
        REPL,
        SIZE;

    }

    public class Symbol {
        protected Token token;
        protected String name;
        protected DVStatements.Statement owner = null;
        protected BigInteger index = null;
        protected BigInteger align = null;
        protected DVExpression valueExpression = null;
        protected DVExpression.ExprToken resultValue = null;
        protected HashSet<Symbol> valueValueDependentList = null;
        protected HashSet<Symbol> valueReplDependentList = null;
        protected int valueNumberDependencies = 0;
        protected DVExpression replExpression = null;
        protected DVExpression.ExprToken resultRepl = null;
        protected HashSet<Symbol> replReplDependentList = null;
        protected HashSet<Symbol> replValueDependentList = null;
        protected int replNumberDependencies = 0;
        protected BigInteger length = null;
        protected int originalValueNumberDependencies;
        protected int originalReplNumberDependencies;
        protected BigInteger prevLength = null;
        protected boolean isExternal = false;
        protected boolean isCommon = false;
        protected String externalName = null;
        protected BigInteger externalBind = null;
        protected BigInteger commonSize = null;
        protected BigInteger CommonAlign = null;
        protected boolean isExported = false;
        protected boolean isLocalExported = false;
        protected String exportName = null;
        protected BigInteger exportBind = null;
        protected BigInteger exportType = null;
        protected BigInteger exportSize = null;
        protected TreeMap<String, DVStatements.Statement> referenceMap = new TreeMap();

        protected Symbol(Token token) {
            this.token = token;
            this.name = token.image.toUpperCase();
            DVSymbols.this.symbolMap.put(this.name, this);
        }

        protected Symbol(Token token, String string) {
            this.token = token;
            this.name = string.toUpperCase();
            DVSymbols.this.symbolMap.put(this.name, this);
        }

        protected void setValueValueDependency(Symbol symbol) {
            if (this.valueValueDependentList == null) {
                this.valueValueDependentList = new HashSet();
            }
            if (!this.valueValueDependentList.add(symbol)) {
                return;
            }
            ++symbol.originalValueNumberDependencies;
        }

        protected void setValueReplDependency(Symbol symbol) {
            if (this.valueReplDependentList == null) {
                this.valueReplDependentList = new HashSet();
            }
            if (!this.valueReplDependentList.add(symbol)) {
                return;
            }
            ++symbol.originalReplNumberDependencies;
        }

        protected void setReplValueDependency(Symbol symbol) {
            if (this.replValueDependentList == null) {
                this.replValueDependentList = new HashSet();
            }
            if (!this.replValueDependentList.add(symbol)) {
                return;
            }
            ++symbol.originalValueNumberDependencies;
        }

        protected void setReplReplDependency(Symbol symbol) {
            if (this.replReplDependentList == null) {
                this.replReplDependentList = new HashSet();
            }
            if (!this.replReplDependentList.add(symbol)) {
                return;
            }
            ++symbol.originalReplNumberDependencies;
        }

        protected void markSymbolCommon(DVStatements.Statement statement) {
            if (this.owner != null) {
                statement.putError("Symbol [" + this.name + "] defined as LOCAL - cannot be redefined as COMMON");
                return;
            }
            if (this.isCommon) {
                statement.putError("Symbol [" + this.name + "] already defined as COMMON - statement ignored");
                return;
            }
            if (this.isExternal) {
                statement.putError("Symbol [" + this.name + "] has already been defined as EXTERNAL - cannot be redefined as COMMON");
                return;
            }
            this.isCommon = true;
        }

        protected void setSymbolCommon(BigInteger bigInteger, BigInteger bigInteger2, String string) {
            this.commonSize = bigInteger;
            this.CommonAlign = bigInteger2;
            this.externalName = string;
        }

        protected void markSymbolExported(DVStatements.Statement statement) {
            if (this.isExported) {
                statement.putError("Symbol [" + this.name + "] has already been EXPORTED - statement ignored");
                return;
            }
            this.isExported = true;
        }

        protected void exportSymbol(DVStatements.Statement statement, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, String string) {
            if (this.owner != null && this.owner.ownerSection != null && this.owner.ownerSection.type == DVSections.SectionType.MMAP) {
                statement.putError("Symbol [" + this.name + "] is defined in an MMAP and cannot be exported");
                return;
            }
            if (!DVSymbols.this.statements.abi.verifySymbolType(bigInteger2)) {
                statement.putError("External symbol type [0x" + bigInteger2.toString(16) + "] is invalid");
                return;
            }
            this.exportType = bigInteger2;
            if (!DVSymbols.this.statements.abi.verifyExportedSymbolBind(bigInteger)) {
                statement.putError("External symbol bind [0x" + bigInteger.toString(16) + "] is invalid");
                return;
            }
            this.exportBind = bigInteger;
            if (bigInteger3 == null) {
                bigInteger3 = this.length.multiply(this.resultRepl.intConstant);
            }
            this.exportSize = bigInteger3;
            this.exportName = string == null ? this.name : string;
        }

        protected void markSymbolExternal(DVStatements.Statement statement) {
            if (this.owner != null) {
                statement.putError("Symbol [" + this.name + "] is LOCAL - cannot be redefined as EXTERNAL");
                return;
            }
            if (this.isCommon) {
                statement.putError("Symbol [" + this.name + "] has already been defined as COMMON - cannot be redefined as EXTERNAL");
                return;
            }
            if (this.isExternal) {
                statement.putError("Symbol [" + this.name + "] has already been defined as EXTERNAL - statement ignored");
                return;
            }
            this.isExternal = true;
        }

        protected void setSymbolExternal(BigInteger bigInteger, String string) {
            if (!DVSymbols.this.statements.abi.verifyExternalSymbolBind(bigInteger)) {
                this.owner.putError("External symbol bind [0x" + bigInteger.toString(16) + "] is invalid");
                return;
            }
            this.externalBind = bigInteger;
            this.externalName = string == null ? this.name : string;
        }

        void setLocalExport() {
            this.isLocalExported = true;
            this.exportName = this.name;
            this.exportSize = this.length;
        }

        protected void addReference(DVStatements.Statement statement) {
            this.referenceMap.put(statement.lines[0].lineNo, statement);
        }

        public String getName() {
            return this.name;
        }

        public DVSections.Section getSection() {
            return this.owner.ownerSection;
        }

        public BigInteger getValue() {
            return this.resultValue.intConstant;
        }
    }
}

