/*
 * Decompiled with CFR 0.152.
 */
package framework;

import framework.DVExpression;
import framework.DVImmediateOperand;
import framework.DVOpCodeParm;
import framework.DVStatements;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;

public class DVUtil {
    private static final byte[] hexConv = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final long[] booleanValueList = new long[]{0L, 1L};
    public static final BigInteger max32BitUnsigned = BigInteger.valueOf(-1L);
    public static final BigInteger max32BitSigned = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final BigInteger min32BitSigned = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final BigInteger max64BitUnsigned = BigInteger.valueOf(-1L);
    public static final BigInteger max64BitSigned = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger min64BitSigned = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final String[] sectionReservedNames = new String[]{".dynamic", ".dynstr", ".dynsym", ".hash", ".shstrtab", ".strtab", ".symtab"};
    public static final BigInteger sectionTypeNull = BigInteger.ZERO;
    public static final BigInteger sectionTypeProgbits = BigInteger.ONE;
    public static final BigInteger sectionTypeSymtab = BigInteger.valueOf(2L);
    public static final BigInteger sectionTypeStrtab = BigInteger.valueOf(3L);
    public static final BigInteger sectionTypeRela = BigInteger.valueOf(4L);
    public static final BigInteger sectionTypeHash = BigInteger.valueOf(5L);
    public static final BigInteger sectionTypeDynamic = BigInteger.valueOf(6L);
    public static final BigInteger sectionTypeNote = BigInteger.valueOf(7L);
    public static final BigInteger sectionTypeNobits = BigInteger.valueOf(8L);
    public static final BigInteger sectionTypeRel = BigInteger.valueOf(9L);
    public static final BigInteger sectionTypeShlib = BigInteger.valueOf(10L);
    public static final BigInteger sectionTypeDynsym = BigInteger.valueOf(11L);
    public static final BigInteger specialSectionType32Loproc = BigInteger.valueOf(0x70000000L);
    public static final BigInteger specialSectionType32Hiproc = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final BigInteger specialSectionType32Louser = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final BigInteger specialSectionType32Hiuser = BigInteger.valueOf(-1L);
    public static final BigInteger specialSectionType64Loos = BigInteger.valueOf(0x60000000L);
    public static final BigInteger specialSectionType64Hios = BigInteger.valueOf(0x6FFFFFFFL);
    public static final BigInteger specialSectionType64Loproc = BigInteger.valueOf(0x70000000L);
    public static final BigInteger specialSectionType64Hiproc = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final BigInteger specialSectionIndexUndefined = BigInteger.valueOf(0L);
    public static final BigInteger specialSectionIndexLoReserve = BigInteger.valueOf(65280L);
    public static final BigInteger specialSectionIndexLoProc = BigInteger.valueOf(65280L);
    public static final BigInteger specialSectionIndexHiProc = BigInteger.valueOf(65311L);
    public static final BigInteger specialSectionIndexAbsolute = BigInteger.valueOf(65521L);
    public static final BigInteger specialSectionIndexCommon = BigInteger.valueOf(65522L);
    public static final BigInteger specialSectionIndexHiReserve = BigInteger.valueOf(65535L);
    public static final BigInteger sectionAttributeWrite = BigInteger.ONE;
    public static final BigInteger sectionAttributeAlloc = BigInteger.valueOf(2L);
    public static final BigInteger sectionAttributeExec = BigInteger.valueOf(4L);
    public static final BigInteger sectionAttributeMask = BigInteger.valueOf(7L);
    public static final BigInteger symbolBindLocal = BigInteger.ZERO;
    public static final BigInteger symbolBindGlobal = BigInteger.ONE;
    public static final BigInteger symbolBindWeak = BigInteger.valueOf(2L);
    public static final BigInteger symbolBindLoos = BigInteger.valueOf(10L);
    public static final BigInteger symbolBindHios = BigInteger.valueOf(12L);
    public static final BigInteger symbolBindLoproc = BigInteger.valueOf(13L);
    public static final BigInteger symbolBindHiproc = BigInteger.valueOf(15L);
    public static final BigInteger symbolTypeNoType = BigInteger.ZERO;
    public static final BigInteger symbolTypeObject = BigInteger.ONE;
    public static final BigInteger symbolTypeFunc = BigInteger.valueOf(2L);
    public static final BigInteger symbolTypeSection = BigInteger.valueOf(3L);
    public static final BigInteger symbolTypeFile = BigInteger.valueOf(4L);
    public static final BigInteger symbolTypeLoos = BigInteger.valueOf(10L);
    public static final BigInteger symbolTypeHios = BigInteger.valueOf(12L);
    public static final BigInteger symbolTypeLoproc = BigInteger.valueOf(13L);
    public static final BigInteger symbolTypeHiproc = BigInteger.valueOf(15L);

    public static boolean checkBoolean(DVExpression.ExprToken exprToken) {
        return exprToken.type != DVExpression.TokenType.ABSOLUTE || !exprToken.intConstant.equals(BigInteger.ZERO) && !exprToken.intConstant.equals(BigInteger.ONE);
    }

    public static boolean verifySectionName(DVStatements.Statement statement, String string) {
        if (string.startsWith(".rel")) {
            return statement.putErrorFalse("Section names starting with [.rel] are reserved", new Object[0]);
        }
        for (String string2 : sectionReservedNames) {
            if (!string2.equals(string)) continue;
            return statement.putErrorFalse("Section name [" + string + "] is reserved", new Object[0]);
        }
        return true;
    }

    public static boolean verifySectionType(BigInteger bigInteger) {
        return bigInteger.equals(sectionTypeProgbits) || bigInteger.equals(sectionTypeNote) || bigInteger.equals(sectionTypeNobits);
    }

    public static boolean verifySectionAttribute(BigInteger bigInteger) {
        return bigInteger.and(sectionAttributeMask).equals(bigInteger);
    }

    public static boolean verifyExternalSymbolBind(BigInteger bigInteger) {
        return bigInteger.equals(symbolBindGlobal) || bigInteger.equals(symbolBindWeak);
    }

    public static boolean verifyExportedSymbolBind(BigInteger bigInteger) {
        return bigInteger.equals(symbolBindGlobal);
    }

    public static boolean verifySymbolType(BigInteger bigInteger) {
        return bigInteger.equals(symbolTypeNoType) || bigInteger.equals(symbolTypeObject) || bigInteger.equals(symbolTypeFunc);
    }

    public static String formatException(String string, Exception exception) {
        StackTraceElement[] stackTraceElementArray;
        String string2 = string + "\n" + exception.toString();
        for (StackTraceElement stackTraceElement : stackTraceElementArray = exception.getStackTrace()) {
            string2 = string2 + "\n" + stackTraceElement.toString();
        }
        return string2;
    }

    public static String formatError(String string, Error error) {
        StackTraceElement[] stackTraceElementArray;
        String string2 = string + "\n" + error.toString();
        for (StackTraceElement stackTraceElement : stackTraceElementArray = error.getStackTrace()) {
            string2 = string2 + "\n" + stackTraceElement.toString();
        }
        return string2;
    }

    public static boolean isClassInJar(Class<?> clazz) {
        return clazz.getResource("/" + clazz.getName().replace('.', '/') + ".class").toString().startsWith("jar:file:");
    }

    public static URL getClassLocation(Class<?> clazz) {
        return clazz.getProtectionDomain().getCodeSource().getLocation();
    }

    public static boolean verifyOverflow(byte[] byArray, int n) {
        if (byArray.length <= n) {
            return true;
        }
        return byArray.length == n + 1 && byArray[0] == 0;
    }

    public static int addIntegerToCode(byte[] byArray, int n, int n2, Endianness endianness) {
        if (endianness == Endianness.BIG) {
            byArray[n] = Integer.valueOf(n2 >> 24 & 0xFF).byteValue();
            byArray[n + 1] = Integer.valueOf(n2 >> 16 & 0xFF).byteValue();
            byArray[n + 2] = Integer.valueOf(n2 >> 8 & 0xFF).byteValue();
            byArray[n + 3] = Integer.valueOf(n2 & 0xFF).byteValue();
            return n + 4;
        }
        byArray[n] = Integer.valueOf(n2 & 0xFF).byteValue();
        byArray[n + 1] = Integer.valueOf(n2 >> 8 & 0xFF).byteValue();
        byArray[n + 2] = Integer.valueOf(n2 >> 16 & 0xFF).byteValue();
        byArray[n + 3] = Integer.valueOf(n2 >> 24 & 0xFF).byteValue();
        return n + 4;
    }

    public static int addHalfIntegerToCode(byte[] byArray, int n, int n2, Endianness endianness) {
        if (endianness == Endianness.BIG) {
            byArray[n] = Integer.valueOf(n2 >> 8 & 0xFF).byteValue();
            byArray[n + 1] = Integer.valueOf(n2 & 0xFF).byteValue();
            return n + 2;
        }
        byArray[n] = Integer.valueOf(n2 & 0xFF).byteValue();
        byArray[n + 1] = Integer.valueOf(n2 >> 8 & 0xFF).byteValue();
        return n + 2;
    }

    public static int addCode(byte[] byArray, int n, byte[] byArray2, int n2, int n3, Endianness endianness) {
        int n4;
        int n5;
        int n6;
        if (n3 == 0) {
            return n;
        }
        int n7 = byArray2.length;
        int n8 = n2 - n7;
        if (n8 > 0) {
            int n9 = n6 = byArray2[0] >= 0 ? 0 : -1;
            if (endianness == Endianness.LITTLE) {
                n5 = n + n2 - n8;
                for (n4 = 0; n4 < n8; ++n4) {
                    byArray[n5 + n4] = n6;
                }
                n4 = n + n7 - 1;
                for (int i = 0; i < n7; ++i) {
                    byArray[n4 - i] = byArray2[i];
                }
            } else {
                for (n5 = 0; n5 < n8; ++n5) {
                    byArray[n + n5] = n6;
                }
                System.arraycopy(byArray2, n8, byArray, n + n8, n7 - n8);
            }
        } else if (n8 == 0) {
            if (endianness == Endianness.LITTLE) {
                n6 = n + n2 - 1;
                for (n5 = 0; n5 < n2; ++n5) {
                    byArray[n6 - n5] = byArray2[n5];
                }
            } else {
                System.arraycopy(byArray2, n8, byArray, n + n8, n7 - n8);
            }
        } else {
            n6 = -n8;
            if (endianness == Endianness.LITTLE) {
                n5 = n + n2 + n6 - 1;
                for (n4 = n6; n4 < n7; ++n4) {
                    byArray[n5 - n4] = byArray2[n4];
                }
            } else {
                System.arraycopy(byArray2, n6, byArray, n, n2);
            }
        }
        if (n3 < 2) {
            return n + n2;
        }
        n6 = n + n2;
        for (n5 = 1; n5 < n3; ++n5) {
            System.arraycopy(byArray, n, byArray, n6, n2);
            n6 += n2;
        }
        return n6;
    }

    public static String convertCodeToHex(byte[] byArray, int n, boolean bl) {
        byte[] byArray2 = new byte[n * 2];
        byte[] byArray3 = hexConv;
        int n2 = Math.max(byArray.length - n, 0);
        int n3 = Math.max((n - byArray.length) * 2, 0);
        if (bl) {
            for (int i = 0; i < n3; i += 2) {
                byArray2[i] = 48;
                byArray2[i + 1] = 48;
            }
            for (int i = n2; i < byArray.length; ++i) {
                byte by = byArray[i];
                byArray2[i] = byArray3[by >> 4 & 0xF];
                byArray2[i + 1] = byArray3[by & 0xF];
                i += 2;
            }
        } else {
            for (int i = byArray2.length - 2; i >= byArray2.length - n3; i -= 2) {
                byArray2[i] = 48;
                byArray2[i + 1] = 48;
            }
            for (int i = n2; i < byArray.length; ++i) {
                byte by = byArray[i];
                byArray2[i] = byArray3[by >> 4 & 0xF];
                byArray2[i + 1] = byArray3[by & 0xF];
                i -= 2;
            }
        }
        return new String(byArray2);
    }

    public static String convertCodeToHex(byte[] byArray, int n, int n2, boolean bl) {
        byte[] byArray2 = new byte[n2 * 2];
        byte[] byArray3 = hexConv;
        int n3 = Math.min(byArray.length, n);
        int n4 = Math.max(n + n2 - byArray.length, 0);
        n2 -= n4;
        n4 *= 2;
        if (bl) {
            for (int i = 0; i < n4; i += 2) {
                byArray2[i] = 48;
                byArray2[i + 1] = 48;
            }
            for (int i = n3; i < n3 + n2; ++i) {
                byte by = byArray[i];
                byArray2[i] = byArray3[by >> 4 & 0xF];
                byArray2[i + 1] = byArray3[by & 0xF];
                i += 2;
            }
        } else {
            for (int i = byArray2.length - 2; i >= byArray2.length - n4; i -= 2) {
                byArray2[i] = 48;
                byArray2[i + 1] = 48;
            }
            for (int i = n3; i < n3 + n2; ++i) {
                byte by = byArray[i];
                byArray2[i] = byArray3[by >> 4 & 0xF];
                byArray2[i + 1] = byArray3[by & 0xF];
                i -= 2;
            }
        }
        return new String(byArray2);
    }

    public static String convertCodeToHexPlain(byte[] byArray) {
        return DVUtil.convertCodeToHexPlain(byArray, byArray.length);
    }

    public static String convertCodeToHexPlain(byte[] byArray, int n) {
        n = Math.min(n, byArray.length);
        byte[] byArray2 = new byte[n * 2];
        byte[] byArray3 = hexConv;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            byArray2[n2] = byArray3[by >> 4 & 0xF];
            byArray2[n2 + 1] = byArray3[by & 0xF];
            n2 += 2;
        }
        return new String(byArray2);
    }

    public static String formatHex(int n, int n2) {
        return DVUtil.formatHex(BigInteger.valueOf(n), n2);
    }

    public static String formatHex(BigInteger bigInteger, int n) {
        if (bigInteger == null) {
            return String.format("%" + Integer.toString(n) + "s", "");
        }
        Object object = DVUtil.convertCodeToHexPlain(bigInteger.toByteArray());
        int n2 = n - ((String)object).length();
        if (n2 == 0) {
            return object;
        }
        char c = '0';
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            c = 'F';
        }
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                object = c + (String)object;
            }
            return object;
        }
        n2 = -n2;
        for (int i = 0; i < n2; i += 2) {
            if (((String)object).charAt(i) == c && ((String)object).charAt(i + 1) == c) continue;
            return ((String)object).substring(i);
        }
        return ((String)object).substring(n2);
    }

    public static String formatBinary(int n, int n2, int n3) {
        Object object = "";
        for (int i = 0; i < n2; ++i) {
            object = (n3 & 1) == 1 ? ((n & 1) == 1 ? "1" : "0") + (String)object : "." + (String)object;
            n >>= 1;
            n3 >>= 1;
        }
        return object;
    }

    public static Long getRegister(DVStatements.Statement statement, int n, int n2) {
        return DVUtil.getRegister(statement, n, null, n2, null);
    }

    public static Long getRegister(DVStatements.Statement statement, int n, BigInteger[] bigIntegerArray, int n2) {
        return DVUtil.getRegister(statement, n, bigIntegerArray, n2, null);
    }

    public static Long getRegister(DVStatements.Statement statement, int n, int n2, Integer n3) {
        return DVUtil.getRegister(statement, n, null, n2, n3);
    }

    public static Long getRegister(DVStatements.Statement statement, int n, BigInteger[] bigIntegerArray, int n2, Integer n3) {
        DVExpression.ExprToken exprToken = n3 == null ? statement.getOpCodeParm().getPositionalParameterValue(n2) : statement.getOpCodeParm().getSubParmList(n2)[n3].getSubParmValue();
        if (exprToken.getType() != DVExpression.TokenType.ABSOLUTE) {
            if (n3 == null) {
                statement.putError("Register value for operand [%d] resolves to [%s] - must resolve to ABSOLUTE", n2 + 1, exprToken.getType().name());
            } else {
                statement.putError("Register value for operand [%d], sub-parm [%d] resolves to [%s] - must resolve to ABSOLUTE", n2 + 1, n3 + 1, exprToken.getType().name());
            }
            return null;
        }
        BigInteger bigInteger = exprToken.getIntConstant();
        if (bigInteger.compareTo(BigInteger.ZERO) < 0 || bigInteger.bitLength() > n) {
            if (n3 == null) {
                statement.putError("Register value [%s] for operand [%d] is out of range [0-%d]", bigInteger.toString(), n2 + 1, 1 << n - 1);
            } else {
                statement.putError("Register value [%s] for operand [%d], sub-parm [%d] is out of range [0-%d]", bigInteger.toString(), n2 + 1, n3 + 1, 1 << n - 1);
            }
            return null;
        }
        if (bigIntegerArray != null) {
            for (int i = 0; i < bigIntegerArray.length; ++i) {
                if (!bigInteger.equals(bigIntegerArray[i])) continue;
                if (n3 == null) {
                    statement.putError("Register value [%s] for operand [%d] is invalid", bigInteger.toString(), n2 + 1);
                    continue;
                }
                statement.putError("Register value [%s] for operand [%d], sub-parm [%d] is invalid", bigInteger.toString(), n2 + 1, n3 + 1);
            }
        }
        return bigInteger.longValue();
    }

    public static DVImmediateOperand getImmediate(DVStatements.Statement statement, int n, Integer n2, int n3, boolean bl, EnumSet<ImmType> enumSet) {
        return DVUtil.getImmediate(statement, n, n2, "Immediate", n3, bl, enumSet);
    }

    public static DVImmediateOperand getImmediate(DVStatements.Statement statement, int n, int n2, boolean bl, EnumSet<ImmType> enumSet) {
        return DVUtil.getImmediate(statement, n, null, "Immediate", n2, bl, enumSet);
    }

    public static DVImmediateOperand getImmediate(DVStatements.Statement statement, int n, String string, int n2, boolean bl, EnumSet<ImmType> enumSet) {
        return DVUtil.getImmediate(statement, n, null, string, n2, bl, enumSet);
    }

    public static DVImmediateOperand getImmediate(DVStatements.Statement statement, int n, Integer n2, String string, int n3, boolean bl, EnumSet<ImmType> enumSet) {
        DVExpression.ExprToken exprToken = statement.getOpCodeParm().getPositionalParameterValue(n);
        if (exprToken == null) {
            statement.putError("Immediate at positional parameter [%d] is missing\n", n + 1);
            return null;
        }
        if ((exprToken.getType() == DVExpression.TokenType.ABSOLUTE || exprToken.getType() == DVExpression.TokenType.DISPLACEMENT) && enumSet.contains((Object)ImmType.INTEGER)) {
            BigInteger bigInteger = exprToken.getIntConstant();
            if (DVUtil.verifyImmediate(statement, string, bigInteger, n3, bl, exprToken.getType()) == null) {
                return null;
            }
            return new DVImmediateOperand(ImmType.INTEGER, bigInteger, null, null, null);
        }
        if ((exprToken.getType() == DVExpression.TokenType.EXTERNAL_VALUE || exprToken.getType() == DVExpression.TokenType.OFFSET && exprToken.qualifier != null) && enumSet.contains((Object)ImmType.EXTERNAL)) {
            return new DVImmediateOperand(ImmType.EXTERNAL, exprToken.intConstant, null, null, exprToken);
        }
        if (exprToken.getType() == DVExpression.TokenType.OFFSET) {
            if (enumSet.contains((Object)ImmType.BASEDSP)) {
                DVStatements.Base base = statement.getBase(exprToken.getOffsetSection(), exprToken.getIntConstant(), false);
                if (base == null) {
                    statement.putError(string + ": Unable to locate base register for location [%s]\n", exprToken.getOffsetSection().getOwner().getSymbol().getName() + (exprToken.getIntConstant().compareTo(BigInteger.ZERO) >= 0 ? "+" : "") + exprToken.getIntConstant().toString(16));
                    return null;
                }
                BigInteger bigInteger = exprToken.intConstant.subtract(base.offset);
                if (DVUtil.verifyImmediate(statement, string, bigInteger, n3, bl, exprToken.getType()) == null) {
                    return null;
                }
                return new DVImmediateOperand(ImmType.BASEDSP, bigInteger, base.register.longValue(), exprToken.intConstant, null);
            }
            if (enumSet.contains((Object)ImmType.PCREL)) {
                if (!statement.getOwnerSection().equals(exprToken.getOffsetSection())) {
                    statement.putError(string + ": immediate offset is outside current section and cannot be used to form a PC relative offset");
                    return null;
                }
                BigInteger bigInteger = exprToken.getIntConstant().subtract(statement.getOffset());
                if (DVUtil.verifyImmediate(statement, string, bigInteger, n3, bl, exprToken.getType()) == null) {
                    return null;
                }
                return new DVImmediateOperand(ImmType.PCREL, bigInteger, null, exprToken.intConstant, null);
            }
        }
        if (exprToken.getType() == DVExpression.TokenType.BASE_DISPLACEMENT && enumSet.contains((Object)ImmType.BASEDSP)) {
            DVStatements.Base base = statement.getBase(exprToken.getBaseID());
            if (base == null) {
                statement.putError(String.format(string + ": Unable to location Base with ID [%s]\n", exprToken.getBaseID()));
                return null;
            }
            if (base.getSection() != exprToken.getBaseSection()) {
                statement.putError(String.format(string + ": Section/MMap mismatch between Base ID [%s] for location [%s]\n", base.getID(), exprToken.getOffsetSection().getOwner().getSymbol().getName() + (exprToken.getIntConstant().compareTo(BigInteger.ZERO) >= 0 ? "+" : "") + exprToken.getIntConstant().toString(16)));
                return null;
            }
            return new DVImmediateOperand(ImmType.BASEDSP, exprToken.getIntConstant().subtract(base.getOffset()), base.getRegister().longValue(), exprToken.intConstant, null);
        }
        statement.putError(string + ": resolve to type [%s] and is not of valid type", exprToken.getType().name());
        return null;
    }

    public static Long verifyImmediate(DVStatements.Statement statement, String string, BigInteger bigInteger, int n, boolean bl, DVExpression.TokenType tokenType) {
        int n2;
        if (!bl && bigInteger.compareTo(BigInteger.ZERO) < 0) {
            statement.putError(string + " is unsigned but value [%s] is negative", bigInteger.toString());
        }
        if ((n2 = bigInteger.bitLength()) < n) {
            return bigInteger.longValue();
        }
        if (tokenType == DVExpression.TokenType.ABSOLUTE && bigInteger.compareTo(BigInteger.ZERO) >= 0 && n2 <= n) {
            return bigInteger.longValue();
        }
        statement.putError(string + " value [%s] is too wide", bigInteger.toString());
        return null;
    }

    public static int validateKeyWordList(DVStatements.Statement statement, DVOpCodeParm.KeyWordParm[] keyWordParmArray, String[] stringArray) {
        if (keyWordParmArray.length > stringArray.length) {
            statement.putError(String.format("Only %d optional key-word parameters are allowed", stringArray.length));
            return -1;
        }
        int n = 0;
        for (DVOpCodeParm.KeyWordParm keyWordParm : keyWordParmArray) {
            int n2;
            for (n2 = 0; n2 < stringArray.length && !stringArray[n2].equals(keyWordParm.getKeyValue().toUpperCase()); ++n2) {
            }
            if (n2 > stringArray.length) {
                Object object = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    object = (String)object + " " + stringArray[i];
                }
                statement.putError("Key word value [" + keyWordParm.getKeyValue() + "] must be any of: " + (String)object);
                return -1;
            }
            ++n;
        }
        return n;
    }

    public static Long getBooleanValue(DVStatements.Statement statement, int n, Long l, String string) {
        return DVUtil.getBooleanValue(statement, n, null, l, string);
    }

    public static Long getBooleanValue(DVStatements.Statement statement, int n, Integer n2, Long l, String string) {
        DVExpression.ExprToken exprToken = n2 == null ? statement.getOpCodeParm().getPositionalParameterValue(n) : statement.getOpCodeParm().getSubParmList(n)[n2].getSubParmValue();
        if (exprToken == null && l != null) {
            return l;
        }
        if (exprToken.getType() != DVExpression.TokenType.ABSOLUTE) {
            statement.putError(string + " resolve to [%s] - must resolve to ABSOLUTE", exprToken.getType().name());
            return null;
        }
        if (!exprToken.getIntConstant().equals(BigInteger.ZERO) && exprToken.getIntConstant().equals(BigInteger.ONE)) {
            statement.putError(string + " resolves to [%s] - must resolve to either ZERO or ONE", exprToken.getIntConstant().toString());
            return null;
        }
        return exprToken.getIntConstant().longValue();
    }

    public static Long getSetValue(DVStatements.Statement statement, int n, long[] lArray, boolean bl, String string) {
        return DVUtil.getSetValue(statement, n, null, lArray, bl, string);
    }

    public static Long getSetValue(DVStatements.Statement statement, int n, Integer n2, long[] lArray, String string) {
        return DVUtil.getSetValue(statement, n, n2, lArray, false, string);
    }

    public static Long getSetValue(DVStatements.Statement statement, int n, long[] lArray, String string) {
        return DVUtil.getSetValue(statement, n, null, lArray, false, string);
    }

    public static Long getSetValue(DVStatements.Statement statement, int n, Integer n2, long[] lArray, boolean bl, String string) {
        DVExpression.ExprToken exprToken = n2 == null ? statement.getOpCodeParm().getPositionalParameterValue(n) : statement.getOpCodeParm().getSubParmList(n)[n2].getSubParmValue();
        if (exprToken == null && bl) {
            return lArray[0];
        }
        if (exprToken.getType() != DVExpression.TokenType.ABSOLUTE) {
            statement.putError(string + " resolve to [%s] - must resolve to ABSOLUTE", exprToken.getType().name());
            return null;
        }
        BigInteger bigInteger = exprToken.getIntConstant();
        boolean bl2 = true;
        for (int i = 0; i < lArray.length; ++i) {
            if (!bigInteger.equals(BigInteger.valueOf(lArray[i]))) continue;
            bl2 = false;
            break;
        }
        if (!bl2) {
            return bigInteger.longValue();
        }
        statement.putError(string + " resolves to [%s] - the value is invalid", bigInteger.toString());
        return null;
    }

    public static DVExpression.ExprToken[] getKeyWordTokenList(DVStatements.Statement statement, String[] stringArray) {
        ArrayList<DVOpCodeParm.KeyWordParm> arrayList = statement.opCodeParm.keyWordParmList;
        DVExpression.ExprToken[] exprTokenArray = new DVExpression.ExprToken[stringArray.length];
        block0: for (DVOpCodeParm.KeyWordParm keyWordParm : arrayList) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(keyWordParm.keyValue.toUpperCase())) continue;
                exprTokenArray[i] = keyWordParm.value;
                continue block0;
            }
        }
        return exprTokenArray;
    }

    public static Long getBooleanKeyWordValue(DVStatements.Statement statement, int n, String string, Long l) {
        return DVUtil.getAbsoluteKeyWordValue(statement, n, string, 0L, 0L, booleanValueList, l);
    }

    public static Long getAbsoluteKeyWordValue(DVStatements.Statement statement, int n, String string, long l, long l2, Long l3) {
        return DVUtil.getAbsoluteKeyWordValue(statement, n, string, l, l2, null, l3);
    }

    public static Long getAbsoluteKeyWordValue(DVStatements.Statement statement, int n, String string, long[] lArray, long l) {
        return DVUtil.getAbsoluteKeyWordValue(statement, n, string, 0L, 0L, lArray, l);
    }

    public static Long getAbsoluteKeyWordValue(DVStatements.Statement statement, int n, String string, long l, long l2, long[] lArray, Long l3) {
        DVOpCodeParm.KeyWordParm keyWordParm = statement.getOpCodeParm().getKeyWordParm(n);
        if (keyWordParm == null || keyWordParm.getValue() == null) {
            if (l3 == null) {
                statement.putError(string + " key-word parameter is missing but it is required");
            }
            return l3;
        }
        DVExpression.ExprToken exprToken = keyWordParm.getValue();
        if (exprToken.getType() != DVExpression.TokenType.ABSOLUTE) {
            statement.putError(string + " resolves to [%s] - only ABSOLUTE is allowed", exprToken.getType().name());
            return null;
        }
        BigInteger bigInteger = exprToken.getIntConstant();
        if (lArray != null) {
            for (int i = 0; i < lArray.length; ++i) {
                if (!bigInteger.equals(BigInteger.valueOf(lArray[i]))) continue;
                return lArray[i];
            }
            Object object = "";
            for (int i = 0; i < lArray.length; ++i) {
                object = (String)object + String.format("%d, ", lArray[i]);
            }
            object = "[" + ((String)object).substring(0, ((String)object).length() - 2) + "]";
            statement.putError(string + " resolves to [%s] - only the following values are allowed %s", bigInteger.toString(), object);
        }
        if (bigInteger.compareTo(BigInteger.valueOf(l)) >= 0 && bigInteger.compareTo(BigInteger.valueOf(l2)) <= 0) {
            return bigInteger.longValue();
        }
        statement.putError(string + " resolves to [%s] and is out of range", bigInteger.toString());
        return null;
    }

    public static String escapeString(String string) {
        Object object = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < '\u007f') {
                int n = "\t\b\n\r\f'\"\\".indexOf(c);
                if (n >= 0) {
                    object = (String)object + "\\t\\b\\n\\r\\f\\'\\\"\\\\".substring(n * 2, n * 2 + 2);
                    continue;
                }
                object = (String)object + string.substring(i, i + 1);
                continue;
            }
            object = (String)object + String.format("\\u%04X", c);
        }
        return object;
    }

    public static String unescapeString(String string) throws Exception {
        Object object = "";
        int n = 0;
        int n2;
        while ((n2 = string.indexOf(92, n)) >= 0) {
            object = (String)object + string.substring(n, n2);
            n = n2;
            if (n2 == string.length() - 1) {
                throw new Exception(String.format("String terminates with a single backlash [\\] character\nString\nString [%s]", string));
            }
            char c = string.charAt(n + 1);
            int n3 = "tbnrf'\"\\".indexOf(c);
            if (n3 >= 0) {
                object = (String)object + "\t\b\n\r\f'\"\\".charAt(n3);
                n += 2;
                continue;
            }
            if (c != 'u') {
                throw new Exception(String.format("Character following backslash at position [%d] is an invalid character\nString [%s]", n + 1, string));
            }
            if (n + 6 > string.length()) {
                throw new Exception(String.format("Unicode escape at position [%d] is not followed by four character\nString [%s]", n + 1, string));
            }
            try {
                c = (char)Integer.parseInt(string.substring(n + 2, n + 6), 16);
            }
            catch (Exception exception) {
                throw new Exception(String.format("Unicode escape at position [%d] is not followed by four digits\nString [%s]", n + 1, string));
            }
            object = (String)object + c;
            n += 6;
        }
        return (String)object + string.substring(n);
    }

    protected static String[] expandList(String string) {
        int n;
        Object object = "";
        Object object2 = "";
        String[] stringArray = new String[]{string};
        char c = 'a';
        for (n = string.length() - 1; n >= 0 && (c = (char)string.charAt(n)) >= '0' && c <= '9'; --n) {
            object2 = c + (String)object2;
        }
        if (((String)object2).length() == 0 || n < 0 || c != '-') {
            return stringArray;
        }
        int n2 = string.length() - n - 1;
        --n;
        while (n >= 0 && (c = string.charAt(n)) >= '0' && c <= '9') {
            object = c + (String)object;
            --n;
        }
        if (((String)object).length() == 0 || n < 0) {
            return stringArray;
        }
        int n3 = string.length() - n2 - n - 2;
        int n4 = string.length() - n3 - n2 - 1;
        int n5 = Integer.valueOf((String)object);
        int n6 = Integer.valueOf((String)object2);
        int n7 = n6 - n5 + 1;
        if (n7 <= 1 || n4 == 0) {
            return stringArray;
        }
        stringArray = new String[n7];
        stringArray[0] = string.substring(0, n4 + n3);
        String string2 = string.substring(0, n4) + "%0" + Integer.toString(n3) + "d";
        for (n = 1; n < n7; ++n) {
            stringArray[n] = String.format(string2, n + n5);
        }
        return stringArray;
    }

    public static enum Endianness {
        BIG,
        LITTLE,
        UNDEFINED;

    }

    public static enum ImmType {
        INTEGER,
        BASEDSP,
        PCREL,
        EXTERNAL;

    }
}

